<%@ LANGUAGE=VBSCRIPT %>
<HTML>
<HEAD>
<TITLE>Redirection utilisant les collections de Request</TITLE>
<STYLE TYPE="text/css">
BODY {font-family:Tahoma,Arial,sans-serif; font-size:10pt}
.heading {font-family:Tahoma,Arial,sans-serif; font-size:14pt; font-weight:bold}
.cite {font-family:Tahoma,Arial,sans-serif; font-size:8pt}
</STYLE>
</HEAD>
<BODY BGCOLOR="#FFFFFF">
<SPAN CLASS="heading">Redirection utilisant les collections de Request</SPAN><HR>
<!--------------------------------------------------------------------------->

Although we're not going to redirect you anywhere else, here's some ways it could be done:<P>

<UL>
<LI><B>Using values from the Request.ClientCertificate collection</B></LI>
</UL>
<PRE>&lt;%
  If Request.ClientCertificate("SubjectO") = "Wrox Car Company" Then
    Response.Redirect "/wroxcars/default.asp"     'Wrox Car Co site
  Else
    Response.Redirect "/defaultsite/default.asp"  'normal default site
  End If
%&gt;</PRE>
or ...
<PRE>&lt;%
  Select Case Request.ClientCertificate("SubjectC")
    Case "UK": Response.Redirect "https://uk_site.com/
    Case "DE": Response.Redirect "https://de_site.com/
    Case "FR": Response.Redirect "https://fr_site.com/
    '... etc.
    Case Else: Response.Redirect "https://us_site.com/
  End Select
%&gt;</PRE>


<UL>
<LI><B>Using the port number from Request.ServerVariables("SERVER_PORT")</B></LI>
</UL>
<PRE>&lt;%
  If Request.ServerVariables("SERVER_PORT") = "443" Then
    Response.Redirect "/securesite/default.asp"  'secure user
  Else
    Response.Redirect "/normalsite/default.asp"  'non-secure user
  End If
%&gt;</PRE>

<UL>
<LI><B>Using login name of the user from Request.ServerVariables("AUTH_USER")</B></LI>
</UL>
<PRE>&lt;A HREF="dispcnfg.asp"&gt;Change Display Configuration&lt;/A&gt;&lt;BR&gt;
&lt;A HREF="dispcolr.asp"&gt;Change Display Colors&lt;/A&gt;&lt;BR&gt;
&lt;A HREF="keyboard.asp"&gt;Change Keyboard Configuration&lt;/A&gt;&lt;BR&gt;
&lt;% If Request.ServerVariables("AUTH_USER") _
   = UCase(Request.ServerVariables("SERVER_NAME")) & "\JJSmith" Then %&gt;
&lt;A HREF="allusers.asp"&gt;Administer All Users&lt;/A&gt;&lt;BR&gt;
&lt;A HREF="usrlogon.asp"&gt;Administer Logon Information&lt;/A&gt;
&lt;% End If %&gt;</PRE>

<!--------------------------------------------------------------------------->
<HR><SPAN CLASS="cite">&copy;1999 <A CLASS="cite" HREF="http://www.wrox.com/">Wrox Press</A> -
<A CLASS="cite" HREF="http://webdev.wrox.co.uk/default.asp?bookcode=2610">Professional ASP 3.0</A> (ISBN: 1-861002-61-0)</SPAN>
</BODY>
</HTML>