<%@LANGUAGE="VBScript"%>
<HTML>
<HEAD>
<TITLE>The Scripting.FileSystemObject</TITLE>
<STYLE TYPE="text/css">
BODY {font-family:Tahoma,Arial,sans-serif; font-size:10pt}
.heading {font-family:Tahoma,Arial,sans-serif; font-size:14pt; font-weight:bold}
.cite {font-family:Tahoma,Arial,sans-serif; font-size:8pt}
</STYLE>
<!-- METADATA TYPE="typelib" FILE="c:\WinNT\System32\scrrun.dll" -->
</HEAD>
<BODY BGCOLOR="#FFFFFF">
<SPAN CLASS="heading">Using the Drives Collection</SPAN><HR>
<!--------------------------------------------------------------------------->
<%
Response.Flush

' create a FileSystemObject instance
Set objFSO = Server.CreateObject("Scripting.FileSystemObject")
' create a Drives collection
Set colDrives = objFSO.Drives
' iterate through the Drives collection
For Each objDrive in colDrives
 
  Response.Write "DriveLetter: <B>" & objDrive.DriveLetter & "</B>&nbsp; &nbsp;"
  Response.Write "DriveType: <B>" & objDrive.DriveType
  Select Case objDrive.DriveType
    Case 0: Response.Write " - (Unknown)"
    Case 1: Response.Write " - (Removable)"
    Case 2: Response.Write " - (Fixed)"
    Case 3: Response.Write " - (Network)"
    Case 4: Response.Write " - (CDRom)"
    Case 5: Response.Write " - (RamDisk)"
  End Select
  Response.Write "</B>&nbsp; &nbsp;"
 
 If objDrive.DriveType = 3 Then
    If objDrive.IsReady Then
      Response.Write "Remote drive with ShareName: <B>" & objDrive.ShareName & "</B>"
    Else
      Response.Write "Remote drive - <B>IsReady</B> property returned <B>False</B><BR>"
    End If
  Else If objDrive.IsReady then 
    Response.Write "FileSystem: <B>" & objDrive.FileSystem & "</B>&nbsp; &nbsp;"
    Response.Write "SerialNumber: <B>" & objDrive.SerialNumber & "</B><BR>"
    Response.Write "Local drive with VolumeName: <B>" & objDrive.VolumeName & "</B><BR>"
    Response.Write "AvailableSpace: <B>" & FormatNumber(objDrive.AvailableSpace / 1024, 0) & "</B> KB&nbsp; &nbsp;"
    Response.Write "FreeSpace: <B>" & FormatNumber(objDrive.FreeSpace / 1024, 0) & "</B> KB&nbsp; &nbsp;"
    Response.Write "TotalSize: <B>" & FormatNumber(objDrive.TotalSize / 1024, 0) & "</B> KB"
  End if  
  Response.Write "<P>"
  End if
Next
%>

<!--------------------------------------------------------------------------->
<HR><SPAN CLASS="cite">&copy;1999 <A CLASS="cite" HREF="http://www.wrox.com/">Wrox Press</A> -
<A CLASS="cite" HREF="http://webdev.wrox.co.uk/default.asp?bookcode=2610">Professional ASP 3.0</A> (ISBN: 1-861002-61-0)</SPAN>
</BODY>
</HTML>
