<HTML><HEAD><TITLE>cyScape DashCache Monitoring and Analysis Tool</TITLE></HEAD>
<BODY>
<%
    Set bh = CreateObject("cyScape.browserObj")
    'Note the use of CreateObject instead of Server.CreateObject.  This is so that
    'hitting this page does not count towards the cache.  As a side result however we
    'can not access the browser capabilitity properties but they are not needed for
    'this script.

    response.write "<blockquote>"
    response.write "<h3>cyScape DashCache&trade; Monitoring and Analysis Tool</h3>"

    response.write "<table border=1 cellpadding=5><tr><th>Parameter</th><th>Value</th></tr>"

    response.write "<tr><td align=""right"">DashCache state:</td><td>"
    if bh.i__cacheEnabled then
       response.write "Enabled"
    else
       response.write "Disabled"
    end if
    response.write "</td></tr>"

    response.write "<tr><td align=""right"">Cache running since:</td><td>" & bh.i__CacheStart & "</td></tr>"

    response.write "<tr><td align=""right"">Total browsers in cache:</td><td>" & bh.i__cachecount & "</td></tr>"
    response.write "<tr><td align=""right"">Total cache hits:</td><td>" & bh.i__cachehits & "</td></tr>"
    response.write "<tr><td align=""right"">Total object creations:</td><td>" & bh.i__TotalOverallHits & "</td></tr>"

    hrsCacheRunning = DateDiff("h", bh.i__cacheStart, Now)
    if bh.i__TotalOverallHits > 0 then
       hitRatio = cint(bh.i__cachehits / bh.i__TotalOverallHits * 100)
       if hrsCacheRunning >= 12 then
          if hitRatio < 50 then
             clr = "BGCOLOR=""red"" "
          elseif hitRatio < 75 then
             clr = "BGCOLOR=""yellow"" "
          else
             clr = "BGCOLOR=""lightgreen"" "
          end if
       end if
       hitRatio = hitRatio & "%"
    else
       hitRatio = "0%"
    end if

    response.write "<tr " & clr & "><td align=""right"">Cache hit ratio"
    if hrsCacheRunning < 12 then
       response.write "*"
    end if
    response.write ":</td><td>" & hitRatio & "</td></tr>"

    response.write "<tr><td align=""right"">Max size used by cache:</td><td>" & bh.i__cachesizemax & " bytes</td></tr>"
    response.write "<tr><td align=""right"">Current cache size:</td><td>" & bh.i__cachesize & " bytes</td></tr>"
    response.write "<tr><td align=""right"">Max size available to cache:</td><td>" & bh.i__cachemaximum & " bytes</td></tr>"

    response.write "<tr><td align=""right"">Percentage of cache in use:</td><td>"
    if bh.i__cachemaximum > 0 then
       perCacheinUse = cint(bh.i__cachesize / bh.i__cacheMaximum * 100)
    else 
       perCacheinUse = 0
    end if
    response.write perCacheinUse & "%</td></tr>"

    response.write "<tr><td align=""right"">Total cache cleans:</td><td>" & bh.i__cachecleantotal & "</td></tr>"
    response.write "</table><P>"

    if hrsCacheRunning < 12 then
       response.write "* Your cache should be running for a minimum of 12 hours before evaluating the cache hit ratio."
   end if
    
%>
<P>
Note: If you are using BrowserHawk in virtual directories marked to run in separate processes (isolated processes) under IIS 
you should run this script from each virtual directory, as each one has its own cache.
</BLOCKQUOTE></BODY></HTML>