<%
   'showbrow.asp  v2.0b
   '03/25/98 JAA: Initial development 
   '08/12/98 JAA: 
   ' - Added option to look up visitors IP address using BrowserHawk's new ResolveIP method
   ' - Added use of alternating background table cell colors to improve readability, 
   '   if the browser supports table cell background colors of course ;-)
   '10/02/98 RTL:
   ' - Updated to also show the raw user agent string
   ' - Added checks to display intuitive messages if SSL properties not available
   '12/22/98 RTL:
   ' - Updated to test whether cookies are enabled or disabled using new CookieDetector method

   'This script displays a listing of all properties you have defined in your
   'BrowserHawk BDF. Note that out of BrowserHawk's internal system properties are
   'suppressed, as this info is of little use outside of the BrowserHawk Editor.

   'NOTE: This script demonstrates an advanced way of using BrowserHawk by dynamically accessing
   'all defined property names using the BrowserHawk object's "PATH" method.  Typically your scripts
   'using BrowserHawk will not involve this level of complexity.  For example, if you wanted to check
   'the platform of the visiting browser, you would simply create the BrowserHawk object, then use:
   '  " if thisBrowser.platform = "Win95" then ... ".  See the on-line documentation for more information
   'on using BrowserHawk from your web scripts.

   'Let's get started...

   'Create an instance of the BrowserHawk component based on the web browser's
   'user agent which is hitting this page.  

   ' **********
   ' Cookie enabled/disabled detection code starts here.  Note that the code is even easier
   ' if using a session level BrowserHawk object as explained in the BrowserHawk Cookie Detector
   ' documentation.  We demonstrate the page level usage here for those users who do not choose
   ' to user BrowserHawk in session variables.

   set thisBrowser = Server.CreateObject("cyScape.browserObj")
   cookieVal = Request.Cookies("bhCookie")
   if cookieVal = "" then
      thisBrowser.CookieDetector "noredirect"
   end if
   ' The first time through the about method call causes this script to redirect to itself at this point
   ' and execute the above code a second time.

   ' The second time through we wind up back here because of our use of the "noredirect" keyword.
   ' So at this point, if the cookie "bhCookie" is anything but "" then cookies are enabled.
   ' Otherwise cookies are disabled.  We'll use this information later on.

   ' Optional: Since some developers may prefer that the bhcd2=xxxxx not stay in the URL after the
   ' test is completed, we demonstrate here how to get reset the URL.  Note that this causes
   ' another redirect but for those that want the URL unchanged this is the best way to do it.
   ' Note that you don't want to redirect if cookies are not enabled, as this would cause a loop.
   if Request.QueryString("bhcd2") <> "" and cookieVal <> "" then
      response.redirect Request.ServerVariables("SCRIPT_NAME")
   end if      
%>

<HTML><HEAD><TITLE>Browser Capabilities Test Page</TITLE></HEAD>
<BODY BGCOLOR="#FFFFFF">

<BLOCKQUOTE>
<H2>Browser Capabilities Test Page</H2>
<FONT SIZE=+1>The following is information on your web browser's capabilities<br>
as detected by <A HREF="http://www.cyscape.com/browserhawk/home.asp?q=showbrow">BrowserHawk v2.0</A>:</FONT>
<P>

<%
   response.write "User agent: " & Request.ServerVariables("HTTP_USER_AGENT") & "<p>"

   if Request.QueryString("resolveip") = "Yes" then
      response.write "Please wait while your IP address is resolved.<br>Click <a href=""showbrow.asp"">here</a> to go back to no IP lookup.<P>"
   end if

    'if this browser supports tables then let's lay the data out in nicely formatted table
   if thisBrowser.tables = True then
      if thisBrowser.TableBGCOlor then
         color1 = "<TD BGCOLOR=#F0F0F0>"
         color2 = "<TD BGCOLOR=#FFFFFF>"
      else
         color1 = "<TD>"
         color2 = "<TD>"
      end if

      response.write "<TABLE "
      if thisBrowser.TableBGColor then
         response.write "bgcolor=""#CCCCCC"""
      end if
      response.write "BORDER=1 CELLPADDING=3 WIDTH=350><TR><TD BGCOLOR=""#99CCCC"" COLSPAN=2 ALIGN=CENTER><FONT SIZE=+2>Browser: " & thisBrowser.browser & " " & thisBrowser.fullversion & "</FONT></TD></TR>"
      response.write "<TR><TD BGCOLOR=""#FFFFCC""><B>&nbsp;Property</B></TD><TD BGCOLOR=""#FFFFCC""><B>&nbsp;Value</B></TD></TR>"
   else
      response.write "<H2>Your browser: " & thisBrowser.browser & " " & thisBrowser.fullversion & "</H2>"
   end if

   'Loop through each property in the newly created browser object
   For each thisProperty in thisBrowser

        bolSysProperty = False

        'Dynamically reference the property using its PATH method
	PropVal = thisBrowser.path(thisProperty)

        'Check to see if this property is a BrowserHawk system property
        if len(thisProperty) >= 3 then
           if left(thisProperty, 3) = "i__" or thisProperty = "Versionpos" then
              bolSysProperty = True
           end if
        end if

        'Display property if not a BrowserHawk system property
        if bolSysProperty = False then

           'See if this is the IPAddr property.  If so, check to see if they have requested to resolve the IP.
           'This is only done upon request because DNS lookups are a time consuming operation (typically about 3 seconds).
   
	   if thisProperty = "IPAddr" then
              if Request.QueryString("resolveip") = "Yes" then

                 'Use the ResolveIP method to look up the host name.  Since we call ResolveIP without passing in any
                 'parameters, it automatically looks up the IP Address that is in the IPAddr property.
                 'Note that you can look up a specific IP address by passing in the IP to resolve.  
                 'For example: thisBrowser.ResolveIP("207.46.130.138")
                 strHostName = thisBrowser.ResolveIP
                 if strHostName = "" then
                    strHostName = "<br>&nbsp;Host name not available"
                 else
                    strHostName = "<br>&nbsp;" & strHostName
                 end if
              else
                 strHostName = "<br>Click <a href=""showbrow.asp?resolveip=Yes"">here</a> to have BrowserHawk look up host name."
              end if
           elseif thisProperty = "SSLKeySize" then
              if Request.ServerVariables("SERVER_SOFTWARE") = "Microsoft-IIS/3.0" then
                 strHostName = "<br>Not available under IIS 3.0"
              elseif thisBrowser.SSLActive = False then

                 strHostName = "<br>This page must be accessed with HTTPS:// to determine key size."

                 'In other words, in order to check the strenth of the key size (40 bit vs. 128 bit), the
                 'BrowserHawk object must be created on a page with an active SSL connection.  One way to do this
                 'is to first check to see if the browser supports SSL at all, and if so, redirect them to a SSL page 
                 'which captures this value. For example:
                 '  if thisBrowser.SSl then response.redirect "https://domain.com/sslcheck.asp"
                 'Then from sslcheck.asp you create the bhawk object, and check the SSLKeySize variable there.

                 'IMPORTANT NOTE: If you are trying to detect browser support for 40 bit vs. 128 bit in your scripts,
                 'your server side SSL certificate MUST be created with 1024 bit encryption.  Otherwise browsers
                 'that support 128 bit encryption will be downgraded to 40 bit SSL by the server, and BrowserHawk will 
                 'likewise report the actual key strength of 40 bit despite a 128 bit browser being used.
 
              end if
           elseif thisProperty = "Cookies" then
              if Request.Cookies("bhCookie") = "" then
                 strHostName ="<br>&nbsp;** DISABLED **"
              else
                 strHostName ="<br>&nbsp;ENABLED"
              end if
           else
              strHostName = ""
           end if

           if thisBrowser.tables then

              'select which color background to use for this row since we're alternating.  Note no color is used
              'if the browser does not support background colors in table cells.

              intColorCnt = intColorCnt + 1
              if intColorCnt / 2 = CInt(intColorCnt/2) then
                 colorToUse = color1
              else
                 colorToUse = color2
              end if
              
              response.write "<TR>" & colorToUse & "&nbsp;" & thisProperty & "</TD>" & colorToUse & "&nbsp;" & CStr(PropVal) & strHostName & "</TD></TR>" & chr(10)

           else
              response.write thisProperty & ": " & CStr(PropVal) & strHostName & "<BR>" & chr(10)
           end if
        end if
    Next

    if thisBrowser.tables = True then
       response.write "</TABLE>"
    end if

    'As with any object you create using the "CreateObject" command, you should
    'release it before your script terminates. If you are storing an object in a
    '"Session" variable, be can release it in global.asa in the onSession_end event.

    'Good programming habits - release the BrowserHawk object by setting it to "Nothing".
    set thisBrowser = Nothing
%>
</BLOCKQUOTE></BODY></HTML>
