<%@LANGUAGE="VBSCRIPT"%>
<HTML>
<HEAD>
<TITLE>Testing Stonebroom.Regex</TITLE>
</HEAD>
<BODY>
<FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
This page demonstrates the <B>Stonebroom.RegEx</B><SUP>&copy;</SUP> component<BR>
in action with Microsoft<SUP>&reg;</SUP> Active Server Pages<SUP>&copy;</SUP>.<P>
<HR>

<!-- include file containing values for enumerated constants -->
<!-- because ASP does not recognize these intrinsicaly -->
<!-- #include file="regex.inc" -->

<%

Function GetDataTypeString(lngDataType)
'to convert data type number into a string name
  Select Case lngDataType
    Case -1 : GetDataTypeString = "REG_ERROR"
    Case 0 : GetDataTypeString = "REG_NONE"
    Case 1 : GetDataTypeString = "REG_SZ"
    Case 2 : GetDataTypeString = "REG_EXPAND_SZ"
    Case 3 : GetDataTypeString = "REG_BINARY"
    Case 4 : GetDataTypeString = "REG_DWORD"
    Case 5 : GetDataTypeString = "REG_DWORD_BIG_ENDIAN"
    Case 6 : GetDataTypeString = "REG_LINK"
    Case 7 : GetDataTypeString = "REG_MULTI_SZ"
    Case 8 : GetDataTypeString = "REG_RESOURCE_LIST"
    Case 9 : GetDataTypeString = "REG_FULL_RESOURCE_DESCRIPTOR"
    Case 10 : GetDataTypeString = "REG_RESOURCE_REQUIREMENTS_LIST"
  End Select
End Function

'On Error Resume Next

'create the component instance
Set objRX = Server.CreateObject("Stonebroom.RegEx")

'see if it was created OK
If IsObject(objRX) Then
  	
  'variable to update with data type
  Dim varDataType

  'get MajorVersion for IIS	
  strSubKey = "Software\Microsoft\InetStp"
  strValueName = "MajorVersion"
  strMajorVersion = objRX.GetRegValueEx(HKEY_LOCAL_MACHINE, strSubKey, strValueName, varDataType)
  strMajorVersionType = GetDataTypeString(CLng(varDataType))

  'get AnonymousUser for IIS	
  strSubKey = "Software\Microsoft\InetStp"
  strValueName = "AnonymousUser"
  strAnonymousUser = objRX.GetRegValueEx(HKEY_LOCAL_MACHINE, strSubKey, strValueName, varDataType)
  strAnonymousUserType = GetDataTypeString(CLng(varDataType))
 
  'get current IE version string
  strSubKey = "Software\Microsoft\Internet Explorer"
  strValueName = "Version"
  strIEVersion = objRX.GetRegValueEx(HKEY_LOCAL_MACHINE, strSubKey, strValueName, varDataType)
  strIEVersionType = GetDataTypeString(CLng(varDataType))

  'get NT Service Pack Version  strCSDVersionType = 
  strSubKey = "Software\Microsoft\Windows NT\CurrentVersion"
  strValueName = "CSDVersion"
  strCSDVersion = objRX.GetRegValueEx(HKEY_LOCAL_MACHINE, strSubKey, strValueName, varDataType)
  strCSDVersionType = GetDataTypeString(CLng(varDataType))

  'now set subkey and value name for our TestValue subkey
  strSubKey = "Software\Stonebroom\TestRegEx"
  strValueName = "TestValue"

  'see if a new value was provided for our TestValue subkey 
  strNewValue = Request.Form("txtNewValue")
  If Len(strNewValue) Then
    varDataType = Request.Form("selNewDataType")
    If objRX.SetRegValueEx(HKEY_LOCAL_MACHINE, strSubKey, strValueName, strNewValue, varDataType) Then     
    	Response.Write "<B>Successfully updated the test subkey.</B><HR>"
    Else
    	Response.Write "<B>Failed to update the test subkey.</B><HR>"
    End If	
  End If

  'display current value of our TestValue subkey 
  strTestValue = objRX.GetRegValueEx(HKEY_LOCAL_MACHINE, strSubKey, strValueName, varDataType)

Else

  'couldn't create the component instance
  Response.Write "ASP could not create the RegEx object on the server.<P>"

End If
%>

<TABLE CELLSPACING="10">
 <TR>
  <TH ALIGN="LEFT"><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    HKEY_LOCAL_MACHINE Subkey</FONT></TH>
  <TH ALIGN="LEFT"><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    Value Name</FONT></TH>
  <TH ALIGN="LEFT"><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    Value</FONT></TH>
  <TH ALIGN="LEFT"><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    Type</FONT></TH>
 </TR>
 <TR>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    Software\Microsoft\InetStp</FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    MajorVersion</FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    <!-- insert value returned by component -->
    <% = strMajorVersion %></FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    <!-- insert value returned by component -->
    <% = strMajorVersionType %></FONT></TD>
 </TR> 
 <TR>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    Software\Microsoft\InetStp</FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    AnonymousUser</FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    <!-- insert value returned by component -->
    <% = strAnonymousUser %></FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    <!-- insert value returned by component -->
    <% = strAnonymousUserType %></FONT></TD>
 </TR> 
 <TR>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    Software\Microsoft\Internet Explorer</FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    Version</FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    <!-- insert value returned by component -->
    <% = strIEVersion %></FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    <!-- insert value returned by component -->
    <% = strIEVersionType %></FONT></TD>
 </TR> 
 <TR>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    Software\Microsoft\Windows NT\CurrentVersion</FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    CSDVersion</FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    <!-- insert value returned by component -->
    <% = strCSDVersion %></FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    <!-- insert value returned by component -->
    <% = strCSDVersionType %></FONT></TD>
 </TR> 
</TABLE>

<HR>

<FORM ACTION="<% = Request.ServerVariables("SCRIPT_NAME") %>" METHOD="POST">
<TABLE>
 <TR>
  <TD ALIGN="RIGHT"><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    Registry Key:</FONT></TD>
  <TD COLSPAN="2"><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2"><B>
    HKEY_LOCAL_MACHINE\Software\Stonebroom\TestRegEx</B></FONT></TD>
 </TR> 
 <TR>
  <TD ALIGN="RIGHT"><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    TestValue = </FONT></TD>
  <TD COLSPAN="2"><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2"><B>
    <!-- insert value returned by component -->
    <% = strTestValue %></B></FONT></TD>
 </TR>
 <TR>
  <TD ALIGN="RIGHT"><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    New Value:</FONT></TD>
  <TD COLSPAN="2"><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    <INPUT TYPE="TEXT" SIZE="20" NAME="txtNewValue"></FONT></TD>
 </TR>
 <TR>
  <TD ALIGN="RIGHT"><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    Data Type:</FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    <SELECT SIZE="1" NAME="selNewDataType">
      <!-- values come from include file regex.inc -->
      <OPTION VALUE="<% = REG_SZ %>">REG_SZ
      <OPTION VALUE="<% = REG_BINARY %>">REG_BINARY
      <OPTION VALUE="<% = REG_DWORD %>">REG_DWORD
    </SELECT>
    </FONT></TD>
  <TD><FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE="2">
    <INPUT TYPE="SUBMIT" VALUE="Change"></FONT></TD>
 </TR>
</TABLE>
</FORM>
</FONT>

<HR>

<FONT FACE="Tahoma,Verdana,Arial,sans-serif" SIZE=1><P>&copy;1999 Stonebroom Software, UK</P></FONT>

</BODY>
</HTML>