VERSION 5.00
Begin VB.Form frmTest_RegEx 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Test Stonebroom RegEx"
   ClientHeight    =   4425
   ClientLeft      =   1140
   ClientTop       =   1560
   ClientWidth     =   8040
   Icon            =   "Test_RegEx.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4425
   ScaleWidth      =   8040
   Begin VB.CommandButton cmdVer 
      Caption         =   "V&ersion"
      Height          =   375
      Left            =   6390
      TabIndex        =   30
      Top             =   3870
      Width           =   825
   End
   Begin VB.CommandButton cmdSet 
      Caption         =   "&Set Value"
      Enabled         =   0   'False
      Height          =   375
      Left            =   5400
      TabIndex        =   26
      Top             =   3870
      Width           =   915
   End
   Begin VB.CommandButton cmdExit 
      Cancel          =   -1  'True
      Caption         =   "E&xit"
      Height          =   375
      Left            =   7290
      TabIndex        =   27
      Top             =   3870
      Width           =   645
   End
   Begin VB.Frame fraValue 
      Caption         =   " SubKey &Value"
      Height          =   1005
      Left            =   4320
      TabIndex        =   22
      Top             =   2610
      Width           =   3615
      Begin VB.TextBox txtValue 
         Height          =   285
         Left            =   810
         TabIndex        =   24
         Top             =   450
         Width           =   2625
      End
      Begin VB.Label lblValue 
         Caption         =   "V&alue: "
         Height          =   285
         Left            =   270
         TabIndex        =   23
         Top             =   450
         Width           =   645
      End
   End
   Begin VB.Frame fraSubKey 
      Caption         =   " Registry Sub&Key"
      Height          =   2355
      Left            =   3510
      TabIndex        =   8
      Top             =   90
      Width           =   4425
      Begin VB.OptionButton optSubKey 
         Caption         =   "Display\Settings"
         Height          =   285
         Index           =   5
         Left            =   270
         TabIndex        =   14
         Tag             =   "Display\Settings"
         ToolTipText     =   "Use with HKEY_CURRENT_CONFIG, try Resolution value name"
         Top             =   1620
         Width           =   3885
      End
      Begin VB.OptionButton optSubKey 
         Caption         =   "Hardware\Description\System\CentralProcessor\0"
         Height          =   285
         Index           =   4
         Left            =   270
         TabIndex        =   13
         Tag             =   "Hardware\Description\System\CentralProcessor\0"
         ToolTipText     =   "Use with HKEY_LOCAL_MACHINE, try Identifier value name"
         Top             =   1350
         Width           =   4065
      End
      Begin VB.TextBox txtSubKey 
         BackColor       =   &H8000000F&
         Enabled         =   0   'False
         Height          =   285
         Left            =   1080
         TabIndex        =   16
         Text            =   "Software\Stonebroom\TestRegEx"
         Top             =   1890
         Width           =   3165
      End
      Begin VB.OptionButton optSubKey 
         Caption         =   "Other:"
         Height          =   285
         Index           =   6
         Left            =   270
         TabIndex        =   15
         Top             =   1890
         Width           =   825
      End
      Begin VB.OptionButton optSubKey 
         Caption         =   "Control Panel\Desktop\WindowMetrics"
         Height          =   285
         Index           =   3
         Left            =   270
         TabIndex        =   12
         Tag             =   "Control Panel\Desktop\WindowMetrics"
         ToolTipText     =   "Use with HKEY_CURRENT_USER, try IconSpacingFactor value name"
         Top             =   1080
         Width           =   3885
      End
      Begin VB.OptionButton optSubKey 
         Caption         =   "Control Panel\Colors"
         Height          =   285
         Index           =   2
         Left            =   270
         TabIndex        =   11
         Tag             =   "Control Panel\Colors"
         ToolTipText     =   "Use with HKEY_CURRENT_USER, try ButtonFace value name"
         Top             =   810
         Width           =   3975
      End
      Begin VB.OptionButton optSubKey 
         Caption         =   "DirectAnimation.SequencerControl\CLSID"
         Height          =   285
         Index           =   1
         Left            =   270
         TabIndex        =   10
         Tag             =   "DirectAnimation.SequencerControl\CLSID"
         ToolTipText     =   "Use with HKEY_CLASSES_ROOT"
         Top             =   540
         Width           =   3975
      End
      Begin VB.OptionButton optSubKey 
         Caption         =   "ADODB.Command\CurVer"
         Height          =   285
         Index           =   0
         Left            =   270
         TabIndex        =   9
         Tag             =   "ADODB.Command\CurVer"
         ToolTipText     =   "Use with HKEY_CLASSES_ROOT"
         Top             =   270
         Width           =   3975
      End
   End
   Begin VB.Frame fraType 
      Caption         =   " SubKey &Type "
      Height          =   1725
      Left            =   90
      TabIndex        =   17
      Top             =   2610
      Width           =   4065
      Begin VB.ComboBox cboValueType 
         BackColor       =   &H8000000F&
         Enabled         =   0   'False
         Height          =   315
         ItemData        =   "Test_RegEx.frx":030A
         Left            =   1260
         List            =   "Test_RegEx.frx":030C
         Style           =   2  'Dropdown List
         TabIndex        =   28
         Top             =   1260
         Width           =   2625
      End
      Begin VB.TextBox txtValueName 
         BackColor       =   &H8000000F&
         Enabled         =   0   'False
         Height          =   285
         Left            =   1260
         TabIndex        =   21
         Text            =   "Test Named Key"
         Top             =   900
         Width           =   2625
      End
      Begin VB.OptionButton optType 
         Caption         =   "Enumerated (Multiple) Subkey Values"
         Height          =   285
         Index           =   1
         Left            =   270
         TabIndex        =   19
         Top             =   540
         Width           =   3525
      End
      Begin VB.OptionButton optType 
         Caption         =   "Default (Single) Key Value"
         Height          =   285
         Index           =   0
         Left            =   270
         TabIndex        =   18
         Top             =   270
         Width           =   2625
      End
      Begin VB.Label lblValType 
         Alignment       =   1  'Right Justify
         Caption         =   "Va&lue Type: "
         Height          =   285
         Left            =   180
         TabIndex        =   29
         Top             =   1260
         Width           =   1095
      End
      Begin VB.Label lblType 
         Alignment       =   1  'Right Justify
         Caption         =   "Value &Name: "
         Enabled         =   0   'False
         Height          =   285
         Left            =   180
         TabIndex        =   20
         Top             =   900
         Width           =   1095
      End
   End
   Begin VB.CommandButton cmdGet 
      Caption         =   "&Get Value"
      Default         =   -1  'True
      Height          =   375
      Left            =   4320
      TabIndex        =   25
      Top             =   3870
      Width           =   1005
   End
   Begin VB.Frame fraHive 
      Caption         =   " &Registry Hive "
      Height          =   2355
      Left            =   90
      TabIndex        =   0
      Top             =   90
      Width           =   3255
      Begin VB.OptionButton optHive 
         Caption         =   "HKEY_DYN_DATA"
         Height          =   285
         Index           =   6
         Left            =   270
         TabIndex        =   7
         Top             =   1890
         Width           =   2625
      End
      Begin VB.OptionButton optHive 
         Caption         =   "HKEY_CURRENT_CONFIG"
         Height          =   285
         Index           =   5
         Left            =   270
         TabIndex        =   6
         Top             =   1620
         Width           =   2625
      End
      Begin VB.OptionButton optHive 
         Caption         =   "HKEY_PERFORMANCE_DATA"
         Height          =   285
         Index           =   4
         Left            =   270
         TabIndex        =   5
         Top             =   1350
         Width           =   2805
      End
      Begin VB.OptionButton optHive 
         Caption         =   "HKEY_USERS"
         Height          =   285
         Index           =   3
         Left            =   270
         TabIndex        =   4
         Top             =   1080
         Width           =   2265
      End
      Begin VB.OptionButton optHive 
         Caption         =   "HKEY_LOCAL_MACHINE"
         Height          =   285
         Index           =   2
         Left            =   270
         TabIndex        =   3
         Top             =   810
         Width           =   2625
      End
      Begin VB.OptionButton optHive 
         Caption         =   "HKEY_CURRENT_USER"
         Height          =   285
         Index           =   1
         Left            =   270
         TabIndex        =   2
         Top             =   540
         Width           =   2625
      End
      Begin VB.OptionButton optHive 
         Caption         =   "HKEY_CLASSES_ROOT"
         Height          =   285
         Index           =   0
         Left            =   270
         TabIndex        =   1
         Top             =   270
         Width           =   2625
      End
   End
End
Attribute VB_Name = "frmTest_RegEx"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'Registry Extended Value Type Constants
Private Const REG_NONE = 0                        ' No value
Private Const REG_SZ = 1                          ' Unicode null terminated string
Private Const REG_EXPAND_SZ = 2                   ' Unicode null terminated unexpanded environment string
Private Const REG_BINARY = 3                      ' Free form binary
Private Const REG_DWORD = 4                       ' 32-bit number default format
Private Const REG_DWORD_LITTLE_ENDIAN = 4         ' 32-bit number same as REG_DWORD
Private Const REG_DWORD_BIG_ENDIAN = 5            ' 32-bit number with reversed bytes
Private Const REG_LINK = 6                        ' Symbolic Link (unicode string)
Private Const REG_MULTI_SZ = 7                    ' Multiple unicode strings separated by Chr(0), ends with 2 x Chr(0)
Private Const REG_RESOURCE_LIST = 8               ' Resource list in the resource map
Private Const REG_FULL_RESOURCE_DESCRIPTOR = 9    ' Resource list in the hardware description
Private Const REG_RESOURCE_REQUIREMENTS_LIST = 10
Private Const REG_ERROR = -1                      ' Error while processing request

'global values to hold user selection
Private glngRegHive As Long
Private glngSubKey As Long
Private glngKeyType As Long
Private glngKeyValue As Long

'variable to hold a reference to the Registry component
Private objRegEx As Object

Private Sub cboValueType_Click()
   'update the global variable
   glngKeyValue = cboValueType.ListIndex
   'only set focus if form is not loading
   If frmTest_RegEx.Visible Then
      With txtValue
         .SetFocus
         .SelStart = 0
         .SelLength = Len(.Text)
      End With
   End If
   'enable the 'Set' button as appropriate
   Call EnableSetButton
End Sub

Private Sub cmdExit_Click()
   End   'close application
End Sub

Private Sub cmdGet_Click()
   Dim strSubKey As String
   Dim strValueName As String
   Dim varRetVal As Variant
   Dim lngValueType As Long
   Dim strRetVal As String
   Dim strMsg As String
   
   'set up an error trap
   On Error GoTo CGC_Err
   If glngSubKey = 6 Then
      'custom subkey has been entered by the user
      strSubKey = txtSubKey.Text
   Else
      'one of the predefined values is selected
      strSubKey = optSubKey(glngSubKey).Tag
   End If
   If glngKeyType = 1 Then
      'we want a named value from this enumerated subkey
      strValueName = txtValueName.Text
      'call the component GetRegValueEx method
      'registry value type is returned in last parameter
      varRetVal = objRegEx.GetRegValueEx(glngRegHive, strSubKey, strValueName, lngValueType)
      'see what value type was returned
      Select Case lngValueType
         Case REG_NONE
            strMsg = "Key has no value." & vbCrLf
         Case REG_DWORD, REG_DWORD_LITTLE_ENDIAN, REG_DWORD_BIG_ENDIAN
            strMsg = "Value returned by the component is of type 'Long'." & vbCrLf
         Case REG_SZ, REG_EXPAND_SZ, REG_LINK
            strMsg = "Value returned by the component is of type 'String'." & vbCrLf
         Case REG_BINARY
            strMsg = "Value returned by the component is of type 'Binary'." & vbCrLf
            'convert from binary string to normal string for display
            varRetVal = Replace(varRetVal, Chr(1), "1")
            varRetVal = Replace(varRetVal, Chr(0), "0")
         Case REG_MULTI_SZ
            strMsg = "Value returned by the component is of type 'Multiple String'." & vbCrLf
            'strip off second terminating Chr(0) and convert all other Chr(0) to CRLF
            varRetVal = Left(varRetVal, Len(varRetVal) - 1)
            varRetVal = vbCrLf & Replace(varRetVal, Chr(0), vbCrLf)
         Case REG_RESOURCE_LIST, REG_FULL_RESOURCE_DESCRIPTOR, REG_RESOURCE_REQUIREMENTS_LIST
            strMsg = "Value returned by the component is of type 'Resource (List)'." & vbCrLf
            'convert all Chr(0) to CRLF
            varRetVal = Replace(varRetVal, Chr(0), vbCrLf)
         Case Else
            strMsg = "Value returned by the component is of unknown type." & vbCrLf
      End Select
      'convert to a string for the message box
      strRetVal = CStr(varRetVal)
      If Len(strRetVal) = 0 Then strRetVal = "[NULL]"
   Else
      'we want the default value for the subkey
      'call the component GetRegValue method
      strRetVal = objRegEx.GetRegValue(glngRegHive, strSubKey)
      strMsg = "Value returned by the component is of type 'String'." & vbCrLf
   End If
   If Len(strRetVal) Then
      'display the value found
      strMsg = strMsg & "Value returned by the component is: '" & strRetVal & "'."
   Else
      'component returns an empty string if no value found
      strMsg = "Failed to read the Registry key '" & strSubKey & "\" & strValueName & "'."
   End If
   MsgBox strMsg, vbOKOnly + vbInformation, "Stonebroom.RegEx Test"
   Exit Sub
CGC_Err:
   MsgBox "Cannot access Registry value", vbOKOnly, "Error"
   Exit Sub
End Sub

Private Sub cmdSet_Click()
   Dim strSubKey As String
   Dim strValueName As String
   Dim varKeyValue As Variant
   Dim strKeyValue As String
   Dim strChar As String
   Dim strMsg As String
   Dim blnStringType As Boolean
   Dim blnNotBinary As Boolean
   Dim blnWorked As Boolean
   Dim intLoop As Integer
   
   'set up an error trap
   On Error GoTo CSC_Err
   'confirm update before continuing
   strMsg = "WARNING: Updating the Registry can prevent your system" & vbCrLf _
          & "from working properly. Are you sure you want to continue ?"
   If MsgBox(strMsg, vbYesNo + vbDefaultButton2 + vbExclamation, "Updating the registry") = vbNo Then Exit Sub
   If glngSubKey = 6 Then
      'custom subkey has been entered by the user
      strSubKey = txtSubKey.Text
   Else
      'one of the predefined values is selected
      strSubKey = optSubKey(glngSubKey).Tag
   End If
   'get the new value for the key as a Variant
   'value to place in the registry for 'Ex' method
   varKeyValue = txtValue.Text
   'value for non-'Ex' method and in message box later on
   strKeyValue = CStr(varKeyValue)
   If glngKeyType = 1 Then
      'we'll update a named value for this enumerated subkey
      strValueName = txtValueName.Text   'value name to use for this value
      Select Case glngKeyValue
         Case REG_BINARY, REG_LINK
            'do nothing, sent to function as variant
         Case REG_DWORD, REG_DWORD_BIG_ENDIAN
            'this is a Long ('DWORD') value type
            'check that it's a legal number
            If IsNumeric(varKeyValue) Then
               varKeyValue = CLng(varKeyValue)
               'convert to number-type variant
               'error trap will handle case where it's
               'not convertible to a Long number type
            Else
               'display message and exit
               MsgBox "Value is not a legal number", vbOKOnly + vbExclamation, "Value Error"
               With txtValue
                  .SetFocus
                  .SelStart = 0
                  .SelLength = Len(.Text)
               End With
               Exit Sub
            End If
         Case REG_MULTI_SZ
            'multiple strings in special format
            varKeyValue = Replace(varKeyValue, " ", Chr(0)) & Chr(0) & Chr(0)
         Case REG_SZ, REG_EXPAND_SZ
            'ordinary String ('SZ') value type
            'convert variant to a String-type variant
            varKeyValue = CStr(varKeyValue)
      End Select
      'call the component SetRegValueEx method with Variant value
      blnWorked = objRegEx.SetRegValueEx(glngRegHive, strSubKey, strValueName, varKeyValue, glngKeyValue)
   Else
      'we'll update the 'Default' value for the subkey, as an SZ string value
      'call the component SetRegValue method with String value
      blnWorked = objRegEx.SetRegValue(glngRegHive, strSubKey, strKeyValue)
   End If
   If blnWorked Then
      strMsg = "Successfully set value in the Registry to: '" & strKeyValue & "'."
   Else
      strMsg = "Failed to set the Registry key '" & strSubKey & "\" & strValueName & "'."
   End If
   MsgBox strMsg, vbOKOnly + vbInformation, "Stonebroom.RegEx Test"
   Exit Sub
CSC_Err:
   MsgBox "Cannot update Registry value", vbOKOnly + vbExclamation, "Error"
   Exit Sub
End Sub

Private Sub cmdVer_Click()
   MsgBox "Internal Version Number: " & objRegEx.GetInternalVersionNumber(), vbOKOnly + vbInformation, "RegEx Version"
End Sub

Private Sub Form_Load()
   
   'create an instance of the Registry component
   Set objRegEx = CreateObject("Stonebroom.RegEx")
   
   'fill the 'ValueType' combo box list
   cboValueType.AddItem "Select the value data type:"
   cboValueType.AddItem "REG_SZ"
   cboValueType.AddItem "REG_EXPAND_SZ"
   cboValueType.AddItem "REG_BINARY"
   cboValueType.AddItem "REG_DWORD"
   cboValueType.AddItem "REG_DWORD_BIG_ENDIAN"
   cboValueType.AddItem "REG_LINK"
   cboValueType.AddItem "REG_MULTI_SZ"

   'set the global values to their defaults
   glngRegHive = 0
   glngSubKey = 0
   glngKeyType = 0
   glngKeyValue = 0
   'set the option buttons to match the global defaults
   optHive(glngRegHive) = True
   optSubKey(glngSubKey) = True
   optType(glngKeyType) = True
   cboValueType.ListIndex = glngKeyValue
End Sub

Private Sub optHive_Click(intIndex As Integer)
   'update the global variable
   glngRegHive = intIndex
End Sub

Private Sub optSubKey_Click(intIndex As Integer)
   'update the global variable
   glngSubKey = intIndex
   'set the enabled state of just the textbox
   SetTextBox (intIndex = 6), Null, txtSubKey
End Sub

Private Sub SetTextBox(blnEnabled As Boolean, objLabel As Variant, objControl As Control)
   'set the enabled state of a label and textbox
   If IsObject(objLabel) Then objLabel.Enabled = blnEnabled
   With objControl
      .Enabled = blnEnabled
      If blnEnabled Then
         .BackColor = &H80000005
         'only set focus if form is not loading
         If (objControl.Name <> "cboValueType") And (frmTest_RegEx.Visible) Then
            .SetFocus
            .SelStart = 0
            .SelLength = Len(.Text)
         End If
      Else
         .BackColor = &H8000000F
      End If
   End With
End Sub

Private Sub optType_Click(intIndex As Integer)
   'update the global variable
   glngKeyType = intIndex
   'set the enabled state of the labels, textbox and combo list
   SetTextBox (intIndex = 1), lblType, txtValueName
   SetTextBox (intIndex = 1), lblValType, cboValueType
   'enable the 'Set' button as appropriate
   Call EnableSetButton
End Sub

Private Sub txtValue_Change()
   'enable the 'Set' button as appropriate
   Call EnableSetButton
End Sub

Sub EnableSetButton()
   'enable 'Set' button only if:
   '  there is a value in the 'Value' text box AND
   '  the subkey type is 'Default' OR
   '  the value (data) type list is set to a REG_xxx value
   cmdSet.Enabled = (Len(txtValue.Text) > 0) And ((optType(0).Value) Or (Not (cboValueType.ListIndex = 0)))
End Sub
