<%@LANGUAGE="VBScript"%>
<%
'prevent any other errors from stopping execution
On Error Resume Next

'get a reference to the ASPError object
Set objASPError = Server.GetLastError()

'get the property values
strErrNumber = CStr(objASPError.Number) 'normal error code
strASPCode = objASPError.ASPCode        'ASP error code (if available)
If Len(strASPCode) Then
   strASPCode = "'" & strASPCode & "' "
Else
   strASPCode = ""
End If
strErrDescription = objASPError.Description
strASPDescription = objASPError.ASPDescription
strCategory = objASPError.Category      'type or source of error
strFileName = objASPError.File          'file path and name
strLineNum = objASPError.Line           'line number in file
strColNum = objASPError.Column          'column number in line
If IsNumeric(strColNum) Then            'if available convert to integer
   lngColNum = CLng(strColNum)
Else
   lngColNum = 0
End If
strSourceCode = objASPError.Source    'source code of line

'create the error message string
strDetail = "ASP Error " & strASPCode & "occurred " & Now
If Len(strCategory) Then
   strDetail = strDetail & " in " & strCategory
End If
strDetail = strDetail & vbCrlf & "Error number: " & strErrNumber _
          & " (0x" & Hex(strErrNumber) & ")" & vbCrlf
If Len(strFileName) Then
   strDetail = strDetail & "File: " & strFileName
   If strLineNum > "0" Then
      strDetail = strDetail & ", line " & strLineNum
      If lngColNum > 0 Then
         strDetail = strDetail & ", column " & lngColNum
         If Len(strSourceCode) Then
            strDetail = strDetail & vbCrlf & strSourceCode & vbCrlf _
                      & String(lngColNum - 1, "-") & "^"
         End If
      End If
   End If
   strDetail = strDetail & vbCrlf
End If
strDetail = strDetail & strErrDescription & vbCrlf
If Len(strASPDescription) Then
   strDetail = strDetail & "ASP reports: " & strASPDescription & vbCrlf
End If

'now log error to a file. Edit the path to suit your machine.
'you need to give the IUSR_machinename permission to write and modify
'the file or directory used for the log file:
strErrorLog = "c:\temp\custom_error.log"
Set objFSO = Server.CreateObject("Scripting.FileSystemObject")
Set objTStream = objFSO.OpenTextFile(strErrorLog, 8, True)  '8 = ForAppending
If Err.Number = 0 Then objTStream.WriteLine strDetail & vbCrlf
If Err.Number = 0 Then
   objTStream.Close
   blnFailedToLog = False
Else
   blnFailedToLog = True
End If

'if we don't want to display the error page for
'a particular error, in this case 'type mismatch'
'we can jump to another page instead:
'If objASPError.Number = -2146828275 Then
'   Response.Clear
'  Response.Redirect "/"
'End If
%>

<HTML>
<HEAD>
<TITLE>There is a problem with our site</TITLE>
<STYLE TYPE="text/css">
BODY {font-family:Tahoma,Arial,sans-serif; font-size:10pt}
INPUT {font-family:Tahoma,Arial,sans-serif; font-size:9pt}
.heading {font-family:Tahoma,Arial,sans-serif; font-size:14pt; font-weight:bold}
.subhead {font-family:Tahoma,Arial,sans-serif; font-size:12pt; font-weight:bold; padding-bottom:5px}
.cite {font-family:Tahoma,Arial,sans-serif; font-size:8pt}
</STYLE>
</HEAD>
<BODY BGCOLOR="#FFFFFF">
<SPAN CLASS="heading">Dsol, il y a un problme sur notre site</SPAN><HR>
<SPAN CLASS="subhead">La page demande ne peut tre affiche.</SPAN><P>
<!--------------------------------------------------------------------------->

<%
'see if the logging to file failed
'if so, display message
If blnFailedToLog Then
   Response.Write "<B>WARNING: Cannot log error to file '" & strErrorLog & "'</B>.<P>"
End If

'see if we are displaying the error information
If Session("ShowError") = "Yes" Then
%>
   <PRE><% = Server.HTMLEncode(strDetail) %></PRE>
<%
End If

'see if we are displaying the debug information
If Session("ShowDebug") = "Yes" Then Server.Transfer "debug_request.asp"

'create the buttons to return to the previous or Home page
strReferrer = Request.ServerVariables("HTTP_REFERER")
If Len(strReferrer) Then
%>
   <FORM ACTION="<% = strReferrer %>">
   <INPUT TYPE="SUBMIT" NAME="cmdOK" VALUE="&nbsp;&nbsp;&nbsp;">
   &nbsp; Page Prcdente<P>
   </FORM>
<%
End If
%>
<FORM ACTION="/">
<INPUT TYPE="SUBMIT" NAME="cmdOK" VALUE="&nbsp;&nbsp;&nbsp;">
&nbsp; Page d'accueil<P>
</FORM>

<!--------------------------------------------------------------------------->
<HR><SPAN CLASS="cite">&copy;1999 <A CLASS="cite" HREF="http://www.wrox.com/">Wrox Press</A> -
<A CLASS="cite" HREF="http://webdev.wrox.co.uk/books/2610/"> ASP 3.0</A> </SPAN>
</BODY>
</HTML>
