<%
Function ParamDirectionDesc(iPD)

    ' return the description for a parameter direction

    Select Case iPD
    Case adParamUnknown
        ParamDirectionDesc = "adParamUnknown"
    Case adParamInput
        ParamDirectionDesc = "adParamInput"
    Case adParamOutput
        ParamDirectionDesc = "adParamOutput"
    Case adParamInputOutput
        ParamDirectionDesc = "adParamInputOutput"
    case adParamReturnValue
        ParamDirectionDesc = "adParamReturnValue"
    End Select

End Function

Function CursorTypeDesc(iCT)

    ' return the description for the cursor type
    
    Select Case iCT
    Case adOpenForwardOnly
        CursorTypeDesc = "adOpenForwardOnly"
    Case adOpenKeyset
        CursorTypeDesc = "adOpenKeyset"
    Case adOpenStatic
        CursorTypeDesc = "adOpenStatic"
    Case adOpenDynamic
        CursorTypeDesc = "adOpenDynamic"
    End Select

End Function

Function LockTypeDesc(iLT)

    ' return the description for the lock type

    Select Case iLT
    Case adLockReadOnly
        LockTypeDesc = "adLockReadOnly"
    Case adLockPessimistic
        LockTypeDesc = "adLockPessimistic"
    Case adLockOptimistic
        LockTypeDesc = "adLockOptimistic"
    Case adLockBatchOptimistic
        LockTypeDesc = "adLockBatchOptimistic"
    End Select

End Function

Function CursorLocationDesc(iCL)

    ' return the description for the cursor location

    Select Case iCL
    Case adUseServer
        CursorLocationDesc = "adUseServer"
    Case adUseClient
        CursorLocationDesc = "adUseClient"
    End Select

End Function

Function CommandTypeDesc(iCT)

    ' return the description for the command type

    Select Case iCT
    Case (adCmdText And adExecuteNoRecords)
        CommandTypeDesc = "adCmdText + NoRecs"
    Case (adCmdStoredProc And adExecuteNoRecords)
        CommandTypeDesc = "adCmdStoredProc + NoRecs"
    Case adCmdText
        CommandTypeDesc = "adCmdText"
    Case adCmdStoredProc
        CommandTypeDesc = "adCmdStoredProc"
    Case adCmdTable
        CommandTypeDesc = "adCmdTable"
    Case adCmdTableDirect
        CommandTypeDesc = "adCmdTableDirect"
    Case adCmdUnknown
        CommandTypeDesc = "adCmdUnknown"
    End Select

End Function

Function SchemaTypeDesc(iST)

    Dim sType

    Select Case iST
    Case adSchemaAsserts
        sType = "adSchemaAsserts"
    Case adSchemaCatalogs
        sType = "adSchemaCatalogs"
    Case adSchemaCharacterSets
        sType = "adSchemaCharacterSets"
    Case adSchemaCheckConstraints
        sType = "adSchemaCheckConstraints"
    Case adSchemaCollations
        sType = "adSchemaCollations"
    Case adSchemaColumnPrivileges
        sType = "adSchemaColumnPrivileges"
    Case adSchemaColumns
        sType = "adSchemaColumns"
    Case adSchemaColumnsDomainUsage
        sType = "adSchemaColumnsDomainUsage"
    Case adSchemaConstraintColumnUsage
        sType = "adSchemaConstraintColumnUsage"
    Case adSchemaConstraintTableUsage
        sType = "adSchemaConstraintTableUsage"
    Case adSchemaCubes
        sType = "adSchemaCubes"
    Case adSchemaDimensions
        sType = "adSchemaDimensions"
    Case adSchemaDBInfoKeywords
        sType = "adSchemaDBInfoKeywords"
    Case adSchemaDBInfoLiterals
        sType = "adSchemaDBInfoLiterals"
    Case adSchemaForeignKeys
        sType = "adSchemaForeignKeys"
    Case adSchemaHierarchies
        sType = "adSchemaHierarchies"
    Case adSchemaIndexes
        sType = "adSchemaIndexes"
    Case adSchemaKeyColumnUsage
        sType = "adSchemaKeyColumnUsage"
    Case adSchemaLevels
        sType = "adSchemaLevels"
    Case adSchemaMeasures
        sType = "adSchemaMeasures"
    Case adSchemaMembers
        sType = "adSchemaMembers"
    Case adSchemaPrimaryKeys
        sType = "adSchemaPrimaryKeys"
    Case adSchemaProcedureColumns
        sType = "adSchemaProcedureColumns"
    Case adSchemaProcedureParameters
        sType = "adSchemaProcedureParameters"
    Case adSchemaProcedures
        sType = "adSchemaProcedures"
    Case adSchemaProperties
        sType = "adSchemaProperties"
    Case adSchemaProviderSpecific
        sType = "adSchemaProviderSpecific"
    Case adSchemaProviderTypes
        sType = "adSchemaProviderTypes"
    Case adSchemaReferentialContraints
        sType = "adSchemaReferentialContraints"
    Case adSchemaSchemata
        sType = "adSchemaSchemata"
    Case adSchemaSQLLanguages
        sType = "adSchemaSQLLanguages"
    Case adSchemaStatistics
        sType = "adSchemaStatistics"
    Case adSchemaTableConstraints
        sType = "adSchemaTableConstraints"
    Case adSchemaTablePrivileges
        sType = "adSchemaTablePrivileges"
    Case adSchemaTables
        sType = "adSchemaTables"
    Case adSchemaTranslations
        sType = "adSchemaTranslations"
    Case adSchemaTrustees
        sType = "adSchemaTrustees"
    Case adSchemaUsagePrivileges
        sType = "adSchemaUsagePrivileges"
    Case adSchemaViewColumnUsage
        sType = "adSchemaViewColumnUsage"
    Case adSchemaViews
        sType = "adSchemaViews"
    Case adSchemaViewTableUsage
        sType = "adSchemaViewTableUsage"
    End Select
    
    SchemaTypeDesc = sType

End Function

Function DataTypeDesc(lngType)

    Select Case lngType
    Case adBigInt
        DataTypeDesc = "adBigInt"
    Case adBinary
        DataTypeDesc = "adBinary"
    Case adBoolean
        DataTypeDesc = "adBoolean"
    Case adBSTR
        DataTypeDesc = "adBSTR"
    Case adChapter
        DataTypeDesc = "adChapter"
    Case adChar
        DataTypeDesc = "adChar"
    Case adCurrency
        DataTypeDesc = "adCurrency"
    Case adDate
        DataTypeDesc = "adDate"
    Case adDBDate
        DataTypeDesc = "adDBDate"
    Case adDBFileTime
        DataTypeDesc = "adDBFileTime"
    Case adDBTime
        DataTypeDesc = "adDBTime"
    Case adDBTimeStamp
        DataTypeDesc = "adDBTimeStamp"
    Case adDecimal
        DataTypeDesc = "adDecimal"
    Case adDouble
        DataTypeDesc = "adDouble"
    Case adEmpty
        DataTypeDesc = "adEmpty"
    Case adError
        DataTypeDesc = "adError"
    Case adFileTime
        DataTypeDesc = "adFileTime"
    Case adGUID
        DataTypeDesc = "adGUID"
    Case adIDispatch
        DataTypeDesc = "adIDispatch"
    Case adInteger
        DataTypeDesc = "adInteger"
    Case adIUnknown
        DataTypeDesc = "adIUnknown"
    Case adLongVarBinary
        DataTypeDesc = "adLongVarBinary"
    Case adLongVarChar
        DataTypeDesc = "adLongVarChar"
    Case adLongVarWChar
        DataTypeDesc = "adLongVarWChar"
    Case adNumeric
        DataTypeDesc = "adNumeric"
    Case adPropVariant
        DataTypeDesc = "adPropVariant"
    Case adSingle
        DataTypeDesc = "adSingle"
    Case adSmallInt
        DataTypeDesc = "adSmallInt"
    Case adTinyInt
        DataTypeDesc = "adTinyInt"
    Case adUnsignedBigInt
        DataTypeDesc = "adUnsignedBigInt"
    Case adUnsignedInt
        DataTypeDesc = "adUnsignedInt"
    Case adUnsignedSmallInt
        DataTypeDesc = "adUnsignedSmallInt"
    Case adUnsignedTinyInt
        DataTypeDesc = "adUnsignedTinyInt"
    Case adUserDefined
        DataTypeDesc = "adUserDefined"
    Case adVarBinary
        DataTypeDesc = "adVarBinary"
    Case adVarChar
        DataTypeDesc = "adVarChar"
    Case adVariant
        DataTypeDesc = "adVariant"
    Case adVarNumeric
        DataTypeDesc = "adVarNumeric"
    Case adVarWChar
        DataTypeDesc = "adVarWChar"
    Case adWChar
        DataTypeDesc = "adWChar"
    Case Else
        DataTypeDesc = "other"
    End Select

End Function

Function StatusDesc(lStatus)
'
' cannot use a simple select case here as the status
' can be a combination of more than one value from RecordStatusEnum
' Exception is adRecOK

    Dim strStatus

    If lStatus = adRecOK Then
        StatusDesc = "The record was successfully updated."
        Exit Function
    End If

    If (lStatus And adRecNew) = adRecNew Then
        strStatus = strStatus & "The record is new."
    End If

    If (lStatus And adRecModified) = adRecModified Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was modified."
    End If

    If (lStatus And adRecDeleted) = adRecDeleted Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was deleted."
    End If

    If (lStatus And adRecUnmodified) = adRecUnmodified Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not modified."
    End If

    If (lStatus And adRecInvalid) = adRecInvalid Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not saved because its bookmark is invalid."
    End If

    If (lStatus And adRecMultipleChanges) = adRecMultipleChanges Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not saved because it would have affected multiple records."
    End If

    If (lStatus And adRecPendingChanges) = adRecPendingChanges Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not saved because it refers to a pending insert."
    End If

    If (lStatus And adRecCanceled) = adRecCanceled Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not saved because the operation was canceled."
    End If

    If (lStatus And adRecCantRelease) = adRecCantRelease Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The new record was not saved because of existing record locks."
    End If

    If (lStatus And adRecConcurrencyViolation) = adRecConcurrencyViolation Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not saved because optimistic concurrency was in use."
    End If

    If (lStatus And adRecIntegrityViolation) = adRecIntegrityViolation Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not saved because the user violated integrity constraints."
    End If

    If (lStatus And adRecMaxChangesExceeded) = adRecMaxChangesExceeded Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not saved because there were too many pending changes."
    End If

    If (lStatus And adRecObjectOpen) = adRecObjectOpen Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not saved because of a conflict with an open storage object."
    End If

    If (lStatus And adRecOutOfMemory) = adRecOutOfMemory Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not saved because the computer has run out of memory."
    End If

    If (lStatus And adRecPermissionDenied) = adRecPermissionDenied Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not saved because the user has insufficient permissions."
    End If

    If (lStatus And adRecDBDeleted) = adRecDBDeleted Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record was not saved because it violates the structure of the underlying database."
    End If
    
    If (lStatus And adRecPermissionDenied) = adRecPermissionDenied Then
        If strStatus <> "" Then strStatus = strStatus & vbCrLf
        strStatus = strStatus & "The record has already been deleted from the data source."
    End If

    StatusDesc = strStatus

End Function

Function FieldAttributeDesc(lAttr)

    Dim strAttr
    
    If (lAttr And adFldMayDefer) = adFldMayDefer Then
        strAttr = "adFldMayDefer"
    End If

    If (lAttr And adFldUpdatable) = adFldUpdatable Then
        If strAttr <> "" Then strAttr = strAttr & ", "
        strAttr = strAttr & "adFldUpdatable"
    End If

    If (lAttr And adFldUnknownUpdatable) = adFldUnknownUpdatable Then
        If strAttr <> "" Then strAttr = strAttr & ", "
        strAttr = strAttr & "adFldUnknownUpdatable"
    End If

    If (lAttr And adFldFixed) = adFldFixed Then
        If strAttr <> "" Then strAttr = strAttr & ", "
        strAttr = strAttr & "adFldFixed"
    End If

    If (lAttr And adFldIsNullable) = adFldIsNullable Then
        If strAttr <> "" Then strAttr = strAttr & ", "
        strAttr = strAttr & "adFldIsNullable"
    End If

    If (lAttr And adFldMayBeNull) = adFldMayBeNull Then
        If strAttr <> "" Then strAttr = strAttr & ", "
        strAttr = strAttr & "adFldMayBeNull"
    End If

    If (lAttr And adFldLong) = adFldLong Then
        If strAttr <> "" Then strAttr = strAttr & ", "
        strAttr = strAttr & "adFldLong"
    End If

    If (lAttr And adFldRowID) = adFldRowID Then
        If strAttr <> "" Then strAttr = strAttr & ", "
        strAttr = strAttr & "adFldRowID"
    End If

    If (lAttr And adFldRowVersion) = adFldRowVersion Then
        If strAttr <> "" Then strAttr = strAttr & ", "
        strAttr = strAttr & "adFldRowVersion"
    End If

    If (lAttr And adFldCacheDeferred) = adFldCacheDeferred Then
        If strAttr <> "" Then strAttr = strAttr & ", "
        strAttr = strAttr & "adFldCacheDeferred"
    End If

    FieldAttributeDesc = strAttr

End Function
%>

