<%

//---- RecordStatusEnum Values ----
var adRecOK = 0x0000000;
var adRecNew = 0x0000001;
var adRecModified = 0x0000002;
var adRecDeleted = 0x0000004;
var adRecUnmodified = 0x0000008;
var adRecInvalid = 0x0000010;
var adRecMultipleChanges = 0x0000040;
var adRecPendingChanges = 0x0000080;
var adRecCanceled = 0x0000100;
var adRecCantRelease = 0x0000400;
var adRecConcurrencyViolation = 0x0000800;
var adRecIntegrityViolation = 0x0001000;
var adRecMaxChangesExceeded = 0x0002000;
var adRecObjectOpen = 0x0004000;
var adRecOutOfMemory = 0x0008000;
var adRecPermissionDenied = 0x0010000;
var adRecSchemaViolation = 0x0020000;
var adRecDBDeleted = 0x0040000;

function RecordStatusDesc(lStatus)
{
//
// cannot use a simple select case here as the status
// can be a combination of more than one value from RecordStatusEnum
// Exception is adRecOK

    var strStatus;

    if (lStatus == adRecOK)
        return "The record was successfully updated.";

    If ((lStatus & adRecNew) == adRecNew)
        strStatus = "The record is new.";

    If ((lStatus & adRecModified) == adRecModified)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was modified.";
    }

    if ((lStatus & adRecDeleted) == adRecDeleted)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was deleted.";
    }

    if ((lStatus & adRecUnmodified) == adRecUnmodified)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not modified.";
    }

    if ((lStatus & adRecInvalid) == adRecInvalid)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not saved because its bookmark is invalid.";
    }

    if ((lStatus & adRecMultipleChanges) == adRecMultipleChanges)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not saved because it would have affected multiple records.";
    }

    if ((lStatus & adRecPendingChanges) == adRecPendingChanges)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not saved because it refers to a pending insert.";
    }

    if ((lStatus & adRecCanceled) == adRecCanceled)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not saved because the operation was canceled.";
    }

    if ((lStatus & adRecCantRelease) == adRecCantRelease)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The new record was not saved because of existing record locks.";
    }

    if ((lStatus & adRecConcurrencyViolation) == adRecConcurrencyViolation)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not saved because optimistic concurrency was in use.";
    }

    if ((lStatus & adRecIntegrityViolation) == adRecIntegrityViolation)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not saved because the user violated integrity constraints.";
    }

    if ((lStatus & adRecMaxChangesExceeded) == adRecMaxChangesExceeded)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not saved because there were too many pending changes.";
    }

    if ((lStatus & adRecObjectOpen) == adRecObjectOpen)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not saved because of a conflict with an open storage object.";
    }

    if ((lStatus & adRecOutOfMemory) == adRecOutOfMemory)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not saved because the computer has run out of memory.";
    }

    if ((lStatus & adRecPermissionDenied) == adRecPermissionDenied)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not saved because the user has insufficient permissions.";
    }

    if ((lStatus & adRecDBDeleted) == adRecDBDeleted)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record was not saved because it violates the structure of the underlying database.";
    }
    
    if ((lStatus & adRecPermissionDenied) == adRecPermissionDenied)
    {
        if (strStatus != "")
            strStatus = strStatus + sCrLF;
        strStatus = strStatus + "The record has already been deleted from the data source.";
    }

    return strStatus;
}
%>