<%@ LANGUAGE=VBSCRIPT %>
<!-- #INCLUDE FILE="../Include/Connection.asp" -->
<HTML>
<HEAD>
<TITLE>ASPPaging.asp</TITLE>
<STYLE TYPE="text/css">
BODY {font-family:Tahoma,Arial,sans-serif; font-size:10pt}
.heading {font-family:Tahoma,Arial,sans-serif; font-size:14pt; font-weight:bold}
.cite {font-family:Tahoma,Arial,sans-serif; font-size:8pt}
</STYLE>
</HEAD>
<BODY BGCOLOR="#FFFFFF">
<SPAN CLASS="heading">Paging through Recordsets using ASP</SPAN><HR>
<!--------------------------------------------------------------------------->

<%
  Dim rsData
  Dim iPage
  Dim iTotalPages
  Dim fldF
  Dim iRec
  Dim sQuote
  Dim sMe

  sQuote = Chr(34)  ' the double quote character

  Set rsData = Server.CreateObject("ADODB.Recordset")

  ' set the page size
  rsData.PageSize = 10
  rsData.CursorLocation = adUseClient

  ' open the data
  rsData.Open "authors", strConn, _
              adOpenForwardOnly, adLockReadOnly, adCmdTable

 ' get the requested data
  If Request.QueryString("PAGE") = "" Then
    iPage = 1
  Else
    ' protect against out of range pages, in case
    ' of a user specified page number
    If iPage < 1 Then
      iPage = 1
    Else
      If iPage > rsData.PageCount Then
        iPage = rsData.PageCount
      Else
        iPage = CInt(Request.QueryString("PAGE"))
      End If
    End If
  End If

  ' set the page
  rsData.AbsolutePage = iPage

  ' start building the table
  Response.Write "<TABLE BORDER=1><THEAD><TR>"
  For Each fldF In rsData.Fields
    Response.Write "<TD>" & fldF.Name & "</TD>"
  Next
  Response.Write "</TR></THEAD><TBODY>"

  ' now loop through the 
  For iRec = 1 To rsData.PageSize
    If Not rsData.EOF Then
      Response.Write "<TR>"
      For Each fldF In rsData.Fields
        Response.Write "<TD>" & fldF.Value & "</TD>"
      Next
      Response.Write "</TR>"
      rsData.MoveNext
    End If
  Next
  Response.Write "</TBODY></THEAD></TABLE><P>"

  ' now some paging controls
  sMe = Request.ServerVariables("SCRIPT_NAME")
  Response.Write "&nbsp;<A HREF=" & sQuote & sMe & "?PAGE=1" & sQuote & ">First Page</A>"

  ' only give an active previous page if there are previous pages
  If iPage = 1 Then
    Response.Write "&nbsp;<SPAN>Previous Page</SPAN>"
  Else
    Response.Write "&nbsp;<A HREF=" & sQuote & sMe & "?PAGE=" & iPage - 1 & sQuote & ">Previous Page</A>"
  End If

  ' only give an active next page if there are more pages
  If iPage = rsData.PageCount Then
    Response.Write "&nbsp;<SPAN>Next Page</SPAN>"
  Else
    Response.Write "&nbsp;<A HREF=" & sQuote & sMe & "?PAGE=" & iPage + 1 &  sQuote & ">Next Page</A>"
  End If

  Response.Write "&nbsp;<A HREF=" & sQuote & sMe & "?PAGE=" & rsData.PageCount & sQuote & ">Last Page</A>"

  ' and clear up
  rsData.Close
  Set rsData = Nothing
%>

<!--------------------------------------------------------------------------->
<HR><SPAN CLASS="cite">&copy;1999 <A CLASS="cite" HREF="http://www.wrox.com/">Wrox Press</A> -
<A CLASS="cite" HREF="http://webdev.wrox.co.uk/books/2610/">Professional ASP 3.0</A> (ISBN: 1-861002-61-0)</SPAN>
</BODY>
</HTML>