<%@ LANGUAGE=VBSCRIPT %>
<!-- #INCLUDE FILE="../Include/Connection.asp" -->
<HTML>
<HEAD>
<TITLE>RDS Single Record Data Binding</TITLE>
<STYLE TYPE="text/css">
BODY		{font-family:Tahoma,Arial,sans-serif; font-size:10pt}
.heading	{font-family:Tahoma,Arial,sans-serif; font-size:14pt; font-weight:bold}
.cite		{font-family:Tahoma,Arial,sans-serif; font-size:8pt}
</STYLE>
</HEAD>
<BODY BGCOLOR="#FFFFFF">
<SPAN CLASS="heading">Single Record Data Binding with RDS</SPAN><HR>
<!--------------------------------------------------------------------------->

<OBJECT CLASSID="clsid:BD96C556-65A3-11D0-983A-00C04FC29E33"
        ID="dsoData" HEIGHT="0" WIDTH="0">
  <PARAM NAME="URL" VALUE="RDSURLData.asp?TABLE=authors">
</OBJECT>

<TABLE ID="tblData">
  <TR><TD>ID:</TD><TD><INPUT TYPE="TEXT" DATASRC="#dsoData" DATAFLD="au_id"></INPUT></TD></TR>
  <TR><TD>First Name:</TD><TD><INPUT TYPE="TEXT" DATASRC="#dsoData" DATAFLD="au_fname"></INPUT></TD></TR>
  <TR><TD>Last Name:</TD><TD><INPUT TYPE="TEXT" DATASRC="#dsoData" DATAFLD="au_lname"></INPUT></TD></TR>
  <TR><TD>Phone:</TD><TD><INPUT TYPE="TEXT" DATASRC="#dsoData" DATAFLD="phone"></INPUT></TD></TR>
  <TR><TD>Address:</TD><TD><INPUT TYPE="TEXT" DATASRC="#dsoData" DATAFLD="address"></INPUT></TD></TR>
  <TR><TD>City:</TD><TD><INPUT TYPE="TEXT" DATASRC="#dsoData" DATAFLD="city"></INPUT></TD></TR>
  <TR><TD>State:</TD><TD><INPUT TYPE="TEXT" DATASRC="#dsoData" DATAFLD="state"></INPUT></TD></TR>
  <TR><TD>Zip:</TD><TD><INPUT TYPE="TEXT" DATASRC="#dsoData" DATAFLD="zip"></INPUT></TD></TR>
  <TR><TD>Contact:</TD><TD><INPUT TYPE="TEXT" DATASRC="#dsoData" DATAFLD="contract"></INPUT></TD></TR>
</TABLE>

<button id="cmdFirst" title="First Record"
    onclick="dsoData.recordset.MoveFirst()">&nbsp;|&lt;&nbsp;</button>
<button id="cmdPrevious" title="Previous Record"
    onclick="if (!dsoData.recordset.BOF) dsoData.recordset.MovePrevious()">
    &nbsp;&lt;&nbsp;</button>
<button id="cmdNext" title="Next Record"
    onclick="if (!dsoData.recordset.EOF) dsoData.recordset.MoveNext()">
    &nbsp;&gt;&nbsp;</button>
<button id="cmdLast" title="Last Record"
    onclick="dsoData.recordset.MoveLast()">&nbsp;&gt;|&nbsp;</button>&nbsp;
<button id="cmdDelete" title="Delete This Record"
    onclick="dsoData.recordset.Delete()">Delete</button>&nbsp;
<button id="cmdAddNew" title="Add New Record"
    onclick="dsoData.recordset.AddNew()">Add</button>&nbsp;
<button id="cmdCancelAll" title="Abandon All Changes"
    onclick="cancelChanges()">Cancel</button>&nbsp;
<button id="cmdUpdateAll" title="Save All Changes"
    onclick="updateData()">Save</button>

<SPAN ID="lblSuccess" STYLE="display:none">Changes applied successfully</SPAN>
<BUTTON ID="cmdShowErrors" onclick="showErrors()"
        STYLE="display:none">Show previous errors</BUTTON>
<BR>
<SPAN ID="fraErrors" BORDER="1" STYLE="display:none; width:100%">
  <HR>
  An error occurred whilst updating the data.<BR>
  The following table details the errors:<P>
  <TABLE ID="tblErrors">
  </TABLE>
  <BR>
  <BUTTON ID="cmdHideErrors" onclick="hideErrors(false)">Hide Errors</BUTTON>
</SPAN>

<SCRIPT LANGUAGE=JScript>

var sCR = String.fromCharCode(13);

function updateData()
{
  // try and update the data
  try
  {
    // submit the changes back to the server
    dsoData.submitChanges();
    dsoData.Refresh();

    // everything OK, so let the user know
    hideErrors(true);
  }

  // RDS throws an error if the update fails
  catch (e)
  {
    var sError;				// error string
    var fldF;				// field in recordset
    var iStatus;			// error status or record
    var rsConflicts;			// recordset of errors
    var adAffectAll = 3;		// resync all records
    var adResyncUnderlyingValues = 1;	// only  resync underlyingValue property

    sError = '<TABLE ID="tblErrors" BORDER="1"><THEAD><TR>' + 
             '<TD>Status</TD>' +
             '<TD>Field</TD>' + 
             '<TD>Your Value</TD>' + 
             '<TD>Value in data store</TD>' +
             '<TD>Value before you changed it</TD>' +
             '<TD>Field Status</TD>' +
             '</TR></THEAD><TBODY>';

    // there's been an error, so get the underlyingValues back
    // from the server to see what's changed
    try
    {
      dsoData.recordset.resync(adAffectAll, adResyncUnderlyingValues);
    }
    catch(e)
    {
      // an error occurred during synchonization
      var eErr;

      // build a table of the errors
      sError = e + '<P>' + '<TABLE ID="tblErrors" BORDER="1"><THEAD><TR>' +
               '<TD>Number</TD><TD>Description</TD></TR>' + 
               '</THEAD><TBODY>';
      for (eErr = new Enumerator(dsoData.recordset.activeConnection.Errors);
           !eErr.atEnd(); eErr.moveNext())
        sError = sError + '<TR><TD>' + eErr.item().number + '</TD>' +
                              '<TD>' + eErr.item().description + '</TD>' + 
                          '</TR>';
      sError = sError + '</TBODY></TABLE>';

      // show the errors in a new window;
      tblErrors.outerHTML = sError;
      showErrors();

      return;
    }

    // clone the recordset so we don't alter the position of the original
    rsConflicts = dsoData.recordset.clone();

    // loop through the records in the recordset
    while (!rsConflicts.EOF)
    {
      // we're only interested in records that are modified in some way
      iStatus = rsConflicts.status;
      if (iStatus != adRecUnmodified)
      {
        // identify the reason for the error
        sError = sError + '<TR><TD>' + RecordStatusDesc(iStatus) + '</TD>';

        // loop through the fields
        for (fldF = new Enumerator(rsConflicts.Fields);
             !fldF.atEnd(); fldF.moveNext())
        {
          // add the conflicting details to the table
          if (fldF.item().originalValue != fldF.item().underlyingValue)
            sError = sError + '<TD>' + fldF.item().name + '</TD>' +
                              '<TD>' + fldF.item().value + '</TD>' + 
                              '<TD>' + fldF.item().underlyingValue + '</TD>' +
                              '<TD>' + fldF.item().originalValue + '</TD>' +
                              '<TD>' + fldF.item().status + '</TD>'
                              ;
        }
        sError = sError + '</TR>';
      }
      rsConflicts.moveNext();
    }
    sError = sError + '</TBODY></TABLE>';

    // show the errors in a new window;
    tblErrors.outerHTML = sError;
    showErrors();
  }
}

function showErrors()
{
  // show the errors
  fraErrors.style.display = 'inline';
  lblSuccess.style.display = 'none';
}

function hideErrors(bSuccess)
{
  // hide the errors
  fraErrors.style.display = 'none';
  if (bSuccess)
  {
    lblSuccess.style.display = 'inline';
    cmdShowErrors.style.display = 'none';
  }
  else
    cmdShowErrors.style.display = 'inline';
}

function cancelChanges()
{
  // cancel changes
  dsoData.CancelUpdate();
  lblSuccess.style.display = 'none';
  cmdShowErrors.style.display = 'none';
  fraErrors.style.display = 'none';
}


//-------------------------------------------------------------

// record status enum values
var adRecNew = 0x0000001;
var adRecModified = 0x0000002;
var adRecDeleted = 0x0000004;
var adRecUnmodified = 0x0000008;
var adRecInvalid = 0x0000010;
var adRecMultipleChanges = 0x0000040;
var adRecPendingChanges = 0x0000080;
var adRecCanceled = 0x0000100;
var adRecCantRelease = 0x0000400;
var adRecConcurrencyViolation = 0x0000800;
var adRecIntegrityViolation = 0x0001000;
var adRecMaxChangesExceeded = 0x0002000;
var adRecObjectOpen = 0x0004000;
var adRecOutOfMemory = 0x0008000;
var adRecPermissionDenied = 0x0010000;
var adRecSchemaViolation = 0x0020000;
var adRecDBDeleted = 0x0040000;

function RecordStatusDesc(lStatus)
{
// Return the record status
// The status can be a combination of values

    var strStatus = '';

    if ((lStatus & adRecNew) == adRecNew)
        strStatus = "The record is new.";

    if ((lStatus & adRecModified) == adRecModified)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was modified by another user.";
    }

    if ((lStatus & adRecDeleted) == adRecDeleted)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was deleted by another user.";
    }

    if ((lStatus & adRecUnmodified) == adRecUnmodified)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not modified.";
    }

    if ((lStatus & adRecInvalid) == adRecInvalid)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not saved because its bookmark is invalid.";
    }

    if ((lStatus & adRecMultipleChanges) == adRecMultipleChanges)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not saved because it would have affected multiple records.";
    }

    if ((lStatus & adRecPendingChanges) == adRecPendingChanges)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not saved because it refers to a pending insert.";
    }

    if ((lStatus & adRecCanceled) == adRecCanceled)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not saved because the operation was canceled.";
    }

    if ((lStatus & adRecCantRelease) == adRecCantRelease)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The new record was not saved because of existing record locks.";
    }

    if ((lStatus & adRecConcurrencyViolation) == adRecConcurrencyViolation)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not saved because optimistic concurrency was in use.";
    }

    if ((lStatus & adRecIntegrityViolation) == adRecIntegrityViolation)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not saved because the user violated integrity constraints.";
    }

    if ((lStatus & adRecMaxChangesExceeded) == adRecMaxChangesExceeded)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not saved because there were too many pending changes.";
    }

    if ((lStatus & adRecObjectOpen) == adRecObjectOpen)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not saved because of a conflict with an open storage object.";
    }

    if ((lStatus & adRecOutOfMemory) == adRecOutOfMemory)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not saved because the computer has run out of memory.";
    }

    if ((lStatus & adRecPermissionDenied) == adRecPermissionDenied)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not saved because the user has insufficient permissions.";
    }

    if ((lStatus & adRecDBDeleted) == adRecDBDeleted)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record was not saved because it violates the structure of the underlying database.";
    }
    
    if ((lStatus & adRecPermissionDenied) == adRecPermissionDenied)
    {
        if (strStatus != "")
            strStatus = strStatus + sCR;
        strStatus = strStatus + "The record has already been deleted from the data source.";
    }

    return strStatus;
}
</SCRIPT>

<!--------------------------------------------------------------------------->
<HR><SPAN CLASS="cite">&copy;1999 <A CLASS="cite" HREF="http://www.wrox.com/">Wrox Press</A> -
<A CLASS="cite" HREF="http://webdev.wrox.co.uk/books/2610/">Professional ASP 3.0</A> (ISBN: 1-861002-61-0)</INPUT>
</BODY>
</HTML>