CREATE PROCEDURE usp_PagedAuthors
	@iPage		int,
	@iPageSize	int
AS
BEGIN
	-- disable row counts
	SET NOCOUNT ON

	-- declare variables
	DECLARE @iStart		int		-- start record
	DECLARE @iEnd		int		-- end record
	DECLARE @iPageCount		int		-- total number of pages

	-- create the temporary table
	CREATE TABLE #PagedAuthors
	(
		ID		int		IDENTITY,
		au_id		varchar(11)	NOT NULL ,
		au_lname	varchar(40)	NOT NULL ,
		au_fname	varchar(20)	NOT NULL ,
		phone		char(12)		NOT NULL ,
		address		varchar(40)	NULL ,
		city		varchar(20)	NULL ,
		state		char(2)		NULL ,
		zip		char(5)		NULL ,
		contract		bit		NOT NULL 
	)

	-- populate the temporary table
	INSERT INTO #PagedAuthors (au_id, au_lname, au_fname, 
			phone, address, city, state, zip, contract)
	SELECT	au_id, au_lname, au_fname, 
			phone, address, city, state, zip, contract
	FROM		authors


	-- work out how many pages there are in total
	SELECT	@iPageCount = COUNT(*)
	FROM 		authors

	SELECT	@iPageCount = CEILING(@iPageCount / @iPageSize) + 1

	-- check the page number
	IF @iPage < 1
		SELECT @iPage = 1

	IF @iPage > @iPageCount
		SELECT @iPage = @iPageCount

	-- calculate the start and end records
	SELECT @iStart = (@iPage - 1) * @iPageSize
	SELECT @iEnd = @iStart + @iPageSize + 1

	-- select only those records that fall within our page
	SELECT	au_id, au_lname, au_fname, 
			phone, address, city, state, zip, contract
	FROM		#PagedAuthors
	WHERE	ID > @iStart
	AND		ID < @iEnd


	DROP TABLE #PagedAuthors

	-- turn back on record counts
	SET NOCOUNT OFF

	-- Return the number of records left
	RETURN @iPageCount
END