<%

Sub TraverseTree(recNode)

  Dim rsChildren
  Dim recChildNode

' Display the node name
  Response.Write FormatItem(recNode("RESOURCE_PARSENAME")) & "<BR>"

' Get any child nodes
  Set rsChildren = recNode.GetChildren

' Increase the indenting level
  intLevel = intLevel + 1

' Loop through the children
  While Not rsChildren.EOF

  ' Does this child contain other children
    If rsChildren("RESOURCE_ISCOLLECTION") Then
    ' Create a new child node
      Set recChildNode = Server.CreateObject("ADODB.Record")

    ' Open the new child node
      recChildNode.Open rsChildren

    ' Traverse this child
      TraverseTree recChildNode

    ' Close up
      recChildNode.Close
      Set recChildNode = Nothing
    Else
      Response.Write FormatItem(rsChildren("RESOURCE_PARSENAME")) & "<BR>"
    End If

    rsChildren.MoveNext
  Wend
      
' Decrease the indenting level
  intLevel = intLevel - 1

' Close the child recordset
  rsChildren.Close
  Set rsChildren = Nothing

End Sub

Function FormatItem(strItem)

  Dim strSpaces

  strSpaces = Space(intLevel * 2)
  strSpaces = Replace (strSpaces, "..", "..&nbsp;&nbsp;..")

  FormatItem = strSpaces & Replace(strItem, "%20", " ")

End Function


%>