VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 1  'NoTransaction
END
Attribute VB_Name = "BookTitles"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public Function RetrieveTitleListASP(strConn As Variant)

  Dim arTitles()
  Dim arDiscount()
  Dim varResponse
  Dim intCount, intRows
  Dim objContext As COMSVCSLib.ObjectContext
  Dim objResponse As ASPTypeLibrary.Response
  Dim res
  
  res = RetrieveTitleList(strConn, arTitles, arDiscount)
  Set objContext = GetObjectContext
  
  If res = True Then
  
    varResponse = "<P>The following books are currently defined in the " & _
                  "pubs database:" & vbCrLf & "<TABLE CELLSPACING=""2""" & _
                  "CELLPADDING=""0"">" & vbCrLf & "<TR>" & _
                  "<TD BGCOLOR=""#3AC2EF""><STRONG>ID</STRONG></TD>" & vbCrLf & _
                  "<TD BGCOLOR=""#3AC2EF""><STRONG>Title</STRONG></TD>" & vbCrLf & _
                  "<TD BGCOLOR=""#3AC2EF""><STRONG>Price</STRONG></TD>" & vbCrLf & _
                  "<TD BGCOLOR=""#3AC2EF""><STRONG>Discount</STRONG></TD>" & vbCrLf & _
                  "<TD BGCOLOR=""#3AC2EF""><STRONG>Notes</STRONG></TD>" & vbCrLf & _
                  "<TD BGCOLOR=""#3AC2EF""></TD></TR><TR></TR>"

    intRows = UBound(arTitles, 2)
    For intCount = 0 To intRows
     
      varResponse = varResponse & "<TR>" & _
                    "<TD BGCOLOR=""#3AC2EF"">" & arTitles(0, intCount) & _
                    "<TD BGCOLOR=""#3AC2EF"">" & arTitles(1, intCount) & _
                    "<TD BGCOLOR=""#3AC2EF"">" & arTitles(2, intCount) & _
                    "<TD BGCOLOR=""#3AC2EF"">" & arDiscount(intCount) & _
                    "<TD BGCOLOR=""#3AC2EF"">" & arTitles(3, intCount) & _
                    "<TD BGCOLOR=""#3AC2EF"">" & _
                    "<FORM NAME=""A"" METHOD=""POST"" ACTION=""Delete.asp?id=" & arTitles(0, intCount) & """>" & _
                    "<INPUT TYPE=""SUBMIT"" VALUE=""Delete""" & _
                    "NAME=""B1""></FORM></TD></TR>"
   
    Next
   
    varResponse = varResponse & "</TABLE>" & vbCrLf & _
                  "<FORM NAME=""A"" METHOD=""POST"" ACTION=""Add.asp"">" & _
                  "<INPUT TYPE=""SUBMIT"" VALUE=""Add a new Title"" NAME=""B1"">" & _
                  "</FORM>"

    objContext.SetComplete
 Else
    varResponse = Right(CStr(arTitles(0)), 8)
    objContext.SetAbort
 End If
 
 Set objResponse = objContext("Response")
 objResponse.Write varResponse
  
 Set objResponse = Nothing
 Set objContext = Nothing

End Function
                                     

Public Function RetrieveTitleList(strConn As Variant, arTitles As Variant, _
                                  arDiscount As Variant) As Variant

  On Error GoTo errorRetrieveTitleList

  Dim objBookData As BookData.TitleData
  Dim blnTitlesOK As Boolean

  Set objBookData = CreateObject("BookData.TitleData")

  blnTitlesOK = objBookData.GetTitleList(CStr(strConn), arTitles)
  Set objBookData = Nothing

  If blnTitlesOK Then
     Dim intRows, intCount
     intRows = UBound(arTitles, 2)
     'arDiscount = Array(1)
     ReDim arDiscount(intRows)

     For intCount = 0 To intRows
         If IsNull(arTitles(2, intCount)) Then arTitles(2, intCount) = 0
         arDiscount(intCount) = Round((arTitles(2, intCount) * 0.65), 2)
     Next intCount

     RetrieveTitleList = "True"
     GetObjectContext.SetComplete
  Else
     RetrieveTitleList = "False - " & arTitles
     GetObjectContext.SetAbort
  End If

  Exit Function

errorRetrieveTitleList:

  RetrieveTitleList = Err.Description

End Function

Public Function AddTitle(Id As Variant, Title As Variant, Price As Variant, _
                         Notes As Variant, strConn As String) As Variant

  On Error GoTo errorAddTitle

  Dim objBookData As BookData.TitleData
  Set objBookData = CreateObject("BookData.TitleData")

  AddTitle = objBookData.AddTitleToDB(CStr(Id), CStr(Title), CCur(Price), _
                                      CStr(Notes), CStr(strConn))
  Set objBookData = Nothing

  If AddTitle = True Then
     GetObjectContext.SetComplete
  Else
     GetObjectContext.SetAbort
  End If

  Exit Function

errorAddTitle:

  AddTitle = "Error - " & Err.Description
  GetObjectContext.SetAbort

End Function

Public Function DeleteTitle(Id As Variant, strConn As Variant) As Variant

  Dim objBookData As BookData.TitleData
  Set objBookData = CreateObject("BookData.TitleData")
    
  Dim ret As Variant
  ret = objBookData.CheckTitleExists(CStr(Id), CStr(strConn))
    
  If ret <> True Then
     GetObjectContext.SetAbort
     Set objBookData = Nothing
     DeleteTitle = False
     Exit Function
  End If
    
  DeleteTitle = objBookData.DeleteTitleFromDB(CStr(Id), CStr(strConn))
  GetObjectContext.SetComplete
  Set objBookData = Nothing

End Function

