<%

Dim gTermList
gTermList = "No background information available for this story."

Sub ShowHeadlines(Section,Style,Start,Limit)

	  Dim strSep, intCount, objXML, objRootHeadlines, intNode, strHeadline, strFolder, strFile

  	If Style = "bullets" Then
     		strSep = "<LI>"
  	Else
     		strSep = "<P>"
  	End If

	
   ' Checks to see if XML object exists
	If Not IsObject(Application("objXML")) Then
		Response.Write("No data available.")
		Response.End
	End If


' Creates an instance of the XML processor object
  Set objXML = Application("objXML")
	
' Sets the node 'content' as the root element
  Set objRootHeadlines = objXML.documentElement.selectSingleNode("content")

' Loop through each news item to extract headlines and urls
  For intNode = 0 To (objRootHeadlines.childNodes.length - 1)

      strHeadline = objRootHeadlines.childNodes.item(intNode).childNodes.item(0).text
      strFolder = objRootHeadlines.childNodes.item(intNode).childNodes.item(2).text
      strFile = objRootHeadlines.childNodes.item(intNode).childNodes.item(3).text

    ' Gets only the items from the selected folder and within the proper range
      If Section = strFolder Then
         intCount = intCount + 1
         If intCount >= Start Then
            Response.Write(strSep & "<A HREF='storydisplay.asp?folder=" & _
                           strFolder & "&file=" & strFile & "'>" & _
                           strHeadline & "</A>")
         End If
      End If

' Checks to see if at the Limit yet, if so it Exits the loop
  If intCount = Limit Then
     Exit For
  End If

  Next

  Response.Write("<P>")


End Sub


Sub ShowBlurbs(Section,Style,Start,Limit)

   Dim strSep, intCount, objXML, objRootHeadlines, intNode, strHeadline, strBlurb, strFolder, strFile

   If Style = "bullets" Then
      strSep = "<LI>"
   End If

   ' Checks to see if XML object exists
	If Not IsObject(Application("objXML")) Then
		Response.Write("No data available.")
		Response.End
	End If

' Creates an instance of the XML processor object
  Set objXML = Application("objXML")

' Sets the node 'content' as the root element
  Set objRootHeadlines = objXML.documentElement.selectSingleNode("content")

' Loop through each news item to extract headlines and urls
  For intNode = 0 To (objRootHeadlines.childNodes.length - 1)

     strHeadline = objRootHeadlines.childNodes.item(intNode).childNodes.item(0).text
     strBlurb = objRootHeadlines.childNodes.item(intNode).childNodes.item(1).text
     strFolder = objRootHeadlines.childNodes.item(intNode).childNodes.item(2).text
     strFile = objRootHeadlines.childNodes.item(intNode).childNodes.item(3).text


   ' Gets only the items from the selected folder and within the proper range
     If Section = strFolder Then
        intCount = intCount + 1
        If intCount >= Start Then
           Response.Write(strSep & "<B><A HREF='storydisplay.asp?folder=" & _
                          strFolder & "&file=" & strFile & "'>" & strHeadline & _
                          "</A></B><BR>")
           Response.Write("<FONT SIZE=2>" & strBlurb & "<P>")
        End If
     End If

     If intCount = Limit Then
        Exit For
     End If

  Next


End Sub


Sub ShowBriefs(Limit)

  Dim intCount, objXML, objRootHeadlines, intNode, strHeadline, strBlurb, strFolder, strFile

   ' Checks to see if XML object exists
	If Not IsObject(Application("objXML")) Then
		Response.Write("No data available.")
		Response.End
	End If

  Set objXML = Application("objXML")

  Set objRootHeadlines = objXML.documentElement.selectSingleNode("content")

' Loop through each news item to extract headlines and urls
  For intNode = 0 To (objRootHeadlines.childNodes.length - 1)

      strHeadline = objRootHeadlines.childNodes.item(intNode).childNodes.item(0).text
      strBlurb = objRootHeadlines.childNodes.item(intNode).childNodes.item(1).text
      strFolder = objRootHeadlines.childNodes.item(intNode).childNodes.item(2).text
      strFile = objRootHeadlines.childNodes.item(intNode).childNodes.item(3).text

      If strFolder = "Breves" Then
         intCount = intCount + 1
         Response.Write(strSep & "<B>" & strHeadline & "</B><BR>")
         Response.Write("<font size=1>" & strBlurb & "<P>")
      End If

     If intCount = Limit Then
        Exit For
     End If

   Next


End Sub


Sub ShowStory(Folder,File)
	
  On Error Resume Next

  Dim strSourceFile, objRootStory, objXML, strHeadline, strByline, _
strDateline, strBody, objArtset, strTerm, intNode

  strSourceFile = Server.MapPath(Folder) & "\" & File

' GET THE STORY

' CREATE AN INSTANCE OF THE XML PROCESSOR OBJECT
  Set objXML = Server.CreateObject("Microsoft.XMLDOM")

' LOAD THE REQUESTED STORY
  objXML.load(strSourceFile)

' Sets the document element of the story
  Set objRootStory = objXML.documentElement

' PARSE MAIN ELEMENTS INTO VARIABLES

' Instead of DTD, check for parsing error in well-formedness
If objXML.parseError = 0 Then

 ' Gets each of the elements of the story, if available
 ' HEADLINE ELEMENT
   strHeadline = objRootStory.childNodes.item(0).text
 ' BYLINE ELEMENT
   strByline = objRootStory.childNodes.item(1).text
 ' DATALINE ELEMENT
   strDateline = objRootStory.ChildNodes.item(2).text
 ' BODY ELEMENT
   strBody = objRootStory.childNodes.item(3).xml

 ' ARTWORK ELEMENT (OPTIONAL)
 ' Puts any artwork into a node
   Set objArtset = objRootStory.selectNodes("artset")

 ' If artwork is in node, then process it and put into HTML table
   If objArtset.length > 0 Then
      artfile = objArtset.item(0).childNodes.item(0).childNodes.item(0).text
      caption = objArtset.item(0).childNodes.item(0).childNodes.item(1).text
      artwork = "<TABLE BORDER=0 bgcolor=#CCCCCC ALIGN=RIGHT " & _
                "CELLSPACING=5 WIDTH=150><TR><TD><IMG SRC=""artwork/" & _
                artfile & """ ALIGN=RIGHT BORDER=0></TD></TR>"
      artwork = artwork & "<TR><TD><FONT FACE=""arial,sans-serif""" & _
                "SIZE=1 COLOR=#555555><I>" & caption & _
                "</I></FONT></TD></TR></TABLE>"
   End If

'GET WHOLE GLOSSARY
' LOAD SETTINGS.XML USING EXISTING INSTANCE OF XML PROCESSOR
  
  Set objXML = Application("objXML")

' SELECT THE GLOSSARY ELEMENT AS CURRENT NODE
  Set objRootTerms = objXML.documentElement.selectSingleNode("glossary")

'COLLECT MATCHING GLOSSARY TERMS	
' FOR/NEXT LOOP CHECKING BODY ELEMENT FOR MATCHES IN GLOSSARY NODE
  For intNode = 0 to objRootTerms.childNodes.length - 1
     strTerm = objRootTerms.childNodes(intNode).childNodes(0).text

     If InStr(strBody,strTerm)>0 Then
        If gTermList = "No background information available for this story." _
           Then
             gTermList = ""
        End If
      ' FORMAT EACH MATCH FOR HTML DISPLAY
      ' ADD EACH FORMATTED MATCH TO GLOBAL STRING FOR LATER USE
        gTermList = gTermList & "<DIV ID=""Term" & intNode & """><B>" & strTerm & _
                   ":</B><BR>" & objRootTerms.childNodes(intNode).childNodes(1).xml & _
                   "</DIV><P>"

        strBody = Replace(strBody, strTerm, ("<FONT COLOR=#0000BB STYLE=" & _
                       """cursor:hand;"" onmouseover=""Term" & intNode & _
                       ".className='selected'"" onmouseout=""Term" & intNode & _
                       ".className='plain' ""><U>" & strTerm & _
                       "</U></FONT>"), 1, 1)

     End If
  Next

' FORMAT AND WRITE STORY
' If one of the elements of the story are missing then don't display it
  If strHeadline="" Or strByline="" Or strDateline="" Or strBody="" Then
     Response.Write("<Font Color=#555555><I>Sorry, the requested " & _
                    "story is not availabe right now.<BR>" & _
                    "Please try again later.</I><P>&nbsp;</P>" & _
                    "<P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P>")

  Else
   ' STANDARD NON-FONT-SPECIFIC HTML FOR EACH STORY
   ' RESPONSE.WRITE TO STREAM
     Response.Write("<H2>" & strHeadline & "</H2>")
     Response.Write("<HR Size=1 NOSHADE COLOR=#BBBBBB>")
     Response.Write("<FONT SIZE=1 COLOR=#444444><B>" & strByline & _
                    "</B></FONT><BR>")
     Response.Write("<FONT SIZE=1 COLOR=#444444><I>" & strDateline & _
                    "</I></FONT>")
     Response.Write("<HR SIZE=1 NOSHADE COLOR=#BBBBBB>")
     Response.Write(artwork)
     Response.Write("<FONT SIZE=2>" & strBody & "</FONT>")

  End If

Else
' If there was a well-formedness error, don't display story
  Response.Write("<FONT COLOR=#555555><I>Sorry, the requested story " & _
                 "is not availabe right now.<BR>Please try again " & _
                 "later.</I><P>&nbsp;</P><P>&nbsp;</P><P>&nbsp;</P>" & _
                 "<P>&nbsp;</P>")

End If


End Sub


%>