<%
' creates xml data from a recordset

Dim iLevel
Dim sQ
Dim sCR

sQ = chr(34)
sCR = chr(13)

Function RecordsetToXML (oRec, sName, bNS)
'
' Purpose:	Converts an ADO recordset to an XML stream
' Parameters:	oRec		The XML Recordset
'		sName		The namespace name
'		bNS		True to use namespaces (the way the mspersist does)
'				False just to output plain XML, 1 tag per field
	dim sXML

	If bNS Then
		sXML = RecToXMLNS (oRec, sName)
	Else
		sXML = RecToXML (oRec, sName)
	End If

	RecordsetToXML = "<?xml version='1.0' encoding='iso-8859-1'?>" & sCR & sXML

End Function

Function RecToXML (oRec, sName)

	Dim oFld
	Dim sXML
	Dim sSpaces
	Dim sNames

	' work out the indent level
	sSpaces = Space (iLevel * 2)

	' is sName plural?
	' this allows us to have <items> and <item>
	If Right(sName, 1) = "s" Then
		sNames = sName
		sName = Left (sName, Len(sName) - 1)
	Else
		sNames = sName & "s"
	End If

	sXML = sSpaces & "<" & sNames & ">" & vbCR

	' now move in one level
	iLevel = iLevel + 1
	sSpaces = Space (iLevel * 2)

	' loop through the records
	oRec.MoveFirst
	While Not oRec.EOF
		' loop through the fields
		sXML = sXML & sSpaces & "<" & sName & ">" & vbCR
		For Each oFld In oRec.Fields
			' recurse if a child recordset
			If oFld.Type = adChapter Then
				Set oChapter = oFld.Value
				If Not oChapter.EOF Then
					iLevel = iLevel + 1
					sXML = sXML & RecToXML (oChapter, oFld.Name)
					iLevel = ilevel - 1
				End If
			Else
				sXML = sXML & sSpaces & "  " & _
					"<" & oFld.Name & ">" & _
					      ProperFormat(oFld) & _
					"</" & oFld.Name & ">" & vbCR
			End If
		Next
		sXML = sXML & sSpaces & "</" & sName & ">" & vbCR

		oRec.MoveNext
	Wend

	' now move back one level
	iLevel = iLevel - 1
	sSpaces = Space (iLevel * 2)

	sXML = sXML & sSpaces & "</" & sNames & ">" & vbCR

	RecToXML = sXML

End Function

Function RecToXMLNS (oRec, sName)

	Dim sXML

	sXML = "<xml xmlns:s=""uuid:BDC6E3F0-6DA3-11d1-A2A3-00AA00C14882""" & vbcr & _
		" xmlns:dt=""uuid:C2F41010-65B3-11d1A29F-00AA00C14882""" & vbcr & _
		" xmlns:rs=""urn:schemas-microsoft-com:rowset""" & vbcr & _
		" xmlns:z=""#RowsetSchema"">" & sCR

	sXML = sXML & GetSchema (oRec)
	sXML = sXML & GetData (oRec)
	sXML = sXML & "</xml>"

	RecToXMLNS = sXML

End Function

Function GetSchema (oRec)

	Dim sXML

	sXML = "<s:Schema id=""RowsetSchema"">" & sCR
	sXML = sXML & GetElementType (oRec)
	sXML = sXML & GetAttributes (oRec)
	sXML = sXML & "</s:Schema>"

	GetSchema = sXML

End Function

Function GetElementType (oRec)

	Dim sXML

	sXML = "<s:ElementType name=""row"" content=""eltOnly"">" & sCR
	For Each oFld in oRec.Fields
		If oFld.Type = adChapter Then
			sXML = sXML & "<s:element type="'" & oFld.Name & "'" occurs="'ZEROORMORE'/>" & vbCR
		Else
			sXML = sXML & "<s:attribute type=""" & oFld.Name & """/>" & vbCR
		End If
	Next
	sXML = sXML & "</s:ElementType>" & vbCR

	GetElementType = sXML

End Function

Function GetAttributes (oRec)

	Dim sXML
	Dim oFld
	Dim iNum

	iNum = 1
	For Each oFld in oRec.Fields
		sXML = sXML & "<s:AttributeType name=""" & oFld.Name & """" & _
			" rs:number=""" & iNum & """" & _
			" rs:writeunknown=""true"">" & vbCR
		sXML = sXML & "<s:datatype dt:type=""" & GetTypeName (oFld) & """" & _
			" dt:maxlength=""" & oFld.DefinedSize & """" & _
			" rs:precision=""" & oFld.Precision & """" & _
			" rs:maybenull=""" & GetMayBeNull(oFld) & """" & _
			" rs:fixedlength=""" & GetIsFixedLength(oFld) & """/>" & vbCR
		sXML = sXML & "</s:AttributeType>" & vbCR
		iNum = iNum + 1
	Next

	GetAttributes = sXML

End Function

Function GetTypeName (oFld)
' todo finish mappings

	Select Case oFld.Type
	Case adCurrency
		GetTypeName = "i8"

	Case adDate, adDBFileTime, adDBTime, adDBTimeStamp, adFileTime
		getTypeName = "dateTime"

	Case Else
		GetTypeName = "string"
	End Select

End Function

Function GetMayBeNull (oFld)

	If (oFld.Attributes And adFldMayBeNull) = adFldMayBeNull Then
		GetMayBeNull = "true"
	Else
		GetMayBeNull = "false"
	End If

End Function

Function GetIsFixedLength (oFld)

	If (oFld.Attributes And adFldFixed) = adFldFixed Then
		GetIsFixedLength = "true"
	Else
		GetIsFixedLength = "false"
	End If

End Function

Function GetData (oRec)

	Dim sXML
	Dim oFld

	sXML = "<rs:data>" & vbCR

	While Not oRec.EOF
		sXML = sXML & "<z:row "
		For Each oFld In oRec.Fields
			sXML = sXML & " " & oFld.Name & "=""" & oFld.Value & """"
		Next
		sXML = sXML & "/>" & vbCR
		oRec.MoveNext
	Wend

	sXML = sXML & "</rs:data>"

	GetData = sXML

End Function

Function RecToCMLNSData (oRec, sName)

	Dim oFld
	Dim sXML
	Dim sSpaces
	Dim sNames

	' work out the indent level
	sSpaces = Space (iLevel * 2)

	' is sName plural?
	' this allows us to have <items> and <item>
	If Right(sName, 1) = "s" Then
		sNames = sName
		sName = Left (sName, Len(sName) - 1)
	Else
		sNames = sName & "s"
	End If

	sXML = sSpaces & "<" & sNames & ">" & vbCR

	' now move in one level
	iLevel = iLevel + 1
	sSpaces = Space (iLevel * 2)

	' loop through the records
	oRec.MoveFirst
	While Not oRec.EOF
		' loop through the fields
		sXML = sXML & sSpaces & "<" & sName & ">" & vbCR
		For Each oFld In oRec.Fields
			' recurse if a child recordset
			If oFld.Type = adChapter Then
				Set oChapter = oFld.Value
				If Not oChapter.EOF Then
					iLevel = iLevel + 1
					sXML = sXML & RecToCMLNSData (oChapter, oFld.Name)
					iLevel = ilevel - 1
				End If
			Else
				sXML = sXML & sSpaces & "  " & _
					"<" & oFld.Name & ">" & _
					      ProperFormat(oFld) & _
					"</" & oFld.Name & ">" & vbCR
			End If
		Next
		sXML = sXML & sSpaces & "</" & sName & ">" & vbCR

		oRec.MoveNext
	Wend

	' now move back one level
	iLevel = iLevel - 1
	sSpaces = Space (iLevel * 2)

	sXML = sXML & sSpaces & "</" & sNames & ">" & vbCR

	RecToCMLNSData = sXML

End Function


Function ProperFormat (oFld)

	Dim vValue

	Select case oFld.Type
	Case adCurrency
		If IsNull(oFld.Value) Then
			vValue = ""
		Else
			vValue = FormatCurrency (oFld.Value)
		End If

	Case adDate, adDBFileTime, adDBTime, adDBTimeStamp, adFileTime
		vValue = FormatDateTime (oFld.Value)

	Case adBigInt, adInteger, adSmallInt, adTinyInt, adUnsignedBigInt, adUnsignedInt, adUnsignedSmallInt, adUnsignedTinyInt
		If IsNull(oFld.Value) Then
			vValue = ""
		Else
			vValue = FormatNumber (oFld.Value, 0)
		End If

	Case adBSTR, adLongVarWChar, adVarWChar, adWChar
		vValue = Left(oFld.Value, InStr (oFld.Value, 0)) - 1

	Case adBoolean
		If oFld.Value Then
			vValue = "True"
		Else
			vValue = "False"
		End If

	Case adDecimal, adDouble, adNumeric, adSingle, adVarNumeric
		vValue = FormatNumber (oFld.Value)

	Case adBinary, adLongVarBinary
		vValue = "<binary data>"
	Case Else
		vValue = oFld.Value

	End Select

	' now check for invalid XML characters

End Function

%>

