<script language="JavaScript">

// Removes all characters which are not digits
// from a string
function numericOnly(sString)
{
	var sNumericOnly = "";
	var sValidChars = "1234567890";
	for (var iCharPos = 0; iCharPos < sString.length; iCharPos++)
	{
		if (sValidChars.indexOf(sString.charAt(iCharPos)) != -1)
			sNumericOnly = sNumericOnly + sString.charAt(iCharPos);
	}
	
	return sNumericOnly;
}
// Removes all whitespace characters
// from start and end of a string
function trim(sString)
{
	sTrimmedString = "";
	if (sString != "")
	{
		var iStart = 0;
		var iEnd = sString.length - 1;
		var sWhitespace = " \t\f\n\r\v";
		
		while (sWhitespace.indexOf(sString.charAt(iStart)) != -1)
		{
			iStart++;
			if (iStart > iEnd)
				break;
		}
		
		// If the string not just whitespace
		if (iStart <= iEnd)
		{
			while (sWhitespace.indexOf(sString.charAt(iEnd)) != -1)
				iEnd--;
			sTrimmedString = sString.substring(iStart,++iEnd);
		}
	}
	return sTrimmedString;
}
// Checks all text boxes and radio button groups
// have a value entered
function checkCompleted(theForm)
{
	var bRadioChecked;
	var sElementGroupName;
	var theElement;
	
	// loop through all elements on form
	for (var iElement = 0; iElement < theForm.length;iElement++)
	{	
		theElement = theForm[iElement];
		
		// <INPUT TYPE="TEXT">
		if (theElement.type == "text")
		{
			if (trim(theElement.value) == "")
				{
					alert("You must complete all the form details");
					theElement.focus();
					theElement.select();
					return false;
				}
		}
		// <INPUT TYPE="RADIO">
		else if (theElement.type == "radio")
		{
			bRadioChecked = false;
			sElementGroupName = theElement.name;

			// all radio buttons in a group have the same name
			// so loop through all radio elements with same name
			// until one true or last one reached
			while (theElement.name == sElementGroupName)
			{
				if (theElement.checked == true)
					bRadioChecked = true;

				iElement++;
				theElement = theForm[iElement];
			}
			
			if (bRadioChecked == false)
			{
				// radio button names in form radCreditCard
				// so just cut off first 3 characters
				alert("Please select your " + sElementGroupName.substring(3,sElementGroupName.length));
				return false;
			}
			iElement--;
		}
	}
	return true;
}
// Checks card not expired already
function checkCardExpDate(cboExpMonth,cboExpYear)
{
var nowDate = new Date();
	var nowYear = nowDate.getYear();
	var nowMonth = nowDate.getMonth() + 1;
	
	var expYear = cboExpYear.options[cboExpYear.selectedIndex].value;
	var expMonth = cboExpMonth.options[cboExpMonth.selectedIndex].value;
	
	// some browsers return only 99 for the year so we need
	// to compensate for that
	if (nowYear < 1900)
		nowYear = nowYear + 1900;

	if (expYear <= nowYear)
	{
		if (expMonth < nowMonth)
		{
			alert("The credit card expiry date you have selected has expired")
			cboExpMonth.focus();
			return false;
		}
	}
}
</script>
