/**
LDAP.js version 2.0
This library is designed to provide access to a LDAP server
from JavaScript primarily via the Netscape JAVA Directory SDK.
A middle-ware class is used to communicate with the Directory SDK.
This is primarily because JavaScript doesn't yet support exceptions
and to make sure that only valid JavaScript values are returned.


This version hopefully is easier to use. It also adds extra functions
like the ability to modify the LDAP database and to use your own search
filters.
I've also attempted to make it mimic more the Server Side JavaScript
Database object.

Hopefully you find this software useful. But as with any project of
this type, mileage may vary. Which means that I believe it will work, 
but there are no specified or implied warranties to the usefullness of 
this software.
**/

/**
Primary author: Mark Wilcox, mewilcox@unt.edu

Also thanks to:
Willy Mena wmena@phoenixgroup.com
Darrell Rials drials@sbti.com
Allan Anderson of Stonebridge Technologies
Raphael Luta luta@terra.fr
**/

/**
How to use:
You perform all actions through a LDAP object.
When you make a new LDAP object it automatically connects to
the server.

I also added a weak hack to deal with errors called
doError()
This function is called within each of these methods.
I've included it in a file called utils.js
You can write your own doError() by following the example
provided and by including it instead of my code when
you compile your code.

Here are the public methods:
//constructor
LDAP ()

//generic methods
authenticate()
getAttributeArray()
setAttribute()
addAttribute()

//search methods
getDN()
getSearchBase()
setSearchBase()
getSearchScope()
setSearchScope()
setSearchBase()
doSearch()     //use scope,base,filter specified in constructor
doFullSearch()  //specify scope,base,filter
doSearchTable() // do output as HTML table
doFullSearchTable() //do full search, output as HTML table
                           
//error handling
getErrorCode();
getErrorMessage();
getLDAPErrorCode();
  
//internal methods and those kept to keep older scripts from
connect()
disconnect()
**/

/* object constructor
*/

function LDAP(ldap_host,ldap_port,ldap_basedn,ldap_scope,ldap_MGR_DN,ldap_MGR_PW){
 //scope variables
this.SCOPE_BASE = Packages.mark.ldap.SSJSLDAP.SCOPE_BASE; // retrieve only 1 entry
this.SCOPE_ONE = Packages.mark.ldap.SSJSLDAP.SCOPE_ONE;   // all levels below baseDN, but not ldap_basedn
this.SCOPE_SUB = Packages.mark.ldap.SSJSLDAP.SCOPE_SUB;   // search entire dBase starting at ldap_basedn and continue below baseDN
this.duh = " "; //test value                                                                              
  this.host = ldap_host;
  this.port = ldap_port;
  this.base = ldap_basedn;
  if ((ldap_scope == null) || (ldap_scope=="")) {
      this.scope = this.SCOPE_BASE;
       }

  this.MGR_DN = ldap_MGR_DN;
  this.MGR_PW = ldap_MGR_PW;
  
  //set up function calls
  
  this.authenticate = authenticate;
  this.setAttribute = setAttribute;
  this.addAttribute = addAttribute;
  this.removeAttribute = removeAttribute;
  this.getSearchBase = getSearchBase;
  this.setSearchBase = setSearchBase;
  this.getSearchScope = getSearchScope;
  this.setSearchScope = setSearchScope;
  
  this.getDN = getDN;
  this.doSearch  = doSearch;
  this.doFullSearch = doFullSearch;
  this.doFullSearchTable = doFullSearchTable;

  this.addEntry = addEntry;

  this.getErrorCode = getErrorCode;
  this.getErrorMessage = getErrorMessage;
  this.getLDAPErrorCode = getLDAPErrorCode;
 


//private objects
/* This is our LDAP connection object
   Due to a bug in Enterprise 3 where it does not properly close LDAP
   connections internally, we must reduce the number of connections
   we open ourselves with this API.
   The JAVA LDAP SDK enables us to use the clone() method of the LDAPConnection
   class to also reduce the number of connections we have to initiate. Each connection
   is unique, but won't actually try to open an entirely new one unless we reauthenticate
   after creating the initial connection.
   So I recommend the following:
   1) When you use this package always authenticate as one user id for the entire life of the
   application. For example if you are going to only be doing searches, authenticate anonymously once.
   2) If you want to allow modifications from an SSJS application, again authenticate as one ID. To
   restrict access, use the ACL features built into the Enterprise server to do so.
   It's easier to manage and it reduces the number of connections. See the following article on how
   to do so: http://developer.netscape.com.....

*/
debug("calling this connection call");
this.connection =  connect(this.host,this.port,this.base,this.scope,this.MGR_DN,this.MGR_PW);

 
} 

/*************PRIVATE FUNCTIONS**************************************/

// connect to the server, for life of the application
// returns a "ldap" object that represents how JavaScript will communicate with the LDAP SDK. 
function connect(host,port,searchBase,searchScope,mgr_DN,mgr_PW){
 ld = new Packages.mark.ldap.SSJSLDAP(host,parseInt(port),searchBase,parseInt(searchScope),mgr_DN,mgr_PW);
debug("in connect\n");
  var conn = ld.connect();


  if (conn != void(0)){
 debug("this.conn oK!");
    return(ld);
  }
  else{
    return null;
  }  
}

//needed because the SDK isConnected will return true until you call disconnect()
function isConnected(ldap){
  var v = java.util.Vector();
  v.addElement("cn");  
 //search for anything we're testing connections, not results :-)
  ldap.connection.getAttributes(this.base,parseInt(this.scope),"(cn=John Doe)",v,1);
  if (this.getLDAPErrorCode() == 0) { return true;}
  else{ return false;}
 }
function disconnect(){
    this.connection.disconnect();
    }

/*****************END PRIVATE FUNCTIONS******************************/

/*function getSearchBase()
 returns a string that reprents the current base of searches
*/
 function getSearchBase(){
  return this.basedn;
  }

/* function getSearchScope
  returns the current scope used for searches
*/
function getSearchScope(){
  return this.scope;
  }

/* function setSearchBase()
  pass it a string that represents the base DN to start
  sets a new base to use for searches
*/
function setSearchBase(baseDN){
  this.base = baseDN;
  }

 /* function setSearchScope()
  pass it a number that represents the scope of the search
  sets a new scope to use for searches
 */
function setSearchScope(new_scope){
    this.scope = parseInt(new_scope);
    }

/* function getDN
 pass it a search filter and it returns the Distinguished Name
 of that entry
 */

function getDN(searchFilter) {
return  this.connection.getDN(this.base,parseInt(this.scope),searchFilter);
 }


 
 function setAttribute(entryDN,modifierDN,attribute,value){
    this.connection.setAttribute(entryDN,modifierDN,attribute,value)
   }


 function addAttribute(entryDN,modifierDN,attribute,value){
     this.connection.addAttribute(entryDN,modifierDN,attribute,value);
    }

 function removeAttribute(entryDN,modifierDN,attribute,value){
    this.connection.removeAttribute(entryDN,modifierDN,attribute,value)
   }
  
 function authenticate(userDN,password){
   return this.connection.authenticate(userDN,password);
  }

//set maxResults to 0 if you want unlimted return
 function doFullSearch(searchFilter,attributes,maxResults){
    return (this.connection.getAttributes(this.base,parseInt(this.scope),searchFilter,attributes,parseInt(maxResults)));
 }
 
  function doFullSearchTable(searchFilter,attributes,maxResults){
    var tempArray = this.doFullSearch(searchFilter,attributes,maxResults);
      write("<TABLE border=1>");
           
      for(var i=0;i<tempArray.length;i++){
           valueString = tempArray[i];
      var st = java.util.StringTokenizer(valueString,"|");
      var attributeName;
      var attributeValue;
    while(st.hasMoreElements()){
       attributeName = st.nextElement();
       attributeValue = st.nextElement();
       write("<TR><TD>"+attributeName+"</TD><TD>"+attributeValue+"</TD></TR>")
        }
        } 
         write("</TABLE>");
          }

 
 function doSearch(searchFilter,attributes,maxResults){
    var javaArray = this.connection.getAttributes(this.base,parseInt(this.scope),searchFilter,attributes,parseInt(maxResults));
    var jsArray = new Array();
   
    //possible kludge here because on my system it returns a Java String type not JS String
   for(var i=0;i<javaArray.length;i++){
      valueString = javaArray[i];
      var st = java.util.StringTokenizer(valueString,"|");
      var attributeName;
      var attributeValue;
    while(st.hasMoreElements()){
       attributeName = st.nextElement();
       attributeValue = st.nextElement();
       jsArray[i]=attributeValue;
        }
        } 
      return (jsArray);
   }

/* addEntry function
  creates a new entry in the LDAP server.
  give it the distinguished name of the new entry
  the distinguished name of the modifier
  and an ldapEntry JS object*/

function addEntry(entryDN,modifierDN,myAttributes){
  this.connection.addEntry(entryDN,modifierDN,myAttributes.attrs);
 }

function getErrorCode(){
 return this.connection.ERROR_CODE;
  }

 
function getErrorMessage(){
  if (this.getErrorCode() != "0"){
    return this.connection.ERROR_MESSAGE;
    }
  else return "Application OK!";
  }


function getLDAPErrorCode(){
  return this.connection.LDAP_ERROR_CODE;
  }

/**********************************************************************************/
//This is the LDAPAttributes JavaScript object correlates with a Netscape LDAPAttributes object


function LDAPAttributes(){
this.attrs = new Packages.netscape.ldap.LDAPAttributeSet();
this.addAttributes = addAttributes;
}


function addAttributes(attribute,attributeArray){
// returns an array of Java Strings the size of the attributeArray
var attr = new netscape.ldap.LDAPAttribute(attribute);
 //copy from JavaScript psuedo-array to attribute
   for (var i=0;i<attributeArray.length;i++){
        attr.addValue(new java.lang.String(attributeArray[i]));
          }
      this.attrs.add(attr);
   
}


