/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.Renderer;
import javax.media.j3d.Screen3D;
import javax.media.j3d.TextureBin;
import javax.media.j3d.VirtualUniverse;

class DetailTextureImage {
    static final int NFORMAT = 7;
    int[] objectIds;
    int[] refCount;
    int[] resourceCreationMask;
    ImageComponent2DRetained image = null;
    Object resourceLock = new Object();

    DetailTextureImage(ImageComponent2DRetained imageComponent2DRetained) {
        this.image = imageComponent2DRetained;
    }

    native void bindTexture(long var1, int var3);

    native void updateTextureImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, byte[] var10);

    synchronized void incTextureBinRefCount(int n, TextureBin textureBin) {
        if (this.refCount == null) {
            this.refCount = new int[7];
        }
        if (this.resourceCreationMask == null) {
            this.resourceCreationMask = new int[7];
        }
        int n2 = n;
        this.refCount[n2] = this.refCount[n2] + 1;
        if (this.image != null && (this.image.isByReference() || this.image.source.getCapability(3))) {
            textureBin.renderBin.addNodeComponent(this.image);
        }
    }

    synchronized void decTextureBinRefCount(int n, TextureBin textureBin) {
        if (this.refCount != null) {
            int n2 = n;
            this.refCount[n2] = this.refCount[n2] - 1;
        }
        if (this.image != null && (this.image.isByReference() || this.image.source.getCapability(3))) {
            textureBin.renderBin.removeNodeComponent(this.image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void freeDetailTextureId(int n, int n2) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.objectIds != null) {
                for (int i = 0; i < this.resourceCreationMask.length; ++i) {
                    int n3 = i;
                    this.resourceCreationMask[n3] = this.resourceCreationMask[n3] & ~n2;
                    if (this.resourceCreationMask[i] != 0 || this.objectIds[i] != n) continue;
                    this.objectIds[i] = -1;
                    VirtualUniverse.mc.freeTexture2DId(n);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void freeTextureId(int n, int n2) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.objectIds != null && this.objectIds[n] == n2) {
                this.objectIds[n] = -1;
                VirtualUniverse.mc.freeTexture2DId(this.objectIds[n]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        if (this.objectIds != null) {
            Object object = VirtualUniverse.mc.contextCreationLock;
            synchronized (object) {
                boolean bl = false;
                for (int i = 0; i < this.objectIds.length; ++i) {
                    if (this.objectIds[i] <= 0) continue;
                    Enumeration enumeration = Screen3D.deviceRendererMap.elements();
                    while (enumeration.hasMoreElements()) {
                        Renderer renderer = (Renderer)enumeration.nextElement();
                        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                        j3dMessage.threads = 16;
                        j3dMessage.type = 44;
                        j3dMessage.universe = null;
                        j3dMessage.view = null;
                        j3dMessage.args[0] = null;
                        j3dMessage.args[1] = new Integer(this.objectIds[i]);
                        j3dMessage.args[2] = "2D";
                        renderer.rendererStructure.addMessage(j3dMessage);
                    }
                    this.objectIds[i] = -1;
                    bl = true;
                }
                if (bl) {
                    VirtualUniverse.mc.setWorkForRequestRenderer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyImageComponentImageChanged(ImageComponentRetained imageComponentRetained, Object object) {
        if (this.resourceCreationMask != null) {
            Object object2 = this.resourceLock;
            synchronized (object2) {
                for (int i = 0; i < 7; ++i) {
                    this.resourceCreationMask[i] = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindTexture(Canvas3D canvas3D, int n) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.objectIds == null) {
                this.objectIds = new int[7];
                for (int i = 0; i < 7; ++i) {
                    this.objectIds[i] = -1;
                }
            }
            if (this.objectIds[n] == -1) {
                this.objectIds[n] = VirtualUniverse.mc.getTexture2DId();
            }
            canvas3D.addTextureResource(this.objectIds[n], this);
        }
        this.bindTexture(canvas3D.ctx, this.objectIds[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateNative(Canvas3D canvas3D, int n) {
        if ((canvas3D.textureExtendedFeatures & 0x200) == 0) {
            return;
        }
        boolean bl = false;
        this.bindTexture(canvas3D, n);
        if (canvas3D.useSharedCtx && canvas3D.screen.renderer.sharedCtx != 0L) {
            if ((this.resourceCreationMask[n] & canvas3D.screen.renderer.rendererBit) == 0) {
                bl = true;
                canvas3D.makeCtxCurrent(canvas3D.screen.renderer.sharedCtx);
                this.bindTexture(canvas3D, n);
            }
        } else if ((this.resourceCreationMask[n] & canvas3D.canvasBit) == 0) {
            bl = true;
        }
        if (bl) {
            this.updateTextureImage(canvas3D.ctx, 1, 0, n, this.image.storedYupFormat, this.image.width, this.image.height, 0, this.image.imageYup);
        }
        if (canvas3D.useSharedCtx) {
            canvas3D.makeCtxCurrent(canvas3D.ctx);
            Object object = this.resourceLock;
            synchronized (object) {
                int n2 = n;
                this.resourceCreationMask[n2] = this.resourceCreationMask[n2] | canvas3D.screen.renderer.rendererBit;
            }
        }
        Object object = this.resourceLock;
        synchronized (object) {
            int n3 = n;
            this.resourceCreationMask[n3] = this.resourceCreationMask[n3] | canvas3D.canvasBit;
        }
    }
}

