/*
 * Decompiled with CFR 0.152.
 */
package abbot;

import abbot.Version;
import abbot.i18n.Strings;
import abbot.tester.Robot;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.UIManager;

public class BugReport
extends Error
implements Version {
    private static final String LS = System.getProperty("line.separator");
    private static final String BUGREPORT_URL = Strings.get("bugreport.url");
    private String errorMessage;
    private Throwable throwable;

    private static String getReportingInfo() {
        return Strings.get("bugreport.info", new Object[]{LS + BUGREPORT_URL + LS});
    }

    public static String getSystemInfo() {
        return "abbot version: 1.0.0rc2" + LS + "         mode: " + Robot.getEventModeDescription() + LS + "           OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ") " + LS + " Java version: " + System.getProperty("java.version") + " (vm " + System.getProperty("java.vm.version") + ")" + LS + "    Classpath: " + System.getProperty("java.class.path") + LS + "Look and Feel: " + UIManager.getLookAndFeel();
    }

    public BugReport(String error) {
        this(error, null);
    }

    public BugReport(String error, Throwable thr) {
        super(error);
        this.errorMessage = error;
        this.throwable = thr;
    }

    public String toString() {
        String exc = "";
        if (this.throwable != null) {
            StringWriter writer = new StringWriter();
            this.throwable.printStackTrace(new PrintWriter(writer));
            exc = writer.toString();
        }
        return this.errorMessage + LS + BugReport.getReportingInfo() + LS + BugReport.getSystemInfo() + LS + exc;
    }
}

