/*
 * Decompiled with CFR 0.152.
 */
package abbot;

import abbot.util.Tee;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Log {
    private static final int LOG = 1;
    private static final int WARN = 2;
    private static final int DEBUG = 4;
    private static final String NL = System.getProperty("line.separator");
    public static final int FULL_STACK = 0;
    public static final int NO_STACK = -1;
    private static final int CLASS_STACK_DEPTH = -2;
    private static final String STDOUT_NAME = "<stdout>";
    private static boolean synchronous;
    private static boolean logMessages;
    private static boolean echoToConsole;
    private static final PrintStream STDOUT;
    private static final PrintStream STDERR;
    private static boolean showThreads;
    private static int debugStackDepth;
    private static int logStackDepth;
    private static int excStackDepth;
    private static boolean showTimestamp;
    private static DateFormat timestampFormat;
    private static final String COMMON_PREFIX = "com.oculustech.DOME.client";
    private static final boolean ECLIPSE;
    private static Map debugged;
    private static Set notdebugged;
    private static boolean debugAll;
    private static boolean debugInner;
    private static final String DEFAULT_LOGFILE_NAME = "co-log.txt";
    private static ByteArrayOutputStream preInitLog;
    private static PrintStream logStream;
    private static PrintStream debugStream;
    private static PrintStream warnStream;
    private static LogThread logThread;
    private static String logFilename;
    private static boolean showWarnings;
    private static PrintStream BUFFER;
    private static String hostname;
    private static final String DEFAULT_HOSTNAME = "unknown";
    private static String lastMessage;
    private static int lastMessageRepeatCount;
    private static String lastMessageTimestamp;
    private static PrintStream lastMessageStream;

    protected Log() {
    }

    public static String[] init(String[] args) {
        logMessages = false;
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--enable-warnings")) {
                showWarnings = true;
                Log.setEchoToConsole(true);
                continue;
            }
            if (args[i].equals("--no-timestamp")) {
                showTimestamp = false;
                continue;
            }
            if (args[i].equals("--show-threads")) {
                showThreads = true;
                continue;
            }
            if (args[i].equals("--keep-console")) {
                Log.setEchoToConsole(true);
                continue;
            }
            if (args[i].equals("--stack-depth")) {
                if (++i < args.length) {
                    try {
                        debugStackDepth = Integer.parseInt(args[i]);
                    }
                    catch (Exception exc) {}
                    continue;
                }
                Log.warn("Ignoring --stack-depth with no argument");
                continue;
            }
            if (args[i].equals("--exception-depth")) {
                if (++i < args.length) {
                    try {
                        excStackDepth = Integer.parseInt(args[i]);
                    }
                    catch (Exception exc) {}
                    continue;
                }
                Log.warn("Ignoring --exception-depth with no argument");
                continue;
            }
            if (args[i].equals("--debug") || args[i].equals("--no-debug")) {
                if (++i < args.length) {
                    boolean exclude = args[i].startsWith("--no");
                    if (exclude) {
                        Log.removeDebugClass(args[i]);
                        continue;
                    }
                    Log.addDebugClass(args[i]);
                    Log.setEchoToConsole(true);
                    continue;
                }
                Log.warn("Ignoring " + args[i - 1] + " with no argument");
                continue;
            }
            if (args[i].equals("--log")) {
                String filename = DEFAULT_LOGFILE_NAME;
                if (++i < args.length) {
                    filename = args[i];
                }
                Log.initLogging(filename);
                continue;
            }
            newArgs.add(args[i]);
        }
        return newArgs.toArray(new String[newArgs.size()]);
    }

    public static boolean loggingInitialized() {
        return logMessages && logStream != null;
    }

    public static String getHostName() {
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostname = DEFAULT_HOSTNAME;
                Log.warn("Cannot get hostname, using " + hostname);
            }
        }
        return hostname;
    }

    public static String getLogFilename() {
        return logFilename;
    }

    public static PrintStream getLog() {
        return logStream;
    }

    public static void initLogging(String filename) {
        PrintStream ps = STDOUT;
        logFilename = STDOUT_NAME;
        if (!"-".equals(filename) && filename != null) {
            try {
                ps = new PrintStream(new FileOutputStream(filename), true);
                logFilename = filename;
            }
            catch (IOException e) {
                STDERR.println("Unable to write to " + filename);
                STDERR.println("Output will go to the console");
            }
        }
        Log.setDestination(ps);
        Log.log("Log started on " + Log.getHostName() + " (directed to " + logFilename + ")");
        Log.log(Log.getSystemInfo());
    }

    public static void setDestination(PrintStream ps) {
        logMessages = true;
        logStream = ps;
        if (logStream == STDOUT) {
            debugStream = logStream;
            warnStream = STDERR;
        } else if (logStream == BUFFER) {
            debugStream = new StdOutTee(BUFFER);
            warnStream = new StdErrTee(BUFFER);
        } else {
            if (preInitLog.size() > 0) {
                ps.print(preInitLog.toString());
                preInitLog.reset();
            }
            debugStream = new StdOutTee(logStream);
            warnStream = new StdErrTee(logStream);
            System.setErr(warnStream);
            System.setOut(debugStream);
            if (logFilename != null) {
                File file = new File(logFilename);
                STDOUT.println("Output also captured in the log file at " + file.getAbsolutePath());
            }
        }
        Log.setEchoToConsole(logStream != STDOUT);
    }

    public static String getSystemInfo() {
        Locale loc = Locale.getDefault();
        return "System Details:" + NL + "     java: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + NL + "       os: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + NL + " user.dir: " + System.getProperty("user.dir") + NL + "   locale: " + loc.getDisplayName() + " " + "[" + loc.getLanguage() + " " + loc.getCountry() + "]" + NL + "classpath: " + System.getProperty("java.class.path");
    }

    public static void setDebugStackDepth(int depth) {
        debugStackDepth = depth;
    }

    public static void clearDebugClasses() {
        debugged.clear();
        debugAll = false;
        notdebugged.clear();
    }

    public static void removeDebugClass(String className) {
        Log.setClassDebugEnabled(className, false);
    }

    public static void addDebugClass(Class class1) {
        Log.addDebugClass(class1.getName());
    }

    public static void removeDebugClass(Class class1) {
        Log.removeDebugClass(class1.getName());
    }

    public static void addDebugClass(String className) {
        if (className.indexOf(":") == -1) {
            Log.addDebugClass(className, -2);
        } else {
            Log.setClassDebugEnabled(className, true);
        }
    }

    public static void addDebugClass(String className, int depth) {
        Log.setClassDebugEnabled(className + ":" + depth, true);
    }

    private static void setClassDebugEnabled(String id, boolean enable) {
        String className;
        int colon = id.indexOf(":");
        String string = className = colon == -1 ? id : id.substring(0, colon);
        if ("all".equals(className)) {
            debugAll = enable;
            if (enable) {
                notdebugged.clear();
            } else {
                debugged.clear();
            }
        } else {
            className = Log.getFullClassName(className);
            int depth = -2;
            try {
                depth = colon == -1 ? debugStackDepth : Integer.parseInt(id.substring(colon + 1));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (enable) {
                debugged.put(className, new Integer(depth));
                notdebugged.remove(className);
                Log.debug("Debugging enabled for " + className + " (" + depth + ")");
            } else {
                notdebugged.add(className);
                debugged.remove(className);
                Log.debug("Debugging disabled for " + className);
            }
        }
    }

    private static String getFullClassName(String className) {
        if (COMMON_PREFIX != null && className.startsWith("*.")) {
            className = COMMON_PREFIX + className.substring(1);
        }
        return className;
    }

    private static String getStackTrace(int pop, int lines) {
        return Log.getStackTrace(pop, lines, new Throwable("--debug--"));
    }

    private static String getStackTrace(int pop, int lines, Throwable thr) {
        if (lines != -1) {
            String stack = Log.getStackTrace(pop, thr);
            if (lines == 0) {
                return stack;
            }
            return Log.trimStackTrace(stack, lines);
        }
        return "";
    }

    private static String getStackTrace(int pop, Throwable thr) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream newStream = new PrintStream(os, true);
        thr.printStackTrace(newStream);
        String trace = ((Object)os).toString();
        int getLoc = trace.lastIndexOf("getStackTrace");
        int at = trace.indexOf("\tat ", getLoc);
        if (at != -1) {
            trace = trace.substring(at + 3);
        }
        while (pop-- > 0) {
            at = trace.indexOf("\tat ");
            if (at == -1) continue;
            trace = trace.substring(at + 3);
        }
        return trace.trim();
    }

    private static String trimStackTrace(String trace, int lines) {
        int index;
        boolean all;
        int end = trace.indexOf(")") + 1;
        boolean bl = all = lines == 0;
        while ((all || --lines > 0) && (index = trace.indexOf("\tat ", end)) >= 0) {
            end = trace.indexOf(")", index) + 1;
        }
        return trace.substring(0, end);
    }

    private static String extractClass(String trace) {
        int sub;
        int paren = trace.indexOf("(");
        String tmp = paren == -1 ? trace : trace.substring(0, paren);
        int mstart = tmp.lastIndexOf(".");
        String cname = mstart == -1 ? tmp : tmp.substring(0, mstart);
        cname = cname.trim();
        if (debugInner && (sub = cname.indexOf("$")) != -1) {
            cname = cname.substring(0, sub).trim();
        }
        return cname;
    }

    public static boolean isClassDebugEnabled(Class cls) {
        return Log.isClassDebugEnabled(cls.getName());
    }

    public static boolean isClassDebugEnabled(String className) {
        return (debugAll || debugged.containsKey(className)) && !notdebugged.contains(className);
    }

    static int getClassStackDepth(String cname) {
        Integer depth = (Integer)debugged.get(cname);
        if (depth != null && depth != -2) {
            return depth;
        }
        return debugStackDepth;
    }

    public static void debug(String event) {
        Log.internalDebug(event, new Context(4));
    }

    public static void debug(String event, int lines) {
        Log.internalDebug(event, new Context(4), lines);
    }

    public static void debug(Throwable thr) {
        Log.internalDebug("", new Context(4, thr));
    }

    public static void debug(String m, Throwable e) {
        Log.internalDebug(m, new Context(4, e));
    }

    private static void internalDebug(String msg, Context context) {
        Log.internalDebug(msg, context, -2);
    }

    private static void internalDebug(String msg, Context context, int lines) {
        if (debugged.size() > 0 || debugAll) {
            Log.internalLog(msg, context, lines, 1, echoToConsole ? debugStream : logStream);
        }
    }

    private static String abbreviate(String msg, String expr, String sub) {
        if (ECLIPSE) {
            return msg;
        }
        StringBuffer sb = new StringBuffer(msg);
        int index = msg.indexOf(expr);
        int len = expr.length();
        while (index >= 0) {
            sb.replace(index, index + len, sub);
            index = sb.toString().indexOf(expr);
        }
        return sb.toString();
    }

    private static String abbreviate(String msg) {
        if (COMMON_PREFIX != null) {
            msg = Log.abbreviate(msg, COMMON_PREFIX, "*");
        }
        return msg;
    }

    private static void internalWarn(String message, Context context, int depth, int pop) {
        Log.internalLog(message, context, depth, pop, showWarnings ? warnStream : logStream);
    }

    public static String getStack(int lines) {
        return Log.getStackTrace(1, lines);
    }

    public static String getStack(Throwable t) {
        return Log.getStackTrace(0, t);
    }

    public static String getStack(int lines, Throwable thr) {
        return Log.getStackTrace(1, lines, thr);
    }

    public static void warn(String message) {
        Log.internalWarn(message, new Context(2), debugStackDepth, 1);
    }

    public static void warn(String message, Throwable e) {
        Log.internalWarn(message, new Context(2, e), debugStackDepth, 1);
    }

    public static void warn(String message, int lines) {
        Log.internalWarn(message, new Context(2), lines, 1);
    }

    public static void warn(Throwable thr) {
        Log.internalWarn("", new Context(2, thr), debugStackDepth, 1);
    }

    public static void log(Throwable thr) {
        Log.internalLog("", new Context(1, thr), excStackDepth, 1);
    }

    public static void log(String message, Throwable thr) {
        Log.internalLog(message, new Context(1, thr), excStackDepth, 1);
    }

    public static void log(String message) {
        Log.internalLog(message, new Context(1), logStackDepth, 1);
    }

    private static void internalLog(String event, Context context, int depth, int pop) {
        Log.internalLog(event, context, depth, pop, logStream);
    }

    private static void internalLog(String event, Context context, int depth, int pop, PrintStream stream) {
        String thread = Thread.currentThread().getName();
        if (synchronous) {
            Log.logMessage(event, new Date(), context, depth, pop, stream, thread);
        } else if (logThread != null) {
            logThread.post(event, thread, new Date(), context, depth, pop, stream);
        } else {
            STDERR.println("Message posted after close: " + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void flush() {
        while (logThread.queue.size() > 0) {
            Vector vector = logThread.queue;
            synchronized (vector) {
                logThread.queue.notifyAll();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        debugStream.flush();
        warnStream.flush();
        logStream.flush();
    }

    public static void close() {
        Log.flush();
        Log.log("Log closed");
        logStream.close();
        logThread.terminate();
        logThread = null;
    }

    private static void logMessage(String msg, Date date, Context context, int depth, int pop, PrintStream stream, String threadName) {
        String trace;
        boolean debug;
        boolean bl = debug = context.type == 4;
        if (debug) {
            trace = Log.getStackTrace(pop, 0, context);
            String cname = Log.extractClass(trace);
            if (!Log.isClassDebugEnabled(cname)) {
                return;
            }
            if (depth == -2) {
                trace = Log.trimStackTrace(trace, Log.getClassStackDepth(cname));
            }
        } else {
            trace = Log.getStackTrace(pop, depth, context);
        }
        if (context.thrown != null) {
            Throwable e = context.thrown;
            String where = Log.getStackTrace(0, excStackDepth, e);
            String type = e instanceof Error ? "Error" : "Exception thrown";
            trace = type + " at " + where + ": " + e + NL + "\t(caught at " + trace + ")";
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
                where = Log.getStackTrace(0, excStackDepth, e);
                trace = trace + NL + "Target exception was " + e + " at " + where;
            } else if (e instanceof UndeclaredThrowableException) {
                e = ((UndeclaredThrowableException)e).getUndeclaredThrowable();
                where = Log.getStackTrace(0, excStackDepth, e);
                trace = trace + NL + "Undeclared exception was " + e + " at " + where;
            } else if (e instanceof ExceptionInInitializerError) {
                e = ((ExceptionInInitializerError)e).getException();
                where = Log.getStackTrace(0, excStackDepth, e);
                trace = trace + NL + "Exception was " + e + " at " + where;
            }
        }
        trace = Log.abbreviate(trace);
        if (showThreads) {
            trace = "[" + threadName + "] " + trace;
        }
        String timestamp = timestampFormat.format(date);
        if (showTimestamp) {
            trace = timestamp + " " + trace;
        }
        String output = trace.trim();
        if (msg != null && !"".equals(msg)) {
            output = output + ":\n\t" + msg;
        }
        if (stream == lastMessageStream && (msg == lastMessage || msg != null && msg.equals(lastMessage))) {
            ++lastMessageRepeatCount;
            lastMessageTimestamp = timestamp;
        } else {
            if (lastMessageRepeatCount > 0) {
                lastMessageStream.println(lastMessageTimestamp + ": Last message repeated " + lastMessageRepeatCount + " times");
                lastMessageStream.flush();
            }
            stream.println(output);
            lastMessage = msg;
            lastMessageStream = stream;
            lastMessageRepeatCount = 0;
            lastMessageTimestamp = timestamp;
        }
    }

    public static void setSynchronous(boolean b) {
        synchronous = b;
    }

    public static void setShowThreads(boolean b) {
        showThreads = b;
    }

    public static void setEchoToConsole(boolean b) {
        echoToConsole = b;
    }

    static {
        logMessages = true;
        echoToConsole = true;
        STDOUT = System.out;
        STDERR = System.err;
        showThreads = false;
        showTimestamp = true;
        timestampFormat = new SimpleDateFormat("yyMMdd HH:mm:ss:SSS");
        ECLIPSE = System.getProperty("java.class.path").indexOf("eclipse") != -1;
        debugged = new HashMap();
        notdebugged = new HashSet();
        debugInner = true;
        preInitLog = new ByteArrayOutputStream();
        showWarnings = true;
        BUFFER = new PrintStream(preInitLog);
        Log.setDestination(BUFFER);
        logThread = new LogThread();
        logThread.start();
        debugStackDepth = Integer.getInteger("co.debug_stack_depth", 1);
        logStackDepth = Integer.getInteger("co.log_stack_depth", -1);
        excStackDepth = Integer.getInteger("co.exception_stack_depth", 0);
        Runtime.getRuntime().addShutdownHook(new Thread("Log shutdown hook"){

            public void run() {
                Log.close();
            }
        });
        hostname = null;
        lastMessage = null;
        lastMessageRepeatCount = 0;
        lastMessageTimestamp = null;
        lastMessageStream = null;
    }

    private static class LogThread
    extends Thread {
        private boolean terminate;
        private Vector queue = new Vector();

        public LogThread() {
            super("Logging thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            Vector vector = this.queue;
            synchronized (vector) {
                this.terminate = true;
                this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void post(String msg, String threadName, Date date, Context throwable, int depth, int pop, PrintStream output) {
            Vector vector = this.queue;
            synchronized (vector) {
                if (!this.terminate) {
                    this.queue.add(new Object[]{msg, date, throwable, new int[]{depth, pop}, output, threadName});
                    this.queue.notifyAll();
                } else {
                    STDERR.println("discarded: " + msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            this.setName("Logging thread (to " + logStream + ")");
            while (!this.terminate) {
                try {
                    Object[] list;
                    while (this.queue.size() > 0) {
                        list = (Object[])this.queue.get(0);
                        int[] args = (int[])list[3];
                        Log.logMessage((String)list[0], (Date)list[1], (Context)list[2], args[0], args[1], (PrintStream)list[4], (String)list[5]);
                        this.queue.remove(0);
                    }
                    list = this.queue;
                    // MONITORENTER : this.queue
                    if (this.queue.size() == 0) {
                        this.queue.wait();
                    }
                    // MONITOREXIT : list
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable e) {
                    STDERR.println("Error in logging thread: " + e);
                    e.printStackTrace();
                }
            }
        }
    }

    private static class Context
    extends Throwable {
        public Throwable thrown;
        public int type;

        public Context(int type) {
            this.type = type;
        }

        public Context(int type, Throwable t) {
            this(type);
            this.thrown = t;
        }
    }

    private static final class StdOutTee
    extends Tee {
        private StdOutTee(PrintStream p1) {
            super(STDOUT, p1);
        }

        public String toString() {
            return "<stdout> and log";
        }
    }

    private static final class StdErrTee
    extends Tee {
        private StdErrTee(PrintStream p1) {
            super(STDERR, p1);
        }

        public String toString() {
            return "<stderr> and log";
        }
    }
}

