/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.finder.BasicFinder;
import abbot.finder.ComponentFinder;
import abbot.finder.ComponentSearchException;
import abbot.finder.matchers.ClassMatcher;
import abbot.i18n.Strings;
import abbot.tester.ActionFailedException;
import abbot.tester.JComponentTester;
import abbot.tester.JListTester;
import abbot.util.AWT;
import abbot.util.ExtendedComparator;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;

public class JComboBoxTester
extends JComponentTester {
    private JListTester listTester = new JListTester();

    public String[] getContents(JComboBox cb) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < cb.getItemCount(); ++i) {
            list.add(cb.getItemAt(i).toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public void actionSelectIndex(Component comp, int index) {
        final JComboBox cb = (JComboBox)comp;
        if (!cb.getUI().isPopupVisible(cb)) {
            if (cb.isEditable()) {
                this.invokeAndWait(new Runnable(){

                    public void run() {
                        cb.getUI().setPopupVisible(cb, true);
                    }
                });
            } else {
                this.actionClick(cb);
            }
        }
        JList list = this.findComboList(cb);
        this.listTester.actionSelectIndex(list, index);
    }

    public JList findComboList(JComboBox cb) {
        JList comp;
        JPopupMenu popup = AWT.findActivePopupMenu();
        if (popup == null) {
            long now = System.currentTimeMillis();
            while ((popup = AWT.findActivePopupMenu()) == null) {
                if (System.currentTimeMillis() - now > (long)popupDelay) {
                    throw new ActionFailedException(Strings.get("tester.JComboBox.popup_not_found"));
                }
                this.sleep();
            }
        }
        if ((comp = this.findJList(popup)) == null) {
            throw new ActionFailedException(Strings.get("tester.JComboBox.popup_not_found"));
        }
        return comp;
    }

    private JList findJList(Container parent) {
        try {
            ComponentFinder finder = BasicFinder.getDefault();
            return (JList)finder.find(parent, new ClassMatcher(JList.class));
        }
        catch (ComponentSearchException e) {
            return null;
        }
    }

    public String getValueAsString(JComboBox combo, JList list, Object item, int index) {
        String value = item.toString();
        if (value.startsWith(item.getClass().getName() + "@")) {
            Component c = combo.getRenderer().getListCellRendererComponent(list, item, index, true, true);
            if (c instanceof JLabel) {
                return ((JLabel)c).getText();
            }
            return null;
        }
        return value;
    }

    public void actionSelectItem(Component comp, String item) {
        JComboBox cb = (JComboBox)comp;
        Object obj = cb.getSelectedItem();
        if (obj == null && item == null || obj != null && ExtendedComparator.stringsMatch(item, obj.toString())) {
            return;
        }
        for (int i = 0; i < cb.getItemCount(); ++i) {
            obj = cb.getItemAt(i);
            Log.debug("Comparing against '" + obj + "'");
            if ((obj != null || item != null) && (obj == null || !ExtendedComparator.stringsMatch(item, obj.toString()))) continue;
            this.actionSelectIndex(comp, i);
            return;
        }
        String mid = "[";
        StringBuffer contents = new StringBuffer();
        for (int i = 0; i < cb.getItemCount(); ++i) {
            contents.append(mid);
            contents.append(cb.getItemAt(i).toString());
            mid = ", ";
        }
        contents.append("]");
        throw new ActionFailedException(Strings.get("tester.JComboBox.item_not_found", new Object[]{item, contents.toString()}));
    }
}

