/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.tester.ActionFailedException;
import abbot.tester.ComponentLocation;
import abbot.tester.JComponentTester;
import abbot.tester.LocationUnavailableException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.Field;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class JToolBarTester
extends JComponentTester {
    public boolean isFloating(JToolBar bar) {
        ToolBarUI ui = bar.getUI();
        return ui instanceof BasicToolBarUI && ((BasicToolBarUI)ui).isFloating();
    }

    public void actionFloat(Component c, int x, int y) {
        JToolBar bar = (JToolBar)c;
        if (!bar.isFloatable()) {
            throw new ActionFailedException("The JToolBar is not floatable");
        }
        if (this.isFloating(bar)) {
            throw new ActionFailedException("The JToolBar is already floating");
        }
        Window w = SwingUtilities.getWindowAncestor(c);
        JToolBarLocation loc = new JToolBarLocation();
        this.actionDrag(c, loc);
        this.actionDrop(w, x - w.getX(), y - w.getY());
        if (!this.isFloating(bar)) {
            throw new ActionFailedException("Bar not floated");
        }
    }

    public void actionFloat(Component c) {
        Window w = SwingUtilities.getWindowAncestor(c);
        Point where = w.getLocation();
        this.actionFloat(c, where.x, where.y);
    }

    public void actionUnfloat(Component c, String constraint) {
        if (!("North".equals(constraint) || "East".equals(constraint) || "South".equals(constraint) || "West".equals(constraint))) {
            throw new IllegalArgumentException("Invalid drop location");
        }
        JToolBar bar = (JToolBar)c;
        Container dock = null;
        if (bar.getUI() instanceof BasicToolBarUI) {
            try {
                Field f = BasicToolBarUI.class.getDeclaredField("dockingSource");
                f.setAccessible(true);
                dock = (Container)f.get(bar.getUI());
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
        if (dock == null) {
            throw new ActionFailedException("Can't determine dock");
        }
        this.actionDrag(bar, new JToolBarLocation());
        this.actionDrop(dock, new DockLocation(bar, constraint));
        if (this.isFloating(bar)) {
            throw new ActionFailedException("Failed to dock the tool bar (" + constraint + ")");
        }
    }

    public void actionUnfloat(Component c) {
        Window w = SwingUtilities.getWindowAncestor(c);
        this.close(w);
        this.waitForIdle();
    }

    private class DockLocation
    extends ComponentLocation {
        private String constraint;
        private JToolBar bar;

        public DockLocation(JToolBar bar, String constraint) {
            if (!("North".equals(constraint) || "East".equals(constraint) || "South".equals(constraint) || "West".equals(constraint))) {
                throw new IllegalArgumentException("Invalid dock location");
            }
            this.constraint = constraint;
            this.bar = bar;
        }

        public Point getPoint(Component c) {
            int y;
            int x;
            int offset;
            if (!(c instanceof Container)) {
                throw new LocationUnavailableException("Dock is not a container");
            }
            Container dock = (Container)c;
            Insets insets = dock.getInsets();
            int n = offset = this.bar.getOrientation() == 0 ? this.bar.getHeight() : this.bar.getWidth();
            if ("North".equals(this.constraint)) {
                x = dock.getWidth() / 2;
                y = insets.top;
            } else if ("East".equals(this.constraint)) {
                x = dock.getWidth() - insets.right - 1;
                y = dock.getHeight() / 2;
                if (y < insets.top + offset) {
                    y = insets.top + offset;
                }
            } else if ("West".equals(this.constraint)) {
                x = insets.left;
                y = dock.getHeight() / 2;
                if (y < insets.top + offset) {
                    y = insets.top + offset;
                }
            } else {
                x = dock.getWidth() / 2;
                y = dock.getHeight() - insets.bottom - 1;
                if (x < insets.left + offset) {
                    x = insets.left + offset;
                } else if (x > dock.getWidth() - insets.right - offset - 1) {
                    x = dock.getWidth() - insets.right - offset - 1;
                }
            }
            return new Point(x, y);
        }
    }

    private class JToolBarLocation
    extends ComponentLocation {
        private JToolBarLocation() {
        }

        public Point getPoint(Component c) {
            int y;
            int x;
            JToolBar bar = (JToolBar)c;
            Insets insets = bar.getInsets();
            if (Math.max(Math.max(Math.max(insets.left, insets.top), insets.right), insets.bottom) == insets.left) {
                x = insets.left / 2;
                y = c.getHeight() / 2;
            } else if (Math.max(Math.max(insets.top, insets.right), insets.bottom) == insets.top) {
                x = c.getWidth() / 2;
                y = insets.top / 2;
            } else if (Math.max(insets.right, insets.bottom) == insets.right) {
                x = c.getWidth() - insets.right / 2;
                y = c.getHeight() / 2;
            } else {
                x = c.getWidth() / 2;
                y = c.getHeight() - insets.bottom / 2;
            }
            return new Point(x, y);
        }
    }
}

