/*
 * Decompiled with CFR 0.152.
 */
package abbot.util;

import abbot.Log;
import abbot.Platform;
import abbot.finder.AWTHierarchy;
import abbot.finder.BasicFinder;
import abbot.finder.ComponentSearchException;
import abbot.finder.Hierarchy;
import abbot.finder.Matcher;
import abbot.finder.matchers.ClassMatcher;
import abbot.tester.AWTConstants;
import abbot.util.Bugs;
import abbot.util.ExtendedComparator;
import abbot.util.Reflector;
import abbot.util.Regexp;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;

public class AWT {
    public static int POPUP_TIMEOUT = 5000;
    private static Hierarchy hierarchy = new AWTHierarchy();
    private static final boolean POPUP_ON_BUTTON2 = false;
    private static final PopupMenu[] NO_POPUPS;
    private static final Matcher POPUP_MATCHER;

    private AWT() {
    }

    public static boolean hasDefaultName(Component c) {
        String name = AWT.getName(c);
        if (name == null) {
            return true;
        }
        if (c instanceof JComponent) {
            return c instanceof JLayeredPane && "null.layeredPane".equals(name) || c instanceof JPanel && ("null.glassPane".equals(name) || "null.contentPane".equals(name));
        }
        return c instanceof Button && Regexp.stringMatch("button[0-9]+", name) || c instanceof Canvas && Regexp.stringMatch("canvas[0-9]+", name) || c instanceof Checkbox && Regexp.stringMatch("checkbox[0-9]+", name) || c instanceof Choice && Regexp.stringMatch("choice[0-9]+", name) || c instanceof Dialog && Regexp.stringMatch("dialog[0-9]+", name) || c instanceof FileDialog && Regexp.stringMatch("filedlg[0-9]+", name) || c instanceof Frame && Regexp.stringMatch("frame[0-9]+", name) || c instanceof List && Regexp.stringMatch("list[0-9]+", name) || c instanceof Label && Regexp.stringMatch("label[0-9]+", name) || c instanceof Panel && Regexp.stringMatch("panel[0-9]+", name) || c instanceof Scrollbar && Regexp.stringMatch("scrollbar[0-9]+", name) || c instanceof ScrollPane && Regexp.stringMatch("scrollpane[0-9]+", name) || c instanceof TextArea && Regexp.stringMatch("text[0-9]+", name) || c instanceof TextField && Regexp.stringMatch("textfield[0-9]+", name) || c instanceof Window && Regexp.stringMatch("win[0-9]+", name);
    }

    public static void invokeAndWait(Runnable action) {
        if (EventQueue.isDispatchThread()) {
            action.run();
        } else {
            try {
                EventQueue.invokeAndWait(action);
            }
            catch (InterruptedException ie) {
                Log.warn(ie);
            }
            catch (InvocationTargetException ite) {
                Log.warn(ite);
            }
        }
    }

    public static void invokeAction(Runnable action) {
        if (EventQueue.isDispatchThread()) {
            action.run();
        } else {
            EventQueue.invokeLater(action);
        }
    }

    private static java.util.List disable(Object root, java.util.List list) {
        if (Bugs.hasMenuDisableBug() && root instanceof JMenuBar) {
            return list;
        }
        if (root instanceof Component) {
            int i;
            MenuBar mb;
            if (root instanceof Frame && (mb = ((Frame)root).getMenuBar()) != null) {
                for (i = 0; i < mb.getMenuCount(); ++i) {
                    AWT.disable(mb.getMenu(i), list);
                }
            }
            if (root instanceof Container) {
                Component[] children = ((Container)root).getComponents();
                for (i = 0; i < children.length; ++i) {
                    AWT.disable(children[i], list);
                }
            }
            if (((Component)root).isEnabled()) {
                list.add(root);
                ((Component)root).setEnabled(false);
            }
        } else if (root instanceof MenuItem && ((MenuItem)root).isEnabled()) {
            if (root instanceof Menu) {
                Menu menu = (Menu)root;
                for (int i = 0; i < menu.getItemCount(); ++i) {
                    AWT.disable(menu.getItem(i), list);
                }
            }
            list.add(root);
            ((MenuItem)root).setEnabled(false);
        }
        return list;
    }

    public static void reenableHierarchy(final java.util.List enabled) {
        AWT.invokeAndWait(new Runnable(){

            public void run() {
                for (Object o : enabled) {
                    if (o instanceof Component) {
                        ((Component)o).setEnabled(true);
                        continue;
                    }
                    if (!(o instanceof MenuItem)) continue;
                    ((MenuItem)o).setEnabled(true);
                }
            }
        });
    }

    public static java.util.List disableHierarchy(final Component root) {
        final ArrayList list = new ArrayList();
        AWT.invokeAndWait(new Runnable(){

            public void run() {
                AWT.disable(root, list);
            }
        });
        return list;
    }

    public static boolean isOnMenuBar(MenuComponent mc) {
        if (mc instanceof MenuBar) {
            return true;
        }
        return mc.getParent() instanceof MenuComponent && AWT.isOnMenuBar((MenuComponent)((Object)mc.getParent()));
    }

    public static Component getInvoker(MenuComponent mc) {
        if (AWT.isOnMenuBar(mc)) {
            return null;
        }
        MenuContainer parent = mc.getParent();
        while (parent instanceof MenuComponent) {
            parent = ((MenuComponent)((Object)parent)).getParent();
        }
        return parent instanceof Component ? (Component)parent : null;
    }

    public static Component getInvoker(Component comp) {
        if (comp instanceof JPopupMenu) {
            return ((JPopupMenu)comp).getInvoker();
        }
        return (comp = comp.getParent()) != null ? AWT.getInvoker(comp) : null;
    }

    public static Window getWindow(Component comp) {
        Component invoker;
        if (comp == null) {
            return null;
        }
        if (comp instanceof Window) {
            return (Window)comp;
        }
        if (comp instanceof MenuElement && (invoker = AWT.getInvoker(comp)) != null) {
            return AWT.getWindow(invoker);
        }
        return AWT.getWindow(hierarchy.getParent(comp));
    }

    public static boolean isAWTPopupMenuBlocking() {
        return Bugs.showAWTPopupMenuBlocks() && AWT.isAWTTreeLockHeld();
    }

    private static boolean isAWTTreeLockHeld() {
        return AWT.isAWTTreeLockHeld(Toolkit.getDefaultToolkit().getSystemEventQueue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAWTTreeLockHeld(EventQueue eq) {
        Frame[] frames = Frame.getFrames();
        if (frames.length == 0) {
            return false;
        }
        ThreadStateChecker checker = new ThreadStateChecker(frames[0].getTreeLock());
        try {
            ThreadStateChecker threadStateChecker = checker;
            synchronized (threadStateChecker) {
                checker.start();
                if (!checker.started) {
                    checker.wait(30000L);
                    if (!checker.started) {
                        throw new Error("Popup checking thread never started");
                    }
                }
            }
            if (checker.isAlive()) {
                checker.join(100L);
            }
            return checker.isAlive();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static void dismissAWTPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        Robot robot = abbot.tester.Robot.getRobot();
        if (robot != null) {
            Window w;
            Component c = AWT.getFocusOwner();
            if (c != null && (w = AWT.getWindow(c)) != null && w.isShowing()) {
                robot.keyPress(27);
                robot.keyRelease(27);
            }
        } else {
            Log.warn("The current system configuation can not automatically dismiss an AWT popup");
        }
    }

    public static boolean isOnPopup(MenuComponent mc) {
        MenuContainer parent = mc.getParent();
        while (parent instanceof MenuComponent) {
            if (parent instanceof MenuBar) {
                return false;
            }
            parent = ((MenuComponent)((Object)parent)).getParent();
        }
        return true;
    }

    public static boolean isOnPopup(Component comp) {
        boolean isWrapper = AWT.isTransientPopup(comp);
        Component invoker = AWT.getInvoker(comp);
        boolean isOnJMenu = invoker instanceof JMenu && invoker.getParent() instanceof JMenuBar;
        return isWrapper || invoker != null && !isOnJMenu;
    }

    public static boolean isHeavyweightPopup(Component c) {
        if (c instanceof Window && !(c instanceof Dialog) && !(c instanceof Frame)) {
            String name = AWT.getName(c);
            String cname = c.getClass().getName();
            return "###overrideRedirect###".equals(name) || "###focusableSwingPopup###".equals(name) || cname.indexOf("PopupFactory$WindowPopup") != -1 || cname.indexOf("HeavyWeightWindow") != -1;
        }
        return false;
    }

    private static String getName(Component c) {
        try {
            return c.getName();
        }
        catch (Throwable e) {
            Log.warn(e);
            return null;
        }
    }

    public static boolean isLightweightPopup(Component c) {
        if (c instanceof JPanel) {
            Window w = SwingUtilities.getWindowAncestor(c);
            if (w != null && AWT.isHeavyweightPopup(w)) {
                return false;
            }
            JPanel panel = (JPanel)c;
            Container parent = panel.getParent();
            if (parent != null && parent instanceof JLayeredPane) {
                JLayeredPane lp = (JLayeredPane)parent;
                int layer = JLayeredPane.POPUP_LAYER;
                if (JLayeredPane.getLayer(panel) == layer) {
                    return true;
                }
            }
            return panel.getComponentCount() == 1 && panel.getComponents()[0] instanceof JPopupMenu;
        }
        return false;
    }

    public static boolean isContentPane(Component c) {
        if (c.getParent() instanceof JLayeredPane) {
            JLayeredPane p = (JLayeredPane)c.getParent();
            if (p.getParent() instanceof JRootPane) {
                return ((JRootPane)p.getParent()).getContentPane() == c;
            }
            int layer = JLayeredPane.FRAME_CONTENT_LAYER;
            return p.getLayer(c) == layer && !(c instanceof JMenuBar);
        }
        return false;
    }

    public static boolean isGlassPane(Component c) {
        if (c.getParent() instanceof JRootPane) {
            JRootPane p = (JRootPane)c.getParent();
            return p.getGlassPane() == c;
        }
        return false;
    }

    public static boolean isTransientPopup(Component c) {
        return AWT.isLightweightPopup(c) || AWT.isHeavyweightPopup(c);
    }

    private static boolean containsToolTip(Component c) {
        if (c instanceof JToolTip) {
            return true;
        }
        if (c instanceof Container) {
            Component[] kids = ((Container)c).getComponents();
            for (int i = 0; i < kids.length; ++i) {
                if (!AWT.containsToolTip(kids[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isToolTip(Component c) {
        return AWT.isTransientPopup(c) && AWT.containsToolTip(c);
    }

    public static boolean isInternalFrameDecoration(Component c) {
        Container parent = c.getParent();
        return parent instanceof JInternalFrame && !(c instanceof JRootPane) || parent != null && parent.getParent() instanceof JInternalFrame && !(parent instanceof JRootPane);
    }

    public static int getPopupMask() {
        return 4;
    }

    public static int getTertiaryMask() {
        return 8;
    }

    public static boolean getPopupOnPress() {
        return Platform.isWindows() || Platform.isMacintosh();
    }

    public static PopupMenu[] getPopupMenus(Component c) {
        try {
            Field field = Component.class.getDeclaredField("popups");
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Vector popups = (Vector)field.get(c);
            field.setAccessible(accessible);
            if (popups != null) {
                return popups.toArray(new PopupMenu[popups.size()]);
            }
            return NO_POPUPS;
        }
        catch (NoSuchFieldException e) {
            throw new Error("No field named 'popups' in class Component");
        }
        catch (IllegalAccessException e) {
            throw new Error("Can't access popup for component " + c);
        }
    }

    public static MenuItem[] findAWTPopupMenuItems(Component parent, String path) {
        PopupMenu[] popups = AWT.getPopupMenus(parent);
        ArrayList list = new ArrayList();
        for (int i = 0; i < popups.length; ++i) {
            list.addAll(AWT.findMenuItems(popups[i], path, true));
        }
        return list.toArray(new MenuItem[list.size()]);
    }

    public static MenuItem[] findAWTMenuItems(Frame frame, String path) {
        MenuBar mb = frame.getMenuBar();
        if (mb != null) {
            Collection items = AWT.findMenuItems(mb, path, true);
            return items.toArray(new MenuItem[items.size()]);
        }
        return new MenuItem[0];
    }

    public static String getPath(MenuItem item) {
        String path = AWT.getPath(item, false);
        if (AWT.isOnPopup(item) && AWT.findAWTPopupMenuItems(AWT.getInvoker(item), path).length > 1) {
            path = AWT.getPath(item, true);
        }
        return path;
    }

    private static String getPath(MenuItem item, boolean includePopupName) {
        MenuContainer top;
        Component invoker;
        MenuContainer root = invoker = AWT.getInvoker(item);
        if (invoker == null) {
            top = item.getParent();
            while (top instanceof Menu && !(((Menu)top).getParent() instanceof MenuBar)) {
                top = ((Menu)top).getParent();
            }
            if (top == null) {
                throw new RuntimeException("MenuItem is not attached to the hierarchy");
            }
            root = ((Menu)top).getParent();
        } else {
            top = item.getParent();
            while (top instanceof Menu && !(((Menu)top).getParent() instanceof Component)) {
                top = ((Menu)top).getParent();
            }
        }
        String path = item.getLabel();
        MenuItem mi = item;
        while (mi.getParent() != top) {
            mi = (MenuItem)((Object)mi.getParent());
            path = mi.getLabel() + "|" + path;
        }
        if (top instanceof PopupMenu) {
            if (includePopupName) {
                String name = ((PopupMenu)top).getName();
                if (Regexp.stringMatch("popup[0-9]+", name)) {
                    PopupMenu[] all = AWT.getPopupMenus(invoker);
                    for (int i = 0; i < all.length; ++i) {
                        if (all[i] != top) continue;
                        name = "popup#" + i;
                        break;
                    }
                }
                path = name + "|" + path;
            }
        } else {
            path = ((Menu)top).getLabel() + "|" + path;
        }
        Log.debug("Path for " + item + " is " + path);
        return path;
    }

    private static Collection findMenuItems(MenuContainer mc, String path, boolean matchPath) {
        ArrayList<MenuItem> list;
        block6: {
            block5: {
                if (matchPath) {
                    Log.debug("Searching for '" + path + "' on '" + mc);
                }
                list = new ArrayList<MenuItem>();
                if (!(mc instanceof MenuBar)) break block5;
                for (int i = 0; i < ((MenuBar)mc).getMenuCount(); ++i) {
                    Menu menu = ((MenuBar)mc).getMenu(i);
                    Log.debug("Scanning '" + menu + "'");
                    list.addAll(AWT.findMenuItems(menu, path, matchPath));
                }
                break block6;
            }
            if (!(mc instanceof Menu)) break block6;
            for (int i = 0; i < ((Menu)mc).getItemCount(); ++i) {
                MenuItem mi = ((Menu)mc).getItem(i);
                if (mi instanceof MenuContainer) {
                    Log.debug("Scanning '" + mi + "'");
                    list.addAll(AWT.findMenuItems((MenuContainer)((Object)mi), path, matchPath));
                    continue;
                }
                if (path.equals(mi.getLabel())) {
                    Log.debug("Found '" + mi + "'");
                    list.add(mi);
                    continue;
                }
                if (!matchPath || !ExtendedComparator.stringsMatch(path, AWT.getPath(mi, false)) && !ExtendedComparator.stringsMatch(path, AWT.getPath(mi, true))) continue;
                Log.debug("Found (path) '" + mi + "'");
                list.add(mi);
            }
        }
        return list;
    }

    public static Component getFocusOwner() {
        try {
            Class<?> cls = Class.forName("java.awt.KeyboardFocusManager");
            Field field = cls.getDeclaredField("focusOwner");
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Component c = (Component)field.get(null);
            field.setAccessible(accessible);
            return c;
        }
        catch (Exception e) {
            Window w;
            if (!(e instanceof ClassNotFoundException)) {
                Log.log(e);
            }
            Iterator iter = new AWTHierarchy().getRoots().iterator();
            Component focus = null;
            while (iter.hasNext() && (!(w = (Window)iter.next()).isShowing() || (focus = AWT.getFocusOwner(w)) == null)) {
            }
            return focus;
        }
    }

    private static Component getFocusOwner(Window w) {
        Component focus = w.getFocusOwner();
        if (focus == null) {
            Window[] owned = w.getOwnedWindows();
            for (int i = 0; i < owned.length; ++i) {
                focus = owned[i].getFocusOwner();
                if (focus == null) continue;
                return focus;
            }
        }
        return focus;
    }

    public static AppContext getAppContext(Component c) {
        try {
            Field field = Component.class.getDeclaredField("appContext");
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            AppContext appContext = (AppContext)field.get(c);
            field.setAccessible(accessible);
            return appContext;
        }
        catch (Exception e) {
            Log.warn(e);
            return null;
        }
    }

    public static boolean eventTypeEnabled(Component c, int id) {
        if (c instanceof Choice) {
            return true;
        }
        try {
            AWTEvent ev = new AWTEvent(c, id){};
            Method m = Component.class.getDeclaredMethod("eventEnabled", AWTEvent.class);
            m.setAccessible(true);
            Boolean b = (Boolean)m.invoke((Object)c, ev);
            return b;
        }
        catch (Exception e) {
            Log.warn(e);
            return true;
        }
    }

    public static boolean isSharedInvisibleFrame(Component c) {
        return c == JOptionPane.getRootFrame();
    }

    public static boolean isAppletViewerFrame(Component c) {
        return c.getClass().getName().equals("sun.applet.AppletViewer");
    }

    public static JPopupMenu getActivePopupMenu() {
        try {
            return (JPopupMenu)BasicFinder.getDefault().find(POPUP_MATCHER);
        }
        catch (ComponentSearchException e) {
            return null;
        }
    }

    public static JPopupMenu findActivePopupMenu() {
        JPopupMenu popup = AWT.getActivePopupMenu();
        if (popup == null && !SwingUtilities.isEventDispatchThread()) {
            long now = System.currentTimeMillis();
            while ((popup = AWT.getActivePopupMenu()) == null && System.currentTimeMillis() - now <= (long)POPUP_TIMEOUT) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        return popup;
    }

    public static Point getLocationOnScreen(Component c) {
        if (AWT.isAWTTreeLockHeld()) {
            if (!c.isShowing()) {
                throw new IllegalComponentStateException("component must be showing on the screen to determine its location");
            }
            Point loc = new Point(c.getLocation());
            if (!(c instanceof Window)) {
                Container parent = c.getParent();
                if (parent == null) {
                    throw new IllegalComponentStateException("component must be showing on the screen to determine its location");
                }
                Point ploc = AWT.getLocationOnScreen(parent);
                loc.translate(ploc.x, ploc.y);
            }
            return loc;
        }
        return new Point(c.getLocationOnScreen());
    }

    public static boolean isTransientDialog(Component c) {
        if (c instanceof Window) {
            Container contentPane;
            Component[] kids;
            if (c instanceof JDialog && (kids = (contentPane = ((JDialog)c).getContentPane()).getComponents()).length == 1) {
                return kids[0] instanceof JOptionPane || kids[0] instanceof JFileChooser || kids[0] instanceof JColorChooser;
            }
        } else if (!(c instanceof JOptionPane || c instanceof JFileChooser || c instanceof JColorChooser)) {
            Container parent = c.getParent();
            return parent != null && AWT.isTransientDialog(parent);
        }
        return false;
    }

    public static Applet findAppletDescendent(Container c) {
        try {
            return (Applet)BasicFinder.getDefault().find(c, new ClassMatcher(Applet.class));
        }
        catch (ComponentSearchException e) {
            return null;
        }
    }

    public static boolean isTertiaryButton(int mods) {
        return (mods & 0x1C) != 16 && (mods & AWTConstants.POPUP_MASK) == 0;
    }

    public static int getModifiers(String mods) {
        int value = 0;
        if (mods != null && !mods.equals("")) {
            StringTokenizer st = new StringTokenizer(mods, "| ");
            while (st.hasMoreTokens()) {
                String flag = st.nextToken();
                if (!flag.endsWith("_MASK")) {
                    flag = flag + "_MASK";
                }
                if (AWTConstants.POPUP_MODIFIER.equals(flag)) {
                    value |= AWTConstants.POPUP_MASK;
                    continue;
                }
                if (AWTConstants.TERTIARY_MODIFIER.equals(flag)) {
                    value |= AWTConstants.TERTIARY_MASK;
                    continue;
                }
                if (flag.equals("0")) continue;
                value |= Reflector.getFieldValue(InputEvent.class, flag);
            }
        }
        return value;
    }

    private static String getModifiers(int flags, boolean isMouse) {
        int macModifiers = 14;
        boolean isMacButton = isMouse && Platform.isMacintosh() && (flags & macModifiers) != 0;
        String mods = "";
        String or = "";
        if ((flags & 0x20) != 0) {
            mods = mods + or + "ALT_GRAPH_MASK";
            or = "|";
            flags &= 0xFFFFFFDF;
        }
        if ((flags & 0x10) != 0 && !isMacButton) {
            mods = mods + or + "BUTTON1_MASK";
            or = "|";
            flags &= 0xFFFFFFEF;
        }
        if ((flags & 8) != 0 && !isMacButton && !isMouse) {
            mods = mods + or + "ALT_MASK";
            or = "|";
            flags &= 0xFFFFFFF7;
        }
        if ((flags & 2) != 0 && !isMacButton) {
            mods = mods + or + "CTRL_MASK";
            or = "|";
            flags &= 0xFFFFFFFD;
        }
        if ((flags & 4) != 0 && !isMacButton && !isMouse) {
            mods = mods + or + "META_MASK";
            or = "|";
            flags &= 0xFFFFFFFB;
        }
        if ((flags & AWTConstants.POPUP_MASK) != 0) {
            mods = mods + or + "POPUP_MASK";
            or = "|";
            flags &= ~AWTConstants.POPUP_MASK;
        }
        if ((flags & AWTConstants.TERTIARY_MASK) != 0) {
            mods = mods + or + "TERTIARY_MASK";
            or = "|";
            flags &= ~AWTConstants.TERTIARY_MASK;
        }
        if ((flags & 1) != 0) {
            mods = mods + or + "SHIFT_MASK";
            or = "|";
            flags &= 0xFFFFFFFE;
        }
        if ("".equals(mods)) {
            mods = "0";
        }
        return mods;
    }

    public static String getKeyModifiers(int flags) {
        return AWT.getModifiers(flags, false);
    }

    public static String getMouseModifiers(int flags) {
        return AWT.getModifiers(flags, true);
    }

    public static String getModifiers(InputEvent event) {
        return AWT.getModifiers(event.getModifiers(), event instanceof MouseEvent);
    }

    public static String getKeyCode(int keycode) {
        return Reflector.getFieldName(KeyEvent.class, keycode, "VK_");
    }

    public static int getKeyCode(String code) {
        return Reflector.getFieldValue(KeyEvent.class, code);
    }

    public static boolean isModifier(int keycode) {
        switch (keycode) {
            case 16: 
            case 17: 
            case 18: 
            case 157: 
            case 65406: {
                return true;
            }
        }
        return false;
    }

    public static int keyCodeToMask(int code) {
        switch (code) {
            case 157: {
                return 4;
            }
            case 18: {
                return 8;
            }
            case 65406: {
                return 32;
            }
            case 17: {
                return 2;
            }
            case 16: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Keycode is not a modifier: " + code);
    }

    public static int maskToKeyCode(int mask) {
        switch (mask) {
            case 4: {
                return 157;
            }
            case 8: {
                return 18;
            }
            case 32: {
                return 65406;
            }
            case 2: {
                return 17;
            }
            case 1: {
                return 16;
            }
        }
        throw new IllegalArgumentException("Unrecognized mask '" + mask + "'");
    }

    public static Component retargetMouseEvent(Component comp, int id, Point pt) {
        Point where = pt;
        while (!(comp instanceof Window) && !AWT.eventTypeEnabled(comp, id)) {
            Log.debug("Retargeting event, " + abbot.tester.Robot.toString(comp) + " not interested");
            where = SwingUtilities.convertPoint(comp, where.x, where.y, comp.getParent());
            comp = comp.getParent();
        }
        pt.setLocation(where);
        return comp;
    }

    public static Insets getInsets(Container c) {
        try {
            Insets insets = c.getInsets();
            if (insets != null) {
                return insets;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new Insets(0, 0, 0, 0);
    }

    public static boolean containsFocus(Component c) {
        Component owner = AWT.getFocusOwner();
        return owner != null && SwingUtilities.isDescendingFrom(owner, c);
    }

    static {
        String to = System.getProperty("abbot.finder.popup_timeout");
        if (to != null) {
            try {
                POPUP_TIMEOUT = Integer.parseInt(to);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NO_POPUPS = new PopupMenu[0];
        POPUP_MATCHER = new ClassMatcher(JPopupMenu.class, true);
    }

    private static class ThreadStateChecker
    extends Thread {
        public boolean started;
        private Object lock;

        public ThreadStateChecker(Object lock) {
            super("thread state checker");
            this.setDaemon(true);
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                this.started = true;
                this.notifyAll();
            }
            object = this.lock;
            synchronized (object) {
            }
        }
    }
}

