/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.TextureRetained;

class TextureCubeMapRetained
extends TextureRetained {
    static final int NUMFACES = 6;

    TextureCubeMapRetained() {
    }

    void initialize(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.numFaces = 6;
        super.initialize(n, n2, n3, n4, n5, n6, n7);
    }

    void initImage(int n, int n2, ImageComponent imageComponent) {
        if (this.images == null) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureRetained0"));
        }
        if (imageComponent instanceof ImageComponent3D) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap3"));
        }
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap4"));
        }
        if (this.source.isLive()) {
            if (this.images[n2][n] != null) {
                this.images[n2][n].clearLive(this.refCount);
            }
            if (imageComponent != null) {
                ((ImageComponentRetained)imageComponent.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        ((ImageComponent2DRetained)imageComponent.retained).setTextureRef();
        this.images[n2][n] = imageComponent != null ? (ImageComponentRetained)imageComponent.retained : null;
    }

    final void setImage(int n, int n2, ImageComponent imageComponent) {
        this.checkImageSize(n, imageComponent);
        this.initImage(n, n2, imageComponent);
        Object[] objectArray = new Object[]{new Integer(n), imageComponent, new Integer(n2)};
        this.sendMessage(4, objectArray);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            if (imageComponent != null && n < this.maxLevels) {
                ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponent.retained;
                if (imageComponentRetained.isByReference()) {
                    if (imageComponentRetained.bImage[0] == null) {
                        this.enable = false;
                    }
                } else if (imageComponentRetained.imageYup == null) {
                    this.enable = false;
                }
                if (!this.enable) {
                    this.sendMessage(1, Boolean.FALSE);
                }
            }
        }
    }

    void initImages(int n, ImageComponent[] imageComponentArray) {
        if (imageComponentArray.length != this.maxLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture20"));
        }
        for (int i = 0; i < imageComponentArray.length; ++i) {
            this.initImage(i, n, imageComponentArray[i]);
        }
    }

    final void setImages(int n, ImageComponent[] imageComponentArray) {
        int n2;
        ImageComponentRetained[] imageComponentRetainedArray = new ImageComponentRetained[imageComponentArray.length];
        for (n2 = 0; n2 < imageComponentArray.length; ++n2) {
            imageComponentRetainedArray[n2] = (ImageComponentRetained)imageComponentArray[n2].retained;
        }
        this.checkSizes(imageComponentRetainedArray);
        this.initImages(n, imageComponentArray);
        ImageComponent[] imageComponentArray2 = new ImageComponent[imageComponentArray.length];
        for (n2 = 0; n2 < imageComponentArray.length; ++n2) {
            imageComponentArray2[n2] = imageComponentArray[n2];
        }
        Object[] objectArray = new Object[]{imageComponentArray2, new Integer(n)};
        this.sendMessage(32, objectArray);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            for (n2 = 0; this.enable && n2 < this.maxLevels; ++n2) {
                if (imageComponentArray[n2] == null) continue;
                ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponentArray[n2].retained;
                if (imageComponentRetained.isByReference()) {
                    if (imageComponentRetained.bImage[0] != null) continue;
                    this.enable = false;
                    continue;
                }
                if (imageComponentRetained.imageYup != null) continue;
                this.enable = false;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
    }

    final ImageComponent getImage(int n, int n2) {
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap4"));
        }
        return this.images != null && this.images[n2][n] != null ? (ImageComponent)this.images[n2][n].source : null;
    }

    final ImageComponent[] getImages(int n) {
        if (this.images == null) {
            return null;
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap4"));
        }
        ImageComponent[] imageComponentArray = new ImageComponent[this.images[n].length];
        for (int i = 0; i < this.images[n].length; ++i) {
            imageComponentArray[i] = this.images[n][i] != null ? (ImageComponent)this.images[n][i].source : null;
        }
        return imageComponentArray;
    }

    native void bindTexture(long var1, int var3, boolean var4);

    native void updateTextureFilterModes(long var1, int var3, int var4);

    native void updateTextureBoundary(long var1, int var3, int var4, float var5, float var6, float var7, float var8);

    native void updateTextureSharpenFunc(long var1, int var3, float[] var4);

    native void updateTextureFilter4Func(long var1, int var3, float[] var4);

    native void updateTextureAnisotropicFilter(long var1, float var3);

    native void updateTextureImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, byte[] var11);

    native void updateTextureSubImage(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, byte[] var14);

    void updateTextureDimensions(Canvas3D canvas3D) {
        for (int i = 0; i < 6; ++i) {
            this.updateTextureImage(canvas3D.ctx, i, this.maxLevels, 0, this.format, 1, this.width, this.height, this.boundaryWidth, null);
        }
    }

    void updateTextureImage(Canvas3D canvas3D, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        this.updateTextureImage(canvas3D.ctx, n, n2, n3, n4, n5, n6, n7, n8, byArray);
    }

    void updateTextureSubImage(Canvas3D canvas3D, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, byte[] byArray) {
        this.updateTextureSubImage(canvas3D.ctx, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, byArray);
    }
}

