/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.HashCodeUtil;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.GMatrix;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;
import javax.vecmath.Vector4f;

public class Transform3D {
    double[] mat = new double[16];
    double[] rot = null;
    double[] scales = null;
    private int type = 0;
    private static final int AFFINE_BIT = 1;
    private static final int ORTHO_BIT = 2;
    private static final int CONGRUENT_BIT = 4;
    private static final int RIGID_BIT = 8;
    private static final int CLASSIFY_BIT = 16;
    private static final int SCALE_BIT = 32;
    private static final int ROTATION_BIT = 64;
    private static final int SVD_BIT = 128;
    private static final int CLASSIFY_ALL_DIRTY = 31;
    private static final int ROTSCALESVD_DIRTY = 224;
    private int dirtyBits;
    boolean autoNormalize = false;
    private static final double EPS = 1.110223024E-16;
    static final double EPSILON = 1.0E-10;
    static final double EPSILON_ABSOLUTE = 1.0E-5;
    static final double EPSILON_RELATIVE = 1.0E-4;
    public static final int ZERO = 1;
    public static final int IDENTITY = 2;
    public static final int SCALE = 4;
    public static final int TRANSLATION = 8;
    public static final int ORTHOGONAL = 16;
    public static final int RIGID = 32;
    public static final int CONGRUENT = 64;
    public static final int AFFINE = 128;
    public static final int NEGATIVE_DETERMINANT = 256;
    private static final int ORTHO = 0x40000000;

    public Transform3D(Matrix4f matrix4f) {
        this.set(matrix4f);
    }

    public Transform3D(Matrix4d matrix4d) {
        this.set(matrix4d);
    }

    public Transform3D(Transform3D transform3D) {
        this.set(transform3D);
    }

    public Transform3D() {
        this.setIdentity();
    }

    public Transform3D(float[] fArray) {
        this.set(fArray);
    }

    public Transform3D(double[] dArray) {
        this.set(dArray);
    }

    public Transform3D(Quat4d quat4d, Vector3d vector3d, double d) {
        this.set(quat4d, vector3d, d);
    }

    public Transform3D(Quat4f quat4f, Vector3d vector3d, double d) {
        this.set(quat4f, vector3d, d);
    }

    public Transform3D(Quat4f quat4f, Vector3f vector3f, float f) {
        this.set(quat4f, vector3f, f);
    }

    public Transform3D(GMatrix gMatrix) {
        this.set(gMatrix);
    }

    public Transform3D(Matrix3f matrix3f, Vector3d vector3d, double d) {
        this.set(matrix3f, vector3d, d);
    }

    public Transform3D(Matrix3d matrix3d, Vector3d vector3d, double d) {
        this.set(matrix3d, vector3d, d);
    }

    public Transform3D(Matrix3f matrix3f, Vector3f vector3f, float f) {
        this.set(matrix3f, vector3f, f);
    }

    public final int getType() {
        if ((this.dirtyBits & 0x10) != 0) {
            this.classify();
        }
        return this.type & 0xBFFFFFFF;
    }

    final boolean isOrtho() {
        if ((this.dirtyBits & 2) != 0) {
            if (Transform3D.almostZero(this.mat[0] * this.mat[2] + this.mat[4] * this.mat[6] + this.mat[8] * this.mat[10]) && Transform3D.almostZero(this.mat[0] * this.mat[1] + this.mat[4] * this.mat[5] + this.mat[8] * this.mat[9]) && Transform3D.almostZero(this.mat[1] * this.mat[2] + this.mat[5] * this.mat[6] + this.mat[9] * this.mat[10])) {
                this.type |= 0x40000000;
                this.dirtyBits &= 0xFFFFFFFD;
                return true;
            }
            this.type &= 0xBFFFFFFF;
            this.dirtyBits &= 0xFFFFFFFD;
            return false;
        }
        return (this.type & 0x40000000) != 0;
    }

    final boolean isCongruent() {
        if ((this.dirtyBits & 4) != 0) {
            this.classifyRigid();
        }
        return (this.type & 0x40) != 0;
    }

    final boolean isAffine() {
        if ((this.dirtyBits & 1) != 0) {
            this.classifyAffine();
        }
        return (this.type & 0x80) != 0;
    }

    final boolean isRigid() {
        if ((this.dirtyBits & 8) != 0) {
            if ((this.dirtyBits & 4) != 0) {
                this.classifyRigid();
            } else {
                if ((this.type & 0x40) != 0) {
                    double d;
                    if ((this.dirtyBits & 0x20) != 0) {
                        d = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
                    } else {
                        if (this.scales == null) {
                            this.scales = new double[3];
                        }
                        d = this.scales[0];
                    }
                    this.type = Transform3D.almostOne(d) ? (this.type |= 0x20) : (this.type &= 0xFFFFFFDF);
                } else {
                    this.type &= 0xFFFFFFDF;
                }
                this.dirtyBits &= 0xFFFFFFF7;
            }
        }
        return (this.type & 0x20) != 0;
    }

    public final int getBestType() {
        this.getType();
        if ((this.type & 1) != 0) {
            return 1;
        }
        if ((this.type & 2) != 0) {
            return 2;
        }
        if ((this.type & 4) != 0) {
            return 4;
        }
        if ((this.type & 8) != 0) {
            return 8;
        }
        if ((this.type & 0x10) != 0) {
            return 16;
        }
        if ((this.type & 0x20) != 0) {
            return 32;
        }
        if ((this.type & 0x40) != 0) {
            return 64;
        }
        if ((this.type & 0x80) != 0) {
            return 128;
        }
        if ((this.type & 0x100) != 0) {
            return 256;
        }
        return 0;
    }

    public final boolean getDeterminantSign() {
        return this.determinant() >= 0.0;
    }

    public final void setAutoNormalize(boolean bl) {
        this.autoNormalize = bl;
        if (bl) {
            this.normalize();
        }
    }

    public final boolean getAutoNormalize() {
        return this.autoNormalize;
    }

    private static final boolean almostZero(double d) {
        return d < 1.0E-5 && d > -1.0E-5;
    }

    private static final boolean almostOne(double d) {
        return d < 1.00001 && d > 0.99999;
    }

    private static final boolean almostEqual(double d, double d2) {
        double d3 = d - d2;
        if (d3 >= 0.0) {
            if (d3 < 1.0E-10) {
                return true;
            }
            if (d2 > 0.0 || d > -d2) {
                return d3 < 1.0E-4 * d;
            }
            return d3 < -1.0E-4 * d2;
        }
        if (d3 > -1.0E-10) {
            return true;
        }
        if (d2 < 0.0 || -d > d2) {
            return d3 > 1.0E-4 * d;
        }
        return d3 > -1.0E-4 * d2;
    }

    private final void classifyAffine() {
        this.type = Transform3D.almostZero(this.mat[12]) && Transform3D.almostZero(this.mat[13]) && Transform3D.almostZero(this.mat[14]) && Transform3D.almostOne(this.mat[15]) ? (this.type |= 0x80) : (this.type &= 0xFFFFFF7F);
        this.dirtyBits &= 0xFFFFFFFE;
    }

    private final void classifyRigid() {
        if ((this.dirtyBits & 1) != 0) {
            this.type &= 0x40000000;
            this.classifyAffine();
        } else {
            this.type &= 0x40000080;
        }
        if ((this.type & 0x80) != 0 && this.isOrtho()) {
            if ((this.dirtyBits & 0x20) != 0) {
                double d;
                double d2 = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
                double d3 = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9];
                if (Transform3D.almostEqual(d2, d3) && Transform3D.almostEqual(d = this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10], d2)) {
                    this.type |= 0x40;
                    if (Transform3D.almostOne(d2)) {
                        this.type |= 0x20;
                    }
                }
            } else {
                double d;
                if (this.scales == null) {
                    this.scales = new double[3];
                }
                if (Transform3D.almostEqual(d = this.scales[0], this.scales[1]) && Transform3D.almostEqual(d, this.scales[2])) {
                    this.type |= 0x40;
                    if (Transform3D.almostOne(d)) {
                        this.type |= 0x20;
                    }
                }
            }
        }
        this.dirtyBits &= 0xFFFFFFFF;
    }

    private final void classify() {
        if ((this.dirtyBits & 0xD) != 0) {
            this.classifyRigid();
        }
        if ((this.type & 0x80) != 0) {
            if ((this.type & 0x40) != 0) {
                if ((this.type & 0x20) != 0) {
                    if (this.zeroTranslation()) {
                        this.type |= 0x10;
                        if (this.rotateZero() && this.mat[0] > 0.0 && this.mat[5] > 0.0 && this.mat[10] > 0.0) {
                            this.type |= 0xE;
                        }
                    } else if (this.rotateZero()) {
                        this.type |= 8;
                    }
                } else if (this.zeroTranslation() && this.rotateZero()) {
                    this.type |= 4;
                }
            }
        } else if (Transform3D.almostZero(this.mat[12]) && Transform3D.almostZero(this.mat[13]) && Transform3D.almostZero(this.mat[14]) && Transform3D.almostZero(this.mat[15]) && this.zeroTranslation() && this.rotateZero() && Transform3D.almostZero(this.mat[0]) && Transform3D.almostZero(this.mat[5]) && Transform3D.almostZero(this.mat[10])) {
            this.type |= 1;
        }
        if (!this.getDeterminantSign()) {
            this.type |= 0x100;
        }
        this.dirtyBits &= 0xFFFFFFEF;
    }

    final boolean zeroTranslation() {
        return Transform3D.almostZero(this.mat[3]) && Transform3D.almostZero(this.mat[7]) && Transform3D.almostZero(this.mat[11]);
    }

    final boolean rotateZero() {
        return Transform3D.almostZero(this.mat[1]) && Transform3D.almostZero(this.mat[2]) && Transform3D.almostZero(this.mat[4]) && Transform3D.almostZero(this.mat[6]) && Transform3D.almostZero(this.mat[8]) && Transform3D.almostZero(this.mat[9]);
    }

    public String toString() {
        return this.mat[0] + ", " + this.mat[1] + ", " + this.mat[2] + ", " + this.mat[3] + "\n" + this.mat[4] + ", " + this.mat[5] + ", " + this.mat[6] + ", " + this.mat[7] + "\n" + this.mat[8] + ", " + this.mat[9] + ", " + this.mat[10] + ", " + this.mat[11] + "\n" + this.mat[12] + ", " + this.mat[13] + ", " + this.mat[14] + ", " + this.mat[15] + "\n";
    }

    public final void setIdentity() {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 1073742078;
        this.dirtyBits = 96;
    }

    public final void setZero() {
        this.mat[0] = 0.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 0.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 0.0;
        this.type = 0x40000001;
        this.dirtyBits = 96;
    }

    public final void add(Transform3D transform3D) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.mat[n] = this.mat[n] + transform3D.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void add(Transform3D transform3D, Transform3D transform3D2) {
        for (int i = 0; i < 16; ++i) {
            this.mat[i] = transform3D.mat[i] + transform3D2.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void sub(Transform3D transform3D) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.mat[n] = this.mat[n] - transform3D.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void sub(Transform3D transform3D, Transform3D transform3D2) {
        for (int i = 0; i < 16; ++i) {
            this.mat[i] = transform3D.mat[i] - transform3D2.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void transpose() {
        double d = this.mat[4];
        this.mat[4] = this.mat[1];
        this.mat[1] = d;
        d = this.mat[8];
        this.mat[8] = this.mat[2];
        this.mat[2] = d;
        d = this.mat[12];
        this.mat[12] = this.mat[3];
        this.mat[3] = d;
        d = this.mat[9];
        this.mat[9] = this.mat[6];
        this.mat[6] = d;
        d = this.mat[13];
        this.mat[13] = this.mat[7];
        this.mat[7] = d;
        d = this.mat[14];
        this.mat[14] = this.mat[11];
        this.mat[11] = d;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void transpose(Transform3D transform3D) {
        if (this != transform3D) {
            this.mat[0] = transform3D.mat[0];
            this.mat[1] = transform3D.mat[4];
            this.mat[2] = transform3D.mat[8];
            this.mat[3] = transform3D.mat[12];
            this.mat[4] = transform3D.mat[1];
            this.mat[5] = transform3D.mat[5];
            this.mat[6] = transform3D.mat[9];
            this.mat[7] = transform3D.mat[13];
            this.mat[8] = transform3D.mat[2];
            this.mat[9] = transform3D.mat[6];
            this.mat[10] = transform3D.mat[10];
            this.mat[11] = transform3D.mat[14];
            this.mat[12] = transform3D.mat[3];
            this.mat[13] = transform3D.mat[7];
            this.mat[14] = transform3D.mat[11];
            this.mat[15] = transform3D.mat[15];
            this.dirtyBits = 255;
            if (this.autoNormalize) {
                this.normalize();
            }
        } else {
            this.transpose();
        }
    }

    public final void set(Quat4f quat4f) {
        this.mat[0] = 1.0f - 2.0f * quat4f.y * quat4f.y - 2.0f * quat4f.z * quat4f.z;
        this.mat[4] = 2.0f * (quat4f.x * quat4f.y + quat4f.w * quat4f.z);
        this.mat[8] = 2.0f * (quat4f.x * quat4f.z - quat4f.w * quat4f.y);
        this.mat[1] = 2.0f * (quat4f.x * quat4f.y - quat4f.w * quat4f.z);
        this.mat[5] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.z * quat4f.z;
        this.mat[9] = 2.0f * (quat4f.y * quat4f.z + quat4f.w * quat4f.x);
        this.mat[2] = 2.0f * (quat4f.x * quat4f.z + quat4f.w * quat4f.y);
        this.mat[6] = 2.0f * (quat4f.y * quat4f.z - quat4f.w * quat4f.x);
        this.mat[10] = 1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.y * quat4f.y;
        this.mat[3] = 0.0;
        this.mat[7] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 112;
        this.type = 0x400000E0;
    }

    public final void set(Quat4d quat4d) {
        this.mat[0] = 1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z;
        this.mat[4] = 2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z);
        this.mat[8] = 2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y);
        this.mat[1] = 2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z);
        this.mat[5] = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z;
        this.mat[9] = 2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x);
        this.mat[2] = 2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y);
        this.mat[6] = 2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x);
        this.mat[10] = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y;
        this.mat[3] = 0.0;
        this.mat[7] = 0.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = 112;
        this.type = 0x400000E0;
    }

    public final void setRotation(Matrix3d matrix3d) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = matrix3d.m00 * this.scales[0];
        this.mat[1] = matrix3d.m01 * this.scales[1];
        this.mat[2] = matrix3d.m02 * this.scales[2];
        this.mat[4] = matrix3d.m10 * this.scales[0];
        this.mat[5] = matrix3d.m11 * this.scales[1];
        this.mat[6] = matrix3d.m12 * this.scales[2];
        this.mat[8] = matrix3d.m20 * this.scales[0];
        this.mat[9] = matrix3d.m21 * this.scales[1];
        this.mat[10] = matrix3d.m22 * this.scales[2];
        this.dirtyBits |= 0xFE;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setRotation(Matrix3f matrix3f) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = (double)matrix3f.m00 * this.scales[0];
        this.mat[1] = (double)matrix3f.m01 * this.scales[1];
        this.mat[2] = (double)matrix3f.m02 * this.scales[2];
        this.mat[4] = (double)matrix3f.m10 * this.scales[0];
        this.mat[5] = (double)matrix3f.m11 * this.scales[1];
        this.mat[6] = (double)matrix3f.m12 * this.scales[2];
        this.mat[8] = (double)matrix3f.m20 * this.scales[0];
        this.mat[9] = (double)matrix3f.m21 * this.scales[1];
        this.mat[10] = (double)matrix3f.m22 * this.scales[2];
        this.dirtyBits |= 0xFE;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setRotation(Quat4f quat4f) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = (1.0 - 2.0 * (double)quat4f.y * (double)quat4f.y - 2.0 * (double)quat4f.z * (double)quat4f.z) * this.scales[0];
        this.mat[4] = 2.0 * (double)(quat4f.x * quat4f.y + quat4f.w * quat4f.z) * this.scales[0];
        this.mat[8] = 2.0 * (double)(quat4f.x * quat4f.z - quat4f.w * quat4f.y) * this.scales[0];
        this.mat[1] = 2.0 * (double)(quat4f.x * quat4f.y - quat4f.w * quat4f.z) * this.scales[1];
        this.mat[5] = (1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.z * (double)quat4f.z) * this.scales[1];
        this.mat[9] = 2.0 * (double)(quat4f.y * quat4f.z + quat4f.w * quat4f.x) * this.scales[1];
        this.mat[2] = 2.0 * (double)(quat4f.x * quat4f.z + quat4f.w * quat4f.y) * this.scales[2];
        this.mat[6] = 2.0 * (double)(quat4f.y * quat4f.z - quat4f.w * quat4f.x) * this.scales[2];
        this.mat[10] = (1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.y * (double)quat4f.y) * this.scales[2];
        this.dirtyBits |= 0x50;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
        this.type &= 0xFFFFFFE0;
    }

    public final void setRotation(Quat4d quat4d) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        this.mat[0] = (1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z) * this.scales[0];
        this.mat[4] = 2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z) * this.scales[0];
        this.mat[8] = 2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y) * this.scales[0];
        this.mat[1] = 2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z) * this.scales[1];
        this.mat[5] = (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z) * this.scales[1];
        this.mat[9] = 2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x) * this.scales[1];
        this.mat[2] = 2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y) * this.scales[2];
        this.mat[6] = 2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x) * this.scales[2];
        this.mat[10] = (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y) * this.scales[2];
        this.dirtyBits |= 0x50;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
        this.type &= 0xFFFFFFE0;
    }

    public final void set(AxisAngle4f axisAngle4f) {
        double d = Math.sqrt(axisAngle4f.x * axisAngle4f.x + axisAngle4f.y * axisAngle4f.y + axisAngle4f.z * axisAngle4f.z);
        if (Transform3D.almostZero(d)) {
            this.setIdentity();
        } else {
            d = 1.0 / d;
            double d2 = (double)axisAngle4f.x * d;
            double d3 = (double)axisAngle4f.y * d;
            double d4 = (double)axisAngle4f.z * d;
            double d5 = Math.sin(axisAngle4f.angle);
            double d6 = Math.cos(axisAngle4f.angle);
            double d7 = 1.0 - d6;
            double d8 = d2 * d4;
            double d9 = d2 * d3;
            double d10 = d3 * d4;
            this.mat[0] = d7 * d2 * d2 + d6;
            this.mat[1] = d7 * d9 - d5 * d4;
            this.mat[2] = d7 * d8 + d5 * d3;
            this.mat[3] = 0.0;
            this.mat[4] = d7 * d9 + d5 * d4;
            this.mat[5] = d7 * d3 * d3 + d6;
            this.mat[6] = d7 * d10 - d5 * d2;
            this.mat[7] = 0.0;
            this.mat[8] = d7 * d8 - d5 * d3;
            this.mat[9] = d7 * d10 + d5 * d2;
            this.mat[10] = d7 * d4 * d4 + d6;
            this.mat[11] = 0.0;
            this.mat[12] = 0.0;
            this.mat[13] = 0.0;
            this.mat[14] = 0.0;
            this.mat[15] = 1.0;
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void set(AxisAngle4d axisAngle4d) {
        double d = Math.sqrt(axisAngle4d.x * axisAngle4d.x + axisAngle4d.y * axisAngle4d.y + axisAngle4d.z * axisAngle4d.z);
        if (Transform3D.almostZero(d)) {
            this.setIdentity();
        } else {
            d = 1.0 / d;
            double d2 = axisAngle4d.x * d;
            double d3 = axisAngle4d.y * d;
            double d4 = axisAngle4d.z * d;
            double d5 = Math.sin(axisAngle4d.angle);
            double d6 = Math.cos(axisAngle4d.angle);
            double d7 = 1.0 - d6;
            double d8 = d2 * d4;
            double d9 = d2 * d3;
            double d10 = d3 * d4;
            this.mat[0] = d7 * d2 * d2 + d6;
            this.mat[1] = d7 * d9 - d5 * d4;
            this.mat[2] = d7 * d8 + d5 * d3;
            this.mat[3] = 0.0;
            this.mat[4] = d7 * d9 + d5 * d4;
            this.mat[5] = d7 * d3 * d3 + d6;
            this.mat[6] = d7 * d10 - d5 * d2;
            this.mat[7] = 0.0;
            this.mat[8] = d7 * d8 - d5 * d3;
            this.mat[9] = d7 * d10 + d5 * d2;
            this.mat[10] = d7 * d4 * d4 + d6;
            this.mat[11] = 0.0;
            this.mat[12] = 0.0;
            this.mat[13] = 0.0;
            this.mat[14] = 0.0;
            this.mat[15] = 1.0;
            this.type = 0x400000E0;
            this.dirtyBits = 112;
        }
    }

    public final void setRotation(AxisAngle4d axisAngle4d) {
        double d;
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        if (Transform3D.almostZero(d = Math.sqrt(axisAngle4d.x * axisAngle4d.x + axisAngle4d.y * axisAngle4d.y + axisAngle4d.z * axisAngle4d.z))) {
            this.mat[0] = this.scales[0];
            this.mat[1] = 0.0;
            this.mat[2] = 0.0;
            this.mat[4] = 0.0;
            this.mat[5] = this.scales[1];
            this.mat[6] = 0.0;
            this.mat[8] = 0.0;
            this.mat[9] = 0.0;
            this.mat[10] = this.scales[2];
        } else {
            d = 1.0 / d;
            double d2 = axisAngle4d.x * d;
            double d3 = axisAngle4d.y * d;
            double d4 = axisAngle4d.z * d;
            double d5 = Math.sin(axisAngle4d.angle);
            double d6 = Math.cos(axisAngle4d.angle);
            double d7 = 1.0 - d6;
            double d8 = d2 * d4;
            double d9 = d2 * d3;
            double d10 = d3 * d4;
            this.mat[0] = (d7 * d2 * d2 + d6) * this.scales[0];
            this.mat[1] = (d7 * d9 - d5 * d4) * this.scales[1];
            this.mat[2] = (d7 * d8 + d5 * d3) * this.scales[2];
            this.mat[4] = (d7 * d9 + d5 * d4) * this.scales[0];
            this.mat[5] = (d7 * d3 * d3 + d6) * this.scales[1];
            this.mat[6] = (d7 * d10 - d5 * d2) * this.scales[2];
            this.mat[8] = (d7 * d8 - d5 * d3) * this.scales[0];
            this.mat[9] = (d7 * d10 + d5 * d2) * this.scales[1];
            this.mat[10] = (d7 * d4 * d4 + d6) * this.scales[2];
        }
        this.dirtyBits |= 0x50;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
        this.type &= 0xFFFFFFE0;
    }

    public final void setRotation(AxisAngle4f axisAngle4f) {
        double d;
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        if (Transform3D.almostZero(d = Math.sqrt(axisAngle4f.x * axisAngle4f.x + axisAngle4f.y * axisAngle4f.y + axisAngle4f.z * axisAngle4f.z))) {
            this.mat[0] = this.scales[0];
            this.mat[1] = 0.0;
            this.mat[2] = 0.0;
            this.mat[4] = 0.0;
            this.mat[5] = this.scales[1];
            this.mat[6] = 0.0;
            this.mat[8] = 0.0;
            this.mat[9] = 0.0;
            this.mat[10] = this.scales[2];
        } else {
            d = 1.0 / d;
            double d2 = (double)axisAngle4f.x * d;
            double d3 = (double)axisAngle4f.y * d;
            double d4 = (double)axisAngle4f.z * d;
            double d5 = Math.sin(axisAngle4f.angle);
            double d6 = Math.cos(axisAngle4f.angle);
            double d7 = 1.0 - d6;
            double d8 = d2 * d4;
            double d9 = d2 * d3;
            double d10 = d3 * d4;
            this.mat[0] = (d7 * d2 * d2 + d6) * this.scales[0];
            this.mat[1] = (d7 * d9 - d5 * d4) * this.scales[1];
            this.mat[2] = (d7 * d8 + d5 * d3) * this.scales[2];
            this.mat[4] = (d7 * d9 + d5 * d4) * this.scales[0];
            this.mat[5] = (d7 * d3 * d3 + d6) * this.scales[1];
            this.mat[6] = (d7 * d10 - d5 * d2) * this.scales[2];
            this.mat[8] = (d7 * d8 - d5 * d3) * this.scales[0];
            this.mat[9] = (d7 * d10 + d5 * d2) * this.scales[1];
            this.mat[10] = (d7 * d4 * d4 + d6) * this.scales[2];
        }
        this.dirtyBits |= 0x50;
        this.dirtyBits &= 0xFFFFFFFF;
        this.type |= 0x40000000;
        this.type &= 0xFFFFFFE0;
    }

    public void rotX(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = d3;
        this.mat[6] = -d2;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = d2;
        this.mat[10] = d3;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public void rotY(double d) {
        double d2;
        double d3 = Math.sin(d);
        this.mat[0] = d2 = Math.cos(d);
        this.mat[1] = 0.0;
        this.mat[2] = d3;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = -d3;
        this.mat[9] = 0.0;
        this.mat[10] = d2;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public void rotZ(double d) {
        double d2;
        double d3 = Math.sin(d);
        this.mat[0] = d2 = Math.cos(d);
        this.mat[1] = -d3;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = d3;
        this.mat[5] = d2;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public final void set(Vector3f vector3f) {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = vector3f.x;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = vector3f.y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = vector3f.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public final void set(Vector3d vector3d) {
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = vector3d.x;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = vector3d.y;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public final void setScale(double d) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        this.scales[1] = this.scales[2] = d;
        this.scales[0] = this.scales[2];
        this.mat[0] = this.rot[0] * d;
        this.mat[1] = this.rot[1] * d;
        this.mat[2] = this.rot[2] * d;
        this.mat[4] = this.rot[3] * d;
        this.mat[5] = this.rot[4] * d;
        this.mat[6] = this.rot[5] * d;
        this.mat[8] = this.rot[6] * d;
        this.mat[9] = this.rot[7] * d;
        this.mat[10] = this.rot[8] * d;
        this.dirtyBits |= 0x9C;
        this.dirtyBits &= 0xFFFFFFDF;
    }

    public final void setScale(Vector3d vector3d) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        this.scales[0] = vector3d.x;
        this.scales[1] = vector3d.y;
        this.scales[2] = vector3d.z;
        this.mat[0] = this.rot[0] * vector3d.x;
        this.mat[1] = this.rot[1] * vector3d.y;
        this.mat[2] = this.rot[2] * vector3d.z;
        this.mat[4] = this.rot[3] * vector3d.x;
        this.mat[5] = this.rot[4] * vector3d.y;
        this.mat[6] = this.rot[5] * vector3d.z;
        this.mat[8] = this.rot[6] * vector3d.x;
        this.mat[9] = this.rot[7] * vector3d.y;
        this.mat[10] = this.rot[8] * vector3d.z;
        this.dirtyBits |= 0x9C;
        this.dirtyBits &= 0xFFFFFFDF;
    }

    public final void setNonUniformScale(double d, double d2, double d3) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[0] = d;
        this.scales[1] = d2;
        this.scales[2] = d3;
        this.mat[0] = d;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = d2;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = d3;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0x40000080;
        this.dirtyBits = 92;
    }

    public final void setTranslation(Vector3f vector3f) {
        this.mat[3] = vector3f.x;
        this.mat[7] = vector3f.y;
        this.mat[11] = vector3f.z;
        this.type &= 0xFFFFFFE0;
        this.dirtyBits |= 0x10;
    }

    public final void setTranslation(Vector3d vector3d) {
        this.mat[3] = vector3d.x;
        this.mat[7] = vector3d.y;
        this.mat[11] = vector3d.z;
        this.type &= 0xFFFFFFE0;
        this.dirtyBits |= 0x10;
    }

    public final void set(Quat4d quat4d, Vector3d vector3d, double d) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = d;
        this.scales[0] = this.scales[2];
        this.mat[0] = (1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z) * d;
        this.mat[4] = 2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z) * d;
        this.mat[8] = 2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y) * d;
        this.mat[1] = 2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z) * d;
        this.mat[5] = (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z) * d;
        this.mat[9] = 2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x) * d;
        this.mat[2] = 2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y) * d;
        this.mat[6] = 2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x) * d;
        this.mat[10] = (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y) * d;
        this.mat[3] = vector3d.x;
        this.mat[7] = vector3d.y;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0x400000C0;
        this.dirtyBits = 88;
    }

    public final void set(Quat4f quat4f, Vector3d vector3d, double d) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = d;
        this.scales[0] = this.scales[2];
        this.mat[0] = (double)(1.0f - 2.0f * quat4f.y * quat4f.y - 2.0f * quat4f.z * quat4f.z) * d;
        this.mat[4] = (double)(2.0f * (quat4f.x * quat4f.y + quat4f.w * quat4f.z)) * d;
        this.mat[8] = (double)(2.0f * (quat4f.x * quat4f.z - quat4f.w * quat4f.y)) * d;
        this.mat[1] = (double)(2.0f * (quat4f.x * quat4f.y - quat4f.w * quat4f.z)) * d;
        this.mat[5] = (double)(1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.z * quat4f.z) * d;
        this.mat[9] = (double)(2.0f * (quat4f.y * quat4f.z + quat4f.w * quat4f.x)) * d;
        this.mat[2] = (double)(2.0f * (quat4f.x * quat4f.z + quat4f.w * quat4f.y)) * d;
        this.mat[6] = (double)(2.0f * (quat4f.y * quat4f.z - quat4f.w * quat4f.x)) * d;
        this.mat[10] = (double)(1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.y * quat4f.y) * d;
        this.mat[3] = vector3d.x;
        this.mat[7] = vector3d.y;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0x400000C0;
        this.dirtyBits = 88;
    }

    public final void set(Quat4f quat4f, Vector3f vector3f, float f) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = (double)f;
        this.scales[0] = this.scales[2];
        this.mat[0] = (1.0f - 2.0f * quat4f.y * quat4f.y - 2.0f * quat4f.z * quat4f.z) * f;
        this.mat[4] = 2.0f * (quat4f.x * quat4f.y + quat4f.w * quat4f.z) * f;
        this.mat[8] = 2.0f * (quat4f.x * quat4f.z - quat4f.w * quat4f.y) * f;
        this.mat[1] = 2.0f * (quat4f.x * quat4f.y - quat4f.w * quat4f.z) * f;
        this.mat[5] = (1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.z * quat4f.z) * f;
        this.mat[9] = 2.0f * (quat4f.y * quat4f.z + quat4f.w * quat4f.x) * f;
        this.mat[2] = 2.0f * (quat4f.x * quat4f.z + quat4f.w * quat4f.y) * f;
        this.mat[6] = 2.0f * (quat4f.y * quat4f.z - quat4f.w * quat4f.x) * f;
        this.mat[10] = (1.0f - 2.0f * quat4f.x * quat4f.x - 2.0f * quat4f.y * quat4f.y) * f;
        this.mat[3] = vector3f.x;
        this.mat[7] = vector3f.y;
        this.mat[11] = vector3f.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0x400000C0;
        this.dirtyBits = 88;
    }

    public final void set(Matrix3f matrix3f, Vector3f vector3f, float f) {
        this.mat[0] = matrix3f.m00 * f;
        this.mat[1] = matrix3f.m01 * f;
        this.mat[2] = matrix3f.m02 * f;
        this.mat[3] = vector3f.x;
        this.mat[4] = matrix3f.m10 * f;
        this.mat[5] = matrix3f.m11 * f;
        this.mat[6] = matrix3f.m12 * f;
        this.mat[7] = vector3f.y;
        this.mat[8] = matrix3f.m20 * f;
        this.mat[9] = matrix3f.m21 * f;
        this.mat[10] = matrix3f.m22 * f;
        this.mat[11] = vector3f.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 128;
        this.dirtyBits = 254;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3f matrix3f, Vector3d vector3d, double d) {
        this.mat[0] = (double)matrix3f.m00 * d;
        this.mat[1] = (double)matrix3f.m01 * d;
        this.mat[2] = (double)matrix3f.m02 * d;
        this.mat[3] = vector3d.x;
        this.mat[4] = (double)matrix3f.m10 * d;
        this.mat[5] = (double)matrix3f.m11 * d;
        this.mat[6] = (double)matrix3f.m12 * d;
        this.mat[7] = vector3d.y;
        this.mat[8] = (double)matrix3f.m20 * d;
        this.mat[9] = (double)matrix3f.m21 * d;
        this.mat[10] = (double)matrix3f.m22 * d;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 128;
        this.dirtyBits = 254;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3d matrix3d, Vector3d vector3d, double d) {
        this.mat[0] = matrix3d.m00 * d;
        this.mat[1] = matrix3d.m01 * d;
        this.mat[2] = matrix3d.m02 * d;
        this.mat[3] = vector3d.x;
        this.mat[4] = matrix3d.m10 * d;
        this.mat[5] = matrix3d.m11 * d;
        this.mat[6] = matrix3d.m12 * d;
        this.mat[7] = vector3d.y;
        this.mat[8] = matrix3d.m20 * d;
        this.mat[9] = matrix3d.m21 * d;
        this.mat[10] = matrix3d.m22 * d;
        this.mat[11] = vector3d.z;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 128;
        this.dirtyBits = 254;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(GMatrix gMatrix) {
        int n = gMatrix.getNumRow();
        int n2 = gMatrix.getNumCol();
        for (int i = 0; i < 4; ++i) {
            int n3 = i * 4;
            for (int j = 0; j < 4; ++j) {
                this.mat[n3 + j] = i >= n || j >= n2 ? 0.0 : gMatrix.getElement(i, j);
            }
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Transform3D transform3D) {
        this.mat[0] = transform3D.mat[0];
        this.mat[1] = transform3D.mat[1];
        this.mat[2] = transform3D.mat[2];
        this.mat[3] = transform3D.mat[3];
        this.mat[4] = transform3D.mat[4];
        this.mat[5] = transform3D.mat[5];
        this.mat[6] = transform3D.mat[6];
        this.mat[7] = transform3D.mat[7];
        this.mat[8] = transform3D.mat[8];
        this.mat[9] = transform3D.mat[9];
        this.mat[10] = transform3D.mat[10];
        this.mat[11] = transform3D.mat[11];
        this.mat[12] = transform3D.mat[12];
        this.mat[13] = transform3D.mat[13];
        this.mat[14] = transform3D.mat[14];
        this.mat[15] = transform3D.mat[15];
        this.type = transform3D.type;
        this.dirtyBits = transform3D.dirtyBits | 0x40 | 0x20;
        this.autoNormalize = transform3D.autoNormalize;
    }

    synchronized void setWithLock(Transform3D transform3D) {
        this.set(transform3D);
    }

    synchronized void getWithLock(Transform3D transform3D) {
        transform3D.set(this);
    }

    public final void set(double[] dArray) {
        this.mat[0] = dArray[0];
        this.mat[1] = dArray[1];
        this.mat[2] = dArray[2];
        this.mat[3] = dArray[3];
        this.mat[4] = dArray[4];
        this.mat[5] = dArray[5];
        this.mat[6] = dArray[6];
        this.mat[7] = dArray[7];
        this.mat[8] = dArray[8];
        this.mat[9] = dArray[9];
        this.mat[10] = dArray[10];
        this.mat[11] = dArray[11];
        this.mat[12] = dArray[12];
        this.mat[13] = dArray[13];
        this.mat[14] = dArray[14];
        this.mat[15] = dArray[15];
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(float[] fArray) {
        this.mat[0] = fArray[0];
        this.mat[1] = fArray[1];
        this.mat[2] = fArray[2];
        this.mat[3] = fArray[3];
        this.mat[4] = fArray[4];
        this.mat[5] = fArray[5];
        this.mat[6] = fArray[6];
        this.mat[7] = fArray[7];
        this.mat[8] = fArray[8];
        this.mat[9] = fArray[9];
        this.mat[10] = fArray[10];
        this.mat[11] = fArray[11];
        this.mat[12] = fArray[12];
        this.mat[13] = fArray[13];
        this.mat[14] = fArray[14];
        this.mat[15] = fArray[15];
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix4d matrix4d) {
        this.mat[0] = matrix4d.m00;
        this.mat[1] = matrix4d.m01;
        this.mat[2] = matrix4d.m02;
        this.mat[3] = matrix4d.m03;
        this.mat[4] = matrix4d.m10;
        this.mat[5] = matrix4d.m11;
        this.mat[6] = matrix4d.m12;
        this.mat[7] = matrix4d.m13;
        this.mat[8] = matrix4d.m20;
        this.mat[9] = matrix4d.m21;
        this.mat[10] = matrix4d.m22;
        this.mat[11] = matrix4d.m23;
        this.mat[12] = matrix4d.m30;
        this.mat[13] = matrix4d.m31;
        this.mat[14] = matrix4d.m32;
        this.mat[15] = matrix4d.m33;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix4f matrix4f) {
        this.mat[0] = matrix4f.m00;
        this.mat[1] = matrix4f.m01;
        this.mat[2] = matrix4f.m02;
        this.mat[3] = matrix4f.m03;
        this.mat[4] = matrix4f.m10;
        this.mat[5] = matrix4f.m11;
        this.mat[6] = matrix4f.m12;
        this.mat[7] = matrix4f.m13;
        this.mat[8] = matrix4f.m20;
        this.mat[9] = matrix4f.m21;
        this.mat[10] = matrix4f.m22;
        this.mat[11] = matrix4f.m23;
        this.mat[12] = matrix4f.m30;
        this.mat[13] = matrix4f.m31;
        this.mat[14] = matrix4f.m32;
        this.mat[15] = matrix4f.m33;
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3f matrix3f) {
        this.mat[0] = matrix3f.m00;
        this.mat[1] = matrix3f.m01;
        this.mat[2] = matrix3f.m02;
        this.mat[3] = 0.0;
        this.mat[4] = matrix3f.m10;
        this.mat[5] = matrix3f.m11;
        this.mat[6] = matrix3f.m12;
        this.mat[7] = 0.0;
        this.mat[8] = matrix3f.m20;
        this.mat[9] = matrix3f.m21;
        this.mat[10] = matrix3f.m22;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 128;
        this.dirtyBits = 254;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void set(Matrix3d matrix3d) {
        this.mat[0] = matrix3d.m00;
        this.mat[1] = matrix3d.m01;
        this.mat[2] = matrix3d.m02;
        this.mat[3] = 0.0;
        this.mat[4] = matrix3d.m10;
        this.mat[5] = matrix3d.m11;
        this.mat[6] = matrix3d.m12;
        this.mat[7] = 0.0;
        this.mat[8] = matrix3d.m20;
        this.mat[9] = matrix3d.m21;
        this.mat[10] = matrix3d.m22;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 128;
        this.dirtyBits = 254;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setEuler(Vector3d vector3d) {
        double d = Math.sin(vector3d.x);
        double d2 = Math.sin(vector3d.y);
        double d3 = Math.sin(vector3d.z);
        double d4 = Math.cos(vector3d.x);
        double d5 = Math.cos(vector3d.y);
        double d6 = Math.cos(vector3d.z);
        this.mat[0] = d5 * d6;
        this.mat[1] = -(d4 * d3) + d * d2 * d6;
        this.mat[2] = d * d3 + d4 * d2 * d6;
        this.mat[3] = 0.0;
        this.mat[4] = d5 * d3;
        this.mat[5] = d4 * d6 + d * d2 * d3;
        this.mat[6] = -(d * d6) + d4 * d2 * d3;
        this.mat[7] = 0.0;
        this.mat[8] = -d2;
        this.mat[9] = d * d5;
        this.mat[10] = d4 * d5;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0x400000E0;
        this.dirtyBits = 112;
    }

    public final void get(double[] dArray) {
        dArray[0] = this.mat[0];
        dArray[1] = this.mat[1];
        dArray[2] = this.mat[2];
        dArray[3] = this.mat[3];
        dArray[4] = this.mat[4];
        dArray[5] = this.mat[5];
        dArray[6] = this.mat[6];
        dArray[7] = this.mat[7];
        dArray[8] = this.mat[8];
        dArray[9] = this.mat[9];
        dArray[10] = this.mat[10];
        dArray[11] = this.mat[11];
        dArray[12] = this.mat[12];
        dArray[13] = this.mat[13];
        dArray[14] = this.mat[14];
        dArray[15] = this.mat[15];
    }

    public final void get(float[] fArray) {
        fArray[0] = (float)this.mat[0];
        fArray[1] = (float)this.mat[1];
        fArray[2] = (float)this.mat[2];
        fArray[3] = (float)this.mat[3];
        fArray[4] = (float)this.mat[4];
        fArray[5] = (float)this.mat[5];
        fArray[6] = (float)this.mat[6];
        fArray[7] = (float)this.mat[7];
        fArray[8] = (float)this.mat[8];
        fArray[9] = (float)this.mat[9];
        fArray[10] = (float)this.mat[10];
        fArray[11] = (float)this.mat[11];
        fArray[12] = (float)this.mat[12];
        fArray[13] = (float)this.mat[13];
        fArray[14] = (float)this.mat[14];
        fArray[15] = (float)this.mat[15];
    }

    public final void get(Matrix3d matrix3d) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        matrix3d.m00 = this.rot[0];
        matrix3d.m01 = this.rot[1];
        matrix3d.m02 = this.rot[2];
        matrix3d.m10 = this.rot[3];
        matrix3d.m11 = this.rot[4];
        matrix3d.m12 = this.rot[5];
        matrix3d.m20 = this.rot[6];
        matrix3d.m21 = this.rot[7];
        matrix3d.m22 = this.rot[8];
    }

    public final void get(Matrix3f matrix3f) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        matrix3f.m00 = (float)this.rot[0];
        matrix3f.m01 = (float)this.rot[1];
        matrix3f.m02 = (float)this.rot[2];
        matrix3f.m10 = (float)this.rot[3];
        matrix3f.m11 = (float)this.rot[4];
        matrix3f.m12 = (float)this.rot[5];
        matrix3f.m20 = (float)this.rot[6];
        matrix3f.m21 = (float)this.rot[7];
        matrix3f.m22 = (float)this.rot[8];
    }

    public final void get(Quat4f quat4f) {
        double d;
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        if (!(((d = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8])) < 0.0 ? -d : d) < 1.0E-10)) {
            quat4f.w = (float)Math.sqrt(d);
            d = 0.25 / (double)quat4f.w;
            quat4f.x = (float)((this.rot[7] - this.rot[5]) * d);
            quat4f.y = (float)((this.rot[2] - this.rot[6]) * d);
            quat4f.z = (float)((this.rot[3] - this.rot[1]) * d);
            return;
        }
        quat4f.w = 0.0f;
        d = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((d < 0.0 ? -d : d) < 1.0E-10)) {
            quat4f.x = (float)Math.sqrt(d);
            d = 0.5 / (double)quat4f.x;
            quat4f.y = (float)(this.rot[3] * d);
            quat4f.z = (float)(this.rot[6] * d);
            return;
        }
        quat4f.x = 0.0f;
        d = 0.5 * (1.0 - this.rot[8]);
        if (!((d < 0.0 ? -d : d) < 1.0E-10)) {
            quat4f.y = (float)Math.sqrt(d);
            quat4f.z = (float)(this.rot[7] / (2.0 * (double)quat4f.y));
            return;
        }
        quat4f.y = 0.0f;
        quat4f.z = 1.0f;
    }

    public final void get(Quat4d quat4d) {
        double d;
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        if (!(((d = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8])) < 0.0 ? -d : d) < 1.0E-10)) {
            quat4d.w = Math.sqrt(d);
            d = 0.25 / quat4d.w;
            quat4d.x = (this.rot[7] - this.rot[5]) * d;
            quat4d.y = (this.rot[2] - this.rot[6]) * d;
            quat4d.z = (this.rot[3] - this.rot[1]) * d;
            return;
        }
        quat4d.w = 0.0;
        d = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((d < 0.0 ? -d : d) < 1.0E-10)) {
            quat4d.x = Math.sqrt(d);
            d = 0.5 / quat4d.x;
            quat4d.y = this.rot[3] * d;
            quat4d.z = this.rot[6] * d;
            return;
        }
        quat4d.x = 0.0;
        d = 0.5 * (1.0 - this.rot[8]);
        if (!((d < 0.0 ? -d : d) < 1.0E-10)) {
            quat4d.y = Math.sqrt(d);
            quat4d.z = this.rot[7] / (2.0 * quat4d.y);
            return;
        }
        quat4d.y = 0.0;
        quat4d.z = 1.0;
    }

    public final void get(Matrix4d matrix4d) {
        matrix4d.m00 = this.mat[0];
        matrix4d.m01 = this.mat[1];
        matrix4d.m02 = this.mat[2];
        matrix4d.m03 = this.mat[3];
        matrix4d.m10 = this.mat[4];
        matrix4d.m11 = this.mat[5];
        matrix4d.m12 = this.mat[6];
        matrix4d.m13 = this.mat[7];
        matrix4d.m20 = this.mat[8];
        matrix4d.m21 = this.mat[9];
        matrix4d.m22 = this.mat[10];
        matrix4d.m23 = this.mat[11];
        matrix4d.m30 = this.mat[12];
        matrix4d.m31 = this.mat[13];
        matrix4d.m32 = this.mat[14];
        matrix4d.m33 = this.mat[15];
    }

    public final void get(Matrix4f matrix4f) {
        matrix4f.m00 = (float)this.mat[0];
        matrix4f.m01 = (float)this.mat[1];
        matrix4f.m02 = (float)this.mat[2];
        matrix4f.m03 = (float)this.mat[3];
        matrix4f.m10 = (float)this.mat[4];
        matrix4f.m11 = (float)this.mat[5];
        matrix4f.m12 = (float)this.mat[6];
        matrix4f.m13 = (float)this.mat[7];
        matrix4f.m20 = (float)this.mat[8];
        matrix4f.m21 = (float)this.mat[9];
        matrix4f.m22 = (float)this.mat[10];
        matrix4f.m23 = (float)this.mat[11];
        matrix4f.m30 = (float)this.mat[12];
        matrix4f.m31 = (float)this.mat[13];
        matrix4f.m32 = (float)this.mat[14];
        matrix4f.m33 = (float)this.mat[15];
    }

    public final double get(Quat4d quat4d, Vector3d vector3d) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        vector3d.x = this.mat[3];
        vector3d.y = this.mat[7];
        vector3d.z = this.mat[11];
        double d = Transform3D.max3(this.scales);
        double d2 = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4d.w = Math.sqrt(d2);
            d2 = 0.25 / quat4d.w;
            quat4d.x = (this.rot[7] - this.rot[5]) * d2;
            quat4d.y = (this.rot[2] - this.rot[6]) * d2;
            quat4d.z = (this.rot[3] - this.rot[1]) * d2;
            return d;
        }
        quat4d.w = 0.0;
        d2 = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4d.x = Math.sqrt(d2);
            d2 = 0.5 / quat4d.x;
            quat4d.y = this.rot[3] * d2;
            quat4d.z = this.rot[6] * d2;
            return d;
        }
        quat4d.x = 0.0;
        d2 = 0.5 * (1.0 - this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4d.y = Math.sqrt(d2);
            quat4d.z = this.rot[7] / (2.0 * quat4d.y);
            return d;
        }
        quat4d.y = 0.0;
        quat4d.z = 1.0;
        return d;
    }

    public final float get(Quat4f quat4f, Vector3f vector3f) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        double d = Transform3D.max3(this.scales);
        vector3f.x = (float)this.mat[3];
        vector3f.y = (float)this.mat[7];
        vector3f.z = (float)this.mat[11];
        double d2 = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.w = (float)Math.sqrt(d2);
            d2 = 0.25 / (double)quat4f.w;
            quat4f.x = (float)((this.rot[7] - this.rot[5]) * d2);
            quat4f.y = (float)((this.rot[2] - this.rot[6]) * d2);
            quat4f.z = (float)((this.rot[3] - this.rot[1]) * d2);
            return (float)d;
        }
        quat4f.w = 0.0f;
        d2 = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.x = (float)Math.sqrt(d2);
            d2 = 0.5 / (double)quat4f.x;
            quat4f.y = (float)(this.rot[3] * d2);
            quat4f.z = (float)(this.rot[6] * d2);
            return (float)d;
        }
        quat4f.x = 0.0f;
        d2 = 0.5 * (1.0 - this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.y = (float)Math.sqrt(d2);
            quat4f.z = (float)(this.rot[7] / (2.0 * (double)quat4f.y));
            return (float)d;
        }
        quat4f.y = 0.0f;
        quat4f.z = 1.0f;
        return (float)d;
    }

    public final double get(Quat4f quat4f, Vector3d vector3d) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        double d = Transform3D.max3(this.scales);
        vector3d.x = this.mat[3];
        vector3d.y = this.mat[7];
        vector3d.z = this.mat[11];
        double d2 = 0.25 * (1.0 + this.rot[0] + this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.w = (float)Math.sqrt(d2);
            d2 = 0.25 / (double)quat4f.w;
            quat4f.x = (float)((this.rot[7] - this.rot[5]) * d2);
            quat4f.y = (float)((this.rot[2] - this.rot[6]) * d2);
            quat4f.z = (float)((this.rot[3] - this.rot[1]) * d2);
            return d;
        }
        quat4f.w = 0.0f;
        d2 = -0.5 * (this.rot[4] + this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.x = (float)Math.sqrt(d2);
            d2 = 0.5 / (double)quat4f.x;
            quat4f.y = (float)(this.rot[3] * d2);
            quat4f.z = (float)(this.rot[6] * d2);
            return d;
        }
        quat4f.x = 0.0f;
        d2 = 0.5 * (1.0 - this.rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-10)) {
            quat4f.y = (float)Math.sqrt(d2);
            quat4f.z = (float)(this.rot[7] / (2.0 * (double)quat4f.y));
            return d;
        }
        quat4f.y = 0.0f;
        quat4f.z = 1.0f;
        return d;
    }

    public final double get(Matrix3d matrix3d, Vector3d vector3d) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        vector3d.x = this.mat[3];
        vector3d.y = this.mat[7];
        vector3d.z = this.mat[11];
        matrix3d.m00 = this.rot[0];
        matrix3d.m01 = this.rot[1];
        matrix3d.m02 = this.rot[2];
        matrix3d.m10 = this.rot[3];
        matrix3d.m11 = this.rot[4];
        matrix3d.m12 = this.rot[5];
        matrix3d.m20 = this.rot[6];
        matrix3d.m21 = this.rot[7];
        matrix3d.m22 = this.rot[8];
        return Transform3D.max3(this.scales);
    }

    public final float get(Matrix3f matrix3f, Vector3f vector3f) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        vector3f.x = (float)this.mat[3];
        vector3f.y = (float)this.mat[7];
        vector3f.z = (float)this.mat[11];
        matrix3f.m00 = (float)this.rot[0];
        matrix3f.m01 = (float)this.rot[1];
        matrix3f.m02 = (float)this.rot[2];
        matrix3f.m10 = (float)this.rot[3];
        matrix3f.m11 = (float)this.rot[4];
        matrix3f.m12 = (float)this.rot[5];
        matrix3f.m20 = (float)this.rot[6];
        matrix3f.m21 = (float)this.rot[7];
        matrix3f.m22 = (float)this.rot[8];
        return (float)Transform3D.max3(this.scales);
    }

    public final double get(Matrix3f matrix3f, Vector3d vector3d) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        } else if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        vector3d.x = this.mat[3];
        vector3d.y = this.mat[7];
        vector3d.z = this.mat[11];
        matrix3f.m00 = (float)this.rot[0];
        matrix3f.m01 = (float)this.rot[1];
        matrix3f.m02 = (float)this.rot[2];
        matrix3f.m10 = (float)this.rot[3];
        matrix3f.m11 = (float)this.rot[4];
        matrix3f.m12 = (float)this.rot[5];
        matrix3f.m20 = (float)this.rot[6];
        matrix3f.m21 = (float)this.rot[7];
        matrix3f.m22 = (float)this.rot[8];
        return Transform3D.max3(this.scales);
    }

    public final double getScale() {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        return Transform3D.max3(this.scales);
    }

    public final void getScale(Vector3d vector3d) {
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        vector3d.x = this.scales[0];
        vector3d.y = this.scales[1];
        vector3d.z = this.scales[2];
    }

    public final void get(Vector3f vector3f) {
        vector3f.x = (float)this.mat[3];
        vector3f.y = (float)this.mat[7];
        vector3f.z = (float)this.mat[11];
    }

    public final void get(Vector3d vector3d) {
        vector3d.x = this.mat[3];
        vector3d.y = this.mat[7];
        vector3d.z = this.mat[11];
    }

    public final void invert(Transform3D transform3D) {
        if (transform3D == this) {
            this.invert();
        } else if (transform3D.isAffine()) {
            this.invertAffine(transform3D);
        } else {
            this.invertGeneral(transform3D);
        }
    }

    public final void invert() {
        if (this.isAffine()) {
            this.invertAffine();
        } else {
            this.invertGeneral(this);
        }
    }

    final void invertAffine(Transform3D transform3D) {
        double d = transform3D.affineDeterminant();
        if (d == 0.0) {
            throw new SingularMatrixException(J3dI18N.getString("Transform3D1"));
        }
        double d2 = (transform3D.mat[0] * transform3D.mat[0] + transform3D.mat[1] * transform3D.mat[1] + transform3D.mat[2] * transform3D.mat[2] + transform3D.mat[3] * transform3D.mat[3]) * (transform3D.mat[4] * transform3D.mat[4] + transform3D.mat[5] * transform3D.mat[5] + transform3D.mat[6] * transform3D.mat[6] + transform3D.mat[7] * transform3D.mat[7]) * (transform3D.mat[8] * transform3D.mat[8] + transform3D.mat[9] * transform3D.mat[9] + transform3D.mat[10] * transform3D.mat[10] + transform3D.mat[11] * transform3D.mat[11]);
        if (d * d < 1.110223024E-16 * d2) {
            this.invertGeneral(transform3D);
            return;
        }
        d2 = 1.0 / d;
        this.mat[0] = (transform3D.mat[5] * transform3D.mat[10] - transform3D.mat[9] * transform3D.mat[6]) * d2;
        this.mat[1] = -(transform3D.mat[1] * transform3D.mat[10] - transform3D.mat[9] * transform3D.mat[2]) * d2;
        this.mat[2] = (transform3D.mat[1] * transform3D.mat[6] - transform3D.mat[5] * transform3D.mat[2]) * d2;
        this.mat[4] = -(transform3D.mat[4] * transform3D.mat[10] - transform3D.mat[8] * transform3D.mat[6]) * d2;
        this.mat[5] = (transform3D.mat[0] * transform3D.mat[10] - transform3D.mat[8] * transform3D.mat[2]) * d2;
        this.mat[6] = -(transform3D.mat[0] * transform3D.mat[6] - transform3D.mat[4] * transform3D.mat[2]) * d2;
        this.mat[8] = (transform3D.mat[4] * transform3D.mat[9] - transform3D.mat[8] * transform3D.mat[5]) * d2;
        this.mat[9] = -(transform3D.mat[0] * transform3D.mat[9] - transform3D.mat[8] * transform3D.mat[1]) * d2;
        this.mat[10] = (transform3D.mat[0] * transform3D.mat[5] - transform3D.mat[4] * transform3D.mat[1]) * d2;
        this.mat[3] = -(transform3D.mat[3] * this.mat[0] + transform3D.mat[7] * this.mat[1] + transform3D.mat[11] * this.mat[2]);
        this.mat[7] = -(transform3D.mat[3] * this.mat[4] + transform3D.mat[7] * this.mat[5] + transform3D.mat[11] * this.mat[6]);
        this.mat[11] = -(transform3D.mat[3] * this.mat[8] + transform3D.mat[7] * this.mat[9] + transform3D.mat[11] * this.mat[10]);
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits = transform3D.dirtyBits | 0xE0 | 0x10 | 2;
        this.type = transform3D.type;
    }

    final void invertAffine() {
        double d = this.affineDeterminant();
        if (d == 0.0) {
            throw new SingularMatrixException(J3dI18N.getString("Transform3D1"));
        }
        double d2 = (this.mat[0] * this.mat[0] + this.mat[1] * this.mat[1] + this.mat[2] * this.mat[2] + this.mat[3] * this.mat[3]) * (this.mat[4] * this.mat[4] + this.mat[5] * this.mat[5] + this.mat[6] * this.mat[6] + this.mat[7] * this.mat[7]) * (this.mat[8] * this.mat[8] + this.mat[9] * this.mat[9] + this.mat[10] * this.mat[10] + this.mat[11] * this.mat[11]);
        if (d * d < 1.110223024E-16 * d2) {
            this.invertGeneral(this);
            return;
        }
        d2 = 1.0 / d;
        double d3 = (this.mat[5] * this.mat[10] - this.mat[9] * this.mat[6]) * d2;
        double d4 = -(this.mat[1] * this.mat[10] - this.mat[9] * this.mat[2]) * d2;
        double d5 = (this.mat[1] * this.mat[6] - this.mat[5] * this.mat[2]) * d2;
        double d6 = -(this.mat[4] * this.mat[10] - this.mat[8] * this.mat[6]) * d2;
        double d7 = (this.mat[0] * this.mat[10] - this.mat[8] * this.mat[2]) * d2;
        double d8 = -(this.mat[0] * this.mat[6] - this.mat[4] * this.mat[2]) * d2;
        double d9 = (this.mat[4] * this.mat[9] - this.mat[8] * this.mat[5]) * d2;
        double d10 = -(this.mat[0] * this.mat[9] - this.mat[8] * this.mat[1]) * d2;
        double d11 = (this.mat[0] * this.mat[5] - this.mat[4] * this.mat[1]) * d2;
        double d12 = -(this.mat[3] * d3 + this.mat[7] * d4 + this.mat[11] * d5);
        double d13 = -(this.mat[3] * d6 + this.mat[7] * d7 + this.mat[11] * d8);
        this.mat[11] = -(this.mat[3] * d9 + this.mat[7] * d10 + this.mat[11] * d11);
        this.mat[0] = d3;
        this.mat[1] = d4;
        this.mat[2] = d5;
        this.mat[3] = d12;
        this.mat[4] = d6;
        this.mat[5] = d7;
        this.mat[6] = d8;
        this.mat[7] = d13;
        this.mat[8] = d9;
        this.mat[9] = d10;
        this.mat[10] = d11;
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[15] = 1.0;
        this.dirtyBits |= 0xF2;
    }

    final void invertGeneral(Transform3D transform3D) {
        double[] dArray = new double[16];
        int[] nArray = new int[4];
        System.arraycopy(transform3D.mat, 0, dArray, 0, dArray.length);
        if (!Transform3D.luDecomposition(dArray, nArray)) {
            throw new SingularMatrixException(J3dI18N.getString("Transform3D1"));
        }
        this.mat[0] = 1.0;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = 0.0;
        this.mat[4] = 0.0;
        this.mat[5] = 1.0;
        this.mat[6] = 0.0;
        this.mat[7] = 0.0;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = 1.0;
        this.mat[11] = 0.0;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        Transform3D.luBacksubstitution(dArray, nArray, this.mat);
        this.type = 0;
        this.dirtyBits = 255;
    }

    static boolean luDecomposition(double[] dArray, int[] nArray) {
        int n;
        double[] dArray2 = new double[4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 4;
        while (n4-- != 0) {
            double d = 0.0;
            n = 4;
            while (n-- != 0) {
                double d2 = dArray[n2++];
                if (!((d2 = Math.abs(d2)) > d)) continue;
                d = d2;
            }
            if (d == 0.0) {
                return false;
            }
            dArray2[n3++] = 1.0 / d;
        }
        n = 0;
        for (n4 = 0; n4 < 4; ++n4) {
            double d;
            int n5;
            int n6;
            int n7;
            double d3;
            int n8;
            for (n2 = 0; n2 < n4; ++n2) {
                n8 = n + 4 * n2 + n4;
                d3 = dArray[n8];
                int n9 = n2;
                int n10 = n + 4 * n2;
                n7 = n + n4;
                while (n9-- != 0) {
                    d3 -= dArray[n10] * dArray[n7];
                    ++n10;
                    n7 += 4;
                }
                dArray[n8] = d3;
            }
            double d4 = 0.0;
            n3 = -1;
            for (n2 = n4; n2 < 4; ++n2) {
                double d5;
                n8 = n + 4 * n2 + n4;
                d3 = dArray[n8];
                n6 = n4;
                n5 = n + 4 * n2;
                n7 = n + n4;
                while (n6-- != 0) {
                    d3 -= dArray[n5] * dArray[n7];
                    ++n5;
                    n7 += 4;
                }
                dArray[n8] = d3;
                d = dArray2[n2] * Math.abs(d3);
                if (!(d5 >= d4)) continue;
                d4 = d;
                n3 = n2;
            }
            if (n3 < 0) {
                return false;
            }
            if (n4 != n3) {
                n6 = 4;
                n5 = n + 4 * n3;
                n7 = n + 4 * n4;
                while (n6-- != 0) {
                    d = dArray[n5];
                    dArray[n5++] = dArray[n7];
                    dArray[n7++] = d;
                }
                dArray2[n3] = dArray2[n4];
            }
            nArray[n4] = n3;
            if (dArray[n + 4 * n4 + n4] == 0.0) {
                return false;
            }
            if (n4 == 3) continue;
            d = 1.0 / dArray[n + 4 * n4 + n4];
            n8 = n + 4 * (n4 + 1) + n4;
            n2 = 3 - n4;
            while (n2-- != 0) {
                int n11 = n8;
                dArray[n11] = dArray[n11] * d;
                n8 += 4;
            }
        }
        return true;
    }

    static void luBacksubstitution(double[] dArray, int[] nArray, double[] dArray2) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2;
            int n3 = i;
            int n4 = -1;
            for (int j = 0; j < 4; ++j) {
                int n5 = nArray[n + j];
                double d = dArray2[n3 + 4 * n5];
                dArray2[n3 + 4 * n5] = dArray2[n3 + 4 * j];
                if (n4 >= 0) {
                    n2 = j * 4;
                    for (int k = n4; k <= j - 1; ++k) {
                        d -= dArray[n2 + k] * dArray2[n3 + 4 * k];
                    }
                } else if (d != 0.0) {
                    n4 = j;
                }
                dArray2[n3 + 4 * j] = d;
            }
            n2 = 12;
            int n6 = n3 + 12;
            dArray2[n6] = dArray2[n6] / dArray[n2 + 3];
            dArray2[n3 + 8] = (dArray2[n3 + 8] - dArray[(n2 -= 4) + 3] * dArray2[n3 + 12]) / dArray[n2 + 2];
            dArray2[n3 + 4] = (dArray2[n3 + 4] - dArray[(n2 -= 4) + 2] * dArray2[n3 + 8] - dArray[n2 + 3] * dArray2[n3 + 12]) / dArray[n2 + 1];
            dArray2[n3 + 0] = (dArray2[n3 + 0] - dArray[(n2 -= 4) + 1] * dArray2[n3 + 4] - dArray[n2 + 2] * dArray2[n3 + 8] - dArray[n2 + 3] * dArray2[n3 + 12]) / dArray[n2 + 0];
        }
    }

    final double affineDeterminant() {
        return this.mat[0] * (this.mat[5] * this.mat[10] - this.mat[6] * this.mat[9]) - this.mat[1] * (this.mat[4] * this.mat[10] - this.mat[6] * this.mat[8]) + this.mat[2] * (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]);
    }

    public final double determinant() {
        if (this.isAffine()) {
            return this.mat[0] * (this.mat[5] * this.mat[10] - this.mat[6] * this.mat[9]) - this.mat[1] * (this.mat[4] * this.mat[10] - this.mat[6] * this.mat[8]) + this.mat[2] * (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]);
        }
        return this.mat[0] * (this.mat[5] * (this.mat[10] * this.mat[15] - this.mat[11] * this.mat[14]) - this.mat[6] * (this.mat[9] * this.mat[15] - this.mat[11] * this.mat[13]) + this.mat[7] * (this.mat[9] * this.mat[14] - this.mat[10] * this.mat[13])) - this.mat[1] * (this.mat[4] * (this.mat[10] * this.mat[15] - this.mat[11] * this.mat[14]) - this.mat[6] * (this.mat[8] * this.mat[15] - this.mat[11] * this.mat[12]) + this.mat[7] * (this.mat[8] * this.mat[14] - this.mat[10] * this.mat[12])) + this.mat[2] * (this.mat[4] * (this.mat[9] * this.mat[15] - this.mat[11] * this.mat[13]) - this.mat[5] * (this.mat[8] * this.mat[15] - this.mat[11] * this.mat[12]) + this.mat[7] * (this.mat[8] * this.mat[13] - this.mat[9] * this.mat[12])) - this.mat[3] * (this.mat[4] * (this.mat[9] * this.mat[14] - this.mat[10] * this.mat[13]) - this.mat[5] * (this.mat[8] * this.mat[14] - this.mat[10] * this.mat[12]) + this.mat[6] * (this.mat[8] * this.mat[13] - this.mat[9] * this.mat[12]));
    }

    public final void set(double d) {
        this.setScaleTranslation(0.0, 0.0, 0.0, d);
    }

    public final void set(double d, Vector3d vector3d) {
        this.setScaleTranslation(vector3d.x, vector3d.y, vector3d.z, d);
    }

    public final void set(float f, Vector3f vector3f) {
        this.setScaleTranslation(vector3f.x, vector3f.y, vector3f.z, f);
    }

    public final void set(Vector3d vector3d, double d) {
        this.setScaleTranslation(vector3d.x * d, vector3d.y * d, vector3d.z * d, d);
    }

    public final void set(Vector3f vector3f, float f) {
        this.setScaleTranslation(vector3f.x * f, vector3f.y * f, vector3f.z * f, f);
    }

    private final void setScaleTranslation(double d, double d2, double d3, double d4) {
        this.mat[0] = d4;
        this.mat[1] = 0.0;
        this.mat[2] = 0.0;
        this.mat[3] = d;
        this.mat[4] = 0.0;
        this.mat[5] = d4;
        this.mat[6] = 0.0;
        this.mat[7] = d2;
        this.mat[8] = 0.0;
        this.mat[9] = 0.0;
        this.mat[10] = d4;
        this.mat[11] = d3;
        this.mat[12] = 0.0;
        this.mat[13] = 0.0;
        this.mat[14] = 0.0;
        this.mat[15] = 1.0;
        if (this.scales == null) {
            this.scales = new double[3];
        }
        this.scales[1] = this.scales[2] = d4;
        this.scales[0] = this.scales[2];
        this.type = 0x400000C0;
        this.dirtyBits = 88;
    }

    public final void mul(double d) {
        int n = 0;
        while (n < 16) {
            int n2 = n++;
            this.mat[n2] = this.mat[n2] * d;
        }
        this.dirtyBits = 255;
    }

    public final void mul(double d, Transform3D transform3D) {
        for (int i = 0; i < 16; ++i) {
            this.mat[i] = transform3D.mat[i] * d;
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void mul(Transform3D transform3D) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        boolean bl = false;
        if (transform3D.isAffine()) {
            d12 = this.mat[0] * transform3D.mat[0] + this.mat[1] * transform3D.mat[4] + this.mat[2] * transform3D.mat[8];
            d11 = this.mat[0] * transform3D.mat[1] + this.mat[1] * transform3D.mat[5] + this.mat[2] * transform3D.mat[9];
            d10 = this.mat[0] * transform3D.mat[2] + this.mat[1] * transform3D.mat[6] + this.mat[2] * transform3D.mat[10];
            d9 = this.mat[0] * transform3D.mat[3] + this.mat[1] * transform3D.mat[7] + this.mat[2] * transform3D.mat[11] + this.mat[3];
            d8 = this.mat[4] * transform3D.mat[0] + this.mat[5] * transform3D.mat[4] + this.mat[6] * transform3D.mat[8];
            d7 = this.mat[4] * transform3D.mat[1] + this.mat[5] * transform3D.mat[5] + this.mat[6] * transform3D.mat[9];
            d6 = this.mat[4] * transform3D.mat[2] + this.mat[5] * transform3D.mat[6] + this.mat[6] * transform3D.mat[10];
            d5 = this.mat[4] * transform3D.mat[3] + this.mat[5] * transform3D.mat[7] + this.mat[6] * transform3D.mat[11] + this.mat[7];
            d4 = this.mat[8] * transform3D.mat[0] + this.mat[9] * transform3D.mat[4] + this.mat[10] * transform3D.mat[8];
            d3 = this.mat[8] * transform3D.mat[1] + this.mat[9] * transform3D.mat[5] + this.mat[10] * transform3D.mat[9];
            d2 = this.mat[8] * transform3D.mat[2] + this.mat[9] * transform3D.mat[6] + this.mat[10] * transform3D.mat[10];
            d = this.mat[8] * transform3D.mat[3] + this.mat[9] * transform3D.mat[7] + this.mat[10] * transform3D.mat[11] + this.mat[11];
            if (this.isAffine()) {
                this.mat[14] = 0.0;
                this.mat[13] = 0.0;
                this.mat[12] = 0.0;
                this.mat[15] = 1.0;
                bl = true;
            } else {
                double d13 = this.mat[12] * transform3D.mat[0] + this.mat[13] * transform3D.mat[4] + this.mat[14] * transform3D.mat[8];
                double d14 = this.mat[12] * transform3D.mat[1] + this.mat[13] * transform3D.mat[5] + this.mat[14] * transform3D.mat[9];
                double d15 = this.mat[12] * transform3D.mat[2] + this.mat[13] * transform3D.mat[6] + this.mat[14] * transform3D.mat[10];
                double d16 = this.mat[12] * transform3D.mat[3] + this.mat[13] * transform3D.mat[7] + this.mat[14] * transform3D.mat[11] + this.mat[15];
                this.mat[12] = d13;
                this.mat[13] = d14;
                this.mat[14] = d15;
                this.mat[15] = d16;
            }
        } else {
            d12 = this.mat[0] * transform3D.mat[0] + this.mat[1] * transform3D.mat[4] + this.mat[2] * transform3D.mat[8] + this.mat[3] * transform3D.mat[12];
            d11 = this.mat[0] * transform3D.mat[1] + this.mat[1] * transform3D.mat[5] + this.mat[2] * transform3D.mat[9] + this.mat[3] * transform3D.mat[13];
            d10 = this.mat[0] * transform3D.mat[2] + this.mat[1] * transform3D.mat[6] + this.mat[2] * transform3D.mat[10] + this.mat[3] * transform3D.mat[14];
            d9 = this.mat[0] * transform3D.mat[3] + this.mat[1] * transform3D.mat[7] + this.mat[2] * transform3D.mat[11] + this.mat[3] * transform3D.mat[15];
            d8 = this.mat[4] * transform3D.mat[0] + this.mat[5] * transform3D.mat[4] + this.mat[6] * transform3D.mat[8] + this.mat[7] * transform3D.mat[12];
            d7 = this.mat[4] * transform3D.mat[1] + this.mat[5] * transform3D.mat[5] + this.mat[6] * transform3D.mat[9] + this.mat[7] * transform3D.mat[13];
            d6 = this.mat[4] * transform3D.mat[2] + this.mat[5] * transform3D.mat[6] + this.mat[6] * transform3D.mat[10] + this.mat[7] * transform3D.mat[14];
            d5 = this.mat[4] * transform3D.mat[3] + this.mat[5] * transform3D.mat[7] + this.mat[6] * transform3D.mat[11] + this.mat[7] * transform3D.mat[15];
            d4 = this.mat[8] * transform3D.mat[0] + this.mat[9] * transform3D.mat[4] + this.mat[10] * transform3D.mat[8] + this.mat[11] * transform3D.mat[12];
            d3 = this.mat[8] * transform3D.mat[1] + this.mat[9] * transform3D.mat[5] + this.mat[10] * transform3D.mat[9] + this.mat[11] * transform3D.mat[13];
            d2 = this.mat[8] * transform3D.mat[2] + this.mat[9] * transform3D.mat[6] + this.mat[10] * transform3D.mat[10] + this.mat[11] * transform3D.mat[14];
            d = this.mat[8] * transform3D.mat[3] + this.mat[9] * transform3D.mat[7] + this.mat[10] * transform3D.mat[11] + this.mat[11] * transform3D.mat[15];
            if (this.isAffine()) {
                this.mat[12] = transform3D.mat[12];
                this.mat[13] = transform3D.mat[13];
                this.mat[14] = transform3D.mat[14];
                this.mat[15] = transform3D.mat[15];
            } else {
                double d17 = this.mat[12] * transform3D.mat[0] + this.mat[13] * transform3D.mat[4] + this.mat[14] * transform3D.mat[8] + this.mat[15] * transform3D.mat[12];
                double d18 = this.mat[12] * transform3D.mat[1] + this.mat[13] * transform3D.mat[5] + this.mat[14] * transform3D.mat[9] + this.mat[15] * transform3D.mat[13];
                double d19 = this.mat[12] * transform3D.mat[2] + this.mat[13] * transform3D.mat[6] + this.mat[14] * transform3D.mat[10] + this.mat[15] * transform3D.mat[14];
                double d20 = this.mat[12] * transform3D.mat[3] + this.mat[13] * transform3D.mat[7] + this.mat[14] * transform3D.mat[11] + this.mat[15] * transform3D.mat[15];
                this.mat[12] = d17;
                this.mat[13] = d18;
                this.mat[14] = d19;
                this.mat[15] = d20;
            }
        }
        this.mat[0] = d12;
        this.mat[1] = d11;
        this.mat[2] = d10;
        this.mat[3] = d9;
        this.mat[4] = d8;
        this.mat[5] = d7;
        this.mat[6] = d6;
        this.mat[7] = d5;
        this.mat[8] = d4;
        this.mat[9] = d3;
        this.mat[10] = d2;
        this.mat[11] = d;
        if ((this.dirtyBits & 4) == 0 && (this.type & 0x40) != 0 && (transform3D.dirtyBits & 4) == 0 && (transform3D.type & 0x40) != 0) {
            this.type &= transform3D.type;
            this.dirtyBits |= transform3D.dirtyBits | 0x10 | 0xE0 | 8;
        } else {
            this.dirtyBits = bl ? 254 : 255;
        }
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void mul(Transform3D transform3D, Transform3D transform3D2) {
        boolean bl = false;
        if (this != transform3D && this != transform3D2) {
            if (transform3D2.isAffine()) {
                this.mat[0] = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[1] * transform3D2.mat[4] + transform3D.mat[2] * transform3D2.mat[8];
                this.mat[1] = transform3D.mat[0] * transform3D2.mat[1] + transform3D.mat[1] * transform3D2.mat[5] + transform3D.mat[2] * transform3D2.mat[9];
                this.mat[2] = transform3D.mat[0] * transform3D2.mat[2] + transform3D.mat[1] * transform3D2.mat[6] + transform3D.mat[2] * transform3D2.mat[10];
                this.mat[3] = transform3D.mat[0] * transform3D2.mat[3] + transform3D.mat[1] * transform3D2.mat[7] + transform3D.mat[2] * transform3D2.mat[11] + transform3D.mat[3];
                this.mat[4] = transform3D.mat[4] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[4] + transform3D.mat[6] * transform3D2.mat[8];
                this.mat[5] = transform3D.mat[4] * transform3D2.mat[1] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.mat[6] * transform3D2.mat[9];
                this.mat[6] = transform3D.mat[4] * transform3D2.mat[2] + transform3D.mat[5] * transform3D2.mat[6] + transform3D.mat[6] * transform3D2.mat[10];
                this.mat[7] = transform3D.mat[4] * transform3D2.mat[3] + transform3D.mat[5] * transform3D2.mat[7] + transform3D.mat[6] * transform3D2.mat[11] + transform3D.mat[7];
                this.mat[8] = transform3D.mat[8] * transform3D2.mat[0] + transform3D.mat[9] * transform3D2.mat[4] + transform3D.mat[10] * transform3D2.mat[8];
                this.mat[9] = transform3D.mat[8] * transform3D2.mat[1] + transform3D.mat[9] * transform3D2.mat[5] + transform3D.mat[10] * transform3D2.mat[9];
                this.mat[10] = transform3D.mat[8] * transform3D2.mat[2] + transform3D.mat[9] * transform3D2.mat[6] + transform3D.mat[10] * transform3D2.mat[10];
                this.mat[11] = transform3D.mat[8] * transform3D2.mat[3] + transform3D.mat[9] * transform3D2.mat[7] + transform3D.mat[10] * transform3D2.mat[11] + transform3D.mat[11];
                if (transform3D.isAffine()) {
                    bl = true;
                    this.mat[14] = 0.0;
                    this.mat[13] = 0.0;
                    this.mat[12] = 0.0;
                    this.mat[15] = 1.0;
                } else {
                    this.mat[12] = transform3D.mat[12] * transform3D2.mat[0] + transform3D.mat[13] * transform3D2.mat[4] + transform3D.mat[14] * transform3D2.mat[8];
                    this.mat[13] = transform3D.mat[12] * transform3D2.mat[1] + transform3D.mat[13] * transform3D2.mat[5] + transform3D.mat[14] * transform3D2.mat[9];
                    this.mat[14] = transform3D.mat[12] * transform3D2.mat[2] + transform3D.mat[13] * transform3D2.mat[6] + transform3D.mat[14] * transform3D2.mat[10];
                    this.mat[15] = transform3D.mat[12] * transform3D2.mat[3] + transform3D.mat[13] * transform3D2.mat[7] + transform3D.mat[14] * transform3D2.mat[11] + transform3D.mat[15];
                }
            } else {
                this.mat[0] = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[1] * transform3D2.mat[4] + transform3D.mat[2] * transform3D2.mat[8] + transform3D.mat[3] * transform3D2.mat[12];
                this.mat[1] = transform3D.mat[0] * transform3D2.mat[1] + transform3D.mat[1] * transform3D2.mat[5] + transform3D.mat[2] * transform3D2.mat[9] + transform3D.mat[3] * transform3D2.mat[13];
                this.mat[2] = transform3D.mat[0] * transform3D2.mat[2] + transform3D.mat[1] * transform3D2.mat[6] + transform3D.mat[2] * transform3D2.mat[10] + transform3D.mat[3] * transform3D2.mat[14];
                this.mat[3] = transform3D.mat[0] * transform3D2.mat[3] + transform3D.mat[1] * transform3D2.mat[7] + transform3D.mat[2] * transform3D2.mat[11] + transform3D.mat[3] * transform3D2.mat[15];
                this.mat[4] = transform3D.mat[4] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[4] + transform3D.mat[6] * transform3D2.mat[8] + transform3D.mat[7] * transform3D2.mat[12];
                this.mat[5] = transform3D.mat[4] * transform3D2.mat[1] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.mat[6] * transform3D2.mat[9] + transform3D.mat[7] * transform3D2.mat[13];
                this.mat[6] = transform3D.mat[4] * transform3D2.mat[2] + transform3D.mat[5] * transform3D2.mat[6] + transform3D.mat[6] * transform3D2.mat[10] + transform3D.mat[7] * transform3D2.mat[14];
                this.mat[7] = transform3D.mat[4] * transform3D2.mat[3] + transform3D.mat[5] * transform3D2.mat[7] + transform3D.mat[6] * transform3D2.mat[11] + transform3D.mat[7] * transform3D2.mat[15];
                this.mat[8] = transform3D.mat[8] * transform3D2.mat[0] + transform3D.mat[9] * transform3D2.mat[4] + transform3D.mat[10] * transform3D2.mat[8] + transform3D.mat[11] * transform3D2.mat[12];
                this.mat[9] = transform3D.mat[8] * transform3D2.mat[1] + transform3D.mat[9] * transform3D2.mat[5] + transform3D.mat[10] * transform3D2.mat[9] + transform3D.mat[11] * transform3D2.mat[13];
                this.mat[10] = transform3D.mat[8] * transform3D2.mat[2] + transform3D.mat[9] * transform3D2.mat[6] + transform3D.mat[10] * transform3D2.mat[10] + transform3D.mat[11] * transform3D2.mat[14];
                this.mat[11] = transform3D.mat[8] * transform3D2.mat[3] + transform3D.mat[9] * transform3D2.mat[7] + transform3D.mat[10] * transform3D2.mat[11] + transform3D.mat[11] * transform3D2.mat[15];
                if (transform3D.isAffine()) {
                    this.mat[12] = transform3D2.mat[12];
                    this.mat[13] = transform3D2.mat[13];
                    this.mat[14] = transform3D2.mat[14];
                    this.mat[15] = transform3D2.mat[15];
                } else {
                    this.mat[12] = transform3D.mat[12] * transform3D2.mat[0] + transform3D.mat[13] * transform3D2.mat[4] + transform3D.mat[14] * transform3D2.mat[8] + transform3D.mat[15] * transform3D2.mat[12];
                    this.mat[13] = transform3D.mat[12] * transform3D2.mat[1] + transform3D.mat[13] * transform3D2.mat[5] + transform3D.mat[14] * transform3D2.mat[9] + transform3D.mat[15] * transform3D2.mat[13];
                    this.mat[14] = transform3D.mat[12] * transform3D2.mat[2] + transform3D.mat[13] * transform3D2.mat[6] + transform3D.mat[14] * transform3D2.mat[10] + transform3D.mat[15] * transform3D2.mat[14];
                    this.mat[15] = transform3D.mat[12] * transform3D2.mat[3] + transform3D.mat[13] * transform3D2.mat[7] + transform3D.mat[14] * transform3D2.mat[11] + transform3D.mat[15] * transform3D2.mat[15];
                }
            }
        } else {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            if (transform3D2.isAffine()) {
                d12 = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[1] * transform3D2.mat[4] + transform3D.mat[2] * transform3D2.mat[8];
                d11 = transform3D.mat[0] * transform3D2.mat[1] + transform3D.mat[1] * transform3D2.mat[5] + transform3D.mat[2] * transform3D2.mat[9];
                d10 = transform3D.mat[0] * transform3D2.mat[2] + transform3D.mat[1] * transform3D2.mat[6] + transform3D.mat[2] * transform3D2.mat[10];
                d9 = transform3D.mat[0] * transform3D2.mat[3] + transform3D.mat[1] * transform3D2.mat[7] + transform3D.mat[2] * transform3D2.mat[11] + transform3D.mat[3];
                d8 = transform3D.mat[4] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[4] + transform3D.mat[6] * transform3D2.mat[8];
                d7 = transform3D.mat[4] * transform3D2.mat[1] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.mat[6] * transform3D2.mat[9];
                d6 = transform3D.mat[4] * transform3D2.mat[2] + transform3D.mat[5] * transform3D2.mat[6] + transform3D.mat[6] * transform3D2.mat[10];
                d5 = transform3D.mat[4] * transform3D2.mat[3] + transform3D.mat[5] * transform3D2.mat[7] + transform3D.mat[6] * transform3D2.mat[11] + transform3D.mat[7];
                d4 = transform3D.mat[8] * transform3D2.mat[0] + transform3D.mat[9] * transform3D2.mat[4] + transform3D.mat[10] * transform3D2.mat[8];
                d3 = transform3D.mat[8] * transform3D2.mat[1] + transform3D.mat[9] * transform3D2.mat[5] + transform3D.mat[10] * transform3D2.mat[9];
                d2 = transform3D.mat[8] * transform3D2.mat[2] + transform3D.mat[9] * transform3D2.mat[6] + transform3D.mat[10] * transform3D2.mat[10];
                d = transform3D.mat[8] * transform3D2.mat[3] + transform3D.mat[9] * transform3D2.mat[7] + transform3D.mat[10] * transform3D2.mat[11] + transform3D.mat[11];
                if (transform3D.isAffine()) {
                    bl = true;
                    this.mat[14] = 0.0;
                    this.mat[13] = 0.0;
                    this.mat[12] = 0.0;
                    this.mat[15] = 1.0;
                } else {
                    double d13 = transform3D.mat[12] * transform3D2.mat[0] + transform3D.mat[13] * transform3D2.mat[4] + transform3D.mat[14] * transform3D2.mat[8];
                    double d14 = transform3D.mat[12] * transform3D2.mat[1] + transform3D.mat[13] * transform3D2.mat[5] + transform3D.mat[14] * transform3D2.mat[9];
                    double d15 = transform3D.mat[12] * transform3D2.mat[2] + transform3D.mat[13] * transform3D2.mat[6] + transform3D.mat[14] * transform3D2.mat[10];
                    double d16 = transform3D.mat[12] * transform3D2.mat[3] + transform3D.mat[13] * transform3D2.mat[7] + transform3D.mat[14] * transform3D2.mat[11] + transform3D.mat[15];
                    this.mat[12] = d13;
                    this.mat[13] = d14;
                    this.mat[14] = d15;
                    this.mat[15] = d16;
                }
            } else {
                d12 = transform3D.mat[0] * transform3D2.mat[0] + transform3D.mat[1] * transform3D2.mat[4] + transform3D.mat[2] * transform3D2.mat[8] + transform3D.mat[3] * transform3D2.mat[12];
                d11 = transform3D.mat[0] * transform3D2.mat[1] + transform3D.mat[1] * transform3D2.mat[5] + transform3D.mat[2] * transform3D2.mat[9] + transform3D.mat[3] * transform3D2.mat[13];
                d10 = transform3D.mat[0] * transform3D2.mat[2] + transform3D.mat[1] * transform3D2.mat[6] + transform3D.mat[2] * transform3D2.mat[10] + transform3D.mat[3] * transform3D2.mat[14];
                d9 = transform3D.mat[0] * transform3D2.mat[3] + transform3D.mat[1] * transform3D2.mat[7] + transform3D.mat[2] * transform3D2.mat[11] + transform3D.mat[3] * transform3D2.mat[15];
                d8 = transform3D.mat[4] * transform3D2.mat[0] + transform3D.mat[5] * transform3D2.mat[4] + transform3D.mat[6] * transform3D2.mat[8] + transform3D.mat[7] * transform3D2.mat[12];
                d7 = transform3D.mat[4] * transform3D2.mat[1] + transform3D.mat[5] * transform3D2.mat[5] + transform3D.mat[6] * transform3D2.mat[9] + transform3D.mat[7] * transform3D2.mat[13];
                d6 = transform3D.mat[4] * transform3D2.mat[2] + transform3D.mat[5] * transform3D2.mat[6] + transform3D.mat[6] * transform3D2.mat[10] + transform3D.mat[7] * transform3D2.mat[14];
                d5 = transform3D.mat[4] * transform3D2.mat[3] + transform3D.mat[5] * transform3D2.mat[7] + transform3D.mat[6] * transform3D2.mat[11] + transform3D.mat[7] * transform3D2.mat[15];
                d4 = transform3D.mat[8] * transform3D2.mat[0] + transform3D.mat[9] * transform3D2.mat[4] + transform3D.mat[10] * transform3D2.mat[8] + transform3D.mat[11] * transform3D2.mat[12];
                d3 = transform3D.mat[8] * transform3D2.mat[1] + transform3D.mat[9] * transform3D2.mat[5] + transform3D.mat[10] * transform3D2.mat[9] + transform3D.mat[11] * transform3D2.mat[13];
                d2 = transform3D.mat[8] * transform3D2.mat[2] + transform3D.mat[9] * transform3D2.mat[6] + transform3D.mat[10] * transform3D2.mat[10] + transform3D.mat[11] * transform3D2.mat[14];
                d = transform3D.mat[8] * transform3D2.mat[3] + transform3D.mat[9] * transform3D2.mat[7] + transform3D.mat[10] * transform3D2.mat[11] + transform3D.mat[11] * transform3D2.mat[15];
                if (transform3D.isAffine()) {
                    this.mat[12] = transform3D2.mat[12];
                    this.mat[13] = transform3D2.mat[13];
                    this.mat[14] = transform3D2.mat[14];
                    this.mat[15] = transform3D2.mat[15];
                } else {
                    double d17 = transform3D.mat[12] * transform3D2.mat[0] + transform3D.mat[13] * transform3D2.mat[4] + transform3D.mat[14] * transform3D2.mat[8] + transform3D.mat[15] * transform3D2.mat[12];
                    double d18 = transform3D.mat[12] * transform3D2.mat[1] + transform3D.mat[13] * transform3D2.mat[5] + transform3D.mat[14] * transform3D2.mat[9] + transform3D.mat[15] * transform3D2.mat[13];
                    double d19 = transform3D.mat[12] * transform3D2.mat[2] + transform3D.mat[13] * transform3D2.mat[6] + transform3D.mat[14] * transform3D2.mat[10] + transform3D.mat[15] * transform3D2.mat[14];
                    double d20 = transform3D.mat[12] * transform3D2.mat[3] + transform3D.mat[13] * transform3D2.mat[7] + transform3D.mat[14] * transform3D2.mat[11] + transform3D.mat[15] * transform3D2.mat[15];
                    this.mat[12] = d17;
                    this.mat[13] = d18;
                    this.mat[14] = d19;
                    this.mat[15] = d20;
                }
            }
            this.mat[0] = d12;
            this.mat[1] = d11;
            this.mat[2] = d10;
            this.mat[3] = d9;
            this.mat[4] = d8;
            this.mat[5] = d7;
            this.mat[6] = d6;
            this.mat[7] = d5;
            this.mat[8] = d4;
            this.mat[9] = d3;
            this.mat[10] = d2;
            this.mat[11] = d;
        }
        if ((transform3D.dirtyBits & 4) == 0 && (transform3D.type & 0x40) != 0 && (transform3D2.dirtyBits & 4) == 0 && (transform3D2.type & 0x40) != 0) {
            this.type = transform3D.type & transform3D2.type;
            this.dirtyBits = transform3D.dirtyBits | transform3D2.dirtyBits | 0x10 | 0xE0 | 8;
        } else {
            this.dirtyBits = bl ? 254 : 255;
        }
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void mulInverse(Transform3D transform3D) {
        Transform3D transform3D2 = VirtualUniverse.mc.getTransform3D(null);
        transform3D2.autoNormalize = false;
        transform3D2.invert(transform3D);
        this.mul(transform3D2);
        FreeListManager.freeObject(2, transform3D2);
    }

    public final void mulInverse(Transform3D transform3D, Transform3D transform3D2) {
        Transform3D transform3D3 = VirtualUniverse.mc.getTransform3D(null);
        transform3D3.autoNormalize = false;
        transform3D3.invert(transform3D2);
        this.mul(transform3D, transform3D3);
        FreeListManager.freeObject(2, transform3D3);
    }

    public final void mulTransposeRight(Transform3D transform3D, Transform3D transform3D2) {
        Transform3D transform3D3 = VirtualUniverse.mc.getTransform3D(null);
        transform3D3.autoNormalize = false;
        transform3D3.transpose(transform3D2);
        this.mul(transform3D, transform3D3);
        FreeListManager.freeObject(2, transform3D3);
    }

    public final void mulTransposeLeft(Transform3D transform3D, Transform3D transform3D2) {
        Transform3D transform3D3 = VirtualUniverse.mc.getTransform3D(null);
        transform3D3.autoNormalize = false;
        transform3D3.transpose(transform3D);
        this.mul(transform3D3, transform3D2);
        FreeListManager.freeObject(2, transform3D3);
    }

    public final void mulTransposeBoth(Transform3D transform3D, Transform3D transform3D2) {
        Transform3D transform3D3 = VirtualUniverse.mc.getTransform3D(null);
        Transform3D transform3D4 = VirtualUniverse.mc.getTransform3D(null);
        transform3D3.autoNormalize = false;
        transform3D4.autoNormalize = false;
        transform3D3.transpose(transform3D);
        transform3D4.transpose(transform3D2);
        this.mul(transform3D3, transform3D4);
        FreeListManager.freeObject(2, transform3D3);
        FreeListManager.freeObject(2, transform3D4);
    }

    public final void normalize() {
        if ((this.dirtyBits & 0xC0) != 0) {
            this.computeScaleRotation(true);
        } else if ((this.dirtyBits & 0xA0) != 0) {
            this.computeScales(true);
        }
        this.mat[0] = this.rot[0] * this.scales[0];
        this.mat[1] = this.rot[1] * this.scales[1];
        this.mat[2] = this.rot[2] * this.scales[2];
        this.mat[4] = this.rot[3] * this.scales[0];
        this.mat[5] = this.rot[4] * this.scales[1];
        this.mat[6] = this.rot[5] * this.scales[2];
        this.mat[8] = this.rot[6] * this.scales[0];
        this.mat[9] = this.rot[7] * this.scales[1];
        this.mat[10] = this.rot[8] * this.scales[2];
        this.dirtyBits |= 0x10;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
    }

    public final void normalize(Transform3D transform3D) {
        this.set(transform3D);
        this.normalize();
    }

    public final void normalizeCP() {
        double d;
        if ((this.dirtyBits & 0x20) != 0) {
            this.computeScales(false);
        }
        if ((d = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]) != 0.0) {
            d = 1.0 / Math.sqrt(d);
            this.mat[0] = this.mat[0] * d;
            this.mat[4] = this.mat[4] * d;
            this.mat[8] = this.mat[8] * d;
        }
        if ((d = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]) != 0.0) {
            d = 1.0 / Math.sqrt(d);
            this.mat[1] = this.mat[1] * d;
            this.mat[5] = this.mat[5] * d;
            this.mat[9] = this.mat[9] * d;
        }
        this.mat[2] = (this.mat[4] * this.mat[9] - this.mat[5] * this.mat[8]) * this.scales[0];
        this.mat[6] = (this.mat[1] * this.mat[8] - this.mat[0] * this.mat[9]) * this.scales[1];
        this.mat[10] = (this.mat[0] * this.mat[5] - this.mat[1] * this.mat[4]) * this.scales[2];
        this.mat[0] = this.mat[0] * this.scales[0];
        this.mat[1] = this.mat[1] * this.scales[0];
        this.mat[4] = this.mat[4] * this.scales[1];
        this.mat[5] = this.mat[5] * this.scales[1];
        this.mat[8] = this.mat[8] * this.scales[2];
        this.mat[9] = this.mat[9] * this.scales[2];
        this.dirtyBits |= 0xDC;
        this.dirtyBits &= 0xFFFFFFFD;
        this.type |= 0x40000000;
    }

    public final void normalizeCP(Transform3D transform3D) {
        this.set(transform3D);
        this.normalizeCP();
    }

    public boolean equals(Transform3D transform3D) {
        return transform3D != null && this.mat[0] == transform3D.mat[0] && this.mat[1] == transform3D.mat[1] && this.mat[2] == transform3D.mat[2] && this.mat[3] == transform3D.mat[3] && this.mat[4] == transform3D.mat[4] && this.mat[5] == transform3D.mat[5] && this.mat[6] == transform3D.mat[6] && this.mat[7] == transform3D.mat[7] && this.mat[8] == transform3D.mat[8] && this.mat[9] == transform3D.mat[9] && this.mat[10] == transform3D.mat[10] && this.mat[11] == transform3D.mat[11] && this.mat[12] == transform3D.mat[12] && this.mat[13] == transform3D.mat[13] && this.mat[14] == transform3D.mat[14] && this.mat[15] == transform3D.mat[15];
    }

    public boolean equals(Object object) {
        return object instanceof Transform3D && this.equals((Transform3D)object);
    }

    public boolean epsilonEquals(Transform3D transform3D, double d) {
        for (int i = 0; i < 16; ++i) {
            double d2 = this.mat[i] - transform3D.mat[i];
            double d3 = d2 < 0.0 ? -d2 : d2;
            if (!(d3 > d)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long l = 1L;
        for (int i = 0; i < 16; ++i) {
            l = 31L * l + HashCodeUtil.doubleToLongBits((double)this.mat[i]);
        }
        return (int)(l ^ l >> 32);
    }

    public final void transform(Vector4d vector4d, Vector4d vector4d2) {
        if (vector4d != vector4d2) {
            vector4d2.x = this.mat[0] * vector4d.x + this.mat[1] * vector4d.y + this.mat[2] * vector4d.z + this.mat[3] * vector4d.w;
            vector4d2.y = this.mat[4] * vector4d.x + this.mat[5] * vector4d.y + this.mat[6] * vector4d.z + this.mat[7] * vector4d.w;
            vector4d2.z = this.mat[8] * vector4d.x + this.mat[9] * vector4d.y + this.mat[10] * vector4d.z + this.mat[11] * vector4d.w;
            vector4d2.w = this.mat[12] * vector4d.x + this.mat[13] * vector4d.y + this.mat[14] * vector4d.z + this.mat[15] * vector4d.w;
        } else {
            this.transform(vector4d);
        }
    }

    public final void transform(Vector4d vector4d) {
        double d = this.mat[0] * vector4d.x + this.mat[1] * vector4d.y + this.mat[2] * vector4d.z + this.mat[3] * vector4d.w;
        double d2 = this.mat[4] * vector4d.x + this.mat[5] * vector4d.y + this.mat[6] * vector4d.z + this.mat[7] * vector4d.w;
        double d3 = this.mat[8] * vector4d.x + this.mat[9] * vector4d.y + this.mat[10] * vector4d.z + this.mat[11] * vector4d.w;
        vector4d.w = this.mat[12] * vector4d.x + this.mat[13] * vector4d.y + this.mat[14] * vector4d.z + this.mat[15] * vector4d.w;
        vector4d.x = d;
        vector4d.y = d2;
        vector4d.z = d3;
    }

    public final void transform(Vector4f vector4f, Vector4f vector4f2) {
        if (vector4f2 != vector4f) {
            vector4f2.x = (float)(this.mat[0] * (double)vector4f.x + this.mat[1] * (double)vector4f.y + this.mat[2] * (double)vector4f.z + this.mat[3] * (double)vector4f.w);
            vector4f2.y = (float)(this.mat[4] * (double)vector4f.x + this.mat[5] * (double)vector4f.y + this.mat[6] * (double)vector4f.z + this.mat[7] * (double)vector4f.w);
            vector4f2.z = (float)(this.mat[8] * (double)vector4f.x + this.mat[9] * (double)vector4f.y + this.mat[10] * (double)vector4f.z + this.mat[11] * (double)vector4f.w);
            vector4f2.w = (float)(this.mat[12] * (double)vector4f.x + this.mat[13] * (double)vector4f.y + this.mat[14] * (double)vector4f.z + this.mat[15] * (double)vector4f.w);
        } else {
            this.transform(vector4f);
        }
    }

    public final void transform(Vector4f vector4f) {
        float f = (float)(this.mat[0] * (double)vector4f.x + this.mat[1] * (double)vector4f.y + this.mat[2] * (double)vector4f.z + this.mat[3] * (double)vector4f.w);
        float f2 = (float)(this.mat[4] * (double)vector4f.x + this.mat[5] * (double)vector4f.y + this.mat[6] * (double)vector4f.z + this.mat[7] * (double)vector4f.w);
        float f3 = (float)(this.mat[8] * (double)vector4f.x + this.mat[9] * (double)vector4f.y + this.mat[10] * (double)vector4f.z + this.mat[11] * (double)vector4f.w);
        vector4f.w = (float)(this.mat[12] * (double)vector4f.x + this.mat[13] * (double)vector4f.y + this.mat[14] * (double)vector4f.z + this.mat[15] * (double)vector4f.w);
        vector4f.x = f;
        vector4f.y = f2;
        vector4f.z = f3;
    }

    public final void transform(Point3d point3d, Point3d point3d2) {
        if (point3d != point3d2) {
            point3d2.x = this.mat[0] * point3d.x + this.mat[1] * point3d.y + this.mat[2] * point3d.z + this.mat[3];
            point3d2.y = this.mat[4] * point3d.x + this.mat[5] * point3d.y + this.mat[6] * point3d.z + this.mat[7];
            point3d2.z = this.mat[8] * point3d.x + this.mat[9] * point3d.y + this.mat[10] * point3d.z + this.mat[11];
        } else {
            this.transform(point3d);
        }
    }

    public final void transform(Point3d point3d) {
        double d = this.mat[0] * point3d.x + this.mat[1] * point3d.y + this.mat[2] * point3d.z + this.mat[3];
        double d2 = this.mat[4] * point3d.x + this.mat[5] * point3d.y + this.mat[6] * point3d.z + this.mat[7];
        point3d.z = this.mat[8] * point3d.x + this.mat[9] * point3d.y + this.mat[10] * point3d.z + this.mat[11];
        point3d.x = d;
        point3d.y = d2;
    }

    public final void transform(Vector3d vector3d, Vector3d vector3d2) {
        if (vector3d2 != vector3d) {
            vector3d2.x = this.mat[0] * vector3d.x + this.mat[1] * vector3d.y + this.mat[2] * vector3d.z;
            vector3d2.y = this.mat[4] * vector3d.x + this.mat[5] * vector3d.y + this.mat[6] * vector3d.z;
            vector3d2.z = this.mat[8] * vector3d.x + this.mat[9] * vector3d.y + this.mat[10] * vector3d.z;
        } else {
            this.transform(vector3d);
        }
    }

    public final void transform(Vector3d vector3d) {
        double d = this.mat[0] * vector3d.x + this.mat[1] * vector3d.y + this.mat[2] * vector3d.z;
        double d2 = this.mat[4] * vector3d.x + this.mat[5] * vector3d.y + this.mat[6] * vector3d.z;
        vector3d.z = this.mat[8] * vector3d.x + this.mat[9] * vector3d.y + this.mat[10] * vector3d.z;
        vector3d.x = d;
        vector3d.y = d2;
    }

    public final void transform(Point3f point3f, Point3f point3f2) {
        if (point3f != point3f2) {
            point3f2.x = (float)(this.mat[0] * (double)point3f.x + this.mat[1] * (double)point3f.y + this.mat[2] * (double)point3f.z + this.mat[3]);
            point3f2.y = (float)(this.mat[4] * (double)point3f.x + this.mat[5] * (double)point3f.y + this.mat[6] * (double)point3f.z + this.mat[7]);
            point3f2.z = (float)(this.mat[8] * (double)point3f.x + this.mat[9] * (double)point3f.y + this.mat[10] * (double)point3f.z + this.mat[11]);
        } else {
            this.transform(point3f);
        }
    }

    public final void transform(Point3f point3f) {
        float f = (float)(this.mat[0] * (double)point3f.x + this.mat[1] * (double)point3f.y + this.mat[2] * (double)point3f.z + this.mat[3]);
        float f2 = (float)(this.mat[4] * (double)point3f.x + this.mat[5] * (double)point3f.y + this.mat[6] * (double)point3f.z + this.mat[7]);
        point3f.z = (float)(this.mat[8] * (double)point3f.x + this.mat[9] * (double)point3f.y + this.mat[10] * (double)point3f.z + this.mat[11]);
        point3f.x = f;
        point3f.y = f2;
    }

    public final void transform(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f != vector3f2) {
            vector3f2.x = (float)(this.mat[0] * (double)vector3f.x + this.mat[1] * (double)vector3f.y + this.mat[2] * (double)vector3f.z);
            vector3f2.y = (float)(this.mat[4] * (double)vector3f.x + this.mat[5] * (double)vector3f.y + this.mat[6] * (double)vector3f.z);
            vector3f2.z = (float)(this.mat[8] * (double)vector3f.x + this.mat[9] * (double)vector3f.y + this.mat[10] * (double)vector3f.z);
        } else {
            this.transform(vector3f);
        }
    }

    public final void transform(Vector3f vector3f) {
        float f = (float)(this.mat[0] * (double)vector3f.x + this.mat[1] * (double)vector3f.y + this.mat[2] * (double)vector3f.z);
        float f2 = (float)(this.mat[4] * (double)vector3f.x + this.mat[5] * (double)vector3f.y + this.mat[6] * (double)vector3f.z);
        vector3f.z = (float)(this.mat[8] * (double)vector3f.x + this.mat[9] * (double)vector3f.y + this.mat[10] * (double)vector3f.z);
        vector3f.x = f;
        vector3f.y = f2;
    }

    public final void setRotationScale(Matrix3f matrix3f) {
        this.mat[0] = matrix3f.m00;
        this.mat[1] = matrix3f.m01;
        this.mat[2] = matrix3f.m02;
        this.mat[4] = matrix3f.m10;
        this.mat[5] = matrix3f.m11;
        this.mat[6] = matrix3f.m12;
        this.mat[8] = matrix3f.m20;
        this.mat[9] = matrix3f.m21;
        this.mat[10] = matrix3f.m22;
        this.dirtyBits |= 0xFE;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void setRotationScale(Matrix3d matrix3d) {
        this.mat[0] = matrix3d.m00;
        this.mat[1] = matrix3d.m01;
        this.mat[2] = matrix3d.m02;
        this.mat[4] = matrix3d.m10;
        this.mat[5] = matrix3d.m11;
        this.mat[6] = matrix3d.m12;
        this.mat[8] = matrix3d.m20;
        this.mat[9] = matrix3d.m21;
        this.mat[10] = matrix3d.m22;
        this.dirtyBits |= 0xFE;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void scaleAdd(double d, Transform3D transform3D, Transform3D transform3D2) {
        for (int i = 0; i < 16; ++i) {
            this.mat[i] = d * transform3D.mat[i] + transform3D2.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void scaleAdd(double d, Transform3D transform3D) {
        for (int i = 0; i < 16; ++i) {
            this.mat[i] = d * this.mat[i] + transform3D.mat[i];
        }
        this.dirtyBits = 255;
        if (this.autoNormalize) {
            this.normalize();
        }
    }

    public final void getRotationScale(Matrix3f matrix3f) {
        matrix3f.m00 = (float)this.mat[0];
        matrix3f.m01 = (float)this.mat[1];
        matrix3f.m02 = (float)this.mat[2];
        matrix3f.m10 = (float)this.mat[4];
        matrix3f.m11 = (float)this.mat[5];
        matrix3f.m12 = (float)this.mat[6];
        matrix3f.m20 = (float)this.mat[8];
        matrix3f.m21 = (float)this.mat[9];
        matrix3f.m22 = (float)this.mat[10];
    }

    public final void getRotationScale(Matrix3d matrix3d) {
        matrix3d.m00 = this.mat[0];
        matrix3d.m01 = this.mat[1];
        matrix3d.m02 = this.mat[2];
        matrix3d.m10 = this.mat[4];
        matrix3d.m11 = this.mat[5];
        matrix3d.m12 = this.mat[6];
        matrix3d.m20 = this.mat[8];
        matrix3d.m21 = this.mat[9];
        matrix3d.m22 = this.mat[10];
    }

    public void lookAt(Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        double d = point3d.x - point3d2.x;
        double d2 = point3d.y - point3d2.y;
        double d3 = point3d.z - point3d2.z;
        double d4 = 1.0 / Math.sqrt(d * d + d2 * d2 + d3 * d3);
        d *= d4;
        d2 *= d4;
        d3 *= d4;
        d4 = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        double d5 = vector3d.x * d4;
        double d6 = vector3d.y * d4;
        double d7 = vector3d.z * d4;
        double d8 = d6 * d3 - d2 * d7;
        double d9 = d7 * d - d5 * d3;
        double d10 = d5 * d2 - d6 * d;
        d4 = 1.0 / Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
        d5 = d2 * (d10 *= d4) - (d9 *= d4) * d3;
        d6 = d3 * (d8 *= d4) - d * d10;
        d7 = d * d9 - d2 * d8;
        this.mat[0] = d8;
        this.mat[1] = d9;
        this.mat[2] = d10;
        this.mat[4] = d5;
        this.mat[5] = d6;
        this.mat[6] = d7;
        this.mat[8] = d;
        this.mat[9] = d2;
        this.mat[10] = d3;
        this.mat[3] = -point3d.x * this.mat[0] + -point3d.y * this.mat[1] + -point3d.z * this.mat[2];
        this.mat[7] = -point3d.x * this.mat[4] + -point3d.y * this.mat[5] + -point3d.z * this.mat[6];
        this.mat[11] = -point3d.x * this.mat[8] + -point3d.y * this.mat[9] + -point3d.z * this.mat[10];
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[15] = 1.0;
        this.type = 0x400000E0;
        this.dirtyBits = 240;
    }

    public void frustum(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 1.0 / (d2 - d);
        double d8 = 1.0 / (d4 - d3);
        double d9 = 1.0 / (d6 - d5);
        this.mat[0] = 2.0 * d5 * d7;
        this.mat[5] = 2.0 * d5 * d8;
        this.mat[10] = (d6 + d5) * d9;
        this.mat[2] = (d2 + d) * d7;
        this.mat[6] = (d4 + d3) * d8;
        this.mat[11] = 2.0 * d6 * d5 * d9;
        this.mat[14] = -1.0;
        this.mat[15] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[7] = 0.0;
        this.mat[4] = 0.0;
        this.mat[3] = 0.0;
        this.mat[1] = 0.0;
        this.type = 0;
        this.dirtyBits = 240;
    }

    public void perspective(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d * 0.5;
        Vector3d vector3d = new Vector3d();
        double d7 = d4 - d3;
        double d8 = Math.sin(d6);
        this.mat[0] = d5 = Math.cos(d6) / d8;
        this.mat[5] = d5 * d2;
        this.mat[10] = (d4 + d3) / d7;
        this.mat[11] = 2.0 * d3 * d4 / d7;
        this.mat[14] = -1.0;
        this.mat[15] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[7] = 0.0;
        this.mat[6] = 0.0;
        this.mat[4] = 0.0;
        this.mat[3] = 0.0;
        this.mat[2] = 0.0;
        this.mat[1] = 0.0;
        this.type = 0;
        this.dirtyBits = 240;
    }

    public void ortho(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 1.0 / (d2 - d);
        double d8 = 1.0 / (d4 - d3);
        double d9 = 1.0 / (d6 - d5);
        this.mat[0] = 2.0 * d7;
        this.mat[3] = -(d2 + d) * d7;
        this.mat[5] = 2.0 * d8;
        this.mat[7] = -(d4 + d3) * d8;
        this.mat[10] = 2.0 * d9;
        this.mat[11] = (d6 + d5) * d9;
        this.mat[14] = 0.0;
        this.mat[13] = 0.0;
        this.mat[12] = 0.0;
        this.mat[9] = 0.0;
        this.mat[8] = 0.0;
        this.mat[6] = 0.0;
        this.mat[4] = 0.0;
        this.mat[2] = 0.0;
        this.mat[1] = 0.0;
        this.mat[15] = 1.0;
        this.type = 128;
        this.dirtyBits = 254;
    }

    double getDistanceScale() {
        if ((this.dirtyBits & 0x20) != 0) {
            double d = this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8];
            if ((this.dirtyBits & 4) == 0 && (this.type & 0x40) != 0) {
                return Math.sqrt(d);
            }
            double d2 = this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9];
            if (d2 > d) {
                d = d2;
            }
            return Math.sqrt((d2 = this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10]) > d ? d2 : d);
        }
        return Transform3D.max3(this.scales);
    }

    private static void mat_mul(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = dArray3;
        if (dArray == dArray3 || dArray2 == dArray3) {
            dArray4 = new double[]{dArray[0] * dArray2[0] + dArray[1] * dArray2[3] + dArray[2] * dArray2[6], dArray[0] * dArray2[1] + dArray[1] * dArray2[4] + dArray[2] * dArray2[7], dArray[0] * dArray2[2] + dArray[1] * dArray2[5] + dArray[2] * dArray2[8], dArray[3] * dArray2[0] + dArray[4] * dArray2[3] + dArray[5] * dArray2[6], dArray[3] * dArray2[1] + dArray[4] * dArray2[4] + dArray[5] * dArray2[7], dArray[3] * dArray2[2] + dArray[4] * dArray2[5] + dArray[5] * dArray2[8], dArray[6] * dArray2[0] + dArray[7] * dArray2[3] + dArray[8] * dArray2[6], dArray[6] * dArray2[1] + dArray[7] * dArray2[4] + dArray[8] * dArray2[7], dArray[6] * dArray2[2] + dArray[7] * dArray2[5] + dArray[8] * dArray2[8]};
        }
        if (dArray4 != dArray3) {
            for (int i = 0; i < 9; ++i) {
                dArray3[i] = dArray4[i];
            }
        }
    }

    private static void transpose_mat(double[] dArray, double[] dArray2) {
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[3];
        dArray2[2] = dArray[6];
        dArray2[3] = dArray[1];
        dArray2[4] = dArray[4];
        dArray2[5] = dArray[7];
        dArray2[6] = dArray[2];
        dArray2[7] = dArray[5];
        dArray2[8] = dArray[8];
    }

    private static final void multipleScale(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] * dArray2[0];
        dArray[1] = dArray[1] * dArray2[0];
        dArray[2] = dArray[2] * dArray2[0];
        dArray[4] = dArray[4] * dArray2[1];
        dArray[5] = dArray[5] * dArray2[1];
        dArray[6] = dArray[6] * dArray2[1];
        dArray[8] = dArray[8] * dArray2[2];
        dArray[9] = dArray[9] * dArray2[2];
        dArray[10] = dArray[10] * dArray2[2];
    }

    private void compute_svd(Transform3D transform3D, double[] dArray, double[] dArray2) {
        double d;
        double[] dArray3 = new double[9];
        double[] dArray4 = new double[9];
        double[] dArray5 = new double[9];
        double[] dArray6 = new double[9];
        double[] dArray7 = new double[9];
        double[] dArray8 = new double[9];
        double[] dArray9 = new double[3];
        double[] dArray10 = new double[3];
        int n = 0;
        dArray8[0] = dArray3[0] = transform3D.mat[0];
        dArray8[1] = dArray3[1] = transform3D.mat[1];
        dArray8[2] = dArray3[2] = transform3D.mat[2];
        dArray8[3] = dArray3[3] = transform3D.mat[4];
        dArray8[4] = dArray3[4] = transform3D.mat[5];
        dArray8[5] = dArray3[5] = transform3D.mat[6];
        dArray8[6] = dArray3[6] = transform3D.mat[8];
        dArray8[7] = dArray3[7] = transform3D.mat[9];
        dArray8[8] = dArray3[8] = transform3D.mat[10];
        if (dArray3[3] * dArray3[3] < 1.110223024E-16) {
            dArray4[0] = 1.0;
            dArray4[1] = 0.0;
            dArray4[2] = 0.0;
            dArray4[3] = 0.0;
            dArray4[4] = 1.0;
            dArray4[5] = 0.0;
            dArray4[6] = 0.0;
            dArray4[7] = 0.0;
            dArray4[8] = 1.0;
        } else if (dArray3[0] * dArray3[0] < 1.110223024E-16) {
            dArray6[0] = dArray3[0];
            dArray6[1] = dArray3[1];
            dArray6[2] = dArray3[2];
            dArray3[0] = dArray3[3];
            dArray3[1] = dArray3[4];
            dArray3[2] = dArray3[5];
            dArray3[3] = -dArray6[0];
            dArray3[4] = -dArray6[1];
            dArray3[5] = -dArray6[2];
            dArray4[0] = 0.0;
            dArray4[1] = 1.0;
            dArray4[2] = 0.0;
            dArray4[3] = -1.0;
            dArray4[4] = 0.0;
            dArray4[5] = 0.0;
            dArray4[6] = 0.0;
            dArray4[7] = 0.0;
            dArray4[8] = 1.0;
        } else {
            d = 1.0 / Math.sqrt(dArray3[0] * dArray3[0] + dArray3[3] * dArray3[3]);
            double d2 = dArray3[0] * d;
            double d3 = dArray3[3] * d;
            dArray6[0] = d2 * dArray3[0] + d3 * dArray3[3];
            dArray6[1] = d2 * dArray3[1] + d3 * dArray3[4];
            dArray6[2] = d2 * dArray3[2] + d3 * dArray3[5];
            dArray3[3] = -d3 * dArray3[0] + d2 * dArray3[3];
            dArray3[4] = -d3 * dArray3[1] + d2 * dArray3[4];
            dArray3[5] = -d3 * dArray3[2] + d2 * dArray3[5];
            dArray3[0] = dArray6[0];
            dArray3[1] = dArray6[1];
            dArray3[2] = dArray6[2];
            dArray4[0] = d2;
            dArray4[1] = d3;
            dArray4[2] = 0.0;
            dArray4[3] = -d3;
            dArray4[4] = d2;
            dArray4[5] = 0.0;
            dArray4[6] = 0.0;
            dArray4[7] = 0.0;
            dArray4[8] = 1.0;
        }
        if (!(dArray3[6] * dArray3[6] < 1.110223024E-16)) {
            if (dArray3[0] * dArray3[0] < 1.110223024E-16) {
                dArray6[0] = dArray3[0];
                dArray6[1] = dArray3[1];
                dArray6[2] = dArray3[2];
                dArray3[0] = dArray3[6];
                dArray3[1] = dArray3[7];
                dArray3[2] = dArray3[8];
                dArray3[6] = -dArray6[0];
                dArray3[7] = -dArray6[1];
                dArray3[8] = -dArray6[2];
                dArray6[0] = dArray4[0];
                dArray6[1] = dArray4[1];
                dArray6[2] = dArray4[2];
                dArray4[0] = dArray4[6];
                dArray4[1] = dArray4[7];
                dArray4[2] = dArray4[8];
                dArray4[6] = -dArray6[0];
                dArray4[7] = -dArray6[1];
                dArray4[8] = -dArray6[2];
            } else {
                d = 1.0 / Math.sqrt(dArray3[0] * dArray3[0] + dArray3[6] * dArray3[6]);
                double d4 = dArray3[0] * d;
                double d5 = dArray3[6] * d;
                dArray6[0] = d4 * dArray3[0] + d5 * dArray3[6];
                dArray6[1] = d4 * dArray3[1] + d5 * dArray3[7];
                dArray6[2] = d4 * dArray3[2] + d5 * dArray3[8];
                dArray3[6] = -d5 * dArray3[0] + d4 * dArray3[6];
                dArray3[7] = -d5 * dArray3[1] + d4 * dArray3[7];
                dArray3[8] = -d5 * dArray3[2] + d4 * dArray3[8];
                dArray3[0] = dArray6[0];
                dArray3[1] = dArray6[1];
                dArray3[2] = dArray6[2];
                dArray6[0] = d4 * dArray4[0];
                dArray6[1] = d4 * dArray4[1];
                dArray4[2] = d5;
                dArray6[6] = -dArray4[0] * d5;
                dArray6[7] = -dArray4[1] * d5;
                dArray4[8] = d4;
                dArray4[0] = dArray6[0];
                dArray4[1] = dArray6[1];
                dArray4[6] = dArray6[6];
                dArray4[7] = dArray6[7];
            }
        }
        if (dArray3[2] * dArray3[2] < 1.110223024E-16) {
            dArray5[0] = 1.0;
            dArray5[1] = 0.0;
            dArray5[2] = 0.0;
            dArray5[3] = 0.0;
            dArray5[4] = 1.0;
            dArray5[5] = 0.0;
            dArray5[6] = 0.0;
            dArray5[7] = 0.0;
            dArray5[8] = 1.0;
        } else if (dArray3[1] * dArray3[1] < 1.110223024E-16) {
            dArray6[2] = dArray3[2];
            dArray6[5] = dArray3[5];
            dArray6[8] = dArray3[8];
            dArray3[2] = -dArray3[1];
            dArray3[5] = -dArray3[4];
            dArray3[8] = -dArray3[7];
            dArray3[1] = dArray6[2];
            dArray3[4] = dArray6[5];
            dArray3[7] = dArray6[8];
            dArray5[0] = 1.0;
            dArray5[1] = 0.0;
            dArray5[2] = 0.0;
            dArray5[3] = 0.0;
            dArray5[4] = 0.0;
            dArray5[5] = -1.0;
            dArray5[6] = 0.0;
            dArray5[7] = 1.0;
            dArray5[8] = 0.0;
        } else {
            d = 1.0 / Math.sqrt(dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]);
            double d6 = dArray3[1] * d;
            double d7 = dArray3[2] * d;
            dArray6[1] = d6 * dArray3[1] + d7 * dArray3[2];
            dArray3[2] = -d7 * dArray3[1] + d6 * dArray3[2];
            dArray3[1] = dArray6[1];
            dArray6[4] = d6 * dArray3[4] + d7 * dArray3[5];
            dArray3[5] = -d7 * dArray3[4] + d6 * dArray3[5];
            dArray3[4] = dArray6[4];
            dArray6[7] = d6 * dArray3[7] + d7 * dArray3[8];
            dArray3[8] = -d7 * dArray3[7] + d6 * dArray3[8];
            dArray3[7] = dArray6[7];
            dArray5[0] = 1.0;
            dArray5[1] = 0.0;
            dArray5[2] = 0.0;
            dArray5[3] = 0.0;
            dArray5[4] = d6;
            dArray5[5] = -d7;
            dArray5[6] = 0.0;
            dArray5[7] = d7;
            dArray5[8] = d6;
        }
        if (!(dArray3[7] * dArray3[7] < 1.110223024E-16)) {
            if (dArray3[4] * dArray3[4] < 1.110223024E-16) {
                dArray6[3] = dArray3[3];
                dArray6[4] = dArray3[4];
                dArray6[5] = dArray3[5];
                dArray3[3] = dArray3[6];
                dArray3[4] = dArray3[7];
                dArray3[5] = dArray3[8];
                dArray3[6] = -dArray6[3];
                dArray3[7] = -dArray6[4];
                dArray3[8] = -dArray6[5];
                dArray6[3] = dArray4[3];
                dArray6[4] = dArray4[4];
                dArray6[5] = dArray4[5];
                dArray4[3] = dArray4[6];
                dArray4[4] = dArray4[7];
                dArray4[5] = dArray4[8];
                dArray4[6] = -dArray6[3];
                dArray4[7] = -dArray6[4];
                dArray4[8] = -dArray6[5];
            } else {
                d = 1.0 / Math.sqrt(dArray3[4] * dArray3[4] + dArray3[7] * dArray3[7]);
                double d8 = dArray3[4] * d;
                double d9 = dArray3[7] * d;
                dArray6[3] = d8 * dArray3[3] + d9 * dArray3[6];
                dArray3[6] = -d9 * dArray3[3] + d8 * dArray3[6];
                dArray3[3] = dArray6[3];
                dArray6[4] = d8 * dArray3[4] + d9 * dArray3[7];
                dArray3[7] = -d9 * dArray3[4] + d8 * dArray3[7];
                dArray3[4] = dArray6[4];
                dArray6[5] = d8 * dArray3[5] + d9 * dArray3[8];
                dArray3[8] = -d9 * dArray3[5] + d8 * dArray3[8];
                dArray3[5] = dArray6[5];
                dArray6[3] = d8 * dArray4[3] + d9 * dArray4[6];
                dArray4[6] = -d9 * dArray4[3] + d8 * dArray4[6];
                dArray4[3] = dArray6[3];
                dArray6[4] = d8 * dArray4[4] + d9 * dArray4[7];
                dArray4[7] = -d9 * dArray4[4] + d8 * dArray4[7];
                dArray4[4] = dArray6[4];
                dArray6[5] = d8 * dArray4[5] + d9 * dArray4[8];
                dArray4[8] = -d9 * dArray4[5] + d8 * dArray4[8];
                dArray4[5] = dArray6[5];
            }
        }
        dArray7[0] = dArray3[0];
        dArray7[1] = dArray3[4];
        dArray7[2] = dArray3[8];
        dArray9[0] = dArray3[1];
        dArray9[1] = dArray3[5];
        if (dArray9[0] * dArray9[0] > 1.110223024E-16 || dArray9[1] * dArray9[1] > 1.110223024E-16) {
            this.compute_qr(dArray7, dArray9, dArray4, dArray5);
        }
        dArray10[0] = dArray7[0];
        dArray10[1] = dArray7[1];
        dArray10[2] = dArray7[2];
        if (Transform3D.almostOne(Math.abs(dArray10[0])) && Transform3D.almostOne(Math.abs(dArray10[1])) && Transform3D.almostOne(Math.abs(dArray10[2]))) {
            int n2;
            for (n2 = 0; n2 < 3; ++n2) {
                if (!(dArray10[n2] < 0.0)) continue;
                ++n;
            }
            if (n == 0 || n == 2) {
                dArray[2] = 1.0;
                dArray[1] = 1.0;
                dArray[0] = 1.0;
                for (n2 = 0; n2 < 9; ++n2) {
                    dArray2[n2] = dArray8[n2];
                }
                return;
            }
        }
        Transform3D.transpose_mat(dArray4, dArray6);
        Transform3D.transpose_mat(dArray5, dArray7);
        this.svdReorder(dArray3, dArray6, dArray7, dArray8, dArray10, dArray2, dArray);
    }

    private void svdReorder(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7) {
        int[] nArray = new int[3];
        double[] dArray8 = new double[3];
        if (dArray5[0] < 0.0) {
            dArray5[0] = -dArray5[0];
            dArray3[0] = -dArray3[0];
            dArray3[1] = -dArray3[1];
            dArray3[2] = -dArray3[2];
        }
        if (dArray5[1] < 0.0) {
            dArray5[1] = -dArray5[1];
            dArray3[3] = -dArray3[3];
            dArray3[4] = -dArray3[4];
            dArray3[5] = -dArray3[5];
        }
        if (dArray5[2] < 0.0) {
            dArray5[2] = -dArray5[2];
            dArray3[6] = -dArray3[6];
            dArray3[7] = -dArray3[7];
            dArray3[8] = -dArray3[8];
        }
        Transform3D.mat_mul(dArray2, dArray3, dArray4);
        if (Transform3D.almostEqual(Math.abs(dArray5[0]), Math.abs(dArray5[1])) && Transform3D.almostEqual(Math.abs(dArray5[1]), Math.abs(dArray5[2]))) {
            int n;
            for (n = 0; n < 9; ++n) {
                dArray6[n] = dArray4[n];
            }
            for (n = 0; n < 3; ++n) {
                dArray7[n] = dArray5[n];
            }
        } else {
            int n;
            int n2;
            int n3;
            if (dArray5[0] > dArray5[1]) {
                if (dArray5[0] > dArray5[2]) {
                    if (dArray5[2] > dArray5[1]) {
                        nArray[0] = 0;
                        nArray[1] = 2;
                        nArray[2] = 1;
                    } else {
                        nArray[0] = 0;
                        nArray[1] = 1;
                        nArray[2] = 2;
                    }
                } else {
                    nArray[0] = 2;
                    nArray[1] = 0;
                    nArray[2] = 1;
                }
            } else if (dArray5[1] > dArray5[2]) {
                if (dArray5[2] > dArray5[0]) {
                    nArray[0] = 1;
                    nArray[1] = 2;
                    nArray[2] = 0;
                } else {
                    nArray[0] = 1;
                    nArray[1] = 0;
                    nArray[2] = 2;
                }
            } else {
                nArray[0] = 2;
                nArray[1] = 1;
                nArray[2] = 0;
            }
            dArray8[0] = dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
            dArray8[1] = dArray[3] * dArray[3] + dArray[4] * dArray[4] + dArray[5] * dArray[5];
            dArray8[2] = dArray[6] * dArray[6] + dArray[7] * dArray[7] + dArray[8] * dArray[8];
            if (dArray8[0] > dArray8[1]) {
                if (dArray8[0] > dArray8[2]) {
                    if (dArray8[2] > dArray8[1]) {
                        n3 = 0;
                        n2 = 1;
                        n = 2;
                    } else {
                        n3 = 0;
                        n = 1;
                        n2 = 2;
                    }
                } else {
                    n2 = 0;
                    n3 = 1;
                    n = 2;
                }
            } else if (dArray8[1] > dArray8[2]) {
                if (dArray8[2] > dArray8[0]) {
                    n = 0;
                    n2 = 1;
                    n3 = 2;
                } else {
                    n = 0;
                    n3 = 1;
                    n2 = 2;
                }
            } else {
                n2 = 0;
                n = 1;
                n3 = 2;
            }
            int n4 = nArray[n3];
            dArray7[0] = dArray5[n4];
            n4 = nArray[n];
            dArray7[1] = dArray5[n4];
            n4 = nArray[n2];
            dArray7[2] = dArray5[n4];
            n4 = nArray[n3];
            if (dArray6 == null) {
                System.out.println("outRot == null");
            }
            if (dArray4 == null) {
                System.out.println("rot == null");
            }
            System.out.flush();
            dArray6[0] = dArray4[n4];
            n4 = nArray[n3] + 3;
            dArray6[3] = dArray4[n4];
            n4 = nArray[n3] + 6;
            dArray6[6] = dArray4[n4];
            n4 = nArray[n];
            dArray6[1] = dArray4[n4];
            n4 = nArray[n] + 3;
            dArray6[4] = dArray4[n4];
            n4 = nArray[n] + 6;
            dArray6[7] = dArray4[n4];
            n4 = nArray[n2];
            dArray6[2] = dArray4[n4];
            n4 = nArray[n2] + 3;
            dArray6[5] = dArray4[n4];
            n4 = nArray[n2] + 6;
            dArray6[8] = dArray4[n4];
        }
    }

    private int compute_qr(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d;
        double d2;
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[2];
        double[] dArray7 = new double[2];
        double[] dArray8 = new double[2];
        double[] dArray9 = new double[9];
        double d3 = 1.0;
        double d4 = -1.0;
        boolean bl = false;
        int n = 1;
        if (Math.abs(dArray2[1]) < 4.89E-15 || Math.abs(dArray2[0]) < 4.89E-15) {
            bl = true;
        }
        for (int i = 0; i < 10 && !bl; ++i) {
            double d5 = Transform3D.compute_shift(dArray[1], dArray2[1], dArray[2]);
            double d6 = (Math.abs(dArray[0]) - d5) * (Transform3D.d_sign(d3, dArray[0]) + d5 / dArray[0]);
            double d7 = dArray2[0];
            double d8 = Transform3D.compute_rot(d6, d7, dArray8, dArray6, 0, n);
            d6 = dArray6[0] * dArray[0] + dArray8[0] * dArray2[0];
            dArray2[0] = dArray6[0] * dArray2[0] - dArray8[0] * dArray[0];
            d7 = dArray8[0] * dArray[1];
            dArray[1] = dArray6[0] * dArray[1];
            d8 = Transform3D.compute_rot(d6, d7, dArray7, dArray5, 0, n);
            n = 0;
            dArray[0] = d8;
            d6 = dArray5[0] * dArray2[0] + dArray7[0] * dArray[1];
            dArray[1] = dArray5[0] * dArray[1] - dArray7[0] * dArray2[0];
            d7 = dArray7[0] * dArray2[1];
            dArray2[1] = dArray5[0] * dArray2[1];
            dArray2[0] = d8 = Transform3D.compute_rot(d6, d7, dArray8, dArray6, 1, n);
            d6 = dArray6[1] * dArray[1] + dArray8[1] * dArray2[1];
            dArray2[1] = dArray6[1] * dArray2[1] - dArray8[1] * dArray[1];
            d7 = dArray8[1] * dArray[2];
            dArray[2] = dArray6[1] * dArray[2];
            dArray[1] = d8 = Transform3D.compute_rot(d6, d7, dArray7, dArray5, 1, n);
            d6 = dArray5[1] * dArray2[1] + dArray7[1] * dArray[2];
            dArray[2] = dArray5[1] * dArray[2] - dArray7[1] * dArray2[1];
            dArray2[1] = d6;
            d2 = dArray3[0];
            dArray3[0] = dArray5[0] * d2 + dArray7[0] * dArray3[3];
            dArray3[3] = -dArray7[0] * d2 + dArray5[0] * dArray3[3];
            d2 = dArray3[1];
            dArray3[1] = dArray5[0] * d2 + dArray7[0] * dArray3[4];
            dArray3[4] = -dArray7[0] * d2 + dArray5[0] * dArray3[4];
            d2 = dArray3[2];
            dArray3[2] = dArray5[0] * d2 + dArray7[0] * dArray3[5];
            dArray3[5] = -dArray7[0] * d2 + dArray5[0] * dArray3[5];
            d2 = dArray3[3];
            dArray3[3] = dArray5[1] * d2 + dArray7[1] * dArray3[6];
            dArray3[6] = -dArray7[1] * d2 + dArray5[1] * dArray3[6];
            d2 = dArray3[4];
            dArray3[4] = dArray5[1] * d2 + dArray7[1] * dArray3[7];
            dArray3[7] = -dArray7[1] * d2 + dArray5[1] * dArray3[7];
            d2 = dArray3[5];
            dArray3[5] = dArray5[1] * d2 + dArray7[1] * dArray3[8];
            dArray3[8] = -dArray7[1] * d2 + dArray5[1] * dArray3[8];
            d = dArray4[0];
            dArray4[0] = dArray6[0] * d + dArray8[0] * dArray4[1];
            dArray4[1] = -dArray8[0] * d + dArray6[0] * dArray4[1];
            d = dArray4[3];
            dArray4[3] = dArray6[0] * d + dArray8[0] * dArray4[4];
            dArray4[4] = -dArray8[0] * d + dArray6[0] * dArray4[4];
            d = dArray4[6];
            dArray4[6] = dArray6[0] * d + dArray8[0] * dArray4[7];
            dArray4[7] = -dArray8[0] * d + dArray6[0] * dArray4[7];
            d = dArray4[1];
            dArray4[1] = dArray6[1] * d + dArray8[1] * dArray4[2];
            dArray4[2] = -dArray8[1] * d + dArray6[1] * dArray4[2];
            d = dArray4[4];
            dArray4[4] = dArray6[1] * d + dArray8[1] * dArray4[5];
            dArray4[5] = -dArray8[1] * d + dArray6[1] * dArray4[5];
            d = dArray4[7];
            dArray4[7] = dArray6[1] * d + dArray8[1] * dArray4[8];
            dArray4[8] = -dArray8[1] * d + dArray6[1] * dArray4[8];
            dArray9[0] = dArray[0];
            dArray9[1] = dArray2[0];
            dArray9[2] = 0.0;
            dArray9[3] = 0.0;
            dArray9[4] = dArray[1];
            dArray9[5] = dArray2[1];
            dArray9[6] = 0.0;
            dArray9[7] = 0.0;
            dArray9[8] = dArray[2];
            if (!(Math.abs(dArray2[1]) < 4.89E-15) && !(Math.abs(dArray2[0]) < 4.89E-15)) continue;
            bl = true;
        }
        if (Math.abs(dArray2[1]) < 4.89E-15) {
            Transform3D.compute_2X2(dArray[0], dArray2[0], dArray[1], dArray, dArray7, dArray5, dArray8, dArray6, 0);
            d2 = dArray3[0];
            dArray3[0] = dArray5[0] * d2 + dArray7[0] * dArray3[3];
            dArray3[3] = -dArray7[0] * d2 + dArray5[0] * dArray3[3];
            d2 = dArray3[1];
            dArray3[1] = dArray5[0] * d2 + dArray7[0] * dArray3[4];
            dArray3[4] = -dArray7[0] * d2 + dArray5[0] * dArray3[4];
            d2 = dArray3[2];
            dArray3[2] = dArray5[0] * d2 + dArray7[0] * dArray3[5];
            dArray3[5] = -dArray7[0] * d2 + dArray5[0] * dArray3[5];
            d = dArray4[0];
            dArray4[0] = dArray6[0] * d + dArray8[0] * dArray4[1];
            dArray4[1] = -dArray8[0] * d + dArray6[0] * dArray4[1];
            d = dArray4[3];
            dArray4[3] = dArray6[0] * d + dArray8[0] * dArray4[4];
            dArray4[4] = -dArray8[0] * d + dArray6[0] * dArray4[4];
            d = dArray4[6];
            dArray4[6] = dArray6[0] * d + dArray8[0] * dArray4[7];
            dArray4[7] = -dArray8[0] * d + dArray6[0] * dArray4[7];
        } else {
            Transform3D.compute_2X2(dArray[1], dArray2[1], dArray[2], dArray, dArray7, dArray5, dArray8, dArray6, 1);
            d2 = dArray3[3];
            dArray3[3] = dArray5[0] * d2 + dArray7[0] * dArray3[6];
            dArray3[6] = -dArray7[0] * d2 + dArray5[0] * dArray3[6];
            d2 = dArray3[4];
            dArray3[4] = dArray5[0] * d2 + dArray7[0] * dArray3[7];
            dArray3[7] = -dArray7[0] * d2 + dArray5[0] * dArray3[7];
            d2 = dArray3[5];
            dArray3[5] = dArray5[0] * d2 + dArray7[0] * dArray3[8];
            dArray3[8] = -dArray7[0] * d2 + dArray5[0] * dArray3[8];
            d = dArray4[1];
            dArray4[1] = dArray6[0] * d + dArray8[0] * dArray4[2];
            dArray4[2] = -dArray8[0] * d + dArray6[0] * dArray4[2];
            d = dArray4[4];
            dArray4[4] = dArray6[0] * d + dArray8[0] * dArray4[5];
            dArray4[5] = -dArray8[0] * d + dArray6[0] * dArray4[5];
            d = dArray4[7];
            dArray4[7] = dArray6[0] * d + dArray8[0] * dArray4[8];
            dArray4[8] = -dArray8[0] * d + dArray6[0] * dArray4[8];
        }
        return 0;
    }

    static final double max(double d, double d2) {
        return d > d2 ? d : d2;
    }

    static final double min(double d, double d2) {
        return d < d2 ? d : d2;
    }

    static final double d_sign(double d, double d2) {
        double d3 = d >= 0.0 ? d : -d;
        return d2 >= 0.0 ? d3 : -d3;
    }

    static final double compute_shift(double d, double d2, double d3) {
        double d4;
        double d5 = Math.abs(d);
        double d6 = Math.abs(d2);
        double d7 = Math.abs(d3);
        double d8 = Transform3D.min(d5, d7);
        double d9 = Transform3D.max(d5, d7);
        if (d8 == 0.0) {
            d4 = 0.0;
            if (d9 != 0.0) {
                double d10 = Transform3D.min(d9, d6) / Transform3D.max(d9, d6);
            }
        } else if (d6 < d9) {
            double d11 = d8 / d9 + 1.0;
            double d12 = (d9 - d8) / d9;
            double d13 = d6 / d9;
            double d14 = d13 * d13;
            double d15 = 2.0 / (Math.sqrt(d11 * d11 + d14) + Math.sqrt(d12 * d12 + d14));
            d4 = d8 * d15;
        } else {
            double d16 = d9 / d6;
            if (d16 == 0.0) {
                d4 = d8 * d9 / d6;
            } else {
                double d17 = d8 / d9 + 1.0;
                double d18 = (d9 - d8) / d9;
                double d19 = d17 * d16;
                double d20 = d18 * d16;
                double d21 = 1.0 / (Math.sqrt(d19 * d19 + 1.0) + Math.sqrt(d20 * d20 + 1.0));
                d4 = d8 * d21 * d16;
                d4 += d4;
            }
        }
        return d4;
    }

    static int compute_2X2(double d, double d2, double d3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n) {
        double d4;
        double d5;
        double d6 = 2.0;
        double d7 = 1.0;
        double d8 = dArray[0];
        double d9 = dArray[1];
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = d;
        double d16 = Math.abs(d15);
        double d17 = d3;
        double d18 = Math.abs(d3);
        int n2 = 1;
        boolean bl = d18 > d16;
        if (bl) {
            n2 = 3;
            double d19 = d15;
            d15 = d17;
            d17 = d19;
            d19 = d16;
            d16 = d18;
            d18 = d19;
        }
        if ((d5 = Math.abs(d4 = d2)) == 0.0) {
            dArray[1] = d18;
            dArray[0] = d16;
            d10 = 1.0;
            d11 = 1.0;
            d12 = 0.0;
            d13 = 0.0;
        } else {
            boolean bl2 = true;
            if (d5 > d16) {
                n2 = 2;
                if (d16 / d5 < 1.110223024E-16) {
                    bl2 = false;
                    d8 = d5;
                    d9 = d18 > 1.0 ? d16 / (d5 / d18) : d16 / d5 * d18;
                    d10 = 1.0;
                    d12 = d17 / d4;
                    d13 = 1.0;
                    d11 = d15 / d4;
                }
            }
            if (bl2) {
                double d20 = d16 - d18;
                double d21 = d20 == d16 ? 1.0 : d20 / d16;
                double d22 = d4 / d15;
                double d23 = 2.0 - d21;
                double d24 = d22 * d22;
                double d25 = d23 * d23;
                double d26 = Math.sqrt(d25 + d24);
                double d27 = d21 == 0.0 ? Math.abs(d22) : Math.sqrt(d21 * d21 + d24);
                double d28 = (d26 + d27) * 0.5;
                if (d5 > d16) {
                    n2 = 2;
                    if (d16 / d5 < 1.110223024E-16) {
                        bl2 = false;
                        d8 = d5;
                        d9 = d18 > 1.0 ? d16 / (d5 / d18) : d16 / d5 * d18;
                        d10 = 1.0;
                        d12 = d17 / d4;
                        d13 = 1.0;
                        d11 = d15 / d4;
                    }
                }
                if (bl2) {
                    d20 = d16 - d18;
                    d21 = d20 == d16 ? 1.0 : d20 / d16;
                    d22 = d4 / d15;
                    d23 = 2.0 - d21;
                    d24 = d22 * d22;
                    d25 = d23 * d23;
                    d26 = Math.sqrt(d25 + d24);
                    d27 = d21 == 0.0 ? Math.abs(d22) : Math.sqrt(d21 * d21 + d24);
                    d28 = (d26 + d27) * 0.5;
                    d9 = d18 / d28;
                    d8 = d16 * d28;
                    d23 = d24 == 0.0 ? (d21 == 0.0 ? Transform3D.d_sign(d6, d15) * Transform3D.d_sign(d7, d4) : d4 / Transform3D.d_sign(d20, d15) + d22 / d23) : (d22 / (d26 + d23) + d22 / (d27 + d21)) * (d28 + 1.0);
                    d21 = Math.sqrt(d23 * d23 + 4.0);
                    d11 = 2.0 / d21;
                    d13 = d23 / d21;
                    d10 = (d11 + d13 * d22) / d28;
                    d12 = d17 / d15 * d13 / d28;
                }
            }
            if (bl) {
                dArray3[0] = d13;
                dArray2[0] = d11;
                dArray5[0] = d12;
                dArray4[0] = d10;
            } else {
                dArray3[0] = d10;
                dArray2[0] = d12;
                dArray5[0] = d11;
                dArray4[0] = d13;
            }
            if (n2 == 1) {
                d14 = Transform3D.d_sign(d7, dArray5[0]) * Transform3D.d_sign(d7, dArray3[0]) * Transform3D.d_sign(d7, d);
            }
            if (n2 == 2) {
                d14 = Transform3D.d_sign(d7, dArray4[0]) * Transform3D.d_sign(d7, dArray3[0]) * Transform3D.d_sign(d7, d2);
            }
            if (n2 == 3) {
                d14 = Transform3D.d_sign(d7, dArray4[0]) * Transform3D.d_sign(d7, dArray2[0]) * Transform3D.d_sign(d7, d3);
            }
            dArray[n] = Transform3D.d_sign(d8, d14);
            double d29 = d14 * Transform3D.d_sign(d7, d) * Transform3D.d_sign(d7, d3);
            dArray[n + 1] = Transform3D.d_sign(d9, d29);
        }
        return 0;
    }

    static double compute_rot(double d, double d2, double[] dArray, double[] dArray2, int n, int n2) {
        double d3;
        double d4;
        double d5;
        if (d2 == 0.0) {
            d5 = 1.0;
            d4 = 0.0;
            d3 = d;
        } else if (d == 0.0) {
            d5 = 0.0;
            d4 = 1.0;
            d3 = d2;
        } else {
            double d6 = d;
            double d7 = d2;
            double d8 = Transform3D.max(Math.abs(d6), Math.abs(d7));
            if (d8 >= 4.994797680505588E145) {
                int n3 = 0;
                while (d8 >= 4.994797680505588E145) {
                    ++n3;
                    d8 = Transform3D.max(Math.abs(d6 *= 2.002083095183101E-146), Math.abs(d7 *= 2.002083095183101E-146));
                }
                d3 = Math.sqrt(d6 * d6 + d7 * d7);
                d5 = d6 / d3;
                d4 = d7 / d3;
                int n4 = n3;
                for (int i = 1; i <= n3; ++i) {
                    d3 *= 4.994797680505588E145;
                }
            } else if (d8 <= 2.002083095183101E-146) {
                int n5 = 0;
                while (d8 <= 2.002083095183101E-146) {
                    ++n5;
                    d8 = Transform3D.max(Math.abs(d6 *= 4.994797680505588E145), Math.abs(d7 *= 4.994797680505588E145));
                }
                d3 = Math.sqrt(d6 * d6 + d7 * d7);
                d5 = d6 / d3;
                d4 = d7 / d3;
                int n6 = n5;
                for (int i = 1; i <= n5; ++i) {
                    d3 *= 2.002083095183101E-146;
                }
            } else {
                d3 = Math.sqrt(d6 * d6 + d7 * d7);
                d5 = d6 / d3;
                d4 = d7 / d3;
            }
            if (Math.abs(d) > Math.abs(d2) && d5 < 0.0) {
                d5 = -d5;
                d4 = -d4;
                d3 = -d3;
            }
        }
        dArray[n] = d4;
        dArray2[n] = d5;
        return d3;
    }

    private static final double max3(double[] dArray) {
        if (dArray[0] > dArray[1]) {
            if (dArray[0] > dArray[2]) {
                return dArray[0];
            }
            return dArray[2];
        }
        if (dArray[1] > dArray[2]) {
            return dArray[1];
        }
        return dArray[2];
    }

    private final void computeScales(boolean bl) {
        if (this.scales == null) {
            this.scales = new double[3];
        }
        if ((!bl || (this.dirtyBits & 0x80) == 0) && this.isAffine()) {
            if (this.isCongruent()) {
                if ((this.dirtyBits & 8) == 0 && (this.type & 0x20) != 0) {
                    this.scales[2] = 1.0;
                    this.scales[1] = 1.0;
                    this.scales[0] = 1.0;
                    this.dirtyBits &= 0xFFFFFFDF;
                    return;
                }
                this.scales[1] = this.scales[2] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[0] = this.scales[2];
                this.dirtyBits &= 0xFFFFFFDF;
                return;
            }
            if (this.isOrtho()) {
                this.scales[0] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[1] = Math.sqrt(this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]);
                this.scales[2] = Math.sqrt(this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10]);
                this.dirtyBits &= 0xFFFFFFDF;
                return;
            }
        }
        if (this.rot == null) {
            this.rot = new double[9];
        }
        this.compute_svd(this, this.scales, this.rot);
        this.dirtyBits &= 0xFFFFFF1F;
    }

    private final void computeScaleRotation(boolean bl) {
        if (this.rot == null) {
            this.rot = new double[9];
        }
        if (this.scales == null) {
            this.scales = new double[3];
        }
        if ((!bl || (this.dirtyBits & 0x80) == 0) && this.isAffine()) {
            if (this.isCongruent()) {
                if ((this.dirtyBits & 8) == 0 && (this.type & 0x20) != 0) {
                    this.rot[0] = this.mat[0];
                    this.rot[1] = this.mat[1];
                    this.rot[2] = this.mat[2];
                    this.rot[3] = this.mat[4];
                    this.rot[4] = this.mat[5];
                    this.rot[5] = this.mat[6];
                    this.rot[6] = this.mat[8];
                    this.rot[7] = this.mat[9];
                    this.rot[8] = this.mat[10];
                    this.scales[2] = 1.0;
                    this.scales[1] = 1.0;
                    this.scales[0] = 1.0;
                    this.dirtyBits &= 0xFFFFFFFF;
                    return;
                }
                double d = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                if (d == 0.0) {
                    this.compute_svd(this, this.scales, this.rot);
                    return;
                }
                this.scales[1] = this.scales[2] = d;
                this.scales[0] = this.scales[2];
                d = 1.0 / d;
                this.rot[0] = this.mat[0] * d;
                this.rot[1] = this.mat[1] * d;
                this.rot[2] = this.mat[2] * d;
                this.rot[3] = this.mat[4] * d;
                this.rot[4] = this.mat[5] * d;
                this.rot[5] = this.mat[6] * d;
                this.rot[6] = this.mat[8] * d;
                this.rot[7] = this.mat[9] * d;
                this.rot[8] = this.mat[10] * d;
                this.dirtyBits &= 0xFFFFFFFF;
                return;
            }
            if (this.isOrtho()) {
                this.scales[0] = Math.sqrt(this.mat[0] * this.mat[0] + this.mat[4] * this.mat[4] + this.mat[8] * this.mat[8]);
                this.scales[1] = Math.sqrt(this.mat[1] * this.mat[1] + this.mat[5] * this.mat[5] + this.mat[9] * this.mat[9]);
                this.scales[2] = Math.sqrt(this.mat[2] * this.mat[2] + this.mat[6] * this.mat[6] + this.mat[10] * this.mat[10]);
                if (this.scales[0] == 0.0 || this.scales[1] == 0.0 || this.scales[2] == 0.0) {
                    this.compute_svd(this, this.scales, this.rot);
                    return;
                }
                double d = 1.0 / this.scales[0];
                this.rot[0] = this.mat[0] * d;
                this.rot[3] = this.mat[4] * d;
                this.rot[6] = this.mat[8] * d;
                d = 1.0 / this.scales[1];
                this.rot[1] = this.mat[1] * d;
                this.rot[4] = this.mat[5] * d;
                this.rot[7] = this.mat[9] * d;
                d = 1.0 / this.scales[2];
                this.rot[2] = this.mat[2] * d;
                this.rot[5] = this.mat[6] * d;
                this.rot[8] = this.mat[10] * d;
                this.dirtyBits &= 0xFFFFFFFF;
                return;
            }
        }
        this.compute_svd(this, this.scales, this.rot);
        this.dirtyBits &= 0xFFFFFF1F;
    }

    final void getRotation(Transform3D transform3D) {
        if ((this.dirtyBits & 0x40) != 0) {
            this.computeScaleRotation(false);
        }
        transform3D.mat[14] = 0.0;
        transform3D.mat[13] = 0.0;
        transform3D.mat[12] = 0.0;
        transform3D.mat[11] = 0.0;
        transform3D.mat[7] = 0.0;
        transform3D.mat[3] = 0.0;
        transform3D.mat[15] = 1.0;
        transform3D.mat[0] = this.rot[0];
        transform3D.mat[1] = this.rot[1];
        transform3D.mat[2] = this.rot[2];
        transform3D.mat[4] = this.rot[3];
        transform3D.mat[5] = this.rot[4];
        transform3D.mat[6] = this.rot[5];
        transform3D.mat[8] = this.rot[6];
        transform3D.mat[9] = this.rot[7];
        transform3D.mat[10] = this.rot[8];
        transform3D.type = 0x400000F0;
        transform3D.dirtyBits = (this.dirtyBits & 0x80) != 0 ? 240 : 112;
    }

    final void setOrthoDirtyBit() {
        this.dirtyBits = 240;
        this.type = 0;
    }
}

