/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.picking;

import com.sun.j3d.internal.UtilFreelistManager;
import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.Locale;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class PickTool {
    private final boolean debug = true;
    protected boolean userDefineShape = false;
    PickShape pickShape;
    BranchGroup pickRootBG = null;
    Locale pickRootL = null;
    Point3d start = null;
    int mode = 512;
    public static final int BOUNDS = 512;
    public static final int GEOMETRY = 256;
    public static final int GEOMETRY_INTERSECT_INFO = 1024;
    public static final int INTERSECT_TEST = 4097;
    public static final int INTERSECT_COORD = 4098;
    public static final int INTERSECT_FULL = 4100;

    public PickTool(BranchGroup branchGroup) {
        this.pickRootBG = branchGroup;
    }

    public BranchGroup getBranchGroup() {
        return this.pickRootBG;
    }

    public PickTool(Locale locale) {
        this.pickRootL = locale;
    }

    public Locale setBranchGroup(Locale locale) {
        return this.pickRootL;
    }

    public static void setCapabilities(Node node, int n) {
        if (node instanceof Morph) {
            Morph morph = (Morph)node;
            switch (n) {
                case 4098: 
                case 4100: {
                    morph.setCapability(12);
                }
                case 4097: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Improper level");
                }
            }
            double[] dArray = morph.getWeights();
            for (int i = 0; i < dArray.length; ++i) {
                GeometryArray geometryArray = morph.getGeometryArray(i);
                PickTool.setCapabilities(geometryArray, n);
            }
        } else if (node instanceof Shape3D) {
            Shape3D shape3D = (Shape3D)node;
            switch (n) {
                case 4098: 
                case 4100: {
                    shape3D.setCapability(12);
                }
                case 4097: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Improper level");
                }
            }
            for (int i = 0; i < shape3D.numGeometries(); ++i) {
                Geometry geometry = shape3D.getGeometry(i);
                if (geometry instanceof GeometryArray) {
                    PickTool.setCapabilities((GeometryArray)geometry, n);
                    continue;
                }
                if (!(geometry instanceof CompressedGeometry)) continue;
                PickTool.setCapabilities((CompressedGeometry)geometry, n);
            }
        } else {
            throw new IllegalArgumentException("Improper node type");
        }
    }

    private static void setCapabilities(GeometryArray geometryArray, int n) {
        switch (n) {
            case 4100: {
                geometryArray.setCapability(2);
                geometryArray.setCapability(4);
                geometryArray.setCapability(6);
            }
            case 4098: {
                geometryArray.setCapability(8);
                geometryArray.setCapability(17);
                geometryArray.setCapability(0);
            }
            case 4097: {
                geometryArray.setCapability(18);
            }
        }
        if (geometryArray instanceof IndexedGeometryArray) {
            PickTool.setCapabilities((IndexedGeometryArray)geometryArray, n);
        }
    }

    private static void setCapabilities(IndexedGeometryArray indexedGeometryArray, int n) {
        switch (n) {
            case 4100: {
                indexedGeometryArray.setCapability(11);
                indexedGeometryArray.setCapability(13);
                indexedGeometryArray.setCapability(15);
            }
            case 4098: {
                indexedGeometryArray.setCapability(9);
            }
        }
    }

    private static void setCapabilities(CompressedGeometry compressedGeometry, int n) {
        switch (n) {
            case 4098: 
            case 4100: {
                compressedGeometry.setCapability(2);
            }
            case 4097: {
                compressedGeometry.setCapability(18);
            }
        }
    }

    public void setShape(PickShape pickShape, Point3d point3d) {
        this.pickShape = pickShape;
        this.start = point3d;
        this.userDefineShape = pickShape != null;
    }

    public void setShapeBounds(Bounds bounds, Point3d point3d) {
        this.pickShape = new PickBounds(bounds);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setMode(int n) {
        if (n != 512 && n != 256 && n != 1024) {
            throw new IllegalArgumentException();
        }
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public void setShapeRay(Point3d point3d, Vector3d vector3d) {
        this.pickShape = new PickRay(point3d, vector3d);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeSegment(Point3d point3d, Point3d point3d2) {
        this.pickShape = new PickSegment(point3d, point3d2);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeCylinderSegment(Point3d point3d, Point3d point3d2, double d) {
        this.pickShape = new PickCylinderSegment(point3d, point3d2, d);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeCylinderRay(Point3d point3d, Vector3d vector3d, double d) {
        this.pickShape = new PickCylinderRay(point3d, vector3d, d);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeConeSegment(Point3d point3d, Point3d point3d2, double d) {
        this.pickShape = new PickConeSegment(point3d, point3d2, d);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public void setShapeConeRay(Point3d point3d, Vector3d vector3d, double d) {
        this.pickShape = new PickConeRay(point3d, vector3d, d);
        this.start = point3d;
        this.userDefineShape = true;
    }

    public PickShape getPickShape() {
        return this.pickShape;
    }

    public Point3d getStartPosition() {
        return this.start;
    }

    public PickResult[] pickAll() {
        PickResult[] pickResultArray = null;
        switch (this.mode) {
            case 512: {
                pickResultArray = this.pickAll(this.pickShape);
                break;
            }
            case 256: {
                pickResultArray = this.pickGeomAll(this.pickShape);
                break;
            }
            case 1024: {
                pickResultArray = this.pickGeomAllIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return pickResultArray;
    }

    public PickResult pickAny() {
        PickResult pickResult = null;
        switch (this.mode) {
            case 512: {
                pickResult = this.pickAny(this.pickShape);
                break;
            }
            case 256: {
                pickResult = this.pickGeomAny(this.pickShape);
                break;
            }
            case 1024: {
                pickResult = this.pickGeomAnyIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return pickResult;
    }

    public PickResult[] pickAllSorted() {
        PickResult[] pickResultArray = null;
        switch (this.mode) {
            case 512: {
                pickResultArray = this.pickAllSorted(this.pickShape);
                break;
            }
            case 256: {
                pickResultArray = this.pickGeomAllSorted(this.pickShape);
                break;
            }
            case 1024: {
                pickResultArray = this.pickGeomAllSortedIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return pickResultArray;
    }

    public PickResult pickClosest() {
        PickResult pickResult = null;
        switch (this.mode) {
            case 512: {
                pickResult = this.pickClosest(this.pickShape);
                break;
            }
            case 256: {
                pickResult = this.pickGeomClosest(this.pickShape);
                break;
            }
            case 1024: {
                pickResult = this.pickGeomClosestIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return pickResult;
    }

    private PickResult[] pickAll(PickShape pickShape) {
        PickResult[] pickResultArray = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            pickResultArray[i] = new PickResult(sceneGraphPathArray[i], pickShape);
        }
        return pickResultArray;
    }

    private PickResult[] pickAllSorted(PickShape pickShape) {
        PickResult[] pickResultArray = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAllSorted(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAllSorted(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            pickResultArray[i] = new PickResult(sceneGraphPathArray[i], pickShape);
        }
        return pickResultArray;
    }

    private PickResult pickAny(PickShape pickShape) {
        PickResult pickResult = null;
        SceneGraphPath sceneGraphPath = null;
        if (this.pickRootBG != null) {
            sceneGraphPath = this.pickRootBG.pickAny(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPath = this.pickRootL.pickAny(pickShape);
        }
        if (sceneGraphPath == null) {
            return null;
        }
        pickResult = new PickResult(sceneGraphPath, pickShape);
        return pickResult;
    }

    private PickResult pickClosest(PickShape pickShape) {
        PickResult pickResult = null;
        SceneGraphPath sceneGraphPath = null;
        if (this.pickRootBG != null) {
            sceneGraphPath = this.pickRootBG.pickClosest(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPath = this.pickRootL.pickClosest(pickShape);
        }
        if (sceneGraphPath == null) {
            return null;
        }
        pickResult = new PickResult(sceneGraphPath, pickShape);
        return pickResult;
    }

    private PickResult[] pickGeomAll(PickShape pickShape) {
        int n;
        SceneGraphPath[] sceneGraphPathArray = null;
        Node[] nodeArray = null;
        int n2 = 0;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        nodeArray = new Node[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (n = 0; n < sceneGraphPathArray.length; ++n) {
            nodeArray[n] = sceneGraphPathArray[n].getObject();
            pickResultArray[n] = new PickResult(sceneGraphPathArray[n], pickShape);
            if (nodeArray[n] instanceof Shape3D) {
                blArray[n] = ((Shape3D)nodeArray[n]).intersect(sceneGraphPathArray[n], pickShape);
            } else if (nodeArray[n] instanceof Morph) {
                blArray[n] = ((Morph)nodeArray[n]).intersect(sceneGraphPathArray[n], pickShape);
            }
            if (!blArray[n]) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n2];
        n2 = 0;
        for (n = 0; n < sceneGraphPathArray.length; ++n) {
            if (!blArray[n]) continue;
            pickResultArray[n2++] = pickResultArray[n];
        }
        return pickResultArray;
    }

    private PickResult[] pickGeomAllSorted(PickShape pickShape) {
        int n;
        SceneGraphPath[] sceneGraphPathArray = null;
        Node[] nodeArray = null;
        int n2 = 0;
        double[] dArray = new double[1];
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        double[] dArray2 = new double[sceneGraphPathArray.length];
        nodeArray = new Node[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (n = 0; n < sceneGraphPathArray.length; ++n) {
            nodeArray[n] = sceneGraphPathArray[n].getObject();
            pickResultArray[n] = new PickResult(sceneGraphPathArray[n], pickShape);
            if (nodeArray[n] instanceof Shape3D) {
                blArray[n] = ((Shape3D)nodeArray[n]).intersect(sceneGraphPathArray[n], pickShape, dArray);
                dArray2[n] = dArray[0];
            } else if (nodeArray[n] instanceof Morph) {
                blArray[n] = ((Morph)nodeArray[n]).intersect(sceneGraphPathArray[n], pickShape, dArray);
                dArray2[n] = dArray[0];
            }
            if (!blArray[n]) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n2];
        double[] dArray3 = new double[n2];
        n2 = 0;
        for (n = 0; n < sceneGraphPathArray.length; ++n) {
            if (!blArray[n]) continue;
            dArray3[n2] = dArray2[n];
            pickResultArray2[n2++] = pickResultArray[n];
        }
        if (n2 > 1) {
            return this.sortPickResults(pickResultArray2, dArray3);
        }
        return pickResultArray2;
    }

    private PickResult pickGeomAny(PickShape pickShape) {
        Node node = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            node = sceneGraphPathArray[i].getObject();
            PickResult pickResult = new PickResult(sceneGraphPathArray[i], pickShape);
            if (!(node instanceof Shape3D ? ((Shape3D)node).intersect(sceneGraphPathArray[i], pickShape) : node instanceof Morph && ((Morph)node).intersect(sceneGraphPathArray[i], pickShape))) continue;
            return pickResult;
        }
        return null;
    }

    private PickResult pickGeomClosest(PickShape pickShape) {
        PickResult[] pickResultArray = this.pickGeomAllSorted(pickShape);
        if (pickResultArray == null) {
            return null;
        }
        return pickResultArray[0];
    }

    private PickResult[] pickGeomAllIntersect(PickShape pickShape) {
        int n;
        SceneGraphPath[] sceneGraphPathArray = null;
        Object var3_3 = null;
        int n2 = 0;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (n = 0; n < sceneGraphPathArray.length; ++n) {
            pickResultArray[n] = new PickResult(sceneGraphPathArray[n], pickShape);
            if (pickResultArray[n].numIntersections() <= 0) continue;
            blArray[n] = true;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n2];
        n2 = 0;
        for (n = 0; n < sceneGraphPathArray.length; ++n) {
            if (!blArray[n]) continue;
            pickResultArray[n2++] = pickResultArray[n];
        }
        return pickResultArray;
    }

    private PickResult[] pickGeomAllSortedIntersect(PickShape pickShape) {
        int n;
        SceneGraphPath[] sceneGraphPathArray = null;
        Object var3_3 = null;
        int n2 = 0;
        double[] dArray = new double[1];
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        double[] dArray2 = new double[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        for (n = 0; n < sceneGraphPathArray.length; ++n) {
            pickResultArray[n] = this.getPickResult(sceneGraphPathArray[n], pickShape);
            int n3 = pickResultArray[n].numIntersections();
            if (n3 <= 0) continue;
            blArray[n] = true;
            boolean bl = false;
            double d = pickResultArray[n].getIntersection(0).getDistance();
            int n4 = 0;
            for (int i = 1; i < n3; ++i) {
                double d2 = pickResultArray[n].getIntersection(i).getDistance();
                if (!(d > d2)) continue;
                d = d2;
                n4 = i;
                bl = true;
            }
            if (bl) {
                PickIntersection pickIntersection = pickResultArray[n].getIntersection(0);
                PickIntersection pickIntersection2 = pickResultArray[n].getIntersection(n4);
                pickResultArray[n].intersections.set(0, pickIntersection2);
                pickResultArray[n].intersections.set(n4, pickIntersection);
            }
            dArray2[n] = pickResultArray[n].getIntersection(0).getDistance();
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n2];
        double[] dArray3 = new double[n2];
        n2 = 0;
        for (n = 0; n < sceneGraphPathArray.length; ++n) {
            if (!blArray[n]) continue;
            dArray3[n2] = dArray2[n];
            pickResultArray2[n2++] = pickResultArray[n];
        }
        if (n2 > 1) {
            return this.sortPickResults(pickResultArray2, dArray3);
        }
        return pickResultArray2;
    }

    private PickResult pickGeomClosestIntersect(PickShape pickShape) {
        PickResult[] pickResultArray = this.pickGeomAllSortedIntersect(pickShape);
        if (pickResultArray == null) {
            return null;
        }
        for (int i = 1; i < pickResultArray.length; ++i) {
            this.freePickResult(pickResultArray[i]);
        }
        return pickResultArray[0];
    }

    private PickResult pickGeomAnyIntersect(PickShape pickShape) {
        Object var2_2 = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            PickResult pickResult = new PickResult(sceneGraphPathArray[i], pickShape);
            pickResult.setFirstIntersectOnly(true);
            if (pickResult.numIntersections() <= 0) continue;
            return pickResult;
        }
        return null;
    }

    private PickResult[] sortPickResults(PickResult[] pickResultArray, double[] dArray) {
        int n;
        int[] nArray = new int[pickResultArray.length];
        PickResult[] pickResultArray2 = new PickResult[pickResultArray.length];
        for (n = 0; n < pickResultArray.length; ++n) {
            nArray[n] = n;
        }
        this.quicksort(0, dArray.length - 1, dArray, nArray);
        for (n = 0; n < pickResultArray.length; ++n) {
            pickResultArray2[n] = pickResultArray[nArray[n]];
        }
        return pickResultArray2;
    }

    private final void quicksort(int n, int n2, double[] dArray, int[] nArray) {
        int n3 = n;
        int n4 = n2;
        double d = dArray[(n + n2) / 2];
        while (true) {
            if (dArray[n3] < d) {
                ++n3;
                continue;
            }
            while (d < dArray[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                double d2 = dArray[n3];
                dArray[n3] = dArray[n4];
                dArray[n4] = d2;
                int n5 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n5;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.quicksort(n, n4, dArray, nArray);
        }
        if (n < n2) {
            this.quicksort(n3, n2, dArray, nArray);
        }
    }

    PickResult getPickResult(SceneGraphPath sceneGraphPath, PickShape pickShape) {
        PickResult pickResult = (PickResult)UtilFreelistManager.pickResultFreelist.getObject();
        if (pickResult == null) {
            pickResult = new PickResult();
        }
        pickResult.reset(sceneGraphPath, pickShape);
        return pickResult;
    }

    void freePickResult(PickResult pickResult) {
        UtilFreelistManager.pickResultFreelist.add(pickResult);
    }
}

