/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class TriangleArrayRetained
extends GeometryArrayRetained {
    TriangleArrayRetained() {
        this.geoType = 2;
    }

    boolean intersect(PickShape pickShape, double[] dArray, Point3d point3d) {
        Point3d[] point3dArray = new Point3d[3];
        double[] dArray2 = new double[1];
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        point3dArray[0] = new Point3d();
        point3dArray[1] = new Point3d();
        point3dArray[2] = new Point3d();
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray[0]);
                    this.getVertexData(n++, point3dArray[1]);
                    this.getVertexData(n++, point3dArray[2]);
                    if (!this.intersectRay(point3dArray, pickRay, dArray2, point3d)) continue;
                    if (dArray == null) {
                        return true;
                    }
                    if (!(dArray2[0] < d)) continue;
                    d = dArray2[0];
                    d2 = point3d.x;
                    d3 = point3d.y;
                    d4 = point3d.z;
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray[0]);
                    this.getVertexData(n++, point3dArray[1]);
                    this.getVertexData(n++, point3dArray[2]);
                    if (!this.intersectSegment(point3dArray, pickSegment.start, pickSegment.end, dArray2, point3d) || !(dArray2[0] <= 1.0)) continue;
                    if (dArray == null) {
                        return true;
                    }
                    if (!(dArray2[0] < d)) continue;
                    d = dArray2[0];
                    d2 = point3d.x;
                    d3 = point3d.y;
                    d4 = point3d.z;
                }
                break;
            }
            case 6: {
                BoundingBox boundingBox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray[0]);
                    this.getVertexData(n++, point3dArray[1]);
                    this.getVertexData(n++, point3dArray[2]);
                    if (!this.intersectBoundingBox(point3dArray, boundingBox, dArray2, point3d)) continue;
                    if (dArray == null) {
                        return true;
                    }
                    if (!(dArray2[0] < d)) continue;
                    d = dArray2[0];
                    d2 = point3d.x;
                    d3 = point3d.y;
                    d4 = point3d.z;
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray[0]);
                    this.getVertexData(n++, point3dArray[1]);
                    this.getVertexData(n++, point3dArray[2]);
                    if (!this.intersectBoundingSphere(point3dArray, boundingSphere, dArray2, point3d)) continue;
                    if (dArray == null) {
                        return true;
                    }
                    if (!(dArray2[0] < d)) continue;
                    d = dArray2[0];
                    d2 = point3d.x;
                    d3 = point3d.y;
                    d4 = point3d.z;
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray[0]);
                    this.getVertexData(n++, point3dArray[1]);
                    this.getVertexData(n++, point3dArray[2]);
                    if (!this.intersectBoundingPolytope(point3dArray, boundingPolytope, dArray2, point3d)) continue;
                    if (dArray == null) {
                        return true;
                    }
                    if (!(dArray2[0] < d)) continue;
                    d = dArray2[0];
                    d2 = point3d.x;
                    d3 = point3d.y;
                    d4 = point3d.z;
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray[0]);
                    this.getVertexData(n++, point3dArray[1]);
                    this.getVertexData(n++, point3dArray[2]);
                    if (!this.intersectCylinder(point3dArray, pickCylinder, dArray2, point3d)) continue;
                    if (dArray == null) {
                        return true;
                    }
                    if (!(dArray2[0] < d)) continue;
                    d = dArray2[0];
                    d2 = point3d.x;
                    d3 = point3d.y;
                    d4 = point3d.z;
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray[0]);
                    this.getVertexData(n++, point3dArray[1]);
                    this.getVertexData(n++, point3dArray[2]);
                    if (!this.intersectCone(point3dArray, pickCone, dArray2, point3d)) continue;
                    if (dArray == null) {
                        return true;
                    }
                    if (!(dArray2[0] < d)) continue;
                    d = dArray2[0];
                    d2 = point3d.x;
                    d3 = point3d.y;
                    d4 = point3d.z;
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("TriangleArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (d < Double.MAX_VALUE) {
            dArray[0] = d;
            point3d.x = d2;
            point3d.y = d3;
            point3d.z = d4;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d[] point3dArray) {
        Point3d[] point3dArray2 = new Point3d[3];
        double[] dArray = new double[1];
        int n = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        point3dArray2[0] = new Point3d();
        point3dArray2[1] = new Point3d();
        point3dArray2[2] = new Point3d();
        switch (point3dArray.length) {
            case 3: {
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray2[0]);
                    this.getVertexData(n++, point3dArray2[1]);
                    this.getVertexData(n++, point3dArray2[2]);
                    if (!this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2])) continue;
                    return true;
                }
                break;
            }
            case 4: {
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray2[0]);
                    this.getVertexData(n++, point3dArray2[1]);
                    this.getVertexData(n++, point3dArray2[2]);
                    if (!this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2]) && !this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[2], point3dArray[3])) continue;
                    return true;
                }
                break;
            }
            case 2: {
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray2[0]);
                    this.getVertexData(n++, point3dArray2[1]);
                    this.getVertexData(n++, point3dArray2[2]);
                    if (!this.intersectSegment(point3dArray2, point3dArray[0], point3dArray[1], dArray, null)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray2[0]);
                    this.getVertexData(n++, point3dArray2[1]);
                    this.getVertexData(n++, point3dArray2[2]);
                    if (!this.intersectTriPnt(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0])) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, GeometryRetained geometryRetained) {
        Point3d[] point3dArray = new Point3d[3];
        int n = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        point3dArray[0] = new Point3d();
        point3dArray[1] = new Point3d();
        point3dArray[2] = new Point3d();
        while (n < this.validVertexCount) {
            this.getVertexData(n++, point3dArray[0]);
            this.getVertexData(n++, point3dArray[1]);
            this.getVertexData(n++, point3dArray[2]);
            transform3D.transform(point3dArray[0]);
            transform3D.transform(point3dArray[1]);
            transform3D.transform(point3dArray[2]);
            if (!geometryRetained.intersect(point3dArray)) continue;
            return true;
        }
        return false;
    }

    boolean intersect(Bounds bounds) {
        Point3d[] point3dArray = new Point3d[3];
        int n = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        point3dArray[0] = new Point3d();
        point3dArray[1] = new Point3d();
        point3dArray[2] = new Point3d();
        switch (bounds.getPickType()) {
            case 6: {
                BoundingBox boundingBox = (BoundingBox)bounds;
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray[0]);
                    this.getVertexData(n++, point3dArray[1]);
                    this.getVertexData(n++, point3dArray[2]);
                    if (!this.intersectBoundingBox(point3dArray, boundingBox, null, null)) continue;
                    return true;
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)bounds;
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray[0]);
                    this.getVertexData(n++, point3dArray[1]);
                    this.getVertexData(n++, point3dArray[1]);
                    if (!this.intersectBoundingSphere(point3dArray, boundingSphere, null, null)) continue;
                    return true;
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
                while (n < this.validVertexCount) {
                    this.getVertexData(n++, point3dArray[0]);
                    this.getVertexData(n++, point3dArray[1]);
                    this.getVertexData(n++, point3dArray[2]);
                    if (!this.intersectBoundingPolytope(point3dArray, boundingPolytope, null, null)) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + bounds);
            }
        }
        return false;
    }

    void computeCentroid() {
        double d;
        int n = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        Point3d point3d = this.getPoint3d();
        Point3d point3d2 = this.getPoint3d();
        Point3d point3d3 = this.getPoint3d();
        Vector3d vector3d = this.getVector3d();
        Vector3d vector3d2 = this.getVector3d();
        Vector3d vector3d3 = this.getVector3d();
        double d2 = 0.0;
        this.centroid.x = 0.0;
        this.centroid.y = 0.0;
        this.centroid.z = 0.0;
        while (n < this.validVertexCount) {
            this.getVertexData(n++, point3d);
            this.getVertexData(n++, point3d2);
            this.getVertexData(n++, point3d3);
            vector3d.sub((Tuple3d)point3d, (Tuple3d)point3d2);
            vector3d3.sub((Tuple3d)point3d2, (Tuple3d)point3d3);
            vector3d2.cross(vector3d, vector3d3);
            vector3d2.normalize();
            if (Double.isNaN(vector3d2.x + vector3d2.y + vector3d2.z)) continue;
            this.getCrossValue(point3d, point3d2, vector3d3);
            this.getCrossValue(point3d2, point3d3, vector3d3);
            this.getCrossValue(point3d3, point3d, vector3d3);
            d = vector3d2.dot(vector3d3);
            this.centroid.x += (point3d.x + point3d2.x + point3d3.x) * d;
            this.centroid.y += (point3d.y + point3d2.y + point3d3.y) * d;
            this.centroid.z += (point3d.z + point3d2.z + point3d3.z) * d;
            d2 += d;
        }
        if (d2 != 0.0) {
            d = 1.0 / (3.0 * d2);
            this.centroid.x *= d;
            this.centroid.y *= d;
            this.centroid.z *= d;
        }
        this.freeVector3d(vector3d3);
        this.freeVector3d(vector3d);
        this.freeVector3d(vector3d2);
        this.freePoint3d(point3d);
        this.freePoint3d(point3d2);
        this.freePoint3d(point3d3);
    }

    int getClassType() {
        return 3;
    }
}

