/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.actions;

import abbot.Log;
import abbot.Platform;
import abbot.editor.EditorConstants;
import abbot.editor.widgets.Mnemonic;
import abbot.editor.widgets.TextFormat;
import abbot.i18n.Strings;
import abbot.tester.AWTConstants;
import abbot.util.AWT;
import java.net.URL;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class EditorAction
extends AbstractAction
implements EditorConstants {
    public static final String ACTION_KEY = "action-key";
    public static final String LARGE_ICON = "large-icon";
    public static final String MNEMONIC_INDEX = "mnemonic-index";

    public EditorAction(String actionKey) {
        super(actionKey);
        String accelerator;
        String longDesc;
        String desc;
        int mn;
        this.putValue(ACTION_KEY, actionKey);
        String key = "actions." + actionKey;
        Mnemonic mnemonic = Mnemonic.getMnemonic(Strings.get(key));
        mnemonic.setMnemonic(this);
        if (mnemonic.index != -1) {
            this.putValue(MNEMONIC_INDEX, new Integer(mnemonic.index));
        }
        if (mnemonic.keycode == 0 && (mn = EditorAction.getMnemonic(key)) != 0) {
            this.putValue("MnemonicKey", new Integer(mn));
        }
        if (!"".equals(desc = Strings.get(key + ".desc", true)) && desc != null) {
            this.putValue("ShortDescription", TextFormat.tooltip(desc));
        }
        if (!"".equals(longDesc = Strings.get(key + ".ldesc", true)) && longDesc != null) {
            this.putValue("LongDescription", TextFormat.tooltip(longDesc));
        } else {
            this.putValue("LongDescription", this.getValue("ShortDescription"));
        }
        String iconName = Strings.get(key + ".icon", true);
        if (!"".equals(iconName) && iconName != null) {
            this.putValue("SmallIcon", this.getIcon(iconName, 16));
            this.putValue(LARGE_ICON, this.getIcon(iconName, 24));
        }
        if (!"".equals(accelerator = Strings.get(key + ".acc", true)) && accelerator != null) {
            accelerator = AWTConstants.MENU_SHORTCUT_STRING + accelerator;
            try {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelerator));
            }
            catch (Exception e) {
                Log.warn("Bad accelerator '" + accelerator + "': " + e);
            }
        }
    }

    public static int getMnemonic(String key) {
        int code = 0;
        if (Platform.isOSX()) {
            return code;
        }
        String mnemonic = Strings.get(key + ".mn", true);
        if (!"".equals(mnemonic) && mnemonic != null) {
            if (!mnemonic.startsWith("VK_")) {
                mnemonic = "VK_" + mnemonic;
            }
            try {
                code = AWT.getKeyCode(mnemonic);
            }
            catch (IllegalArgumentException e) {
                String msg = Strings.get("editor.bad_mnemonic", new Object[]{mnemonic, key + ".mn", Locale.getDefault(), e.toString()});
                Log.warn(msg);
            }
        }
        return code;
    }

    private ImageIcon getIcon(String name, int size) {
        String ABBOT_IMAGE_DIR = "/abbot/editor/icons/";
        String base = ABBOT_IMAGE_DIR + name;
        URL url = this.getClass().getResource(base + ".gif");
        if (url == null) {
            url = this.getClass().getResource(base + size + ".gif");
        }
        ImageIcon icon = url != null ? new ImageIcon(url) : null;
        return icon;
    }
}

