/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class Preferences
extends Properties {
    public static final String PROPS_FILENAME = ".abbot.properties";
    private File file;

    public Preferences() {
        this(PROPS_FILENAME);
    }

    public Preferences(String filename) {
        this.file = new File(new File(System.getProperty("user.home")), filename);
        this.load();
    }

    public int getIntegerProperty(String name, int defaultValue) {
        String prop = this.getProperty(name);
        if (prop != null) {
            try {
                return Integer.parseInt(prop);
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
        return defaultValue;
    }

    private void load() {
        if (this.file.exists()) {
            try {
                this.load(new BufferedInputStream(new FileInputStream(this.file)));
            }
            catch (IOException io) {
                Log.warn(io);
            }
        }
    }

    public void save() {
        try {
            this.store(new BufferedOutputStream(new FileOutputStream(this.file)), "Abbot view preferences");
        }
        catch (IOException io) {
            Log.warn(io);
        }
    }
}

