/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.AssertionFailedError;
import abbot.Log;
import abbot.finder.AWTHierarchy;
import abbot.i18n.Strings;
import abbot.script.Script;
import abbot.script.Sequence;
import abbot.script.Step;
import abbot.script.StepEvent;
import abbot.script.StepListener;
import abbot.script.StepRunner;
import abbot.util.ProcessOutputHandler;
import abbot.util.Properties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class ForkedStepRunner
extends StepRunner {
    int LAUNCH_TIMEOUT = Properties.getProperty("abbot.runner.launch_delay", 60000, 0, 300000);
    int TERMINATE_TIMEOUT = Properties.getProperty("abbot.runner.terminate_delay", 30000, 0, 300000);
    private static ServerSocket serverSocket = null;
    private Process process = null;
    private Socket connection = null;

    public ForkedStepRunner() {
        this((StepRunner)null);
    }

    public ForkedStepRunner(StepRunner parent) {
        super(parent != null ? parent.helper : null);
        if (parent != null) {
            this.setStopOnError(parent.getStopOnError());
            this.setStopOnFailure(parent.getStopOnFailure());
            this.setTerminateOnError(parent.getTerminateOnError());
        }
    }

    Process fork(String vmargs, String[] cmdArgs) throws IOException {
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        ArrayList<String> args = new ArrayList<String>();
        args.add(java);
        args.add("-cp");
        String cp = System.getProperty("java.class.path");
        String acp = System.getProperty("abbot.class.path");
        if (acp != null) {
            cp = cp + System.getProperty("path.separator") + acp;
        }
        args.add(cp);
        if (vmargs != null) {
            StringTokenizer st = new StringTokenizer(vmargs);
            while (st.hasMoreTokens()) {
                args.add(st.nextToken());
            }
        }
        args.addAll(Arrays.asList(cmdArgs));
        if (Log.isClassDebugEnabled(this.getClass())) {
            args.add("--debug");
            args.add(this.getClass().getName());
        }
        cmdArgs = args.toArray(new String[args.size()]);
        Process p = Runtime.getRuntime().exec(cmdArgs);
        return p;
    }

    Process fork(String vmargs) throws UnknownHostException, IOException {
        if (serverSocket == null) {
            serverSocket = new ServerSocket(0);
        }
        int localPort = serverSocket.getLocalPort();
        String[] args = new String[]{this.getClass().getName(), String.valueOf(localPort), String.valueOf(this.getStopOnFailure()), String.valueOf(this.getStopOnError()), String.valueOf(this.getTerminateOnError())};
        Process p = this.fork(vmargs, args);
        new ProcessOutputHandler(p){

            public void handleOutput(byte[] buf, int count) {
                System.out.println("[out] " + new String(buf, 0, count));
            }

            public void handleError(byte[] buf, int count) {
                System.err.println("[err] " + new String(buf, 0, count));
            }
        };
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStep(Step step) throws Throwable {
        Log.debug("run step " + step);
        this.fireStepStart(step);
        this.process = null;
        try {
            Script script = (Script)step;
            this.process = this.forkProcess(script.getVMArgs());
            this.sendScript(script);
            try {
                this.trackScript(script);
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    this.process.exitValue();
                }
                catch (IllegalThreadStateException its) {
                    try {
                        Thread.sleep(this.TERMINATE_TIMEOUT);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            catch (IOException io) {
                this.fireStepError(script, io);
                if (this.getStopOnError()) {
                    throw io;
                }
            }
        }
        catch (AssertionFailedError afe) {
            this.fireStepFailure(step, (Throwable)((Object)afe));
            if (this.getStopOnFailure()) {
                throw afe;
            }
        }
        catch (Throwable thr) {
            this.fireStepError(step, thr);
            if (this.getStopOnError()) {
                throw thr;
            }
        }
        finally {
            if (this.process != null) {
                this.process.destroy();
            }
        }
        this.fireStepEnd(step);
    }

    private Process forkProcess(String vmargs) throws Throwable {
        try {
            Process p = this.fork(vmargs);
            serverSocket.setSoTimeout(this.LAUNCH_TIMEOUT);
            this.connection = serverSocket.accept();
            Log.debug("Got slave connection on " + this.connection);
            return p;
        }
        catch (InterruptedIOException ie) {
            Log.warn(ie);
            throw new RuntimeException(Strings.get("runner.slave_timed_out"));
        }
    }

    private void sendScript(Script script) throws IOException {
        StringWriter writer = new StringWriter();
        script.save(writer);
        ForkedStepRunner.writeMessage(this.connection, script.getDirectory().toString());
        ForkedStepRunner.writeMessage(this.connection, writer.toString());
    }

    private void trackScript(Script script) throws IOException, ForkedFailure, ForkedError {
        StepEvent ev;
        while (!this.stopped() && (ev = this.receiveEvent(script)) != null) {
            Log.debug("Forked event received: " + ev);
            if (ev.getStep() == script && ("step-start".equals(ev.getType()) || "step-end".equals(ev.getType()))) continue;
            Log.debug("Replaying forked event locally " + ev);
            Throwable err = ev.getError();
            if (err != null) {
                this.setError(ev.getStep(), err);
                this.fireStepEvent(ev);
                if (err instanceof AssertionFailedError) {
                    if (!this.getStopOnFailure()) continue;
                    throw (ForkedFailure)((Object)err);
                }
                if (!this.getStopOnError()) continue;
                throw (ForkedError)err;
            }
            this.fireStepEvent(ev);
        }
    }

    static Step decodeStep(Sequence root, String code) {
        if (code.equals("-1")) {
            return root;
        }
        int comma = code.indexOf(",");
        if (comma == -1) {
            int index = Integer.parseInt(code);
            return root.getStep(index);
        }
        String ind = code.substring(0, comma);
        code = code.substring(comma + 1);
        return ForkedStepRunner.decodeStep((Sequence)root.getStep(Integer.parseInt(ind)), code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String encodeStep(Sequence root, Step step) {
        if (root.equals(step)) {
            return "-1";
        }
        List list = root.steps();
        synchronized (list) {
            int index = root.indexOf(step);
            if (index != -1) {
                return String.valueOf(index);
            }
            index = 0;
            for (Step seq : root.steps()) {
                String encoding;
                if (seq instanceof Sequence && (encoding = ForkedStepRunner.encodeStep((Sequence)seq, step)) != null) {
                    return index + "," + encoding;
                }
                ++index;
            }
            return null;
        }
    }

    private StepEvent receiveEvent(Script script) throws IOException {
        String buf = ForkedStepRunner.readMessage(this.connection);
        if (buf == null) {
            Log.debug("End of stream");
            return null;
        }
        StringTokenizer st = new StringTokenizer(buf, "\n");
        String code = st.nextToken();
        String type = st.nextToken();
        String id = st.nextToken();
        Step step = ForkedStepRunner.decodeStep(script, code);
        Object thr = null;
        if (st.hasMoreTokens()) {
            String msg = st.nextToken();
            msg = msg.substring(4);
            String next = st.nextToken();
            while (!next.startsWith("STR:")) {
                msg = msg + next;
                next = st.nextToken();
            }
            String string = next.substring(4);
            next = st.nextToken();
            while (!next.startsWith("TRC:")) {
                string = string + next;
                next = st.nextToken();
            }
            String trace = next.substring(4);
            while (st.hasMoreTokens()) {
                trace = trace + "\n" + st.nextToken();
            }
            if (type.equals("step-failure")) {
                Log.debug("Creating local forked step failure");
                thr = new ForkedFailure(msg, string, trace);
            } else {
                Log.debug("Creating local forked step error");
                thr = new ForkedError(msg, string, trace);
            }
        }
        StepEvent event = new StepEvent(step, type, Integer.parseInt(id), (Throwable)thr);
        return event;
    }

    private static void writeMessage(Socket connection, String msg) throws IOException {
        OutputStream os = connection.getOutputStream();
        byte[] buf = msg.getBytes();
        int len = buf.length;
        for (int i = 0; i < 4; ++i) {
            byte val = (byte)(len >> 24);
            os.write(val);
            len <<= 8;
        }
        os.write(buf, 0, buf.length);
        os.flush();
    }

    private static String readMessage(Socket connection) throws IOException {
        int count;
        InputStream is = connection.getInputStream();
        int len = 0;
        for (int i = 0; i < 4; ++i) {
            int data = is.read();
            if (data == -1) {
                return null;
            }
            len = len << 8 | data;
        }
        byte[] buf = new byte[len];
        for (int offset = 0; offset < len; offset += count) {
            count = is.read(buf, offset, buf.length - offset);
            if (count != -1) continue;
            return null;
        }
        String msg = new String(buf, 0, len);
        return msg;
    }

    public static void main(String[] args) {
        args = Log.init(args);
        try {
            final int port = Integer.parseInt(args[0]);
            final SlaveStepRunner runner = new SlaveStepRunner();
            runner.setStopOnFailure("true".equals(args[1]));
            runner.setStopOnError("true".equals(args[2]));
            runner.setTerminateOnError("true".equals(args[3]));
            new Thread(new Runnable(){

                public void run() {
                    runner.launchSlave(port);
                }
            }, "Forked script").start();
        }
        catch (Throwable e) {
            System.err.println("usage: abbot.script.ForkedStepRunner <port>");
            System.exit(1);
        }
    }

    class ForkedError
    extends RuntimeException {
        private String msg;
        private String str;
        private String trace;

        public ForkedError(String msg, String str, String trace) {
            this.msg = msg + " (forked)";
            this.str = str + " (forked)";
            this.trace = trace + " (forked)";
        }

        public String getMessage() {
            return this.msg;
        }

        public String toString() {
            return this.str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printStackTrace(PrintWriter writer) {
            PrintWriter printWriter = writer;
            synchronized (printWriter) {
                writer.print(this.trace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printStackTrace(PrintStream s) {
            PrintStream printStream = s;
            synchronized (printStream) {
                s.print(this.trace);
            }
        }

        public void printStackTrace() {
            this.printStackTrace(System.err);
        }
    }

    class ForkedFailure
    extends AssertionFailedError {
        private String msg;
        private String str;
        private String trace;

        public ForkedFailure(String msg, String str, String trace) {
            this.msg = msg + " (forked)";
            this.str = str + " (forked)";
            this.trace = trace + " (forked)";
        }

        public String getMessage() {
            return this.msg;
        }

        public String toString() {
            return this.str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printStackTrace(PrintWriter writer) {
            PrintWriter printWriter = writer;
            synchronized (printWriter) {
                writer.print(this.trace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printStackTrace(PrintStream s) {
            PrintStream printStream = s;
            synchronized (printStream) {
                s.print(this.trace);
            }
        }

        public void printStackTrace() {
            this.printStackTrace(System.err);
        }
    }

    protected static class SlaveStepRunner
    extends StepRunner {
        private Socket connection = null;
        private Script script = null;

        protected SlaveStepRunner() {
        }

        protected SecurityManager createSecurityManager() {
            return new StepRunner.ExitHandler(){

                public void checkExit(int status) {
                    String msg = Strings.get("runner.slave_premature_exit", new Object[]{new Integer(status)});
                    SlaveStepRunner.this.fireStepError(SlaveStepRunner.this.script, new Error(msg));
                }
            };
        }

        private void forwardEvent(StepEvent event) {
            Step step = event.getStep();
            StringBuffer sb = new StringBuffer(ForkedStepRunner.encodeStep(this.script, step));
            sb.append("\n");
            sb.append(event.getType());
            sb.append("\n");
            sb.append(event.getID());
            Throwable thr = event.getError();
            if (thr != null) {
                sb.append("\nMSG:");
                sb.append(thr.getMessage());
                sb.append("\nSTR:");
                sb.append(thr.toString());
                sb.append("\nTRC:");
                StringWriter writer = new StringWriter();
                thr.printStackTrace(new PrintWriter(writer));
                sb.append(writer.toString());
            }
            try {
                ForkedStepRunner.writeMessage(this.connection, sb.toString());
            }
            catch (IOException io) {
                // empty catch block
            }
        }

        public void launchSlave(int port) {
            try {
                InetAddress local = InetAddress.getLocalHost();
                this.connection = new Socket(local, port);
            }
            catch (Throwable thr) {
                Log.warn(thr);
                System.exit(1);
            }
            this.script = new Script(new AWTHierarchy());
            try {
                String dirName = ForkedStepRunner.readMessage(this.connection);
                this.script.setFile(new File(new File(dirName), this.script.getFile().getName()));
                String contents = ForkedStepRunner.readMessage(this.connection);
                this.script.load(new StringReader(contents));
                Log.debug("Successfully loaded script, dir=" + dirName);
                this.script.setForked(false);
            }
            catch (IOException io) {
                Log.warn(io);
                System.exit(2);
            }
            catch (Throwable thr) {
                Log.debug(thr);
                StepEvent event = new StepEvent(this.script, "step-error", 0, thr);
                this.forwardEvent(event);
            }
            this.addStepListener(new StepListener(){

                public void stateChanged(StepEvent ev) {
                    SlaveStepRunner.this.forwardEvent(ev);
                }
            });
            try {
                this.run(this.script);
            }
            catch (Throwable thr) {
                Log.debug(thr);
            }
            try {
                this.connection.close();
            }
            catch (IOException io) {
                Log.warn(io);
            }
            System.exit(0);
        }
    }
}

