/*
 * Decompiled with CFR 0.152.
 */
package abbot.util;

import abbot.Log;
import abbot.util.InputStreamHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class ProcessOutputHandler {
    private InputStreamHandler stderr;
    private InputStreamHandler stdout;
    private StringBuffer err = new StringBuffer();

    public ProcessOutputHandler() {
    }

    public ProcessOutputHandler(Process p) {
        this.setProcess(p);
    }

    public String getError() {
        return this.err.toString();
    }

    public synchronized void setProcess(Process p) {
        this.stdout = new InputStreamHandler(p.getInputStream()){

            public void handleBytes(byte[] buf, int count) {
                ProcessOutputHandler.this.handleOutput(buf, count);
            }
        };
        this.stdout.start();
        this.stderr = new InputStreamHandler(p.getErrorStream()){

            public void handleBytes(byte[] buf, int count) {
                ProcessOutputHandler.this.err.append(new String(buf, 0, count));
                ProcessOutputHandler.this.handleError(buf, count);
            }
        };
        this.stderr.start();
    }

    protected void handleOutput(byte[] buf, int count) {
    }

    protected void handleError(byte[] buf, int count) {
    }

    public synchronized void waitFor() throws InterruptedException {
        if (this.stderr != null) {
            this.stderr.join();
        }
        if (this.stdout != null) {
            this.stdout.join();
        }
    }

    public static String exec(String[] command) throws IOException {
        return ProcessOutputHandler.exec(command, null);
    }

    public static String exec(String[] command, String[] environment) throws IOException {
        return ProcessOutputHandler.exec(command, environment, null);
    }

    public static String exec(String[] command, String[] environment, File dir) throws IOException {
        final StringBuffer output = new StringBuffer();
        Log.debug("Running " + Arrays.asList(command));
        Process p = Runtime.getRuntime().exec(command, environment, dir);
        ProcessOutputHandler handler = new ProcessOutputHandler(p){

            public void handleOutput(byte[] buf, int count) {
                output.append(new String(buf, 0, count));
            }
        };
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            Log.debug(e);
        }
        try {
            handler.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int code = p.exitValue();
        if (code != 0) {
            String msg = "Process " + Arrays.asList(command) + " exited with " + code;
            String err = handler.getError();
            if (!"".equals(err)) {
                msg = msg + ":\n" + err;
            }
            Log.debug(msg);
            throw new ProcessAbnormalExitException(msg, code);
        }
        Log.debug("output=" + output.toString());
        return output.toString();
    }

    public static class ProcessAbnormalExitException
    extends IOException {
        private int code;

        private ProcessAbnormalExitException(String msg, int code) {
            super(msg);
            this.code = code;
        }

        public int getExitValue() {
            return this.code;
        }
    }
}

