/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.Log;
import abbot.editor.recorder.JComponentRecorder;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Step;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.text.JTextComponent;

public class JTextComponentRecorder
extends JComponentRecorder {
    private JTextComponent target;
    private int startIndex;
    private int endIndex;
    public static final int SE_SELECTION = 30;

    public JTextComponentRecorder(Resolver resolver) {
        super(resolver);
    }

    protected void init(int rtype) {
        super.init(rtype);
        this.target = null;
        this.startIndex = -1;
        this.endIndex = -1;
    }

    protected boolean isMappedEvent(KeyEvent ev) {
        if (super.isMappedEvent(ev)) {
            Action action = this.getAction(ev);
            return !"default-typed".equals(action.getValue("Name"));
        }
        return false;
    }

    protected boolean dragStarted(Component target, int x, int y, int modifiers, MouseEvent dragEvent) {
        Log.debug("Tracking text selection");
        this.setRecordingType(6);
        this.target = (JTextComponent)target;
        this.startIndex = this.target.viewToModel(new Point(x, y));
        return true;
    }

    protected boolean parseDrop(AWTEvent event) {
        boolean consumed = super.parseDrop(event);
        if (event.getID() == 506) {
            MouseEvent me = (MouseEvent)event;
            this.endIndex = this.target.viewToModel(me.getPoint());
        } else if (event.getID() == 502) {
            this.endIndex = this.target.viewToModel(((MouseEvent)event).getPoint());
            this.setFinished(true);
        }
        return consumed;
    }

    protected Step createStep() {
        Step step = this.getRecordingType() == 6 ? this.createDrop(this.target, this.startIndex, this.endIndex) : super.createStep();
        return step;
    }

    protected Step createClick(Component comp, int x, int y, int mods, int count) {
        if (mods == 16 && count == 1) {
            ComponentReference cr = this.getResolver().addComponent(comp);
            JTextComponent tc = (JTextComponent)comp;
            int index = tc.viewToModel(new Point(x, y));
            return new abbot.script.Action(this.getResolver(), null, "actionClick", new String[]{cr.getID(), String.valueOf(index)}, JTextComponent.class);
        }
        return super.createClick(comp, x, y, mods, count);
    }

    protected Step createDrop(Component comp, int start, int end) {
        ComponentReference cr = this.getResolver().addComponent(comp);
        return new abbot.script.Action(this.getResolver(), null, "actionSelectText", new String[]{cr.getID(), String.valueOf(start), String.valueOf(end)}, JTextComponent.class);
    }
}

