/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.script.Interpreter;
import abbot.script.Resolver;
import abbot.script.Step;
import bsh.TargetError;
import java.util.Map;
import org.jdom.CDATA;
import org.jdom.Element;

public class Expression
extends Step {
    public static final String TAG_EXPRESSION = "expression";
    private static final String USAGE = "<expression>{java/beanshell expression}</expression>";
    private String expression = "";

    public Expression(Resolver resolver, Element el, Map attributes) {
        super(resolver, attributes);
        String expr = null;
        for (Object o : el.getContent()) {
            if (!(o instanceof CDATA)) continue;
            expr = ((CDATA)o).getText();
            break;
        }
        if (expr == null) {
            expr = el.getText();
        }
        this.setExpression(expr);
    }

    public Expression(Resolver resolver, String description) {
        super(resolver, description);
    }

    public String getDefaultDescription() {
        return this.getExpression();
    }

    public String getUsage() {
        return USAGE;
    }

    public String getXMLTag() {
        return TAG_EXPRESSION;
    }

    protected Element addContent(Element el) {
        return el.addContent(new CDATA(this.getExpression()));
    }

    public void setExpression(String text) {
        this.expression = text;
    }

    public String getExpression() {
        return this.expression;
    }

    protected void runStep() throws Throwable {
        Interpreter sh = (Interpreter)((Object)this.getResolver().getProperty("bsh"));
        try {
            sh.eval(this.getExpression());
        }
        catch (TargetError e) {
            throw e.getTarget();
        }
    }
}

