/*
 * Decompiled with CFR 0.152.
 */
package abbot.util;

import abbot.Log;
import abbot.util.AWT;
import abbot.util.Bugs;
import abbot.util.WeakAWTEventListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.text.AttributedCharacterIterator;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import sun.awt.dnd.SunDropTargetEvent;

public class EventNormalizer
implements AWTEventListener {
    private static boolean captureModifierRepeats = Boolean.getBoolean("abbot.capture_modifier_repeats");
    private AWTEventListener listener;
    private WeakAWTEventListener weakListener;
    private long modifiers;
    private Map disposedWindows = new WeakHashMap();
    private DragAwareEventQueue queue;
    private long mask;
    private boolean fnKeyDown;
    private int lastKeyPress = 0;
    private int lastKeyRelease = 0;
    private KeyStroke lastKeyStroke;
    private char lastKeyChar = '\u0000';
    private Component lastKeyComponent;

    public void startListening(AWTEventListener listener, long mask) {
        Log.debug("start listening, mask=0x" + Integer.toHexString((int)mask));
        this.fnKeyDown = false;
        this.lastKeyRelease = 0;
        this.lastKeyPress = 0;
        this.lastKeyStroke = null;
        this.lastKeyChar = '\u0000';
        this.lastKeyComponent = null;
        this.modifiers = 0L;
        this.listener = listener;
        this.mask = mask;
        this.weakListener = new WeakAWTEventListener(this, mask);
        this.queue = new DragAwareEventQueue();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(EventNormalizer.this.queue);
                }
            });
        }
        catch (Exception e) {
            Log.warn(e);
        }
        Log.debug("normalizer now listening");
    }

    public void stopListening() {
        if (this.queue != null) {
            try {
                this.queue.pop();
            }
            catch (EmptyStackException e) {
                Log.warn(e);
            }
            this.queue = null;
        }
        if (this.weakListener != null) {
            this.weakListener.dispose();
            this.weakListener = null;
        }
        this.listener = null;
        this.modifiers = 0L;
    }

    private boolean isSpuriousEvent(AWTEvent event) {
        return this.isDuplicateKeyEvent(event) || this.isOSXFunctionKey(event) || this.isDuplicateDispose(event);
    }

    private boolean isDuplicateDispose(AWTEvent event) {
        if (event instanceof WindowEvent) {
            WindowEvent we = (WindowEvent)event;
            switch (we.getID()) {
                case 202: {
                    Window w = we.getWindow();
                    if (this.disposedWindows.containsKey(w)) {
                        return true;
                    }
                    this.disposedWindows.put(w, Boolean.TRUE);
                    w.addComponentListener(new DisposalWatcher(this.disposedWindows));
                    break;
                }
                case 201: {
                    break;
                }
                default: {
                    this.disposedWindows.remove(we.getWindow());
                }
            }
        }
        return false;
    }

    private boolean isDuplicateKeyEvent(AWTEvent event) {
        int id = event.getID();
        if (id == 401) {
            int mask;
            KeyEvent ke = (KeyEvent)event;
            this.lastKeyRelease = 0;
            int code = ke.getKeyCode();
            if (code == this.lastKeyPress && event.getSource() != this.lastKeyComponent) {
                this.lastKeyPress = 0;
                this.lastKeyComponent = null;
                return true;
            }
            this.lastKeyPress = code;
            this.lastKeyComponent = ke.getComponent();
            if (AWT.isModifier(code) && ((long)(mask = AWT.keyCodeToMask(code)) & this.modifiers) != 0L && !captureModifierRepeats) {
                return true;
            }
            this.modifiers = ke.getModifiers();
        } else if (id == 402) {
            KeyEvent ke = (KeyEvent)event;
            this.lastKeyPress = 0;
            int code = ke.getKeyCode();
            if (code == this.lastKeyRelease && event.getSource() != this.lastKeyComponent) {
                this.lastKeyRelease = 0;
                this.lastKeyComponent = null;
                return true;
            }
            this.lastKeyRelease = code;
            this.lastKeyComponent = ke.getComponent();
            this.modifiers = ke.getModifiers();
        } else if (id == 400) {
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent((KeyEvent)event);
            char ch = ((KeyEvent)event).getKeyChar();
            if ((ks.equals(this.lastKeyStroke) || ch == this.lastKeyChar) && event.getSource() != this.lastKeyComponent) {
                this.lastKeyStroke = null;
                this.lastKeyChar = '\u0000';
                this.lastKeyComponent = null;
                return true;
            }
            this.lastKeyStroke = ks;
            this.lastKeyChar = ch;
            this.lastKeyComponent = ((KeyEvent)event).getComponent();
        } else {
            this.lastKeyRelease = 0;
            this.lastKeyPress = 0;
            this.lastKeyComponent = null;
        }
        return false;
    }

    private boolean isOSXFunctionKey(AWTEvent event) {
        int mods;
        if (event.getID() == 402) {
            if (((KeyEvent)event).getKeyCode() == 17 && this.fnKeyDown) {
                this.fnKeyDown = false;
                return true;
            }
        } else if (event.getID() == 401 && ((KeyEvent)event).getKeyCode() == 17 && ((mods = ((KeyEvent)event).getModifiers()) & 2) == 0) {
            this.fnKeyDown = true;
            return true;
        }
        return false;
    }

    protected void delegate(AWTEvent e) {
        InputMethodEvent im;
        if (Bugs.hasInputMethodInsteadOfKeyTyped() && e.getSource() instanceof JTextComponent && e.getID() == 1100 && (im = (InputMethodEvent)e).getCommittedCharacterCount() > 0) {
            AttributedCharacterIterator iter = im.getText();
            char ch = iter.first();
            while (ch != '\uffff') {
                e = new KeyEvent((Component)e.getSource(), 400, System.currentTimeMillis(), (int)this.modifiers, 0, ch);
                this.listener.eventDispatched(e);
                ch = iter.next();
            }
            return;
        }
        this.listener.eventDispatched(e);
    }

    public void eventDispatched(AWTEvent event) {
        boolean discard = this.isSpuriousEvent(event);
        if (!discard && this.listener != null) {
            this.delegate(event);
        }
    }

    private class DragAwareEventQueue
    extends EventQueue {
        private DragAwareEventQueue() {
        }

        protected void relayDnDEvent(MouseEvent e) {
            int id = e.getID();
            if (id == 503 || id == 506) {
                if ((EventNormalizer.this.mask & 0x20L) != 0L) {
                    EventNormalizer.this.eventDispatched(e);
                }
            } else if (id >= 500 && id <= 507 && (EventNormalizer.this.mask & 0x10L) != 0L) {
                EventNormalizer.this.eventDispatched(e);
            }
        }

        public void pop() throws EmptyStackException {
            if (Toolkit.getDefaultToolkit().getSystemEventQueue() == this) {
                super.pop();
            }
        }

        protected void dispatchEvent(AWTEvent e) {
            if (e instanceof SunDropTargetEvent) {
                MouseEvent me = (MouseEvent)e;
                Component target = SwingUtilities.getDeepestComponentAt(me.getComponent(), me.getX(), me.getY());
                if (target != me.getSource()) {
                    me = SwingUtilities.convertMouseEvent(me.getComponent(), me, target);
                }
                this.relayDnDEvent(me);
            }
            super.dispatchEvent(e);
        }
    }

    private class DisposalWatcher
    extends ComponentAdapter {
        private Map map;

        public DisposalWatcher(Map map) {
            this.map = map;
        }

        public void componentShown(ComponentEvent e) {
            e.getComponent().removeComponentListener(this);
            this.map.remove(e.getComponent());
        }
    }
}

