/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.Log;
import abbot.editor.recorder.JComponentRecorder;
import abbot.script.Action;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Step;
import abbot.tester.JComboBoxTester;
import abbot.util.AWT;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;

public class JComboBoxRecorder
extends JComponentRecorder {
    private JComboBoxTester tester = new JComboBoxTester();
    private JComboBox combo = null;
    private JList list = null;
    private int index = -1;
    private ActionListener listener = null;

    public JComboBoxRecorder(Resolver resolver) {
        super(resolver);
    }

    public boolean accept(AWTEvent event) {
        if (this.isClick(event) && this.getComboBox(event) == null) {
            return false;
        }
        return super.accept(event);
    }

    protected void init(int recordingType) {
        super.init(recordingType);
        this.combo = null;
        this.list = null;
        this.index = -1;
        this.listener = null;
    }

    private JComboBox getComboBox(AWTEvent event) {
        Component comp = (Component)event.getSource();
        if (comp instanceof JButton) {
            comp = comp.getParent();
        }
        if (comp instanceof JComboBox) {
            return (JComboBox)comp;
        }
        return null;
    }

    protected boolean canMultipleClick() {
        return false;
    }

    protected boolean parseClick(AWTEvent event) {
        if (this.isFinished()) {
            return false;
        }
        boolean consumed = true;
        if (this.combo == null) {
            this.combo = this.getComboBox(event);
            this.listener = new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    JComboBoxRecorder.this.index = JComboBoxRecorder.this.combo.getSelectedIndex();
                    if (!JComboBoxRecorder.this.combo.isPopupVisible()) {
                        JComboBoxRecorder.this.combo.removeActionListener(JComboBoxRecorder.this.listener);
                        JComboBoxRecorder.this.setFinished(true);
                    }
                }
            };
            this.combo.addActionListener(this.listener);
            this.setStatus("Waiting for selection");
        } else if (event.getID() == 402 && (((KeyEvent)event).getKeyCode() == 32 || ((KeyEvent)event).getKeyCode() == 10)) {
            this.index = this.combo.getSelectedIndex();
            this.setFinished(true);
        } else if (event.getID() == 501 && !AWT.isOnPopup((Component)event.getSource()) && this.combo != this.getComboBox(event)) {
            this.setFinished(true);
            consumed = false;
        } else if (event.getID() == 402 && ((KeyEvent)event).getKeyCode() == 27) {
            this.setStatus("Selection canceled");
            this.setFinished(true);
        } else {
            Log.debug("Event ignored");
        }
        if (this.list == null && this.combo.isPopupVisible()) {
            this.list = this.tester.findComboList(this.combo);
        }
        if (this.isFinished()) {
            this.combo.removeActionListener(this.listener);
            this.listener = null;
        }
        return consumed;
    }

    protected Step createStep() {
        Step step = null;
        step = this.getRecordingType() == 3 ? this.createSelection(this.combo, this.index) : super.createStep();
        return step;
    }

    protected Step createSelection(JComboBox combo, int index) {
        Action step = null;
        if (combo != null && index != -1) {
            ComponentReference cr = this.getResolver().addComponent(combo);
            String value = this.tester.getValueAsString(combo, this.list, combo.getItemAt(index), index);
            step = value == null ? new Action(this.getResolver(), null, "actionSelectIndex", new String[]{cr.getID(), String.valueOf(index)}, JComboBox.class) : new Action(this.getResolver(), null, "actionSelectItem", new String[]{cr.getID(), value}, JComboBox.class);
        }
        return step;
    }
}

