/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.GeometryStripArrayRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.IndexedLineStripArrayRetained;
import javax.media.j3d.IndexedTriangleFanArrayRetained;
import javax.media.j3d.IndexedTriangleStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineStripArrayRetained;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArrayRetained;

abstract class IndexedGeometryStripArrayRetained
extends IndexedGeometryArrayRetained {
    int[] stripIndexCounts;
    int[] compileStripICOffset;
    int[] compileIndexLength;

    IndexedGeometryStripArrayRetained() {
    }

    void setStripIndexCounts(int[] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += nArray[n];
            if (this instanceof IndexedLineStripArrayRetained) {
                if (nArray[n] >= 2) continue;
                throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArrayRetained1"));
            }
            if (this instanceof IndexedTriangleStripArrayRetained) {
                if (nArray[n] >= 3) continue;
                throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArrayRetained1"));
            }
            if (!(this instanceof IndexedTriangleFanArrayRetained) || nArray[n] >= 3) continue;
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArrayRetained1"));
        }
        if (this.initialIndexIndex + n3 > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryStripArrayRetained0"));
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray2 = null;
        n4 = this.computeMaxIndex(this.initialIndexIndex, n3, this.indexCoord);
        this.doErrorCheck(n4);
        if ((this.vertexFormat & 0x200) == 0) {
            if ((this.vertexFormat & 4) != 0) {
                n5 = this.computeMaxIndex(this.initialIndexIndex, n3, this.indexColor);
                this.doColorCheck(n5);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                nArray2 = new int[this.texCoordSetCount];
                for (n = 0; n < this.texCoordSetCount; ++n) {
                    nArray2[n] = this.computeMaxIndex(this.initialIndexIndex, n3, (int[])this.indexTexCoord[n]);
                    this.doTexCoordCheck(nArray2[n], n);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                n6 = this.computeMaxIndex(this.initialIndexIndex, n3, this.indexNormal);
                this.doNormalCheck(n6);
            }
        }
        this.geomLock.getLock();
        this.validIndexCount = n3;
        this.stripIndexCounts = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.stripIndexCounts[n] = nArray[n];
        }
        this.maxCoordIndex = n4;
        if ((this.vertexFormat & 0x200) == 0) {
            this.maxColorIndex = n5;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n = 0; n < this.texCoordSetCount; ++n) {
                    this.maxTexCoordIndices[n] = nArray2[n];
                }
            }
            this.maxNormalIndex = n6;
        } else {
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n = 0; n < this.texCoordSetCount; ++n) {
                    this.maxTexCoordIndices[n] = this.maxCoordIndex;
                }
            }
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    Object cloneNonIndexedGeometry() {
        GeometryStripArrayRetained geometryStripArrayRetained = null;
        switch (this.geoType) {
            case 14: {
                geometryStripArrayRetained = new LineStripArrayRetained();
                break;
            }
            case 13: {
                geometryStripArrayRetained = new TriangleFanArrayRetained();
                break;
            }
            case 12: {
                geometryStripArrayRetained = new TriangleStripArrayRetained();
            }
        }
        geometryStripArrayRetained.createGeometryArrayData(this.validIndexCount, this.vertexFormat & 0xFFFFF67F, this.texCoordSetCount, this.texCoordSetMap);
        geometryStripArrayRetained.unIndexify(this);
        geometryStripArrayRetained.setStripVertexCounts(this.stripIndexCounts);
        return geometryStripArrayRetained;
    }

    int getNumStrips() {
        return this.stripIndexCounts.length;
    }

    void getStripIndexCounts(int[] nArray) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            nArray[i] = this.stripIndexCounts[i];
        }
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n;
        int n2 = arrayList.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained = (IndexedGeometryStripArrayRetained)arrayList.get(n);
            n3 += indexedGeometryStripArrayRetained.stripIndexCounts.length;
        }
        this.stripIndexCounts = new int[n3];
        this.compileIndexLength = new int[n3];
        this.compileStripICOffset = new int[n2];
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained = (IndexedGeometryStripArrayRetained)arrayList.get(n);
            this.compileStripICOffset[n] = n4;
            this.compileIndexLength[n] = indexedGeometryStripArrayRetained.stripIndexCounts.length;
            System.arraycopy(indexedGeometryStripArrayRetained.stripIndexCounts, 0, this.stripIndexCounts, n4, indexedGeometryStripArrayRetained.stripIndexCounts.length);
            n4 += indexedGeometryStripArrayRetained.stripIndexCounts.length;
        }
        super.mergeGeometryArrays(arrayList);
    }

    int getNumStrips(int n) {
        return this.compileIndexLength[n];
    }

    void getStripIndexCounts(int n, int[] nArray) {
        int n2 = this.compileIndexLength[n];
        int n3 = this.compileStripICOffset[n];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.stripIndexCounts[n3 + 1];
        }
    }
}

