/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Hashtable;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SceneGraphObjectRetained;

public abstract class SceneGraphObject {
    SceneGraphObjectRetained retained;
    private long capabilityBits = 0L;
    private long capabilityIsFrequentBits = -1L;
    private boolean compiled = false;
    private boolean live = false;
    private boolean liveOrCompiled = false;
    private Object userData = null;
    Hashtable nodeHashtable = null;

    public SceneGraphObject() {
        this.createRetained();
    }

    void createRetained() {
        this.retained = null;
    }

    public final boolean getCapability(int n) {
        return (this.capabilityBits & 1L << n) != 0L;
    }

    public final void setCapability(int n) {
        if (this.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject0"));
        }
        this.capabilityBits |= 1L << n;
        this.retained.handleFrequencyChange(n);
    }

    public final void clearCapability(int n) {
        if (this.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject0"));
        }
        this.capabilityBits &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
        this.retained.handleFrequencyChange(n);
    }

    final boolean capabilityBitsEmpty() {
        return this.capabilityBits == 0L;
    }

    public final boolean getCapabilityIsFrequent(int n) {
        return (this.capabilityIsFrequentBits & 1L << n) != 0L;
    }

    public final void setCapabilityIsFrequent(int n) {
        if (this.isCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject1"));
        }
        this.capabilityIsFrequentBits |= 1L << n;
        this.retained.handleFrequencyChange(n);
    }

    public final void clearCapabilityIsFrequent(int n) {
        if (this.isCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject1"));
        }
        this.capabilityIsFrequentBits &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
        this.retained.handleFrequencyChange(n);
    }

    final void setCompiled() {
        this.compiled = true;
        this.liveOrCompiled = this.live || this.compiled;
    }

    public final boolean isCompiled() {
        return this.compiled;
    }

    final void setLive() {
        this.live = true;
        this.liveOrCompiled = this.live || this.compiled;
    }

    final void clearLive() {
        this.live = false;
        this.liveOrCompiled = this.live || this.compiled;
    }

    public final boolean isLive() {
        return this.live;
    }

    final boolean isLiveOrCompiled() {
        return this.liveOrCompiled;
    }

    final void checkForLiveOrCompiled() {
        if (this.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject2"));
        }
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
    }

    protected void duplicateSceneGraphObject(SceneGraphObject sceneGraphObject) {
        this.capabilityBits = sceneGraphObject.capabilityBits;
        this.userData = sceneGraphObject.userData;
    }

    NodeComponent getNodeComponent(NodeComponent nodeComponent, boolean bl, Hashtable hashtable) {
        if (nodeComponent != null && (bl || nodeComponent.duplicateChild())) {
            NodeComponent nodeComponent2 = (NodeComponent)hashtable.get(nodeComponent);
            if (nodeComponent2 == null) {
                nodeComponent.nodeHashtable = hashtable;
                try {
                    nodeComponent2 = nodeComponent.cloneNodeComponent(bl);
                }
                catch (RuntimeException runtimeException) {
                    nodeComponent.nodeHashtable = null;
                    throw runtimeException;
                }
                nodeComponent.nodeHashtable = null;
                hashtable.put(nodeComponent, nodeComponent2);
            }
            return nodeComponent2;
        }
        return nodeComponent;
    }
}

