/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.finder.Hierarchy;
import abbot.util.AWT;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class CompactHierarchy
implements Hierarchy {
    private boolean compact = true;
    private Hierarchy hierarchy;

    public CompactHierarchy(Hierarchy original) {
        this.hierarchy = original;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public Collection getRoots() {
        return this.hierarchy.getRoots();
    }

    public Container getParent(Component c) {
        Component invoker;
        if (this.compact && c instanceof JPopupMenu && (invoker = ((JPopupMenu)c).getInvoker()) instanceof Container) {
            return (Container)invoker;
        }
        if (this.compact && c instanceof JToolTip) {
            return ((JToolTip)c).getComponent();
        }
        Container parent = this.hierarchy.getParent(c);
        if (this.compact) {
            while (parent != null && this.isElided(parent)) {
                parent = this.getParent(parent);
            }
        }
        return parent;
    }

    public boolean contains(Component c) {
        return this.hierarchy.contains(c);
    }

    public void dispose(Window w) {
        this.hierarchy.dispose(w);
    }

    private boolean isIgnored(Component c) {
        if (AWT.isTransientPopup(c)) {
            return true;
        }
        return c instanceof JScrollBar && c.getParent() instanceof JScrollPane;
    }

    private boolean isElided(Component c) {
        Container parent;
        if (AWT.isTransientPopup(c)) {
            return true;
        }
        if (c instanceof Container) {
            if (c instanceof Window) {
                return false;
            }
            if (c instanceof JPopupMenu && ((JPopupMenu)c).getInvoker() instanceof JMenu) {
                return true;
            }
            if (AWT.isContentPane(c) && AWT.isTransientPopup(SwingUtilities.getWindowAncestor(c))) {
                return true;
            }
        }
        if ((parent = c.getParent()) instanceof JScrollPane) {
            return c instanceof JScrollBar || c instanceof JViewport;
        }
        return parent instanceof RootPaneContainer || parent instanceof JRootPane;
    }

    public Collection getComponents(Component c) {
        if (c == null || !(c instanceof Container)) {
            return new ArrayList();
        }
        ArrayList<Component> list = new ArrayList<Component>();
        if (this.compact && c instanceof JMenu) {
            return this.getComponents(((JMenu)c).getPopupMenu());
        }
        for (Component k : this.hierarchy.getComponents(c)) {
            if (this.compact && this.isElided(k)) {
                if (this.isIgnored(k)) continue;
                list.addAll(this.getComponents(k));
                continue;
            }
            list.add(k);
        }
        list.addAll(this.findInvokerPopups(c));
        return list;
    }

    private Collection findInvokerPopups(Component invoker) {
        JLayeredPane jLayeredPane;
        JRootPane rp;
        ArrayList<JComponent> popups = new ArrayList<JComponent>();
        Window root = AWT.getWindow(invoker);
        ArrayList<Window> parents = new ArrayList<Window>(Arrays.asList(root.getOwnedWindows()));
        if ((root instanceof JWindow || root instanceof JFrame || root instanceof JDialog) && (rp = ((RootPaneContainer)((Object)root)).getRootPane()) != null && (jLayeredPane = rp.getLayeredPane()) != null) {
            parents.addAll(Arrays.asList(jLayeredPane.getComponents()));
        }
        for (Component component : parents) {
            JComponent popup = this.findInvokedPopup(invoker, component);
            if (popup == null) continue;
            popups.add(popup);
        }
        return popups;
    }

    private JComponent findInvokedPopup(Component invoker, Component parent) {
        JComponent popup;
        if (!(!AWT.isTransientPopup(parent) || (popup = this.findPopup((Container)parent)) == null || popup instanceof JPopupMenu && this.getParent(popup) instanceof JMenu || this.getParent(popup) != invoker)) {
            return popup;
        }
        return null;
    }

    private JComponent findPopup(Container c) {
        JComponent popup = null;
        Component[] kids = c.getComponents();
        for (int i = 0; i < kids.length && popup == null; ++i) {
            if (kids[i] instanceof JPopupMenu || kids[i] instanceof JToolTip) {
                popup = (JComponent)kids[i];
                continue;
            }
            if (!(kids[i] instanceof Container)) continue;
            popup = this.findPopup((Container)kids[i]);
        }
        return popup;
    }
}

