/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.editor.ComponentNode;
import abbot.editor.ComponentTreeIcons;
import abbot.finder.Hierarchy;
import abbot.util.AWT;
import abbot.util.WeakAWTEventListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.net.URL;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class ComponentTree
extends JTree {
    private Hierarchy hierarchy;
    private ComponentNode root;
    private HierarchyMonitor monitor;
    private DefaultTreeModel model;
    private transient boolean ignoreSelectionChanges;
    private ComponentTreeIcons icons = new ComponentTreeIcons();

    public ComponentTree(Hierarchy h) {
        super(new ComponentNode(h));
        this.setSelectionModel(new SelectionModel());
        this.setCellRenderer(new Renderer());
        this.setShowsRootHandles(true);
        this.setScrollsOnExpand(true);
        this.hierarchy = h;
        this.model = (DefaultTreeModel)this.getModel();
        this.root = (ComponentNode)this.model.getRoot();
        this.monitor = new HierarchyMonitor();
        long mask = 67L;
        new WeakAWTEventListener(this.monitor, mask);
    }

    public void setHierarchy(Hierarchy h) {
        this.hierarchy = h;
        this.root.reload(h);
        this.reload();
    }

    public void setSelectionPath(TreePath path) {
        super.setSelectionPath(path);
        this.makeVisible(path);
        Rectangle rect = this.getPathBounds(path);
        if (rect != null) {
            this.scrollRectToVisible(rect);
        }
    }

    public TreePath getPath(Component comp) {
        return this.root.getPath(comp);
    }

    public void reload() {
        this.reload(null);
    }

    public void reload(Component comp) {
        Component selected;
        ComponentNode node = comp != null ? this.root.getNode(comp) : this.root;
        TreePath path = this.getSelectionPath();
        Component component = selected = path == null ? null : ((ComponentNode)path.getLastPathComponent()).getComponent();
        if (node == null) {
            node = this.root;
        }
        this.ignoreSelectionChanges = true;
        node.reload();
        this.model.reload(node);
        if (selected != null) {
            TreePath newPath = this.root.getPath(selected);
            this.ignoreSelectionChanges = path.equals(newPath);
            this.setSelectionPath(newPath);
        }
        this.ignoreSelectionChanges = false;
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        public Renderer() {
            URL url = this.getClass().getResource("icons/component.gif");
            if (url != null) {
                this.setLeafIcon(new ImageIcon(url));
            }
            if ((url = this.getClass().getResource("icons/container.gif")) != null) {
                this.setOpenIcon(new ImageIcon(url));
                this.setClosedIcon(new ImageIcon(url));
            }
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean exp, boolean leaf, int row, boolean focus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, exp, leaf, row, focus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                Icon icon = null;
                if (value == ComponentTree.this.root) {
                    URL url = this.getClass().getResource("icons/hierarchy-root.gif");
                    if (url != null) {
                        icon = new ImageIcon(url);
                    }
                } else {
                    Component c1 = ((ComponentNode)value).getComponent();
                    if (c1 != null) {
                        icon = ComponentTree.this.icons.getIcon(c1.getClass());
                    }
                }
                if (icon != null) {
                    label.setIcon(icon);
                }
            }
            return c;
        }
    }

    private class HierarchyMonitor
    implements AWTEventListener {
        private HierarchyMonitor() {
        }

        public void eventDispatched(AWTEvent ev) {
            switch (ev.getID()) {
                case 102: 
                case 200: 
                case 202: {
                    Component c = ((ComponentEvent)ev).getComponent();
                    if (!ComponentTree.this.hierarchy.contains(c)) break;
                    ComponentTree.this.reload(ComponentTree.this.hierarchy.getParent(c));
                    break;
                }
                case 300: 
                case 301: {
                    ContainerEvent e = (ContainerEvent)ev;
                    Component c = e.getComponent();
                    Window w = AWT.getWindow(c);
                    if (c instanceof CellRendererPane || !ComponentTree.this.hierarchy.contains(c) || w == null || !ComponentTree.this.hierarchy.contains(w)) break;
                    ComponentTree.this.reload(c);
                    break;
                }
            }
        }
    }

    private class SelectionModel
    extends DefaultTreeSelectionModel {
        private transient boolean settingSelection;

        private SelectionModel() {
        }

        protected void fireValueChanged(TreeSelectionEvent e) {
            if (this.settingSelection || ComponentTree.this.ignoreSelectionChanges) {
                return;
            }
            super.fireValueChanged(e);
        }
    }
}

