/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.i18n.Strings;
import abbot.script.ComponentReference;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class ReferenceAttributeModel
extends AbstractTableModel {
    private ComponentReference reference;
    private static String[] COLUMN_NAMES = new String[]{Strings.get("attribute.name"), Strings.get("attribute.value")};

    public void setReference(ComponentReference ref) {
        this.reference = ref;
        this.fireTableDataChanged();
    }

    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    public int getRowCount() {
        return this.reference == null ? 0 : this.reference.getAttributes().values().size();
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int row, int col) {
        Map.Entry entry = (Map.Entry)this.reference.getAttributes().entrySet().toArray()[row];
        return col == 0 ? entry.getKey() : entry.getValue();
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            String key = (String)this.getValueAt(row, 0);
            this.reference.setAttribute(key, (String)value);
            this.fireTableCellUpdated(row, col);
        }
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }
}

