/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.Log;
import abbot.editor.widgets.ArrayEditor;
import abbot.i18n.Strings;
import abbot.util.PathClassLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import junit.extensions.abbot.ScriptTestCollector;
import junit.runner.Sorter;
import junit.runner.TestCollector;

public class TestSelector
extends JDialog {
    public static final String TEST_NONE = "<None>";
    private JList fList;
    private ArrayEditor pathEditor;
    private JButton fOk;
    private String fSelectedItem;

    public TestSelector(Frame parent, String classPath) {
        super(parent, true);
        this.setSize(350, 300);
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
        this.setTitle(Strings.get("TestSelector.title"));
        this.fList = new JList();
        this.fList.setSelectionMode(0);
        this.fList.setCellRenderer(new TestCellRenderer());
        this.setCollector(classPath);
        JScrollPane listScroll = new JScrollPane(this.fList);
        Object[] paths = PathClassLoader.convertPathToFilenames(classPath);
        this.pathEditor = new ArrayEditor(paths);
        JScrollPane scroll = new JScrollPane(this.pathEditor);
        JPanel path = new JPanel(new BorderLayout());
        JLabel label = new JLabel(Strings.get("selector.classpath"));
        path.add((Component)label, "North");
        path.add((Component)scroll, "Center");
        JSplitPane split = new JSplitPane(0, listScroll, path);
        split.setBorder(null);
        JButton cancel = new JButton(UIManager.getString("OptionPane.cancelButtonText"));
        JButton none = new JButton(Strings.get("None"));
        JLabel desc = new JLabel(Strings.get("SelectTest"));
        this.fOk = new JButton(UIManager.getString("OptionPane.okButtonText"));
        this.fOk.setEnabled(false);
        this.getRootPane().setDefaultButton(this.fOk);
        this.defineLayout(desc, split, this.fOk, none, cancel);
        this.addListeners(this.fOk, none, cancel);
    }

    public void setCollector(String classPath) {
        String fallback = System.getProperty("java.class.path");
        if (fallback.indexOf("abbot.jar") == -1 && (fallback = System.getProperty("abbot.class.path")).indexOf("abbot.jar") == -1) {
            Log.warn("abbot.jar not found in classpath");
        }
        classPath = classPath + System.getProperty("path.separator") + fallback;
        PathClassLoader cl = new PathClassLoader(classPath);
        ScriptTestCollector collector = new ScriptTestCollector(cl);
        Object[] list = this.createTestList((TestCollector)collector).toArray();
        this.setTestList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTestList(final Object[] list) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TestSelector.this.setTestList(list);
                }
            });
            return;
        }
        try {
            this.getParent().setCursor(Cursor.getPredefinedCursor(3));
            this.fList.setModel(new AbstractListModel(){

                public int getSize() {
                    return list.length;
                }

                public Object getElementAt(int i) {
                    return list[i];
                }
            });
        }
        finally {
            this.getParent().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void addListeners(JButton ok, JButton none, JButton cancel) {
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestSelector.this.dispose();
            }
        });
        none.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestSelector.this.fSelectedItem = TestSelector.TEST_NONE;
                TestSelector.this.dispose();
            }
        });
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestSelector.this.okSelected();
            }
        });
        this.fList.addMouseListener(new DoubleClickListener());
        this.fList.addKeyListener(new KeySelectListener());
        this.fList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TestSelector.this.checkEnableOK(e);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TestSelector.this.dispose();
            }
        });
        this.pathEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object[] values = TestSelector.this.pathEditor.getValues();
                final StringBuffer buf = new StringBuffer();
                for (int i = 0; i < values.length; ++i) {
                    buf.append(values[i]);
                    buf.append(System.getProperty("path.separator"));
                }
                new Thread("Available classes loader"){

                    public void run() {
                        TestSelector.this.setCollector(buf.toString());
                    }
                }.start();
            }
        });
    }

    private void defineLayout(Component desc, Component center, Component ok, Component none, Component cancel) {
        this.getContentPane().setLayout(new BorderLayout());
        ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(4, 4, 4, 4));
        this.getContentPane().add(desc, "North");
        this.getContentPane().add(center, "Center");
        JPanel buttons = new JPanel(new GridLayout(1, 0));
        buttons.add(ok);
        buttons.add(none);
        buttons.add(cancel);
        this.getContentPane().add((Component)buttons, "South");
    }

    public void checkEnableOK(ListSelectionEvent e) {
        this.fOk.setEnabled(this.fList.getSelectedIndex() != -1);
    }

    public void okSelected() {
        this.fSelectedItem = (String)this.fList.getSelectedValue();
        this.dispose();
    }

    public boolean isEmpty() {
        return this.fList.getModel().getSize() == 0;
    }

    public void keySelectTestClass(char ch) {
        ListModel model = this.fList.getModel();
        if (!Character.isJavaIdentifierStart(ch)) {
            return;
        }
        for (int i = 0; i < model.getSize(); ++i) {
            String s = (String)model.getElementAt(i);
            if (!TestCellRenderer.matchesKey(s, Character.toUpperCase(ch))) continue;
            this.fList.setSelectedIndex(i);
            this.fList.ensureIndexIsVisible(i);
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    public String getSelectedItem() {
        return this.fSelectedItem;
    }

    private List createTestList(TestCollector collector) {
        Enumeration each = collector.collectTests();
        Vector<String> v = new Vector<String>();
        Vector<String> displayVector = new Vector<String>();
        while (each.hasMoreElements()) {
            String s = (String)each.nextElement();
            v.add(s);
            displayVector.add(TestCellRenderer.displayString(s));
        }
        if (v.size() > 0) {
            Sorter.sortStrings(displayVector, (int)0, (int)(displayVector.size() - 1), (Sorter.Swapper)new ParallelSwapper(v));
        }
        return new ArrayList(v);
    }

    private class ParallelSwapper
    implements Sorter.Swapper {
        Vector fOther;

        ParallelSwapper(Vector other) {
            this.fOther = other;
        }

        public void swap(Vector values, int left, int right) {
            Object tmp = values.elementAt(left);
            values.setElementAt(values.elementAt(right), left);
            values.setElementAt(tmp, right);
            Object tmp2 = this.fOther.elementAt(left);
            this.fOther.setElementAt(this.fOther.elementAt(right), left);
            this.fOther.setElementAt(tmp2, right);
        }
    }

    protected class KeySelectListener
    extends KeyAdapter {
        protected KeySelectListener() {
        }

        public void keyTyped(KeyEvent e) {
            TestSelector.this.keySelectTestClass(e.getKeyChar());
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        protected DoubleClickListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                TestSelector.this.okSelected();
            }
        }
    }

    static class TestCellRenderer
    extends DefaultListCellRenderer {
        Icon fLeafIcon = UIManager.getIcon("Tree.leafIcon");
        Icon fSuiteIcon = UIManager.getIcon("Tree.closedIcon");

        public Component getListCellRendererComponent(JList list, Object value, int modelIndex, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, modelIndex, isSelected, cellHasFocus);
            String displayString = TestCellRenderer.displayString((String)value);
            if (displayString.startsWith("AllTests")) {
                this.setIcon(this.fSuiteIcon);
            } else {
                this.setIcon(this.fLeafIcon);
            }
            this.setText(displayString);
            return c;
        }

        public static String displayString(String className) {
            int typeIndex = className.lastIndexOf(46);
            if (typeIndex < 0) {
                return className;
            }
            return className.substring(typeIndex + 1) + " - " + className.substring(0, typeIndex);
        }

        public static boolean matchesKey(String s, char ch) {
            return ch == Character.toUpperCase(s.charAt(TestCellRenderer.typeIndex(s)));
        }

        private static int typeIndex(String s) {
            int typeIndex = s.lastIndexOf(46);
            int i = 0;
            if (typeIndex > 0) {
                i = typeIndex + 1;
            }
            return i;
        }
    }
}

