/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.actions;

import abbot.editor.actions.Command;
import abbot.editor.actions.NoUndoException;
import abbot.editor.actions.Undoable;
import abbot.editor.actions.UndoableCommand;
import java.util.ArrayList;

public class CommandHistory {
    private ArrayList list = new ArrayList();
    private int cursor = 0;

    private Command get(int idx) {
        return (Command)this.list.get(idx);
    }

    public boolean canUndo() {
        return this.cursor > 0 && this.get(this.cursor - 1) instanceof Undoable;
    }

    public void undo() throws NoUndoException {
        if (!this.canUndo()) {
            this.cursor = this.list.size();
            throw new NoUndoException();
        }
        UndoableCommand undoable = (UndoableCommand)this.get(--this.cursor);
        undoable.undo();
        this.list.add(new CommandComplement(undoable));
    }

    public void add(Command command) {
        if (!(command instanceof Undoable)) {
            this.clear();
        }
        this.list.add(command);
        this.cursor = this.list.size();
    }

    public void clear() {
        this.list.clear();
        this.cursor = 0;
    }

    private class CommandComplement
    implements UndoableCommand {
        private UndoableCommand cmd;

        public CommandComplement(UndoableCommand orig) {
            this.cmd = orig;
        }

        public void execute() {
            this.cmd.undo();
        }

        public void undo() {
            this.cmd.execute();
        }
    }
}

