/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.Log;
import abbot.editor.recorder.ContainerRecorder;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Step;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class JComponentRecorder
extends ContainerRecorder {
    private JComponent target;
    private String actionKey;
    public static final int SE_ACTION_MAP = 20;

    public JComponentRecorder(Resolver resolver) {
        super(resolver);
    }

    protected void init(int rtype) {
        super.init(rtype);
        this.target = null;
        this.actionKey = null;
    }

    public boolean accept(AWTEvent event) {
        boolean accepted;
        if (event instanceof KeyEvent && event.getSource() instanceof JComponent && this.isMappedEvent((KeyEvent)event)) {
            this.init(20);
            accepted = true;
        } else {
            accepted = super.accept(event);
        }
        return accepted;
    }

    protected Action getAction(KeyEvent ke) {
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(ke);
        JComponent comp = (JComponent)ke.getComponent();
        Object binding = comp.getInputMap().get(ks);
        return binding != null ? comp.getActionMap().get(binding) : null;
    }

    protected boolean isMappedEvent(KeyEvent ke) {
        return this.getAction(ke) != null;
    }

    public boolean parse(AWTEvent event) {
        boolean consumed = true;
        switch (this.getRecordingType()) {
            case 20: {
                consumed = this.parseActionMapEvent(event);
                break;
            }
            default: {
                consumed = super.parse(event);
            }
        }
        return consumed;
    }

    protected boolean parseActionMapEvent(AWTEvent event) {
        if (this.target == null) {
            this.target = (JComponent)event.getSource();
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent((KeyEvent)event);
            Object binding = this.target.getInputMap().get(ks);
            Log.debug("Binding is " + binding + " (" + binding.getClass() + ")");
            if (binding instanceof String) {
                this.actionKey = (String)binding;
            } else {
                Action action = this.target.getActionMap().get(binding);
                this.actionKey = (String)action.getValue("Name");
            }
            Log.debug("Keystroke '" + ks + "' mapped to " + this.actionKey);
        }
        if (event.getID() == 402) {
            this.setFinished(true);
        }
        return true;
    }

    protected Step createStep() {
        Step step;
        switch (this.getRecordingType()) {
            case 20: {
                step = this.createActionMap(this.target, this.actionKey);
                break;
            }
            default: {
                step = super.createStep();
            }
        }
        return step;
    }

    protected Step createActionMap(JComponent target, String actionKey) {
        ComponentReference cr = this.getResolver().addComponent(target);
        return new abbot.script.Action(this.getResolver(), null, "actionActionMap", new String[]{cr.getID(), actionKey}, JComponent.class);
    }
}

