/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.BugReport;
import abbot.Log;
import abbot.editor.recorder.RecordingFailedException;
import abbot.i18n.Strings;
import abbot.script.Resolver;
import abbot.script.Step;
import abbot.tester.Robot;
import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class Recorder {
    private ActionListener al;
    private Resolver resolver;
    private long lastEventTime = 0L;

    public Recorder(Resolver resolver) {
        this.resolver = resolver;
    }

    public void addActionListener(ActionListener al) {
        this.al = al;
    }

    protected ActionListener getListener() {
        return this.al;
    }

    public void start() {
        this.lastEventTime = System.currentTimeMillis();
    }

    public abstract void terminate() throws RecordingFailedException;

    public long getLastEventTime() {
        return this.lastEventTime;
    }

    protected abstract Step createStep();

    public Step getStep() {
        return this.createStep();
    }

    public void insertStep(Step step) {
    }

    public void record(AWTEvent event) throws RecordingFailedException {
        if (Log.isClassDebugEnabled(this.getClass())) {
            Log.debug("REC: " + Robot.toString(event));
        }
        this.lastEventTime = System.currentTimeMillis();
        try {
            this.recordEvent(event);
        }
        catch (RecordingFailedException e) {
            throw e;
        }
        catch (Throwable thrown) {
            Log.log("REC: Unexpected failure: " + thrown);
            String msg = Strings.get("editor.recording.exception");
            throw new RecordingFailedException(new BugReport(msg, thrown));
        }
    }

    protected abstract void recordEvent(AWTEvent var1) throws RecordingFailedException;

    public long getEventMask() {
        return -1L;
    }

    protected Resolver getResolver() {
        return this.resolver;
    }

    protected void setStatus(String msg) {
        if (this.al != null) {
            ActionEvent event = new ActionEvent(this, 1001, msg);
            this.al.actionPerformed(event);
        }
    }
}

