/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.widgets;

import abbot.Log;
import abbot.Platform;
import abbot.i18n.Strings;
import abbot.tester.KeyStrokeMap;
import abbot.util.AWT;
import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class Mnemonic {
    public String text;
    public int keycode;
    public int index;

    private Mnemonic(String text, int keycode, int index) {
        this.text = text;
        this.keycode = keycode;
        this.index = index;
    }

    public static void setDisplayedMnemonicIndex(Component c, int index) {
        if (index == -1) {
            return;
        }
        try {
            Method m = c.getClass().getMethod("setDisplayedMnemonicIndex", Integer.TYPE);
            m.invoke((Object)c, new Integer(index));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "Mnemonic text=" + this.text + ", keycode=" + AWT.getKeyCode(this.keycode) + (this.index != -1 ? "displayed index=" + this.index : "");
    }

    public void setMnemonic(AbstractButton button) {
        button.setText(this.text);
        button.setMnemonic(this.keycode);
        Mnemonic.setDisplayedMnemonicIndex(button, this.index);
    }

    public void setMnemonic(JLabel label) {
        label.setText(this.text);
        label.setDisplayedMnemonic(this.keycode);
        Mnemonic.setDisplayedMnemonicIndex(label, this.index);
    }

    public void setMnemonic(JTabbedPane tabbedPane, int tabIndex) {
        tabbedPane.setTitleAt(tabIndex, this.text);
        try {
            Method m = JTabbedPane.class.getMethod("setMnemonicAt", Integer.TYPE, Integer.TYPE);
            m.invoke((Object)tabbedPane, new Integer(tabIndex), new Integer(this.keycode));
            m = JTabbedPane.class.getMethod("setDisplayedMnemonicIndexAt", Integer.TYPE, Integer.TYPE);
            if (this.index != -1) {
                m.invoke((Object)tabbedPane, new Integer(tabIndex), new Integer(this.index));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMnemonic(Action action) {
        action.putValue("Name", this.text);
        if (this.keycode != 0) {
            action.putValue("MnemonicKey", new Integer(this.keycode));
        }
    }

    private static boolean isDisallowed(char ch) {
        return Character.isWhitespace(ch) || ch == '\'' || ch == '\"';
    }

    private static int getMnemonicMapping(char ch) {
        KeyStroke keystroke;
        if (Mnemonic.isDisallowed(ch)) {
            return 0;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return 65 + ch - 65;
        }
        if (ch >= 'a' && ch <= 'z') {
            return 65 + ch - 97;
        }
        if (ch >= '0' && ch <= '9') {
            return 48 + ch - 48;
        }
        String str = Strings.get("MNEMONIC_" + ch, true);
        if (str != null) {
            try {
                return AWT.getKeyCode("VK_" + str.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                Log.warn("'" + str + "' is not a valid mnemonic " + "(use a VK_ constant from KeyEvent)");
            }
        }
        if ((keystroke = KeyStrokeMap.getKeyStroke(ch)) != null) {
            return keystroke.getKeyCode();
        }
        return 0;
    }

    public static Mnemonic getMnemonic(String input) {
        String text = input;
        int mnemonicIndex = -1;
        int keycode = 0;
        int amp = text.indexOf("&");
        int displayIndex = -1;
        while (amp != -1 && amp < text.length() - 1) {
            char ch = text.charAt(amp + 1);
            if (ch == '&') {
                text = text.substring(0, amp) + text.substring(amp + 1);
                amp = text.indexOf("&", amp + 1);
                continue;
            }
            int code = Mnemonic.getMnemonicMapping(ch);
            if (code == 0) {
                amp = text.indexOf("&", amp + 2);
                continue;
            }
            if (mnemonicIndex == -1) {
                text = text.substring(0, amp) + text.substring(amp + 1);
                displayIndex = mnemonicIndex = amp;
                keycode = code;
            }
            amp = text.indexOf("&", amp + 1);
        }
        if (Platform.isOSX()) {
            keycode = 0;
            displayIndex = -1;
        }
        Mnemonic m = new Mnemonic(text, keycode, displayIndex);
        Log.debug(input + "->" + m);
        return m;
    }
}

