/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.widgets;

import abbot.Log;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextField
extends JTextField {
    public static final String ACTION_FOCUS_LOST = "focus-lost";
    public static final String ACTION_TEXT_CHANGED = "text-changed";
    public static final String ACTION_TEXT_INSERTED = "text-inserted";
    public static final String ACTION_TEXT_REMOVED = "text-removed";
    public static final String ACTION_TEXT_REVERTED = "text-reverted";
    private static final String REVERT_ACTION_NAME = "field-revert";
    private boolean notifying;
    private Decorator decorator;

    public static boolean isDocumentAction(String action) {
        return action == ACTION_TEXT_CHANGED || action == ACTION_TEXT_INSERTED || action == ACTION_TEXT_REMOVED;
    }

    public static void decorate(JTextField tf) {
        new Decorator(tf);
    }

    public static void decorate(JTextField tf, String defaultValue) {
        new Decorator(tf, defaultValue);
    }

    public TextField(String value, int columns) {
        super(value, columns);
        this.decorator = new Decorator(this);
    }

    public TextField(String value, String defaultValue, int columns) {
        super(value, columns);
        this.decorator = new Decorator(this, defaultValue);
    }

    public TextField(String value) {
        super(value);
        this.decorator = new Decorator(this);
    }

    public TextField(String value, String defaultValue) {
        super(value);
        this.decorator = new Decorator(this, defaultValue);
    }

    public Dimension getMaximumSize() {
        Dimension size = super.getMaximumSize();
        size.height = super.getPreferredSize().height;
        return size;
    }

    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.height = super.getPreferredSize().height;
        return size;
    }

    public void setDefaultValue(String value) {
        this.decorator.setDefaultValue(value);
    }

    public void setText(String text) {
        if (!this.getText().equals(text) && !this.notifying) {
            super.setText(text != null ? text : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireActionPerformed() {
        this.notifying = true;
        try {
            super.fireActionPerformed();
        }
        finally {
            this.notifying = false;
        }
    }

    public static class Decorator {
        private JTextField textField;
        private String revertText;
        private boolean continuousFire = true;
        private String defaultValue;

        public Decorator(JTextField textField) {
            this(textField, null);
        }

        public Decorator(final JTextField textField, String defValue) {
            this.textField = textField;
            this.defaultValue = defValue;
            textField.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent ev) {
                    if (!ev.isTemporary() && !Decorator.this.isLocalMenuActive(textField)) {
                        Decorator.this.fireActionPerformed(TextField.ACTION_FOCUS_LOST);
                    }
                }
            });
            DocumentListener listener = new DocumentListener(){

                public void changedUpdate(DocumentEvent ev) {
                    if (Decorator.this.continuousFire) {
                        Decorator.this.fireActionPerformed(TextField.ACTION_TEXT_CHANGED);
                    }
                }

                public void insertUpdate(DocumentEvent ev) {
                    String stack = Log.getStack(0);
                    if (stack.indexOf("JTextComponent.setText") != -1) {
                        Decorator.this.revertText = textField.getText();
                    }
                    if (Decorator.this.continuousFire) {
                        Decorator.this.fireActionPerformed(TextField.ACTION_TEXT_INSERTED);
                    }
                }

                public void removeUpdate(DocumentEvent ev) {
                    if (Decorator.this.continuousFire) {
                        Decorator.this.fireActionPerformed(TextField.ACTION_TEXT_REMOVED);
                    }
                }
            };
            textField.getDocument().addDocumentListener(listener);
            textField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String text = textField.getText();
                    if (!TextField.isDocumentAction(e.getActionCommand())) {
                        if (Decorator.this.defaultValue != null && "".equals(text)) {
                            text = Decorator.this.defaultValue;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    textField.setText(Decorator.this.defaultValue);
                                    textField.selectAll();
                                }
                            });
                        }
                        Decorator.this.revertText = text;
                        textField.selectAll();
                    }
                }
            });
            textField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        Decorator.this.revertText();
                    }
                }
            });
            this.revertText = textField.getText();
        }

        private void setDefaultValue(String value) {
            this.defaultValue = value;
        }

        private void revertText() {
            if (!this.textField.getText().equals(this.revertText)) {
                this.textField.setText(this.revertText);
                this.fireActionPerformed(TextField.ACTION_TEXT_REVERTED);
            }
        }

        private void fireActionPerformed(String command) {
            this.textField.setActionCommand(command);
            this.textField.postActionEvent();
            this.textField.setActionCommand(null);
        }

        private boolean isLocalMenuActive(JTextField field) {
            Window window = SwingUtilities.getWindowAncestor(field);
            if (window != null) {
                Component comp = window.getFocusOwner();
                return comp != null && comp instanceof JMenuItem;
            }
            return false;
        }

        protected class RevertFieldAction
        extends AbstractAction {
            public RevertFieldAction() {
                super(TextField.REVERT_ACTION_NAME);
            }

            public void actionPerformed(ActionEvent e) {
                Decorator.this.revertText();
            }
        }
    }
}

