/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.Log;
import abbot.finder.ComponentSearchException;
import abbot.i18n.Strings;
import abbot.script.ArgumentParser;
import abbot.script.NoSuchReferenceException;
import abbot.script.Resolver;
import abbot.script.Step;
import abbot.util.Properties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jdom.CDATA;
import org.jdom.Element;

public class Annotation
extends Step {
    public static final String TAG_ANNOTATION = "annotation";
    public static final String TAG_USER_DISMISS = "userDismiss";
    private static final String USAGE = "<annotation [title=\"...\"] [component=\"<component ID>\"] [x=XX y=YY] [width=WWW height=HHH] [userDismiss=\"true\"]>Text or HTML message</annotation>";
    private static final int WORD_SIZE = 6;
    private static final Color BACKGROUND = new Color((Color.yellow.getRed() + Color.white.getRed() * 3) / 4, (Color.yellow.getGreen() + Color.white.getGreen() * 3) / 4, (Color.yellow.getBlue() + Color.white.getBlue() * 3) / 4);
    private String title;
    private String componentID;
    private boolean userDismiss;
    private static int minDelay = 5000;
    private static int delayUnit = 250;
    private String text = "";
    private int x = -1;
    private int y = -1;
    private int width = -1;
    private int height = -1;
    private transient Object WINDOW_LOCK = new WindowLock();
    private volatile transient Frame frame;
    private volatile transient AnnotationWindow window;
    private transient Point anchorPoint;
    private transient boolean ignoreChanges;

    public Annotation(Resolver resolver, Element el, Map attributes) {
        super(resolver, attributes);
        String hs;
        String ws;
        this.componentID = (String)attributes.get("component");
        this.userDismiss = attributes.get(TAG_USER_DISMISS) != null;
        this.setTitle((String)attributes.get("title"));
        String xs = (String)attributes.get("x");
        String ys = (String)attributes.get("y");
        if (xs != null && ys != null) {
            try {
                this.x = Integer.parseInt(xs);
                this.y = Integer.parseInt(ys);
            }
            catch (NumberFormatException nfe) {
                this.y = -1;
                this.x = -1;
            }
        }
        if ((ws = (String)attributes.get("width")) != null & (hs = (String)attributes.get("height")) != null) {
            try {
                this.width = Integer.parseInt(ws);
                this.height = Integer.parseInt(hs);
            }
            catch (NumberFormatException nfe) {
                this.height = -1;
                this.width = -1;
            }
        }
        String text = null;
        for (Object obj : el.getContent()) {
            if (!(obj instanceof CDATA)) continue;
            text = ((CDATA)obj).getText();
            break;
        }
        if (text == null) {
            text = el.getText();
        }
        this.setText(text);
    }

    public Annotation(Resolver resolver, String description) {
        super(resolver, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShowing() {
        Object object = this.WINDOW_LOCK;
        synchronized (object) {
            return this.window != null;
        }
    }

    private void showAnnotationWindow() {
        Window win = this.getWindow();
        win.pack();
        Point where = null;
        if (this.anchorPoint != null) {
            where = new Point(this.anchorPoint);
        }
        if (this.x != -1 && this.y != -1) {
            if (where != null) {
                where.x += this.x;
                where.y += this.y;
            } else {
                where = new Point(this.x, this.y);
            }
        }
        if (where != null) {
            win.setLocation(where);
        }
        if (this.width != -1 && this.height != -1) {
            win.setSize(new Dimension(this.width, this.height));
        }
        win.setVisible(true);
    }

    public void showAnnotation() {
        this.dispose();
        if (SwingUtilities.isEventDispatchThread()) {
            this.showAnnotationWindow();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Annotation.this.showAnnotationWindow();
                    }
                });
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                    }
                });
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
    }

    public long getDelayTime() {
        long time = this.getText().length() / 6 * delayUnit;
        return Math.max(time, (long)minDelay);
    }

    protected void runStep() throws Throwable {
        this.ignoreChanges = true;
        this.showAnnotation();
        this.ignoreChanges = false;
        long start = System.currentTimeMillis();
        while (this.userDismiss && this.window != null && this.window.isShowing() || !this.userDismiss && System.currentTimeMillis() - start < this.getDelayTime()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread.yield();
        }
        if (!this.userDismiss) {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getWindow() {
        Object object = this.WINDOW_LOCK;
        synchronized (object) {
            if (this.window == null) {
                this.window = this.createWindow();
            }
            return this.window;
        }
    }

    private AnnotationWindow createWindow() {
        Component parent = null;
        JDialog w = null;
        Frame f = null;
        this.anchorPoint = null;
        if (this.componentID != null) {
            try {
                parent = (Component)ArgumentParser.eval(this.getResolver(), this.componentID, Component.class);
                Point loc = parent.getLocationOnScreen();
                this.anchorPoint = new Point(loc.x, loc.y);
                while (!(parent instanceof Dialog) && !(parent instanceof Frame)) {
                    parent = parent.getParent();
                }
                w = parent instanceof Dialog ? (this.title != null ? new AnnotationWindow((Dialog)parent, this.title) : new AnnotationWindow((Dialog)parent)) : (this.title != null ? new AnnotationWindow((Frame)parent, this.title) : new AnnotationWindow((Frame)parent));
            }
            catch (ComponentSearchException e) {
                Log.warn(e);
            }
            catch (NoSuchReferenceException nsr) {
                Log.warn(nsr);
            }
        }
        if (w == null) {
            f = new Frame();
            w = this.title != null ? new AnnotationWindow(f, this.title) : new AnnotationWindow(f);
        }
        JPanel pane = (JPanel)w.getContentPane();
        pane.setBackground(BACKGROUND);
        pane.setLayout(new BorderLayout());
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        JLabel label = new JLabel(this.replaceNewlines(this.text));
        pane.add((Component)label, "Center");
        if (this.userDismiss) {
            JPanel bottom = new JPanel(new BorderLayout());
            bottom.setBackground(BACKGROUND);
            JButton close = new JButton(Strings.get("annotation.continue"));
            bottom.add((Component)close, "East");
            close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    Annotation.this.dispose();
                }
            });
            pane.add((Component)bottom, "South");
        }
        w.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                Annotation.this.dispose();
            }

            public void windowClosed(WindowEvent we) {
                Annotation.this.dispose();
            }
        });
        this.frame = f;
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        Frame f;
        AnnotationWindow w;
        Object object = this.WINDOW_LOCK;
        synchronized (object) {
            w = this.window;
            f = this.frame;
            this.window = null;
            this.frame = null;
        }
        if (w != null) {
            if (f != null) {
                this.getResolver().getHierarchy().dispose(f);
            }
            this.getResolver().getHierarchy().dispose(w);
        }
    }

    private String replaceNewlines(String text) {
        boolean needsHTML = false;
        String[] breaks = new String[]{"\r\n", "\n"};
        for (int i = 0; i < breaks.length; ++i) {
            int index = text.indexOf(breaks[i]);
            while (index != -1) {
                needsHTML = true;
                text = text.substring(0, index) + "<br>" + text.substring(index + breaks[i].length());
                index = text.indexOf(breaks[i]);
            }
        }
        if (needsHTML && !text.startsWith("<html>")) {
            text = "<html>" + text + "</html>";
        }
        return text;
    }

    private void updateWindowSize(Window win) {
        if (this.window != win) {
            return;
        }
        Dimension size = win.getSize();
        this.width = size.width;
        this.height = size.height;
    }

    private void updateWindowPosition(Window win) {
        if (this.window != win) {
            return;
        }
        Point where = win.getLocation();
        this.x = where.x;
        this.y = where.y;
        if (this.anchorPoint != null) {
            this.x -= this.anchorPoint.x;
            this.y -= this.anchorPoint.y;
        }
    }

    public String getDefaultDescription() {
        String desc = "Annotation";
        if (!"".equals(this.getText())) {
            desc = desc + ": " + this.getText();
        }
        return desc;
    }

    public String getUsage() {
        return USAGE;
    }

    public String getXMLTag() {
        return TAG_ANNOTATION;
    }

    protected Element addContent(Element el) {
        return el.addContent(new CDATA(this.getText()));
    }

    public Map getAttributes() {
        Map map = super.getAttributes();
        if (this.componentID != null) {
            map.put("component", this.componentID);
        }
        if (this.userDismiss) {
            map.put(TAG_USER_DISMISS, "true");
        }
        if (this.title != null) {
            map.put("title", this.title);
        }
        if (this.x != -1 || this.y != -1) {
            map.put("x", String.valueOf(this.x));
            map.put("y", String.valueOf(this.y));
        }
        if (this.width != -1 || this.height != -1) {
            map.put("width", String.valueOf(this.width));
            map.put("height", String.valueOf(this.height));
        }
        return map;
    }

    public boolean getUserDismiss() {
        return this.userDismiss;
    }

    public void setUserDismiss(boolean state) {
        this.userDismiss = state;
    }

    public String getRelativeTo() {
        return this.componentID;
    }

    public void setRelativeTo(String id) {
        this.componentID = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setDisplayLocation(Point pt) {
        if (pt != null) {
            this.x = pt.x;
            this.y = pt.y;
        } else {
            this.y = -1;
            this.x = -1;
        }
    }

    public Point getDisplayLocation() {
        if (this.x != -1 || this.y != -1) {
            return new Point(this.x, this.y);
        }
        return null;
    }

    static {
        minDelay = Properties.getProperty("abbot.annotation.min_delay", minDelay, 0, 10000);
        delayUnit = Properties.getProperty("abbot.annotation.delay_unit", delayUnit, 1, 5000);
    }

    class AnnotationWindow
    extends JDialog {
        public AnnotationWindow(Dialog parent, String title) {
            super(parent, title);
            this.addListener();
        }

        public AnnotationWindow(Dialog parent) {
            super(parent);
            this.addListener();
        }

        public AnnotationWindow(Frame parent, String title) {
            super(parent, title);
            this.addListener();
        }

        public AnnotationWindow(Frame parent) {
            super(parent);
            this.addListener();
        }

        private void addListener() {
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent ce) {
                    if (!Annotation.this.ignoreChanges && AnnotationWindow.this.isShowing()) {
                        Annotation.this.updateWindowSize(AnnotationWindow.this);
                    }
                }

                public void componentMoved(ComponentEvent ce) {
                    if (!Annotation.this.ignoreChanges && AnnotationWindow.this.isShowing()) {
                        Annotation.this.updateWindowPosition(AnnotationWindow.this);
                    }
                }
            });
        }
    }

    class WindowLock {
        WindowLock() {
        }
    }
}

