/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.Log;
import abbot.finder.BasicFinder;
import abbot.finder.ComponentSearchException;
import abbot.finder.matchers.ClassMatcher;
import abbot.i18n.Strings;
import abbot.script.ArgumentParser;
import abbot.script.Launch;
import abbot.script.Resolver;
import abbot.tester.ComponentTester;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;

public class Appletviewer
extends Launch {
    private String code;
    private Map params;
    private String codebase;
    private String archive;
    private String width;
    private String height;
    private ClassLoader appletClassLoader;
    private Frame appletViewerFrame;
    private transient SecurityManager oldSM;
    private transient boolean terminating;
    private static final String DEFAULT_WIDTH = "100";
    private static final String DEFAULT_HEIGHT = "100";
    private static final String CLASS_NAME = "sun.applet.Main";
    private static final String METHOD_NAME = "main";
    private static final int LAUNCH_TIMEOUT = 30000;
    private static final String USAGE = "<appletviewer code=\"...\" [params=\"name1=value1,...\"] [codebase=\"...\"] [archive=\"...\"]>";

    protected void quitApplet(Frame frame) {
        new ComponentTester().selectAWTMenuItem(frame, "Applet|Quit");
    }

    private static Map patchAttributes(Map map) {
        map.put("class", CLASS_NAME);
        map.put("method", METHOD_NAME);
        return map;
    }

    public Appletviewer(Resolver resolver, Map attributes) {
        super(resolver, Appletviewer.patchAttributes(attributes));
        this.code = (String)attributes.get("code");
        this.params = this.parseParams((String)attributes.get("params"));
        this.codebase = (String)attributes.get("codebase");
        this.archive = (String)attributes.get("archive");
        this.width = (String)attributes.get("width");
        this.height = (String)attributes.get("height");
    }

    public Appletviewer(Resolver resolver, String description, String code, Map params, String codebase, String archive, String classpath) {
        super(resolver, description, CLASS_NAME, METHOD_NAME, null, classpath, false);
        this.code = code;
        this.params = params;
        this.codebase = codebase;
        this.archive = archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStep() throws Throwable {
        File dir = new File(System.getProperty("user.dir"));
        File htmlFile = File.createTempFile("abbot-applet", ".html", dir);
        htmlFile.deleteOnExit();
        try {
            FileOutputStream os = new FileOutputStream(htmlFile);
            os.write(this.generateHTML().getBytes());
            os.close();
            this.setArguments(new String[]{"[" + htmlFile.getName() + "]"});
            super.runStep();
            long start = System.currentTimeMillis();
            BasicFinder finder = new BasicFinder(this.getResolver().getHierarchy());
            ClassMatcher matcher = new ClassMatcher(Applet.class, true);
            while (true) {
                try {
                    Component c = finder.find(matcher);
                    this.appletViewerFrame = (Frame)SwingUtilities.getWindowAncestor(c);
                    this.addCloseListener(this.appletViewerFrame);
                    this.appletClassLoader = c.getClass().getClassLoader();
                }
                catch (ComponentSearchException e) {
                    if (System.currentTimeMillis() - start > 30000L) {
                        throw new RuntimeException(Strings.get("step.appletviewer.launch_timed_out"));
                    }
                    Thread.sleep(200L);
                    continue;
                }
                break;
            }
        }
        finally {
            htmlFile.delete();
        }
    }

    private void addCloseListener(final Frame frame) {
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Log.debug("window closing");
                Appletviewer.this.quitApplet(frame);
            }
        });
    }

    protected String generateHTML() {
        StringBuffer html = new StringBuffer();
        html.append("<html><applet code=\"" + this.getCode() + "\"");
        html.append(" width=\"" + this.getWidth() + "\"" + " height=\"" + this.getHeight() + "\"");
        if (this.getCodebase() != null) {
            html.append(" codebase=\"" + this.getCodebase() + "\"");
        }
        if (this.getArchive() != null) {
            html.append(" archive=\"" + this.getArchive() + "\"");
        }
        html.append(">");
        for (String key : this.params.keySet()) {
            String value = (String)this.params.get(key);
            html.append("<param name=\"" + key + "\" value=\"" + value + "\">");
        }
        html.append("</applet></html>");
        return html.toString();
    }

    public void setTargetClassName(String name) {
        if (!CLASS_NAME.equals(name)) {
            throw new IllegalArgumentException(Strings.get("step.call.immutable_class"));
        }
        super.setTargetClassName(name);
    }

    public void setMethodName(String name) {
        if (!METHOD_NAME.equals(name)) {
            throw new IllegalArgumentException(Strings.get("step.call.immutable_method"));
        }
        super.setMethodName(name);
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setCodebase(String codebase) {
        this.codebase = codebase;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public String getArchive() {
        return this.archive;
    }

    public String getWidth() {
        return this.width != null ? this.width : "100";
    }

    public void setWidth(String width) {
        this.width = width;
        try {
            Integer.parseInt(width);
        }
        catch (NumberFormatException e) {
            this.width = null;
        }
    }

    public String getHeight() {
        return this.height != null ? this.height : "100";
    }

    public void setHeight(String height) {
        this.height = height;
        try {
            Integer.parseInt(height);
        }
        catch (NumberFormatException e) {
            this.height = null;
        }
    }

    public Map getParams() {
        return this.params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    protected Map parseParams(String attribute) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (attribute != null) {
            String[] list = ArgumentParser.parseArgumentList(attribute);
            for (int i = 0; i < list.length; ++i) {
                String p = list[i];
                int eq = p.indexOf("=");
                map.put(p.substring(0, eq), p.substring(eq + 1));
            }
        }
        return map;
    }

    public String[] getParamsAsArray() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : new TreeMap(this.params).keySet()) {
            String value = (String)this.params.get(key);
            list.add(key + "=" + value);
        }
        return list.toArray(new String[list.size()]);
    }

    public String getParamsAttribute() {
        return ArgumentParser.encodeArguments(this.getParamsAsArray());
    }

    public Map getAttributes() {
        Map map = super.getAttributes();
        map.put("code", this.getCode());
        if (this.params.size() > 0) {
            map.put("params", this.getParamsAttribute());
        }
        if (this.getCodebase() != null) {
            map.put("codebase", this.getCodebase());
        }
        if (this.getArchive() != null) {
            map.put("archive", this.getArchive());
        }
        if (!"100".equals(this.getWidth())) {
            map.put("width", this.getWidth());
        }
        if (!"100".equals(this.getHeight())) {
            map.put("height", this.getHeight());
        }
        map.remove("class");
        map.remove("method");
        map.remove("threaded");
        map.remove("args");
        return map;
    }

    public String getDefaultDescription() {
        String desc = Strings.get("step.appletviewer", new Object[]{this.getCode()});
        return desc;
    }

    public String getUsage() {
        return USAGE;
    }

    public String getXMLTag() {
        return "appletviewer";
    }

    public ClassLoader getContextClassLoader() {
        return this.appletClassLoader != null ? this.appletClassLoader : super.getContextClassLoader();
    }

    protected void install() {
        super.install();
        this.installAppletSecurityManager(super.getContextClassLoader());
    }

    private void installAppletSecurityManager(ClassLoader cl) {
        this.oldSM = System.getSecurityManager();
        Log.debug("install security manager");
        try {
            Class<?> cls = Class.forName("abbot.script.AppletSecurityManager", true, cl);
            Constructor<?> ctor = cls.getConstructor(SecurityManager.class, Boolean.TYPE);
            SecurityManager sm = (SecurityManager)ctor.newInstance(this.oldSM, new Boolean(this.removeSMOnExit()));
            System.setSecurityManager(sm);
        }
        catch (Exception exc) {
            Log.warn(exc);
        }
    }

    protected boolean removeSMOnExit() {
        return false;
    }

    protected Frame getFrame() {
        return this.appletViewerFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Appletviewer appletviewer = this;
        synchronized (appletviewer) {
            if (this.terminating) {
                return;
            }
            this.terminating = true;
        }
        Frame frame = this.appletViewerFrame;
        this.appletViewerFrame = null;
        try {
            if (frame != null) {
                this.quitApplet(frame);
            }
            super.terminate();
            while (System.getSecurityManager() != this.oldSM) {
                Thread.sleep(10L);
            }
            Log.debug("SM restored");
            this.appletClassLoader = null;
            this.oldSM = null;
        }
        catch (InterruptedException e) {
            Log.warn(e);
        }
        finally {
            Appletviewer appletviewer2 = this;
            synchronized (appletviewer2) {
                this.terminating = false;
            }
        }
    }
}

