/*
 * Decompiled with CFR 0.152.
 */
package abbot.util;

import abbot.Log;
import abbot.tester.Robot;
import abbot.util.AWT;
import abbot.util.EDTExceptionCatcher;
import abbot.util.Properties;
import abbot.util.SystemState;
import abbot.util.WeakAWTEventListener;
import java.awt.AWTEvent;
import java.awt.event.AWTEventListener;

public class AWTFixtureHelper {
    private AWTEventListener listener = null;
    private SystemState state = new SystemState();

    public AWTFixtureHelper() {
        try {
            new EDTExceptionCatcher().install();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (Boolean.getBoolean("abbot.fixture.log_events")) {
            long mask = Properties.getProperty("abbot.fixture.event_mask", Long.MIN_VALUE, Long.MAX_VALUE, 2813L);
            Log.log("Using mask value " + mask);
            this.listener = new AWTEventListener(){

                public void eventDispatched(AWTEvent event) {
                    if (AWTFixtureHelper.this.listener != null) {
                        Log.log(Robot.toString(event));
                    }
                }
            };
            new WeakAWTEventListener(this.listener, mask);
        }
    }

    public Throwable getEventDispatchError() {
        return EDTExceptionCatcher.getThrowable();
    }

    public long getEventDispatchErrorTime() {
        return EDTExceptionCatcher.getThrowableTime();
    }

    public void restore() {
        AWT.dismissAWTPopup();
        this.state.restore();
        System.gc();
        System.runFinalization();
    }
}

